/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.actions;

import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.ui.RepConnectorUIPlugin;
import com.sybase.connector.ui.actions.BaseAction;
import com.sybase.connector.ui.model.ConnectionElement;
import com.sybase.connector.ui.model.ElementModel;
import com.sybase.connector.ui.model.ProfileElement;
import com.sybase.connector.ui.view.ConnectionView;
import com.sybase.connector.ui.wizards.ProfileDialogPage2;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.widgets.Shell;

public class LoginAction
extends BaseAction {
    Cursor waitCursor = null;

    public LoginAction(String string) {
        super(string);
    }

    public LoginAction(ConnectionView connectionView, String string) {
        super(connectionView, string);
    }

    public void run() {
        IStructuredSelection iStructuredSelection;
        ElementModel elementModel = null;
        try {
            iStructuredSelection = (IStructuredSelection)this.getViewer().getSelection();
            elementModel = (ElementModel)iStructuredSelection.getFirstElement();
            this.doRun(elementModel);
        }
        catch (Throwable throwable) {
            Status status = new Status(4, "com.sybase.connector.ui.actions", 4, this.getResourceString("LoginAction.doRun.error.reason.loginfailed"), throwable);
            ErrorDialog.openError((Shell)this.getView().getSite().getWorkbenchWindow().getShell(), (String)this.getResourceString("LoginAction.doRun.m1"), (String)this.getResourceString("LoginAction.doRun.error.text"), (IStatus)status);
        }
        if (this.waitCursor != null) {
            this.waitCursor.dispose();
        }
        this.mainView.resetSelection(elementModel);
        iStructuredSelection = new Cursor(null, 0);
        this.getViewer().getControl().setCursor((Cursor)iStructuredSelection);
        this.getViewer().refresh();
    }

    public void doRun(ElementModel elementModel) {
        ProfileElement profileElement = null;
        try {
            if (elementModel instanceof ProfileElement) {
                profileElement = (ProfileElement)elementModel;
                this.profile = profileElement.getProfile();
                ProfileDialogPage2 profileDialogPage2 = new ProfileDialogPage2(this.getView().getSite().getWorkbenchWindow().getShell(), this.profile, (IAction)this);
                profileDialogPage2.open();
                if (this.pressedOK) {
                    this.waitCursor = new Cursor(null, 1);
                    this.getViewer().getControl().setCursor(this.waitCursor);
                    this.getViewer().refresh();
                    profileElement.setProfile(this.profile);
                    this.mainView.getProfileHandler().modifyProfile(profileElement.getProfile());
                    RaClientUtil raClientUtil = new RaClientUtil(profileElement.getProfileHost(), profileElement.getProfilePort(), profileElement.getProfileUser(), profileElement.getProfilePass());
                    RaStatus raStatus = raClientUtil.getConnectionStatus();
                    Properties properties = (Properties)raStatus.getReturnObject();
                    Enumeration<?> enumeration = properties.propertyNames();
                    String string = "";
                    ConnectionElement connectionElement = null;
                    while (enumeration.hasMoreElements()) {
                        string = (String)enumeration.nextElement();
                        connectionElement = new ConnectionElement(string);
                        connectionElement.setStatus(properties.getProperty(string));
                        profileElement.add(connectionElement);
                    }
                    profileElement.setProfileStatus("Connected");
                    this.mainView.modifyProfileMenu(true);
                    this.getViewer().expandToLevel((Object)profileElement, 1);
                }
            }
        }
        catch (Exception exception) {
            RepConnectorUIPlugin.log(exception);
            String string = "login failed";
            String string2 = exception.getMessage();
            if (string2 != null && string2.toLowerCase().indexOf(string) >= 0) {
                Status status = new Status(4, "com.sybase.connector.ui.actions", 4, this.getResourceString("LoginAction.doRun.error.reason.loginfailed"), (Throwable)exception);
                ErrorDialog.openError((Shell)this.getView().getSite().getWorkbenchWindow().getShell(), (String)this.getResourceString("LoginAction.doRun.m1"), (String)this.getResourceString("LoginAction.doRun.error.text"), null);
            } else {
                MultiStatus multiStatus = new MultiStatus(RepConnectorUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, this.getResourceString("LoginAction.doRun.error.reason.noconnect"), (Throwable)exception);
                multiStatus.add((IStatus)new Status(4, RepConnectorUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, exception.getMessage(), (Throwable)exception));
                ErrorDialog.openError((Shell)this.mainView.getSite().getWorkbenchWindow().getShell(), (String)this.getResourceString("LoginAction.doRun.error.title"), (String)this.getResourceString("LoginAction.doRun.error.text"), (IStatus)multiStatus);
            }
            if (profileElement.size() > 0) {
                profileElement.removeAll();
            }
            profileElement.setProfileStatus("Not Connected");
            this.mainView.modifyProfileMenu(false);
        }
        this.getViewer().refresh();
    }
}

