/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.actions;

import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.ui.RepConnectorUIPlugin;
import com.sybase.connector.ui.StatusUtil;
import com.sybase.connector.ui.actions.BaseAction;
import com.sybase.connector.ui.model.ConnectionElement;
import com.sybase.connector.ui.persistance.Profile;
import com.sybase.connector.ui.view.ConnectionView;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class RefreshConnAction
extends BaseAction {
    private TreeViewer _treeViewer = null;
    private IStructuredSelection _selection = null;
    private ConnectionElement _connElem = null;
    private Profile _prof = null;
    private RaStatus _raStatus = null;
    private Shell _shell = null;

    public RefreshConnAction(ConnectionView connectionView, String string) {
        super(connectionView, string);
        this._shell = connectionView.getSite().getShell();
    }

    public void run() {
        try {
            this._treeViewer = this.getViewer();
            this._selection = (IStructuredSelection)this._treeViewer.getSelection();
            this._connElem = (ConnectionElement)this._selection.getFirstElement();
            this._prof = this._connElem.getLoginInfo();
            this._connElem.setStatus("STOP");
            this.doRun();
            if (this._connElem.getStatus().equals("RUNNING")) {
                this.mainView.modifyConnectionMenu(true);
            } else {
                this.mainView.modifyConnectionMenu(false);
            }
        }
        catch (Throwable throwable) {
            RepConnectorUIPlugin.log(throwable);
        }
        this.mainView.resetSelection(this._connElem);
    }

    private void doRun() {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                iProgressMonitor.beginTask(RefreshConnAction.this.getResourceString("action.refresh.refreshing"), -1);
                iProgressMonitor.subTask(RefreshConnAction.this.getResourceString("action.refresh.refreshing"));
                try {
                    RaClientUtil raClientUtil = new RaClientUtil(RefreshConnAction.this._prof.getHostname(), RefreshConnAction.this._prof.getPort(), RefreshConnAction.this._prof.getUsername(), RefreshConnAction.this._prof.getPassword());
                    RefreshConnAction.this._raStatus = raClientUtil.refreshConnection(RefreshConnAction.this._connElem.getName());
                }
                catch (Throwable throwable) {
                    RepConnectorUIPlugin.log(throwable);
                    throw new InvocationTargetException(throwable, throwable.getMessage());
                }
                iProgressMonitor.done();
            }
        };
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this._shell);
        String string = this.getResourceString("action.refresh.status");
        try {
            progressMonitorDialog.run(true, false, iRunnableWithProgress);
            int n = this._raStatus.getCode();
            String string2 = this._raStatus.getMessage();
            if (n == 0 && (string2 == null || string2.equals(""))) {
                this._raStatus.setMessage("Connection Successfully Refreshed.");
            }
            this._connElem.setStatus("RUNNING");
            StatusUtil.createStatusDialog(this._shell, string, this._raStatus);
        }
        catch (InvocationTargetException invocationTargetException) {
            StatusUtil.createStatusDialog(this._shell, string, invocationTargetException);
            this.mainView.modifyConnectionMenu(false);
        }
        catch (Throwable throwable) {
            RepConnectorUIPlugin.log(throwable);
            this.mainView.modifyConnectionMenu(false);
        }
    }
}

