/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.actions;

import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.ui.RepConnectorUIPlugin;
import com.sybase.connector.ui.actions.RenameAction;
import com.sybase.connector.ui.model.ConnectionElement;
import com.sybase.connector.ui.persistance.Profile;
import com.sybase.connector.ui.view.ConnectionView;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class RenameConnAction
extends RenameAction {
    public RenameConnAction(ConnectionView connectionView, String string) {
        super(connectionView, string);
    }

    public void run() {
        TreeViewer treeViewer = this.getView().getViewer();
        ConnectionElement connectionElement = null;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)treeViewer.getSelection();
        if (iStructuredSelection.size() > 1) {
            return;
        }
        try {
            connectionElement = (ConnectionElement)iStructuredSelection.getFirstElement();
            String string = connectionElement.getName();
            String string2 = this.getNewName(string);
            if (string2 == null || string2.trim().equals("") || string2.trim().equalsIgnoreCase(string)) {
                return;
            }
            Profile profile = connectionElement.getLoginInfo();
            RaClientUtil raClientUtil = new RaClientUtil(profile.getHostname(), profile.getPort(), profile.getUsername(), profile.getPassword());
            RaStatus raStatus = raClientUtil.renameConnection(connectionElement.getName(), string2);
            int n = raStatus.getCode();
            if (n != 0 && n != 1) {
                throw new Exception(raStatus.getMessage());
            }
            connectionElement.setName(string2);
            treeViewer.refresh();
        }
        catch (Throwable throwable) {
            MultiStatus multiStatus = new MultiStatus(RepConnectorUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, this.getResourceString("RenameConnAction.doRun.error.reason"), throwable);
            String string = ((Object)((Object)this)).getClass().getName();
            multiStatus.add((IStatus)new Status(4, RepConnectorUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, throwable.getMessage() + "  " + this.getResourceString("RenameConnAction.doRun.error.guide"), throwable));
            ErrorDialog.openError((Shell)this.mainView.getSite().getWorkbenchWindow().getShell(), (String)this.getResourceString("RenameConnAction.doRun.error.title"), (String)this.getResourceString("RenameConnAction.doRun.error.text"), (IStatus)multiStatus);
        }
        this.mainView.resetSelection(connectionElement);
    }
}

