/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.actions;

import com.sybase.connector.ui.actions.RenameAction;
import com.sybase.connector.ui.model.ProfileElement;
import com.sybase.connector.ui.view.ConnectionView;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class RenameProfileAction
extends RenameAction {
    public RenameProfileAction(ConnectionView connectionView, String string) {
        super(connectionView, string);
        this.setType(2);
    }

    public void run() {
        TreeViewer treeViewer = this.getView().getViewer();
        IStructuredSelection iStructuredSelection = (IStructuredSelection)treeViewer.getSelection();
        if (iStructuredSelection.size() > 1) {
            return;
        }
        ProfileElement profileElement = (ProfileElement)iStructuredSelection.getFirstElement();
        String string = this.getNewName(profileElement.getName());
        if (string == null || string.trim().equals("")) {
            return;
        }
        try {
            if (!this.mainView.getProfileHandler().hasProfile(string)) {
                this.mainView.getProfileHandler().renameProfile(profileElement.getName(), string);
                profileElement.setName(string);
            } else {
                MessageDialog.openError((Shell)this.getView().getSite().getWorkbenchWindow().getShell(), (String)this.getResourceString("RenameProfileAction.doRun.m1"), (String)this.getResourceString("RenameProfileAction.doRun.m2"));
            }
        }
        catch (Exception exception) {
            MessageDialog.openError((Shell)this.getView().getSite().getWorkbenchWindow().getShell(), (String)this.getResourceString("RenameProfileAction.doRun.m1"), (String)(this.getResourceString("RenameProfileAction.doRun.m2") + "\n\n\n" + exception.getMessage()));
        }
        this.mainView.resetSelection(profileElement);
        treeViewer.refresh();
    }
}

