/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.actions;

import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.ui.RepConnectorUIPlugin;
import com.sybase.connector.ui.actions.BaseAction;
import com.sybase.connector.ui.model.ConnectionElement;
import com.sybase.connector.ui.persistance.Profile;
import com.sybase.connector.ui.view.ConnectionView;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class SaveAsConnAction
extends BaseAction {
    private String originName = "new_connection";

    public SaveAsConnAction(ConnectionView connectionView, String string) {
        super(connectionView, string);
    }

    public void run() {
        TreeViewer treeViewer = this.getView().getViewer();
        ConnectionElement connectionElement = null;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)treeViewer.getSelection();
        if (iStructuredSelection.size() > 1) {
            return;
        }
        try {
            connectionElement = (ConnectionElement)iStructuredSelection.getFirstElement();
            String string = this.getNewName(connectionElement.getName());
            if (string == null || string.trim().equals("")) {
                return;
            }
            Profile profile = connectionElement.getLoginInfo();
            RaClientUtil raClientUtil = new RaClientUtil(profile.getHostname(), profile.getPort(), profile.getUsername(), profile.getPassword());
            RaStatus raStatus = raClientUtil.copyConnection(connectionElement.getName(), string);
            int n = raStatus.getCode();
            if (n != 0 && n != 1) {
                throw new Exception(raStatus.getMessage());
            }
            ConnectionElement connectionElement2 = new ConnectionElement(string);
            connectionElement.getParent().add(connectionElement2);
            treeViewer.refresh();
        }
        catch (Throwable throwable) {
            MultiStatus multiStatus = new MultiStatus(RepConnectorUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, this.getResourceString("SaveAsConnAction.run.error.reason"), throwable);
            String string = ((Object)((Object)this)).getClass().getName();
            multiStatus.add((IStatus)new Status(4, RepConnectorUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, throwable.getMessage() + " " + this.getResourceString("SaveAsConnAction.run.error.guide"), throwable));
            ErrorDialog.openError((Shell)this.mainView.getSite().getWorkbenchWindow().getShell(), (String)this.getResourceString("SaveAsConnAction.run.error.title"), (String)this.getResourceString("SaveAsConnAction.run.error.text"), (IStatus)multiStatus);
        }
        this.mainView.resetSelection(connectionElement);
    }

    public String getNewName(String string) {
        this.originName = string;
        return this.getNewName();
    }

    public String getNewName() {
        String string = "action.saveas.text";
        String string2 = "action.saveas.dialog.msg";
        String string3 = this.originName;
        IInputValidator iInputValidator = new IInputValidator(){

            public String isValid(String string) {
                if (string.length() == 0) {
                    string = "DefaultName";
                    return null;
                }
                return null;
            }
        };
        InputDialog inputDialog = new InputDialog(this.getView().getSite().getWorkbenchWindow().getShell(), this.getResourceString(string), this.getResourceString(string2), this.getResourceString(string3), iInputValidator);
        inputDialog.setBlockOnOpen(true);
        inputDialog.open();
        return inputDialog.getValue();
    }
}

