/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.actions;

import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.ui.RepConnectorUIPlugin;
import com.sybase.connector.ui.StatusUtil;
import com.sybase.connector.ui.actions.BaseAction;
import com.sybase.connector.ui.model.ConnectionElement;
import com.sybase.connector.ui.persistance.Profile;
import com.sybase.connector.ui.view.ConnectionView;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class StartConnAction
extends BaseAction {
    Shell _shell;
    RaStatus _raStatus = null;
    ConnectionElement _connElem;
    Profile _prof;

    public StartConnAction(ConnectionView connectionView, String string) {
        super(connectionView, string);
        this._shell = connectionView.getSite().getShell();
    }

    public void run() {
        try {
            TreeViewer treeViewer = this.getView().getViewer();
            IStructuredSelection iStructuredSelection = (IStructuredSelection)treeViewer.getSelection();
            this._connElem = (ConnectionElement)iStructuredSelection.getFirstElement();
            this._connElem.setStatus("STOP");
            this._prof = this._connElem.getLoginInfo();
            this.doRun();
            if (!this._connElem.getStatus().equals("RUNNING")) {
                this._connElem.setStatus("STOP");
                this.mainView.modifyConnectionMenu(false);
                throw new Exception(this._raStatus.getMessage());
            }
            this._connElem.setStatus("RUNNING");
            this.mainView.modifyConnectionMenu(true);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mainView.resetSelection(this._connElem);
    }

    private void doRun() {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                iProgressMonitor.beginTask(StartConnAction.this.getResourceString("action.start.starting"), -1);
                iProgressMonitor.subTask(StartConnAction.this.getResourceString("action.start.starting"));
                try {
                    RaClientUtil raClientUtil = new RaClientUtil(StartConnAction.this._prof.getHostname(), StartConnAction.this._prof.getPort(), StartConnAction.this._prof.getUsername(), StartConnAction.this._prof.getPassword());
                    StartConnAction.this._raStatus = raClientUtil.startConnection(StartConnAction.this._connElem.getName());
                }
                catch (Throwable throwable) {
                    RepConnectorUIPlugin.log(throwable);
                    throw new InvocationTargetException(throwable, throwable.getMessage());
                }
                iProgressMonitor.done();
            }
        };
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this._shell);
        String string = this.getResourceString("action.start.status");
        try {
            progressMonitorDialog.run(true, false, iRunnableWithProgress);
            int n = this._raStatus.getCode();
            String string2 = this._raStatus.getMessage();
            if (n == 0 && (string2 == null || string2.equals(""))) {
                this._raStatus.setMessage(this.getResourceString("action.start.success"));
            }
            this._connElem.setStatus("RUNNING");
            StatusUtil.createStatusDialog(this._shell, string, this._raStatus);
        }
        catch (InvocationTargetException invocationTargetException) {
            StatusUtil.createStatusDialog(this._shell, string, invocationTargetException);
            this.mainView.modifyConnectionMenu(false);
        }
        catch (Throwable throwable) {
            this.mainView.modifyConnectionMenu(false);
            RepConnectorUIPlugin.log(throwable);
        }
    }
}

