/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.actions;

import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.ui.RepConnectorUIPlugin;
import com.sybase.connector.ui.StatusUtil;
import com.sybase.connector.ui.actions.BaseAction;
import com.sybase.connector.ui.model.ConnectionElement;
import com.sybase.connector.ui.persistance.Profile;
import com.sybase.connector.ui.view.ConnectionView;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public class StopConnAction
extends BaseAction {
    Shell _shell;
    RaStatus _raStatus = null;
    ConnectionElement _connElem;
    Profile _prof;

    public StopConnAction(ConnectionView connectionView, String string) {
        super(connectionView, string);
        this._shell = connectionView.getSite().getShell();
    }

    public void run() {
        try {
            TreeViewer treeViewer = this.getView().getViewer();
            IStructuredSelection iStructuredSelection = (IStructuredSelection)treeViewer.getSelection();
            String[] stringArray = new String[]{"Yes", "No"};
            MessageDialog messageDialog = new MessageDialog(this.getView().getSite().getWorkbenchWindow().getShell(), "Stop Connection", MessageDialog.getDefaultImage(), "Stopping Connection?", 3, stringArray, 1);
            messageDialog.setBlockOnOpen(true);
            if (messageDialog.open() == 0) {
                this._connElem = (ConnectionElement)iStructuredSelection.getFirstElement();
                this._prof = this._connElem.getLoginInfo();
                this.doRun();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.mainView.resetSelection(this._connElem);
    }

    private void doRun() {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                iProgressMonitor.beginTask(StopConnAction.this.getResourceString("action.stop.starting"), -1);
                iProgressMonitor.subTask(StopConnAction.this.getResourceString("action.stop.starting"));
                try {
                    RaClientUtil raClientUtil = new RaClientUtil(StopConnAction.this._prof.getHostname(), StopConnAction.this._prof.getPort(), StopConnAction.this._prof.getUsername(), StopConnAction.this._prof.getPassword());
                    StopConnAction.this._raStatus = raClientUtil.stopConnection(StopConnAction.this._connElem.getName());
                }
                catch (Throwable throwable) {
                    RepConnectorUIPlugin.log(throwable);
                    throw new InvocationTargetException(throwable, throwable.getMessage());
                }
                iProgressMonitor.done();
            }
        };
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this._shell);
        String string = this.getResourceString("action.stop.status");
        try {
            progressMonitorDialog.run(true, false, iRunnableWithProgress);
            int n = this._raStatus.getCode();
            String string2 = this._raStatus.getMessage();
            if (n == 0 && (string2 == null || string2.equals(""))) {
                this._raStatus.setMessage(this.getResourceString("action.stop.success"));
            }
            if (n == 0) {
                this._connElem.setStatus("STOP");
                this.mainView.modifyConnectionMenu(false);
                StatusUtil.createStatusDialog(this._shell, string, this._raStatus);
            } else {
                this._raStatus.setMessage(this.getResourceString("action.stop.failure"));
                this.mainView.modifyConnectionMenu(true);
                StatusUtil.createStatusDialog(this._shell, string, new Exception(this._raStatus.getMessage()));
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            StatusUtil.createStatusDialog(this._shell, string, invocationTargetException.getTargetException());
            this.mainView.modifyConnectionMenu(false);
        }
        catch (Throwable throwable) {
            this.mainView.modifyConnectionMenu(false);
            RepConnectorUIPlugin.log(throwable);
        }
    }
}

