/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.actions;

import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.ui.RepConnectorUIPlugin;
import com.sybase.connector.ui.StatusUtil;
import com.sybase.connector.ui.actions.BaseAction;
import com.sybase.connector.ui.model.ConnectionElement;
import com.sybase.connector.ui.model.ElementModel;
import com.sybase.connector.ui.persistance.Profile;
import com.sybase.connector.ui.view.ConnectionView;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;

public class ValidateConnAction
extends BaseAction {
    private ElementModel _eModel = null;
    private RaStatus _status = null;
    private Shell _shell;

    public ValidateConnAction(String string) {
        super(string);
    }

    public ValidateConnAction(ConnectionView connectionView, String string) {
        super(connectionView, string);
        this._shell = connectionView.getSite().getShell();
    }

    public void run() {
        if (this.getViewer().getSelection().isEmpty()) {
            return;
        }
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.getViewer().getSelection();
        ElementModel elementModel = (ElementModel)iStructuredSelection.getFirstElement();
        this.doRun(elementModel);
        this.mainView.resetSelection(elementModel);
    }

    public void doRun(ElementModel elementModel) {
        this._eModel = elementModel;
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                iProgressMonitor.beginTask(ValidateConnAction.this.getResourceString("action.validate.connection"), -1);
                iProgressMonitor.subTask(ValidateConnAction.this.getResourceString("action.validate.connection"));
                if (ValidateConnAction.this._eModel instanceof ConnectionElement) {
                    ValidateConnAction.this._eModel = (ConnectionElement)ValidateConnAction.this._eModel;
                    try {
                        Profile profile = ValidateConnAction.this._eModel.getLoginInfo();
                        RaClientUtil raClientUtil = new RaClientUtil(profile.getHostname(), profile.getPort(), profile.getUsername(), profile.getPassword());
                        ValidateConnAction.this._status = raClientUtil.validateConnection(ValidateConnAction.this._eModel.getName());
                        String string = ValidateConnAction.this._status.getMessage();
                        int n = ValidateConnAction.this._status.getCode();
                        if (n == 0 && (string == null || string.equals(""))) {
                            ValidateConnAction.this._status.setMessage(ValidateConnAction.this.getResourceString("action.validate.success"));
                        }
                    }
                    catch (Exception exception) {
                        throw new InvocationTargetException(exception, exception.getMessage());
                    }
                }
                iProgressMonitor.done();
            }
        };
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this._shell);
        String string = this.getResourceString("action.validate.status");
        try {
            progressMonitorDialog.run(true, false, iRunnableWithProgress);
            StatusUtil.createStatusDialog(this._shell, string, this._status);
        }
        catch (InvocationTargetException invocationTargetException) {
            StatusUtil.createStatusDialog(this._shell, string, invocationTargetException);
        }
        catch (Throwable throwable) {
            RepConnectorUIPlugin.log(throwable);
        }
    }
}

