/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.layouts;

import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.ui.RepConnectorUIPlugin;
import com.sybase.connector.ui.StatusUtil;
import com.sybase.connector.ui.model.IElement;
import com.sybase.connector.ui.wizards.ConnectionPropertyObject;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public abstract class BaseInfoPane {
    public Label _statusDestLabel;
    public Text _statusDest;
    protected Composite _composite;
    protected Properties _props;
    protected IElement _element;
    public Shell _shell;
    protected Properties _pingProps = null;
    protected RaStatus _pingStatus = null;
    protected ConnectionPropertyObject _connPropObj = null;
    Composite composite;

    public BaseInfoPane(Composite composite) {
        this._composite = composite;
    }

    public abstract void createLayout();

    protected String getResourceString(String string) {
        return RepConnectorUIPlugin.getResourceString(string);
    }

    protected void createStatusField(Composite composite, int n) {
        try {
            this._statusDestLabel = new Label(composite, 0);
            this._statusDestLabel.setText(this.getResourceString("jms.info.label.status.destination"));
            this._statusDest = new Text(composite, 2048);
            GridData gridData = new GridData();
            gridData.horizontalSpan = n;
            gridData.horizontalAlignment = 4;
            gridData.widthHint = 300;
            this._statusDest.setLayoutData((Object)gridData);
            this._statusDest.setEditable(false);
            this._statusDestLabel.setEnabled(false);
            this._statusDest.setEnabled(false);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void setShell(Shell shell) {
        this._shell = shell;
    }

    public Shell getParentShell() {
        return this._shell;
    }

    public void setProperties(Properties properties) {
        this._props = properties;
    }

    public void setConnElement(IElement iElement) {
        this._element = iElement;
    }

    protected void handlePing(Properties properties) {
        this._pingProps = properties;
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                    iProgressMonitor.beginTask(BaseInfoPane.this.getResourceString("BaseInfoPane.ping.task"), -1);
                    iProgressMonitor.subTask(BaseInfoPane.this.getResourceString("BaseInfoPane.ping.subTask"));
                    String string = BaseInfoPane.this._pingProps.getProperty("ConnectionName");
                    String string2 = BaseInfoPane.this._pingProps.getProperty("PING_PROTOCOL");
                    BaseInfoPane.this._pingStatus = BaseInfoPane.this._element.ping(string, string2, BaseInfoPane.this._pingProps);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    throw new InvocationTargetException(throwable);
                }
                iProgressMonitor.done();
            }
        };
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this._shell);
        String string = this.getResourceString("BaseInfoPane.ping.status");
        try {
            progressMonitorDialog.run(true, false, iRunnableWithProgress);
            if (this._pingStatus == null) {
                return;
            }
            StatusUtil.createStatusDialog(this._shell, string, this._pingStatus);
        }
        catch (Throwable throwable) {
            RepConnectorUIPlugin.log(throwable);
            StatusUtil.createStatusDialog(this._shell, string, throwable);
        }
    }

    public void setConnectionPropertyObject(ConnectionPropertyObject connectionPropertyObject) {
        this._connPropObj = connectionPropertyObject;
    }

    public ConnectionPropertyObject getConnectionPropertyObject(ConnectionPropertyObject connectionPropertyObject) {
        return this._connPropObj;
    }
}

