/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.layouts;

import com.sybase.connector.ui.StatusUtil;
import com.sybase.connector.ui.layouts.BaseInfoPane;
import java.util.Properties;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class MqInfoPane
extends BaseInfoPane {
    private Composite _composite;
    public Text _hostName;
    public Text _portnumber;
    public Text _channel;
    public Text _factory;
    public Text _queueName;
    public Text _userName;
    public Text _password;
    public Button _mqButton;
    public Button _jmsButton;
    public Button _serverButton;
    public Button _clientButton;
    public Button _defaultButton;
    public Button _utfButton;
    public Button _ping;
    private Listener _listener = new Listener(){

        public void handleEvent(Event event) {
        }
    };
    private TraverseListener _traverseListener = new TraverseListener(){

        public void keyTraversed(TraverseEvent traverseEvent) {
            String string;
            if (!(traverseEvent.detail != 16 && traverseEvent.detail != 8 || (string = MqInfoPane.this._portnumber.getText()) == null || string.equals(""))) {
                try {
                    int n = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    StatusUtil.createStatusDialog(MqInfoPane.this._shell, MqInfoPane.this.getResourceString("mqjms.portnumber.notvalid"), MqInfoPane.this.getResourceString("mqjms.portnumber.intrequire"));
                    traverseEvent.doit = false;
                }
            }
        }
    };
    private SelectionListener _myPingListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            Properties properties = new Properties();
            properties.setProperty("PING_PROTOCOL", "IBMMQ");
            if (MqInfoPane.this._mqButton.getSelection()) {
                properties.setProperty("MQType", "MQ");
            } else {
                properties.setProperty("MQType", "MQJMS");
            }
            properties.setProperty("MQ_LocalClient", String.valueOf(MqInfoPane.this._clientButton.getSelection()));
            properties.setProperty("MQ_Encoding", String.valueOf(MqInfoPane.this._utfButton.getSelection()));
            if (MqInfoPane.this._utfButton.getSelection()) {
                properties.setProperty("MQ_Encoding", "utf");
            } else {
                properties.setProperty("MQ_Encoding", "Default");
            }
            properties.setProperty("MQ_Hostname", MqInfoPane.this._hostName.getText());
            properties.setProperty("MQ_PortNumber", MqInfoPane.this._portnumber.getText());
            properties.setProperty("MQ_Channel", MqInfoPane.this._channel.getText());
            properties.setProperty("MQ_QueueManager", MqInfoPane.this._factory.getText());
            properties.setProperty("MQ_LocalQueue", MqInfoPane.this._queueName.getText());
            properties.setProperty("MQ_Username", MqInfoPane.this._userName.getText());
            properties.setProperty("MQ_Password", MqInfoPane.this._password.getText());
            MqInfoPane.this.handlePing(properties);
        }

        public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            this.widgetSelected(selectionEvent);
        }
    };

    public MqInfoPane(Composite composite) {
        super(composite);
        this._composite = composite;
    }

    public void setDefault() {
        this._hostName.setText("");
        this._portnumber.setText("");
        this._channel.setText("");
        this._factory.setText("");
        this._queueName.setText("");
        this._userName.setText("");
        this._password.setText("");
        this._statusDest.setText("");
    }

    public void createLayout() {
        Group group = new Group(this._composite, 0);
        group.setText(this.getResourceString("mq.info.label.messagetype"));
        group.setLayout((Layout)new GridLayout(2, true));
        group.setLayoutData((Object)new GridData(768));
        this._mqButton = new Button((Composite)group, 16);
        this._mqButton.setText(this.getResourceString("mq.info.button.mq"));
        this._mqButton.setSelection(true);
        this._jmsButton = new Button((Composite)group, 16);
        this._jmsButton.setText(this.getResourceString("mq.info.button.mqjms"));
        Group group2 = new Group(this._composite, 0);
        group2.setText(this.getResourceString("mq.info.label.daemon"));
        group2.setLayout((Layout)new GridLayout(2, true));
        group2.setLayoutData((Object)new GridData(768));
        this._serverButton = new Button((Composite)group2, 16);
        this._serverButton.setText(this.getResourceString("mq.info.button.serverdaemon"));
        this._serverButton.setSelection(true);
        this._clientButton = new Button((Composite)group2, 16);
        this._clientButton.setText(this.getResourceString("mq.info.button.clientdaemon"));
        Group group3 = new Group(this._composite, 0);
        group3.setText(this.getResourceString("mq.info.label.encoding"));
        group3.setLayout((Layout)new GridLayout(2, true));
        group3.setLayoutData((Object)new GridData(768));
        this._defaultButton = new Button((Composite)group3, 16);
        this._defaultButton.setText(this.getResourceString("mq.info.button.default"));
        this._defaultButton.setSelection(true);
        this._utfButton = new Button((Composite)group3, 16);
        this._utfButton.setText(this.getResourceString("mq.info.button.utf"));
        Group group4 = new Group(this._composite, 0);
        group4.setText("MQ Information");
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 50;
        group4.setLayout((Layout)gridLayout);
        group4.setLayoutData((Object)new GridData(768));
        Label label = new Label((Composite)group4, 0);
        label.setText(this.getResourceString("mq.info.label.hostname"));
        this._hostName = new Text((Composite)group4, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.widthHint = 300;
        gridData.horizontalSpan = 1;
        this._hostName.setLayoutData((Object)gridData);
        this._hostName.setText(this.getResourceString("mq.info.text.hostname"));
        label = new Label((Composite)group4, 0);
        label.setText(this.getResourceString("mq.info.label.portnumber"));
        this._portnumber = new Text((Composite)group4, 2048);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 1;
        gridData2.widthHint = 300;
        this._portnumber.setLayoutData((Object)gridData2);
        this._portnumber.setText(this.getResourceString("mq.info.text.portnumber"));
        this._portnumber.addTraverseListener(this._traverseListener);
        label = new Label((Composite)group4, 0);
        label.setText(this.getResourceString("mq.info.label.channel"));
        this._channel = new Text((Composite)group4, 2048);
        GridData gridData3 = new GridData();
        gridData3.horizontalSpan = 1;
        gridData3.widthHint = 300;
        this._channel.setLayoutData((Object)gridData3);
        this._channel.setText(this.getResourceString("mq.info.text.channel"));
        label = new Label((Composite)group4, 0);
        label.setText(this.getResourceString("mq.info.label.queuemanager"));
        this._factory = new Text((Composite)group4, 2048);
        GridData gridData4 = new GridData();
        gridData4.horizontalSpan = 1;
        gridData4.widthHint = 300;
        this._factory.setLayoutData((Object)gridData4);
        this._factory.setText(this.getResourceString("mq.info.text.queuemanager"));
        label = new Label((Composite)group4, 0);
        label.setText(this.getResourceString("mq.info.label.queuename"));
        this._queueName = new Text((Composite)group4, 2048);
        GridData gridData5 = new GridData();
        gridData5.horizontalSpan = 1;
        gridData5.widthHint = 300;
        this._queueName.setLayoutData((Object)gridData5);
        this._queueName.setText(this.getResourceString("mq.info.text.queuename"));
        label = new Label((Composite)group4, 0);
        label.setText(this.getResourceString("global.username"));
        this._userName = new Text((Composite)group4, 2048);
        GridData gridData6 = new GridData();
        gridData6.horizontalSpan = 1;
        gridData6.widthHint = 300;
        this._userName.setLayoutData((Object)gridData6);
        label = new Label((Composite)group4, 0);
        label.setText(this.getResourceString("global.password"));
        this._password = new Text((Composite)group4, 2048);
        this._password.setEchoChar('*');
        GridData gridData7 = new GridData();
        gridData7.horizontalSpan = 1;
        gridData7.widthHint = 300;
        this._password.setLayoutData((Object)gridData7);
        this.createStatusField((Composite)group4, 1);
        this._ping = new Button(this._composite, 8);
        this._ping.setText(this.getResourceString("global.ping"));
        GridData gridData8 = new GridData();
        gridData8.horizontalAlignment = 256;
        this._ping.setLayoutData((Object)gridData8);
        this._ping.addSelectionListener(this._myPingListener);
    }

    public Properties getProps() {
        Properties properties = new Properties();
        if (this._mqButton.getSelection()) {
            properties.setProperty("MQType", "MQ");
        } else {
            properties.setProperty("MQType", "MQJMS");
        }
        properties.setProperty("MQ_Hostname", this._hostName.getText());
        properties.setProperty("MQ_PortNumber", this._portnumber.getText());
        properties.setProperty("MQ_Channel", this._channel.getText());
        properties.setProperty("MQ_QueueManager", this._factory.getText());
        properties.setProperty("MQ_LocalQueue", this._queueName.getText());
        properties.setProperty("MQ_Username", this._userName.getText());
        properties.setProperty("MQ_Password", this._password.getText());
        if (this._serverButton.getSelection()) {
            properties.setProperty("MQ_LocalClient", "false");
        } else {
            properties.setProperty("MQ_LocalClient", "true");
        }
        if (this._defaultButton.getSelection()) {
            properties.setProperty("MQ_Encoding", "default");
        } else {
            properties.setProperty("MQ_Encoding", "utf");
        }
        if (this._statusDest.getText() != null) {
            properties.setProperty("Status.Destination", this._statusDest.getText());
        }
        return properties;
    }
}

