/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.model;

import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.ui.model.ElementModel;
import com.sybase.connector.ui.model.IModelVisitor;
import com.sybase.connector.ui.persistance.Profile;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ConnectionElement
extends ElementModel {
    protected static List newConnections = ConnectionElement.buildConnectionList();
    protected static int cursor = 0;
    protected String status = "STOP";
    protected static Vector propertyDescriptors = null;
    private static final String STATUS = "Status";
    private Hashtable bufferedProps = new Hashtable();

    public ConnectionElement(String string) {
        super(string);
    }

    public static ConnectionElement newConnection() {
        ConnectionElement connectionElement = (ConnectionElement)newConnections.get(cursor);
        cursor = (cursor + 1) % newConnections.size();
        return connectionElement;
    }

    protected static List buildConnectionList() {
        newConnections = new ArrayList();
        ConnectionElement[] connectionElementArray = new ConnectionElement[]{};
        for (int i = 0; i < connectionElementArray.length; ++i) {
            newConnections.add(connectionElementArray[i]);
        }
        return newConnections;
    }

    public void accept(IModelVisitor iModelVisitor, Object object) {
        iModelVisitor.visitRepConnector(this, object);
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public String getStatus() {
        return this.status;
    }

    public RaStatus ping(String string, String string2, Properties properties) throws Exception {
        Profile profile = this.getLoginInfo();
        RaClientUtil raClientUtil = new RaClientUtil(profile.getHostname(), profile.getPort(), profile.getUsername(), profile.getPassword());
        Vector vector = raClientUtil.ping(this.getName(), string2, properties);
        Object var7_7 = null;
        for (int i = 0; i < vector.size(); ++i) {
            var7_7 = vector.elementAt(i);
            if (!(var7_7 instanceof RaStatus)) continue;
            return var7_7;
        }
        throw new Exception(ConnectionElement.getResourceString("ConnectionElement.ping.m1"));
    }

    public Profile getLoginInfo() throws Exception {
        return this.parent.getLoginInfo();
    }

    public RaStatus updateConnection(String string, Properties properties) throws Exception {
        Profile profile = this.getLoginInfo();
        RaStatus raStatus = null;
        RaClientUtil raClientUtil = new RaClientUtil(profile.getHostname(), profile.getPort(), profile.getUsername(), profile.getPassword());
        if (properties == null) {
            this.modifyGeneralProps();
            this.modifyInboundProps();
            this.modifyOutboundProps();
            if (this.props.getProperty("OutboundType", "").equals("CUSTOM") || this.props.getProperty("FormatterFlag", "false").equals("true")) {
                this.modifyPluginProps();
            }
            raStatus = raClientUtil.createConnection(this.getName(), this.props, true);
        } else {
            raStatus = raClientUtil.createConnection(this.getName(), properties, true);
        }
        if (raStatus.getCode() != 4) {
            this.setProperties(this.props);
        }
        return raStatus;
    }

    public void setProperties(Properties properties) {
        super.setProperties(properties);
        Enumeration<Object> enumeration = properties.keys();
        String string = "";
        propertyDescriptors = new Vector();
        propertyDescriptors.add(new TextPropertyDescriptor((Object)STATUS, STATUS));
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            propertyDescriptors.add(new TextPropertyDescriptor((Object)string, string));
        }
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (propertyDescriptors != null) {
            IPropertyDescriptor[] iPropertyDescriptorArray = new IPropertyDescriptor[propertyDescriptors.size()];
            for (int i = 0; i < propertyDescriptors.size(); ++i) {
                iPropertyDescriptorArray[i] = (IPropertyDescriptor)propertyDescriptors.elementAt(i);
            }
            return iPropertyDescriptorArray;
        }
        return null;
    }

    public Object getPropertyValue(Object object) {
        try {
            if (this.getProperties().containsKey((String)object)) {
                return this.getProperties().getProperty((String)object);
            }
            if (((String)object).equals(STATUS)) {
                return this.status;
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void setPropertyValue(Object object, Object object2) {
        this.name = object2.toString();
        this.firePropertyChange("list", this.getInvisibleRoot(), this);
    }

    public RaStatus validateConnection(String string, Properties properties) throws Exception {
        return this.ping(this.getName(), "ALL", properties);
    }

    public RaStatus createConnection(String string, Properties properties) throws Exception {
        throw new Exception(ConnectionElement.getResourceString("not.implemented.in.connection") + "createConnection");
    }

    public boolean isConnectionExist(String string) throws Exception {
        if (string != null && this.getName().equals(string)) {
            return true;
        }
        throw new Exception(ConnectionElement.getResourceString("not.implemented.in.connection") + "isConnectionExist");
    }

    public Hashtable getBufferedProps() {
        return this.bufferedProps;
    }

    public void setBufferedProps(Hashtable hashtable) {
        this.bufferedProps = hashtable;
    }

    public Properties getBufferedProps(String string) {
        if (string.equals("GENERAL") && this.bufferedProps.containsKey("GENERAL")) {
            this.bufferedProps.put("GENERAL", this.props.clone());
        }
        return (Properties)this.bufferedProps.get(string);
    }

    public void setBufferedProps(String string, Properties properties) {
        this.bufferedProps.put(string, properties);
    }

    protected void modifyGeneralProps() {
        Properties properties = (Properties)this.bufferedProps.get("GENERAL");
        if (properties != null) {
            this.props.setProperty("DTD_URL", properties.getProperty("DTD_URL"));
            this.props.setProperty("LogLevel", properties.getProperty("LogLevel"));
            this.props.setProperty("InboundType", properties.getProperty("InboundType"));
            this.props.setProperty("OutboundType", properties.getProperty("OutboundType"));
            this.props.setProperty("AutoStart", properties.getProperty("AutoStart"));
            this.props.setProperty("FormatterFlag", properties.getProperty("FormatterFlag"));
            this.props.setProperty("EncryptedFlag", properties.getProperty("EncryptedFlag"));
        }
    }

    protected void modifyInboundProps() {
        String string = this.props.getProperty("InboundType", "REPLICATION");
        Properties properties = null;
        if (string.equals("REPLICATION") && this.bufferedProps.get("IN_REPLICATION") != null) {
            properties = (Properties)this.bufferedProps.get("IN_REPLICATION");
        } else if (string.equals("JMS") && this.bufferedProps.get("IN_JMS") != null) {
            properties = (Properties)this.bufferedProps.get("IN_JMS");
        } else if (string.equals("TIBCO") && this.bufferedProps.get("IN_TIBCO") != null) {
            properties = (Properties)this.bufferedProps.get("IN_TIBCO");
        } else if (string.equals("IBMMQ") && this.bufferedProps.get("IN_IBMMQ") != null) {
            properties = (Properties)this.bufferedProps.get("IN_IBMMQ");
        }
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            String string2 = "";
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                this.props.setProperty(string2, properties.getProperty(string2));
            }
        }
    }

    protected void modifyOutboundProps() {
        String string = this.props.getProperty("OutboundType", "JMS");
        Properties properties = null;
        if (string.equals("JMS") && this.bufferedProps.get("OUT_JMS") != null) {
            properties = (Properties)this.bufferedProps.get("OUT_JMS");
        } else if (string.equals("TIBCO") && this.bufferedProps.get("OUT_TIBCO") != null) {
            properties = (Properties)this.bufferedProps.get("OUT_TIBCO");
        } else if (string.equals("IBMMQ") && this.bufferedProps.get("OUT_IBMMQ") != null) {
            properties = (Properties)this.bufferedProps.get("OUT_IBMMQ");
        } else if (string.equals("DATABASE") && this.bufferedProps.get("OUT_DATABASE") != null) {
            properties = (Properties)this.bufferedProps.get("OUT_DATABASE");
        }
        if (properties != null) {
            Enumeration<Object> enumeration = properties.keys();
            String string2 = "";
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                this.props.setProperty(string2, properties.getProperty(string2));
            }
        }
    }

    protected void modifyPluginProps() {
        Properties properties = (Properties)this.bufferedProps.get("CUSTOM");
        if (properties != null) {
            if (this.props.getProperty("OutboundType").equals("CUSTOM")) {
                this.props.setProperty("SenderPlugin", properties.getProperty("SenderPlugin", ""));
                this.props.setProperty("SenderProperties", properties.getProperty("SenderProperties", ""));
            }
            if (this.props.getProperty("FormatterFlag").equals("true")) {
                this.props.setProperty("FormatterPlugin", properties.getProperty("FormatterPlugin", ""));
                this.props.setProperty("FormatterProperties", properties.getProperty("FormatterProperties", ""));
            }
        }
    }
}

