/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.model;

import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.ui.RepConnectorUIPlugin;
import com.sybase.connector.ui.model.EventReceiver;
import com.sybase.connector.ui.model.EventReceiverHandler;
import com.sybase.connector.ui.model.IElement;
import com.sybase.connector.ui.model.IModelVisitor;
import com.sybase.connector.ui.model.ProfileElement;
import com.sybase.connector.ui.model.SingletonEventListener;
import com.sybase.connector.ui.persistance.Profile;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public abstract class ElementModel
implements ISelection,
IPropertySource,
IAdaptable,
IElement {
    protected ProfileElement parent;
    protected String name;
    protected Properties props = null;
    protected Properties workProps = null;
    protected EventReceiverHandler listener = SingletonEventListener.getSoleInstance();
    private ListenerList propertyChangeListeners = new ListenerList();
    public static final String P_ELEMENT_ID = "ConnectionName";
    public static final String P_ELEMENT_DISPLAY_NAME = "name";
    public static final String P_ELEMENT_ID2 = "ConnectionID";
    public static final String P_ELEMENT_DISPLAY_ID = "id";
    protected static final IPropertyDescriptor[] propertyDescriptors = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"ConnectionName", "name"), new TextPropertyDescriptor((Object)"ConnectionID", "id")};

    public ElementModel() {
    }

    protected void fireAdd(Object object) {
        this.listener.add(new EventReceiver(object));
    }

    protected void fireRemove(Object object) {
        this.listener.remove(new EventReceiver(object));
    }

    public ProfileElement getParent() {
        return this.parent;
    }

    public abstract void accept(IModelVisitor var1, Object var2);

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setProperties(Properties properties) {
        this.props = properties;
    }

    public Properties getProperties() {
        return this.props;
    }

    public Properties getWorkProperties() {
        if (this.workProps == null) {
            return new Properties(this.props);
        }
        return this.workProps;
    }

    public void setWorkProperties(Properties properties) {
        if (this.workProps == null) {
            this.workProps = new Properties(properties);
        } else {
            this.workProps.putAll((Map<?, ?>)properties);
        }
    }

    public void addListener(EventReceiverHandler eventReceiverHandler) {
        this.listener = eventReceiverHandler;
    }

    public ElementModel(String string) {
        this.name = string;
    }

    public ElementModel(String string, Properties properties) {
        this.name = string;
        this.props = properties;
    }

    public void removeListener(EventReceiverHandler eventReceiverHandler) {
        if (this.listener.equals(eventReceiverHandler)) {
            this.listener = SingletonEventListener.getSoleInstance();
        }
    }

    public String getTitle() {
        return this.name;
    }

    public boolean isEmpty() {
        return false;
    }

    public static String getResourceString(String string) {
        return RepConnectorUIPlugin.getResourceString(string);
    }

    public void addPropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.propertyChangeListeners.add((Object)iPropertyChangeListener);
    }

    public void firePropertyChange(String string, Object object, Object object2) {
        final PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent((Object)this, string, object, object2);
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Object[] objectArray = ElementModel.this.propertyChangeListeners.getListeners();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((IPropertyChangeListener)objectArray[i]).propertyChange(propertyChangeEvent);
                }
            }
        });
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return propertyDescriptors;
    }

    public void removePropertyChangeListener(IPropertyChangeListener iPropertyChangeListener) {
        this.propertyChangeListeners.remove((Object)iPropertyChangeListener);
    }

    public Object getPropertyValue(Object object) {
        if (object.equals(P_ELEMENT_ID)) {
            return this.name;
        }
        if (object.equals(P_ELEMENT_ID2)) {
            return new String("99");
        }
        return new String();
    }

    public boolean isPropertySet(Object object) {
        return false;
    }

    public Object getEditableValue() {
        return this;
    }

    public void resetPropertyValue(Object object) {
    }

    public void setPropertyValue(Object object, Object object2) {
        this.name = object2.toString();
        this.firePropertyChange("list", this.getInvisibleRoot(), this);
    }

    public Object getAdapter(Class clazz) {
        try {
            return null;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    protected ElementModel getInvisibleRoot() {
        ProfileElement profileElement = null;
        ProfileElement profileElement2 = this.parent;
        while ((profileElement = profileElement2.getParent()) != null) {
            profileElement2 = profileElement;
        }
        return profileElement2;
    }

    public RaStatus ping(String string, String string2, Properties properties) throws Exception {
        Profile profile = this.getLoginInfo();
        RaClientUtil raClientUtil = new RaClientUtil(profile.getHostname(), profile.getPort(), profile.getUsername(), profile.getPassword());
        Vector vector = raClientUtil.ping(this.getName(), string2, properties);
        Object var7_7 = null;
        for (int i = 0; i < vector.size(); ++i) {
            var7_7 = vector.elementAt(i);
            if (!(var7_7 instanceof RaStatus)) continue;
            return var7_7;
        }
        throw new Exception(ElementModel.getResourceString("ConnectionElement.ping.m1"));
    }

    public RaStatus getLogInfo() throws Exception {
        Profile profile = this.getLoginInfo();
        RaClientUtil raClientUtil = new RaClientUtil(profile.getHostname(), profile.getPort(), profile.getUsername(), profile.getPassword());
        RaStatus raStatus = raClientUtil.getLogInfo(this.name);
        return raStatus;
    }
}

