/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.model;

import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.ui.model.ConnectionElement;
import com.sybase.connector.ui.model.ElementModel;
import com.sybase.connector.ui.model.IElement;
import com.sybase.connector.ui.model.IModelVisitor;
import com.sybase.connector.ui.model.SingletonEventListener;
import com.sybase.connector.ui.persistance.Profile;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ProfileElement
extends ElementModel {
    protected List folders;
    protected List connections;
    private static IModelVisitor adder = new Adder();
    private static IModelVisitor remover = new Remover();
    private ListenerList propertyChangeListeners = new ListenerList();
    public static final String P_PROFILENAME = "ProfileName";
    public static final String P_PROFILENAME_DEFAULT_VALUE = "localhost:8000";
    public static final String P_HOSTNAME = "ProfileHost";
    public static final String P_HOSTNAME_DEFAULT_VALUE = "localhost";
    public static final String P_PORTNUMBER = "ProfilePort";
    public static final String P_PORTNUMBER_DEFAULT_VALUE = "8000";
    public static final String P_USERNAME = "ProfileUser";
    public static final String P_USERNAME_DEFAULT_VALUE = "repraadmin";
    public static final String P_STATUS = "ProfileStatus";
    public static final String P_STATUS_DEFAULT_VALUE = "Not Connected";
    protected static final IPropertyDescriptor[] propertyDescriptors = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"ProfileName", "ProfileName"), new TextPropertyDescriptor((Object)"ProfileHost", "ProfileHost"), new TextPropertyDescriptor((Object)"ProfilePort", "ProfilePort"), new TextPropertyDescriptor((Object)"ProfileUser", "ProfileUser"), new TextPropertyDescriptor((Object)"ProfileStatus", "ProfileStatus")};
    Properties profile = new Properties();

    public ProfileElement() {
        this.folders = new ArrayList();
        this.connections = new ArrayList();
    }

    public ProfileElement(Properties properties) {
        this.profile = properties;
        this.name = properties.getProperty(P_PROFILENAME);
        this.folders = new ArrayList();
        this.connections = new ArrayList();
    }

    public ProfileElement(String string) {
        this();
        this.name = string;
    }

    public List getFolders() {
        return this.folders;
    }

    protected void addFolder(ProfileElement profileElement) {
        this.folders.add(profileElement);
        profileElement.parent = this;
        this.fireAdd(profileElement);
    }

    protected void addConnection(ConnectionElement connectionElement) {
        if (this.getConnection(connectionElement.getName()) != null) {
            return;
        }
        this.connections.add(connectionElement);
        connectionElement.parent = this;
        this.fireAdd(connectionElement);
    }

    public List getConnections() {
        return this.connections;
    }

    public void remove(ElementModel elementModel) {
        elementModel.accept(remover, this);
    }

    protected void removeConnection(ConnectionElement connectionElement) {
        this.connections.remove(connectionElement);
        connectionElement.addListener(SingletonEventListener.getSoleInstance());
        this.fireRemove(connectionElement);
    }

    public void removeAll() {
        while (this.size() != 0) {
            this.remove((ConnectionElement)this.connections.remove(this.size() - 1));
        }
    }

    protected void removeFolder(ProfileElement profileElement) {
        this.folders.remove(profileElement);
        profileElement.addListener(SingletonEventListener.getSoleInstance());
        this.fireRemove(profileElement);
    }

    public void add(ElementModel elementModel) {
        elementModel.accept(adder, this);
    }

    public IElement getConnection(String string) {
        for (int i = 0; i < this.connections.size(); ++i) {
            ElementModel elementModel = (ElementModel)this.connections.get(i);
            if (string == null || !elementModel.getName().equals(string)) continue;
            return elementModel;
        }
        return null;
    }

    public int size() {
        return this.getConnections().size() + this.getFolders().size();
    }

    public void accept(IModelVisitor iModelVisitor, Object object) {
        iModelVisitor.visitTreeFolder(this, object);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return propertyDescriptors;
    }

    public void setPropertyValue(Object object, Object object2) {
        this.name = object2.toString();
        this.firePropertyChange("list", this.getInvisibleRoot(), this);
    }

    public Object getPropertyValue(Object object) {
        try {
            if (object.equals(P_PROFILENAME)) {
                return this.profile.getProperty(P_PROFILENAME, "");
            }
            if (object.equals(P_HOSTNAME)) {
                return this.profile.getProperty(P_HOSTNAME, "");
            }
            if (object.equals(P_PORTNUMBER)) {
                return this.profile.getProperty(P_PORTNUMBER, "");
            }
            if (object.equals(P_USERNAME)) {
                return this.profile.getProperty(P_USERNAME, "");
            }
            if (object.equals(P_STATUS)) {
                return this.profile.getProperty(P_STATUS, P_STATUS_DEFAULT_VALUE);
            }
            return "";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public Properties getProfile() {
        return this.profile;
    }

    public void setProfile(Properties properties) {
        this.profile = properties;
    }

    public void setName(String string) {
        this.profile.setProperty(P_PROFILENAME, string);
        this.name = string;
    }

    public String getProfileName() {
        return this.profile.getProperty(P_PROFILENAME);
    }

    public String getProfileHost() {
        return this.profile.getProperty(P_HOSTNAME);
    }

    public String getProfilePort() {
        return this.profile.getProperty(P_PORTNUMBER);
    }

    public String getProfileUser() {
        return this.profile.getProperty(P_USERNAME);
    }

    public String getProfilePass() {
        return this.profile.getProperty("ProfilePass", "");
    }

    public String getProfileStatus() {
        return this.profile.getProperty(P_STATUS, "");
    }

    public void setProfileName(String string) {
        this.profile.setProperty(P_PROFILENAME, string);
    }

    public void setProfileHost(String string) {
        this.profile.setProperty(P_HOSTNAME, string);
    }

    public void setProfilePort(String string) {
        this.profile.setProperty(P_PORTNUMBER, string);
    }

    public void setProfileUser(String string) {
        this.profile.setProperty(P_USERNAME, string);
    }

    public void setProfilePass(String string) {
        this.profile.setProperty("ProfilePass", string);
    }

    public void setProfileStatus(String string) {
        this.profile.setProperty(P_STATUS, string);
    }

    public Profile getLoginInfo() throws Exception {
        Profile profile = new Profile();
        profile.setName(this.getProfileName());
        profile.setHostname(this.getProfileHost());
        profile.setPort(this.getProfilePort());
        profile.setUsername(this.getProfileUser());
        profile.setPassword(this.getProfilePass());
        return profile;
    }

    public RaStatus updateConnection(String string, Properties properties) throws Exception {
        IElement iElement = this.getConnection(string);
        ConnectionElement connectionElement = null;
        if (iElement instanceof ConnectionElement) {
            connectionElement = (ConnectionElement)iElement;
            return connectionElement.updateConnection(string, properties);
        }
        throw new Exception(ProfileElement.getResourceString("ProfileElement.updateConnection.m1"));
    }

    public RaStatus validateConnection(String string, Properties properties) throws Exception {
        return this.ping(string, "ALL", properties);
    }

    public RaStatus createConnection(String string, Properties properties) throws Exception {
        Profile profile = this.getLoginInfo();
        RaClientUtil raClientUtil = new RaClientUtil(profile.getHostname(), profile.getPort(), profile.getUsername(), profile.getPassword());
        RaStatus raStatus = raClientUtil.createConnection(string, properties, false);
        if (raStatus.getCode() != 4) {
            ConnectionElement connectionElement = new ConnectionElement(string);
            connectionElement.setProperties(properties);
            this.add(connectionElement);
        }
        return raStatus;
    }

    public boolean isConnectionExist(String string) throws Exception {
        return this.getConnection(string) != null;
    }

    private static class Remover
    implements IModelVisitor {
        private Remover() {
        }

        public void visitRepConnector(ConnectionElement connectionElement, Object object) {
            ((ProfileElement)object).removeConnection(connectionElement);
        }

        public void visitTreeFolder(ProfileElement profileElement, Object object) {
            ((ProfileElement)object).removeFolder(profileElement);
            profileElement.addListener(SingletonEventListener.getSoleInstance());
        }
    }

    private static class Adder
    implements IModelVisitor {
        private Adder() {
        }

        public void visitRepConnector(ConnectionElement connectionElement, Object object) {
            ((ProfileElement)object).addConnection(connectionElement);
        }

        public void visitTreeFolder(ProfileElement profileElement, Object object) {
            ((ProfileElement)object).addFolder(profileElement);
        }
    }
}

