/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.persistance;

import com.sybase.connector.ui.ProfileDirectory;
import com.sybase.connector.ui.RepConnectorUIPlugin;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ProfileXMLHandler {
    Hashtable table = new Hashtable();
    String _filename = ProfileDirectory.getInstance().getProfile();
    FileInputStream fin = null;
    XMLDecoder decoder = null;
    FileOutputStream fout = null;
    XMLEncoder encoder = null;
    private static ProfileXMLHandler xmlHandler = null;

    public static ProfileXMLHandler getInstance() {
        if (xmlHandler == null) {
            xmlHandler = new ProfileXMLHandler();
            try {
                xmlHandler.loadXML();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return xmlHandler;
    }

    private ProfileXMLHandler() {
    }

    public void addProfile(Properties properties) throws Exception {
        if (this.hasProfile(properties.getProperty("ProfileName"))) {
            throw new Exception(RepConnectorUIPlugin.getResourceString("ProfileXMLHandler.addProfile.m1") + properties.getProperty("ProfileName"));
        }
        this.table.put(properties.getProperty("ProfileName"), properties);
        this.refreshXML();
    }

    public Properties getProfile(String string) throws Exception {
        if (this.hasProfile(string)) {
            return (Properties)this.table.get(string);
        }
        throw new Exception(RepConnectorUIPlugin.getResourceString("ProfileXMLHandler.getProfile.m1") + string);
    }

    public void modifyProfile(Properties properties) throws Exception {
        if (!this.hasProfile(properties.getProperty("ProfileName"))) {
            throw new Exception(RepConnectorUIPlugin.getResourceString("ProfileXMLHandler.modifyProfile.m1") + properties.getProperty("ProfileName"));
        }
        this.table.put(properties.getProperty("ProfileName"), properties);
        this.refreshXML();
    }

    public void removeProfile(String string) throws Exception {
        if (!this.hasProfile(string)) {
            throw new Exception(RepConnectorUIPlugin.getResourceString("ProfileXMLHandler.removeProfile.m1") + string);
        }
        this.table.remove(string);
        this.refreshXML();
    }

    public void renameProfile(String string, String string2) throws Exception {
        if (this.hasProfile(string)) {
            if (this.hasProfile(string2)) {
                throw new Exception(RepConnectorUIPlugin.getResourceString("ProfileXMLHandler.renameProfile.m1") + string2);
            }
        } else {
            throw new Exception(RepConnectorUIPlugin.getResourceString("ProfileXMLHandler.renameProfile.m2") + string);
        }
        Properties properties = (Properties)this.table.remove(string);
        properties.setProperty("ProfileName", string2);
        this.table.put(string2, properties);
        this.refreshXML();
    }

    public void saveAsProfile(String string, String string2) throws Exception {
        if (this.hasProfile(string)) {
            if (this.hasProfile(string2)) {
                throw new Exception(RepConnectorUIPlugin.getResourceString("ProfileXMLHandler.saveAsProfile.m1") + string2);
            }
        } else {
            throw new Exception(RepConnectorUIPlugin.getResourceString("ProfileXMLHandler.saveAsProfile.m2") + string);
        }
        Properties properties = (Properties)this.table.get(string);
        properties.setProperty("ProfileName", string2);
        this.table.put(string2, properties);
        this.refreshXML();
    }

    public boolean hasProfile(String string) {
        return this.table.containsKey(string);
    }

    public synchronized Hashtable loadXML() throws Exception {
        try {
            File file = new File(this._filename);
            this.fin = new FileInputStream(this._filename);
            this.decoder = new XMLDecoder(this.fin);
            this.table = (Hashtable)this.decoder.readObject();
            this.decoder.close();
            this.fin.close();
            Enumeration enumeration = this.table.keys();
            String string = "";
            Properties properties = null;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                properties = (Properties)((Properties)this.table.get(string)).clone();
                properties.setProperty("ProfilePass", "");
                this.table.put(string, properties);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.table = new Hashtable();
            Properties properties = this.getDefaultProfile();
            this.addProfile(properties);
        }
        return this.table;
    }

    public Properties getDefaultProfile() {
        Properties properties = new Properties();
        properties.setProperty("ProfileName", "localhost:8000");
        properties.setProperty("ProfileHost", "localhost");
        properties.setProperty("ProfilePort", "8000");
        properties.setProperty("ProfileUser", "repraadmin");
        properties.setProperty("ProfilePass", "");
        properties.setProperty("ProfileStatus", "Not Connected");
        return properties;
    }

    public synchronized Vector getProfiles() throws Exception {
        this.loadXML();
        Vector<Properties> vector = new Vector<Properties>();
        Enumeration enumeration = this.table.keys();
        String string = "";
        Properties properties = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            properties = (Properties)this.table.get(string);
            vector.add(properties);
        }
        return vector;
    }

    public synchronized int size() {
        try {
            this.loadXML();
            return this.table.size();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public synchronized void refreshXML() {
        try {
            File file = new File(this._filename);
            this.fout = new FileOutputStream(this._filename);
            this.encoder = new XMLEncoder(this.fout);
            Hashtable<String, Properties> hashtable = new Hashtable<String, Properties>();
            Enumeration enumeration = this.table.keys();
            String string = "";
            Properties properties = null;
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                properties = (Properties)((Properties)this.table.get(string)).clone();
                properties.setProperty("ProfilePass", "");
                hashtable.put(string, properties);
            }
            this.encoder.writeObject(hashtable);
            this.encoder.flush();
            this.encoder.close();
            this.fout.flush();
            this.fout.close();
            this.loadXML();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

