/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.properties;

import com.sybase.connector.ui.layouts.JmsInfoPane;
import com.sybase.connector.ui.layouts.MqInfoPane;
import com.sybase.connector.ui.layouts.RepInfoPane;
import com.sybase.connector.ui.layouts.TibcoInfoPane;
import com.sybase.connector.ui.model.ConnectionElement;
import com.sybase.connector.ui.model.IElement;
import com.sybase.connector.ui.properties.BasePropertyPage;
import com.sybase.connector.ui.properties.DefaultConnProps;
import java.util.Properties;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class InboundPropertyPage
extends BasePropertyPage
implements IWorkbenchPropertyPage {
    private int columns = 1;
    MqInfoPane _mqInfoPane;
    TibcoInfoPane _tibcoInfoPane;
    JmsInfoPane _jmsInfoPane;
    RepInfoPane _repInfoPane;
    boolean _rep = false;
    boolean _jms = false;
    boolean _tibco = false;
    boolean _mq = false;

    private void setDefaultInitProps() {
        if (this._defaultProps != null) {
            String string = this._defaultProps.getProperty("InboundType", "REPLICATION");
            if (string.equals("REPLICATION")) {
                this._rep = true;
            } else if (string.equals("JMS")) {
                this._jms = true;
            } else if (string.equals("TIBCO")) {
                this._tibco = true;
            } else if (string.equals("MQJMS") || string.equals("IBMMQ")) {
                this._mq = true;
            }
        }
    }

    protected Control createContents(Composite composite) {
        try {
            Composite composite2 = new Composite(composite, 2048);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = this.columns;
            gridLayout.horizontalSpacing = 10;
            gridLayout.verticalSpacing = 10;
            gridLayout.marginHeight = 10;
            gridLayout.marginWidth = 10;
            composite2.setLayout((Layout)gridLayout);
            this._element = (IElement)this.getElement();
            if (this._element != null) {
                this._originalProps = this._element.getProperties();
                this._defaultProps = this._workProps = this._element.getWorkProperties();
            }
            this.setDefaultInitProps();
            if (this._rep) {
                this.createRepInfo(composite2);
            } else if (this._jms) {
                gridLayout.numColumns = 3;
                this.createJmsInfo(composite2);
            } else if (this._tibco) {
                this.createTibcoInfo(composite2);
            } else if (this._mq) {
                this.createMqInfo(composite2);
            }
            return composite2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private void createMqInfo(Composite composite) {
        this._mqInfoPane = new MqInfoPane(composite);
        this._mqInfoPane.createLayout();
        this._mqInfoPane.setConnElement(this._element);
        this._mqInfoPane.setShell(this.getShell());
        this._mqInfoPane.setProperties(this._defaultProps);
        this._mqInfoPane._statusDestLabel.setEnabled(true);
        this._mqInfoPane._statusDest.setEnabled(true);
        this._mqInfoPane._statusDest.setEditable(true);
        this.setDefaultMqProps();
    }

    private void setDefaultMqProps() {
        DefaultConnProps.setDefaultMqProps(this._mqInfoPane, this._defaultProps);
    }

    private void createTibcoInfo(Composite composite) {
        this._tibcoInfoPane = new TibcoInfoPane(composite);
        this._tibcoInfoPane.createLayout();
        this._tibcoInfoPane.setConnElement(this._element);
        this._tibcoInfoPane.setShell(this.getShell());
        this._tibcoInfoPane.setProperties(this._defaultProps);
        this._tibcoInfoPane._statusDestLabel.setEnabled(true);
        this._tibcoInfoPane._statusDest.setEnabled(true);
        this._tibcoInfoPane._statusDest.setEditable(true);
        this.setDefaultTibcoProps();
    }

    private void setDefaultTibcoProps() {
        DefaultConnProps.setDefaultTibcoProps(this._tibcoInfoPane, this._defaultProps, 0);
    }

    private void createJmsInfo(Composite composite) {
        this._jmsInfoPane = new JmsInfoPane(composite);
        this._jmsInfoPane.createLayout();
        this._jmsInfoPane.setConnElement(this._element);
        this._jmsInfoPane.setShell(this.getShell());
        this._jmsInfoPane.setProperties(this._defaultProps);
        this._jmsInfoPane._statusDestLabel.setEnabled(true);
        this._jmsInfoPane._statusDest.setEnabled(true);
        this._jmsInfoPane._statusDest.setEditable(true);
        this.setDefaultJmsProps();
    }

    private void setDefaultJmsProps() {
        DefaultConnProps.setDefaultJmsProps(this._jmsInfoPane, this._defaultProps);
    }

    private void createRepInfo(Composite composite) {
        this._repInfoPane = new RepInfoPane(composite);
        this._repInfoPane.createLayout();
        this._repInfoPane.setConnElement(this._element);
        this._repInfoPane.setShell(this.getShell());
        this._repInfoPane.setProperties(this._defaultProps);
        this.setDefaultRepProps();
    }

    private void setDefaultRepProps() {
        DefaultConnProps.setDefaultRepProps(this._repInfoPane, this._defaultProps);
    }

    protected void performDefaults() {
        this.updateApplyButton();
        this._defaultProps = this._originalProps;
        this.setDefaultInitProps();
        if (this._rep) {
            this.setDefaultRepProps();
        } else if (this._jms) {
            this.setDefaultJmsProps();
        } else if (this._tibco) {
            this.setDefaultTibcoProps();
        } else if (this._mq) {
            this.setDefaultMqProps();
        }
    }

    protected void performApply() {
        try {
            ConnectionElement connectionElement = (ConnectionElement)this.getElement();
            Properties properties = null;
            if (this._rep) {
                properties = this._repInfoPane.getProps();
                connectionElement.setBufferedProps("IN_REPLICATION", properties);
            } else if (this._jms) {
                properties = this._jmsInfoPane.getProps();
                connectionElement.setBufferedProps("IN_JMS", properties);
            } else if (this._tibco) {
                properties = this._tibcoInfoPane.getProps();
                connectionElement.setBufferedProps("IN_TIBCO", properties);
            } else if (this._mq) {
                properties = this._mqInfoPane.getProps();
                connectionElement.setBufferedProps("IN_IBMMQ", properties);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }
}

