/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.properties;

import com.sybase.connector.ui.layouts.JdbcInfoPane;
import com.sybase.connector.ui.layouts.JmsInfoPane;
import com.sybase.connector.ui.layouts.MqInfoPane;
import com.sybase.connector.ui.layouts.TibcoInfoPane;
import com.sybase.connector.ui.model.ConnectionElement;
import com.sybase.connector.ui.model.IElement;
import com.sybase.connector.ui.properties.BasePropertyPage;
import com.sybase.connector.ui.properties.DefaultConnProps;
import java.util.Properties;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;

public class OutboundPropertyPage
extends BasePropertyPage
implements IWorkbenchPropertyPage {
    private int columns = 1;
    boolean _jdbc = false;
    boolean _jms = false;
    boolean _tibco = false;
    boolean _mq = false;
    private Properties _defaultProps = new Properties();
    private Properties _originalProps = new Properties();
    private MqInfoPane _mqInfoPane;
    private TibcoInfoPane _tibcoInfoPane;
    private JmsInfoPane _jmsInfoPane;
    private JdbcInfoPane _jdbcInfoPane;

    private void setDefaultInitProps() {
        if (this._defaultProps != null) {
            String string = this._defaultProps.getProperty("OutboundType", "JMS");
            if (string.equals("DATABASE")) {
                this._jdbc = true;
            } else if (string.equals("JMS")) {
                this._jms = true;
            } else if (string.equals("TIBCO")) {
                this._tibco = true;
            } else if (string.equals("IBMMQ") || string.equals("MQJMS")) {
                this._mq = true;
            }
        }
    }

    protected void performDefaults() {
        this.updateApplyButton();
        this._defaultProps = this._originalProps;
        this.setDefaultInitProps();
        if (this._jdbc) {
            this.setDefaultDbProps();
        } else if (this._jms) {
            this.setDefaultJmsProps();
        } else if (this._tibco) {
            this.setDefaultTibcoProps();
        } else if (this._mq) {
            this.setDefaultMqProps();
        }
    }

    protected Control createContents(Composite composite) {
        try {
            Composite composite2 = new Composite(composite, 2048);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = this.columns;
            gridLayout.horizontalSpacing = 10;
            gridLayout.verticalSpacing = 10;
            gridLayout.marginHeight = 10;
            gridLayout.marginWidth = 10;
            composite2.setLayout((Layout)gridLayout);
            this._element = (IElement)this.getElement();
            if (this._element != null) {
                this._workProps = this._element.getWorkProperties();
                this._originalProps = this._element.getProperties();
                this._defaultProps = this._workProps;
            }
            this.setDefaultInitProps();
            if (this._jdbc) {
                gridLayout.numColumns = 3;
                this.createJdbcInfo(composite2);
            } else if (this._jms) {
                gridLayout.numColumns = 3;
                this.createJmsInfo(composite2);
            } else if (this._tibco) {
                this.createTibcoInfo(composite2);
            } else if (this._mq) {
                this.createMqInfo(composite2);
            }
            return composite2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    private void createMqInfo(Composite composite) {
        this._mqInfoPane = new MqInfoPane(composite);
        this._mqInfoPane.createLayout();
        this._mqInfoPane.setConnElement(this._element);
        this._mqInfoPane.setShell(this.getShell());
        this._mqInfoPane.setProperties(this._defaultProps);
        this.setDefaultMqProps();
    }

    private void createTibcoInfo(Composite composite) {
        this._tibcoInfoPane = new TibcoInfoPane(composite);
        this._tibcoInfoPane.createLayout();
        this._tibcoInfoPane.setConnElement(this._element);
        this._tibcoInfoPane.setShell(this.getShell());
        this._tibcoInfoPane.setProperties(this._defaultProps);
        this.setDefaultTibcoProps();
    }

    private void createJmsInfo(Composite composite) {
        this._jmsInfoPane = new JmsInfoPane(composite);
        this._jmsInfoPane.createLayout();
        this._jmsInfoPane.setConnElement(this._element);
        this._jmsInfoPane.setShell(this.getShell());
        this._jmsInfoPane.setProperties(this._defaultProps);
        this.setDefaultJmsProps();
    }

    private void createJdbcInfo(Composite composite) {
        this._jdbcInfoPane = new JdbcInfoPane(composite);
        this._jdbcInfoPane.createLayout();
        this._jdbcInfoPane.setConnElement(this._element);
        this._jdbcInfoPane.setShell(this.getShell());
        this._jdbcInfoPane.setProperties(this._defaultProps);
        this.setDefaultDbProps();
    }

    private void setDefaultMqProps() {
        DefaultConnProps.setDefaultMqProps(this._mqInfoPane, this._defaultProps);
    }

    private void setDefaultTibcoProps() {
        DefaultConnProps.setDefaultTibcoProps(this._tibcoInfoPane, this._defaultProps, 1);
    }

    private void setDefaultJmsProps() {
        DefaultConnProps.setDefaultJmsProps(this._jmsInfoPane, this._defaultProps);
    }

    private void setDefaultDbProps() {
        DefaultConnProps.setDefaultDbProps(this._jdbcInfoPane, this._defaultProps);
    }

    protected void performApply() {
        try {
            ConnectionElement connectionElement = (ConnectionElement)this.getElement();
            Properties properties = null;
            if (this._jms) {
                properties = this._jmsInfoPane.getProps();
                connectionElement.setBufferedProps("OUT_JMS", properties);
            } else if (this._tibco) {
                properties = this._tibcoInfoPane.getProps();
                connectionElement.setBufferedProps("OUT_TIBCO", properties);
            } else if (this._mq) {
                properties = this._mqInfoPane.getProps();
                connectionElement.setBufferedProps("OUT_IBMMQ", properties);
            } else if (this._jdbc) {
                properties = this._jdbcInfoPane.getProps();
                connectionElement.setBufferedProps("OUT_DATABASE", properties);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean performOk() {
        this.performApply();
        return true;
    }
}

