/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.view;

import com.sybase.connector.ui.RepConnectorUIPlugin;
import com.sybase.connector.ui.actions.AddConnAction;
import com.sybase.connector.ui.actions.AddProfileAction;
import com.sybase.connector.ui.actions.DeleteConnAction;
import com.sybase.connector.ui.actions.DeleteProfileAction;
import com.sybase.connector.ui.actions.EditProfileAction;
import com.sybase.connector.ui.actions.LoginAction;
import com.sybase.connector.ui.actions.LogoutAction;
import com.sybase.connector.ui.actions.PropertyAction;
import com.sybase.connector.ui.actions.RefreshConnAction;
import com.sybase.connector.ui.actions.RefreshProfileAction;
import com.sybase.connector.ui.actions.RefreshRootAction;
import com.sybase.connector.ui.actions.RenameConnAction;
import com.sybase.connector.ui.actions.RenameProfileAction;
import com.sybase.connector.ui.actions.SaveAsConnAction;
import com.sybase.connector.ui.actions.StartConnAction;
import com.sybase.connector.ui.actions.StopConnAction;
import com.sybase.connector.ui.actions.ValidateConnAction;
import com.sybase.connector.ui.actions.ViewLogAction;
import com.sybase.connector.ui.model.ElementModel;
import com.sybase.connector.ui.model.ProfileContainer;
import com.sybase.connector.ui.model.ProfileElement;
import com.sybase.connector.ui.persistance.ProfileXMLHandler;
import com.sybase.connector.ui.view.RCChildrenSorter;
import com.sybase.connector.ui.view.RCContentProvider;
import com.sybase.connector.ui.view.RCLabelProvider;
import com.sybase.connector.ui.view.RCSelectionChangedListener;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.ViewPart;

public class ConnectionView
extends ViewPart {
    protected TreeViewer treeViewer;
    protected RCLabelProvider labelProvider;
    protected Action addProfileAction;
    protected Action refreshRootAction;
    protected IAction addConnAction;
    protected IAction deleteProfileAction;
    protected IAction renameProfileAction;
    protected IAction loginAction;
    protected IAction logoutAction;
    protected IAction editProfileAction;
    protected IAction refreshProfileAction;
    protected IAction startConnAction;
    protected IAction stopConnAction;
    protected IAction refreshConnAction;
    protected IAction renameConnAction;
    protected IAction deleteConnAction;
    protected IAction saveAsConnAction;
    protected IAction validateConnAction;
    protected IAction gpaction;
    protected IAction viewLogAction;
    protected ProfileContainer root;
    protected ProfileContainer profileContainer;
    protected ProfileXMLHandler profileHandler;
    protected IToolBarManager toolbarManager = null;
    protected Menu rootmenu = null;
    protected Menu profilemenu = null;
    protected Menu connmenu = null;
    protected SelectionChangedEvent selEvent = null;
    protected RCSelectionChangedListener selectionListener = null;

    public void createPartControl(Composite composite) {
        try {
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 1;
            gridLayout.verticalSpacing = 2;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 2;
            composite.setLayout((Layout)gridLayout);
            this.treeViewer = new TreeViewer(composite);
            RCContentProvider rCContentProvider = new RCContentProvider();
            this.treeViewer.setContentProvider((IContentProvider)rCContentProvider);
            this.treeViewer.setSorter((ViewerSorter)new RCChildrenSorter());
            this.labelProvider = new RCLabelProvider();
            this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            this.treeViewer.setUseHashlookup(true);
            GridData gridData = new GridData();
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            this.treeViewer.getControl().setLayoutData((Object)gridData);
            this.profileHandler = ProfileXMLHandler.getInstance();
            this.root = this.getInitializedRoot();
            this.treeViewer.setInput((Object)this.root);
            this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
            this.hookListeners();
            this.createActions();
            this.createMenus();
            this.createRootMenus();
            this.createProfileMenus();
            this.createConnectionMenus();
            this.root.addPropertyChangeListener(rCContentProvider);
            this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent doubleClickEvent) {
                    this.handleDoubleClick();
                }

                private void handleDoubleClick() {
                    ISelection iSelection = ConnectionView.this.treeViewer.getSelection();
                    Object object = ((IStructuredSelection)iSelection).getFirstElement();
                    ConnectionView.this.treeViewer.setExpandedState(object, !ConnectionView.this.treeViewer.getExpandedState(object));
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    protected void hookListeners() {
        this.selectionListener = new RCSelectionChangedListener(this);
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this.selectionListener);
    }

    protected void createActions() {
        this.addProfileAction = new AddProfileAction(this, ConnectionView.getResourceString("action.new.profile.text"));
        this.addProfileAction.setToolTipText(ConnectionView.getResourceString("action.new.profile.text"));
        this.refreshRootAction = new RefreshRootAction(this, ConnectionView.getResourceString("action.refresh.view.text"));
        this.refreshRootAction.setToolTipText(ConnectionView.getResourceString("action.refresh.view.text"));
        this.loginAction = new LoginAction(this, ConnectionView.getResourceString("action.login.text"));
        this.loginAction.setToolTipText(ConnectionView.getResourceString("action.login.text"));
        this.logoutAction = new LogoutAction(this, ConnectionView.getResourceString("action.logout.text"));
        this.logoutAction.setToolTipText(ConnectionView.getResourceString("action.logout.text"));
        this.renameProfileAction = new RenameProfileAction(this, ConnectionView.getResourceString("action.rename.profile.text"));
        this.renameProfileAction.setToolTipText(ConnectionView.getResourceString("action.rename.profile.text"));
        this.deleteProfileAction = new DeleteProfileAction(this, ConnectionView.getResourceString("action.delete.profile.text"));
        this.deleteProfileAction.setToolTipText(ConnectionView.getResourceString("action.delete.profile.text"));
        this.addConnAction = new AddConnAction(this, ConnectionView.getResourceString("action.new.text"));
        this.addConnAction.setToolTipText(ConnectionView.getResourceString("action.new.text"));
        this.refreshProfileAction = new RefreshProfileAction(this, ConnectionView.getResourceString("action.refresh.view.text"));
        this.refreshProfileAction.setToolTipText(ConnectionView.getResourceString("action.refresh.view.text"));
        this.editProfileAction = new EditProfileAction(this, ConnectionView.getResourceString("action.edit.profile.text"));
        this.editProfileAction.setToolTipText(ConnectionView.getResourceString("action.edit.profile.text"));
        this.startConnAction = new StartConnAction(this, ConnectionView.getResourceString("action.start.text"));
        this.startConnAction.setToolTipText(ConnectionView.getResourceString("action.start.text"));
        this.stopConnAction = new StopConnAction(this, ConnectionView.getResourceString("action.stop.text"));
        this.stopConnAction.setToolTipText(ConnectionView.getResourceString("action.stop.text"));
        this.refreshConnAction = new RefreshConnAction(this, ConnectionView.getResourceString("action.refresh.text"));
        this.refreshConnAction.setToolTipText(ConnectionView.getResourceString("action.refresh.text"));
        this.renameConnAction = new RenameConnAction(this, ConnectionView.getResourceString("action.rename.text"));
        this.renameConnAction.setToolTipText(ConnectionView.getResourceString("action.rename.text"));
        this.saveAsConnAction = new SaveAsConnAction(this, ConnectionView.getResourceString("action.saveas.text"));
        this.saveAsConnAction.setToolTipText(ConnectionView.getResourceString("action.saveas.text"));
        this.deleteConnAction = new DeleteConnAction(this, ConnectionView.getResourceString("action.delete.text"));
        this.deleteConnAction.setToolTipText(ConnectionView.getResourceString("action.delete.text"));
        this.validateConnAction = new ValidateConnAction(this, ConnectionView.getResourceString("action.validate.text"));
        this.validateConnAction.setToolTipText(ConnectionView.getResourceString("action.validate.text"));
        ISelectionProvider iSelectionProvider = this.getSite().getSelectionProvider();
        Shell shell = this.getSite().getWorkbenchWindow().getShell();
        this.gpaction = new PropertyAction(shell, iSelectionProvider);
        this.viewLogAction = new ViewLogAction(this, ConnectionView.getResourceString("action.viewlog.text"));
        this.viewLogAction.setToolTipText(ConnectionView.getResourceString("action.viewlog.text"));
    }

    private void createRootMenus() {
        MenuManager menuManager = new MenuManager("repraContextMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                iMenuManager.add((IAction)ConnectionView.this.addProfileAction);
                iMenuManager.add((IAction)ConnectionView.this.refreshRootAction);
            }
        });
        this.rootmenu = menuManager.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(this.rootmenu);
    }

    private void createProfileMenus() {
        MenuManager menuManager = new MenuManager("repraProfileMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                iMenuManager.add(ConnectionView.this.loginAction);
                iMenuManager.add(ConnectionView.this.logoutAction);
                iMenuManager.add((IContributionItem)new Separator());
                iMenuManager.add(ConnectionView.this.addConnAction);
                iMenuManager.add((IContributionItem)new Separator());
                iMenuManager.add(ConnectionView.this.renameProfileAction);
                iMenuManager.add(ConnectionView.this.refreshProfileAction);
                iMenuManager.add(ConnectionView.this.deleteProfileAction);
                iMenuManager.add((IContributionItem)new Separator());
                iMenuManager.add(ConnectionView.this.editProfileAction);
                iMenuManager.add((IContributionItem)new Separator());
                iMenuManager.add(ConnectionView.this.viewLogAction);
            }
        });
        this.profilemenu = menuManager.createContextMenu(this.treeViewer.getControl());
    }

    public void modifyProfileMenu(boolean bl) {
        if (bl) {
            this.loginAction.setEnabled(false);
            this.logoutAction.setEnabled(true);
            this.refreshProfileAction.setEnabled(true);
            this.editProfileAction.setEnabled(false);
            this.addConnAction.setEnabled(true);
            this.viewLogAction.setEnabled(true);
        } else {
            this.loginAction.setEnabled(true);
            this.logoutAction.setEnabled(false);
            this.refreshProfileAction.setEnabled(false);
            this.editProfileAction.setEnabled(true);
            this.addConnAction.setEnabled(false);
            this.viewLogAction.setEnabled(false);
        }
        this.treeViewer.refresh();
    }

    private void createConnectionMenus() {
        MenuManager menuManager = new MenuManager("repraProfileMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                iMenuManager.add(ConnectionView.this.startConnAction);
                iMenuManager.add(ConnectionView.this.stopConnAction);
                iMenuManager.add(ConnectionView.this.refreshConnAction);
                iMenuManager.add((IContributionItem)new Separator());
                iMenuManager.add(ConnectionView.this.renameConnAction);
                iMenuManager.add(ConnectionView.this.deleteConnAction);
                iMenuManager.add(ConnectionView.this.saveAsConnAction);
                iMenuManager.add((IContributionItem)new Separator());
                iMenuManager.add(ConnectionView.this.validateConnAction);
                iMenuManager.add((IContributionItem)new Separator());
                iMenuManager.add(ConnectionView.this.gpaction);
                iMenuManager.add((IContributionItem)new Separator());
                iMenuManager.add(ConnectionView.this.viewLogAction);
            }
        });
        this.connmenu = menuManager.createContextMenu(this.treeViewer.getControl());
    }

    public void modifyConnectionMenu(boolean bl) {
        if (bl) {
            this.startConnAction.setEnabled(false);
            this.stopConnAction.setEnabled(true);
            this.refreshConnAction.setEnabled(true);
            this.renameConnAction.setEnabled(false);
            this.deleteConnAction.setEnabled(false);
            this.validateConnAction.setEnabled(false);
        } else {
            this.startConnAction.setEnabled(true);
            this.stopConnAction.setEnabled(false);
            this.refreshConnAction.setEnabled(false);
            this.renameConnAction.setEnabled(true);
            this.deleteConnAction.setEnabled(true);
            this.validateConnAction.setEnabled(true);
        }
        this.viewLogAction.setEnabled(true);
        this.treeViewer.refresh();
    }

    protected void createMenus() {
        IMenuManager iMenuManager = this.getViewSite().getActionBars().getMenuManager();
        iMenuManager.setRemoveAllWhenShown(true);
        iMenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                ConnectionView.this.fillMenu(iMenuManager);
            }
        });
        this.fillMenu(iMenuManager);
    }

    protected void fillMenu(IMenuManager iMenuManager) {
    }

    protected void updateSorter(Action action) {
    }

    public RCLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void setText(String string) {
    }

    protected void updateFilter(Action action) {
    }

    protected void createToolbar() {
        this.toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.toolbarManager.add((IAction)this.addProfileAction);
        this.toolbarManager.add((IAction)this.refreshRootAction);
        this.toolbarManager.add(this.loginAction);
        this.toolbarManager.add(this.logoutAction);
        this.toolbarManager.add(this.renameProfileAction);
        this.toolbarManager.add(this.deleteProfileAction);
        this.toolbarManager.add(this.renameProfileAction);
        this.toolbarManager.add(this.refreshProfileAction);
        this.toolbarManager.add(this.addConnAction);
        this.toolbarManager.add(this.startConnAction);
        this.toolbarManager.add(this.stopConnAction);
        this.toolbarManager.add(this.deleteConnAction);
        this.toolbarManager.add(this.refreshConnAction);
        this.toolbarManager.add(this.renameConnAction);
        this.toolbarManager.add(this.saveAsConnAction);
        this.toolbarManager.add(this.validateConnAction);
        this.toolbarManager.add(this.gpaction);
        this.toolbarManager.add(this.viewLogAction);
    }

    private void disableAllAction() {
        this.addProfileAction.setEnabled(false);
        this.refreshRootAction.setEnabled(false);
        this.addConnAction.setEnabled(false);
        this.deleteProfileAction.setEnabled(false);
        this.renameProfileAction.setEnabled(false);
        this.loginAction.setEnabled(false);
        this.logoutAction.setEnabled(false);
        this.editProfileAction.setEnabled(false);
        this.refreshProfileAction.setEnabled(false);
        this.startConnAction.setEnabled(false);
        this.stopConnAction.setEnabled(false);
        this.refreshConnAction.setEnabled(false);
        this.renameConnAction.setEnabled(false);
        this.deleteConnAction.setEnabled(false);
        this.saveAsConnAction.setEnabled(false);
        this.validateConnAction.setEnabled(false);
        this.viewLogAction.setEnabled(false);
    }

    public void enableRootMenu() {
        this.disableAllAction();
        this.addProfileAction.setEnabled(true);
        this.refreshRootAction.setEnabled(true);
    }

    public void enableProfileMenu() {
        this.disableAllAction();
        this.addConnAction.setEnabled(true);
        this.deleteProfileAction.setEnabled(true);
        this.renameProfileAction.setEnabled(true);
        this.loginAction.setEnabled(true);
        this.logoutAction.setEnabled(true);
        this.editProfileAction.setEnabled(true);
        this.refreshProfileAction.setEnabled(true);
        this.viewLogAction.setEnabled(true);
    }

    public void enableConnectionMenu() {
        this.disableAllAction();
        this.startConnAction.setEnabled(true);
        this.stopConnAction.setEnabled(true);
        this.refreshConnAction.setEnabled(true);
        this.renameConnAction.setEnabled(true);
        this.deleteConnAction.setEnabled(true);
        this.saveAsConnAction.setEnabled(true);
        this.validateConnAction.setEnabled(true);
        this.viewLogAction.setEnabled(true);
    }

    public IToolBarManager getToolbarManager() {
        return this.toolbarManager;
    }

    public Menu getRootMenu() {
        return this.rootmenu;
    }

    public Menu getProfileMenu() {
        return this.profilemenu;
    }

    public Menu getConnectionMenu() {
        return this.connmenu;
    }

    public ProfileContainer getInitializedRoot() throws Exception {
        this.root = new ProfileContainer("InvisibleRoot");
        try {
            this.profileContainer = new ProfileContainer(ConnectionView.getResourceString("profilecontainer.name"));
            Vector vector = this.profileHandler.getProfiles();
            ProfileElement profileElement = null;
            for (int i = 0; i < vector.size(); ++i) {
                Properties properties = (Properties)vector.elementAt(i);
                if (properties.getProperty("ProfileName") == null || properties.getProperty("ProfileName").equals("")) continue;
                profileElement = new ProfileElement(properties);
                profileElement.setProfileStatus("Not Connected");
                this.profileContainer.add(profileElement);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        this.root.add(this.profileContainer);
        return this.root;
    }

    public ProfileXMLHandler getProfileHandler() {
        return this.profileHandler;
    }

    public void setFocus() {
    }

    public static String getResourceString(String string) {
        return RepConnectorUIPlugin.getResourceString(string);
    }

    public void setSelectionEvent(SelectionChangedEvent selectionChangedEvent) {
        this.selEvent = selectionChangedEvent;
    }

    public void resetSelection(ElementModel elementModel) {
        try {
            this.treeViewer.setSelection((ISelection)elementModel);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

