/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.view;

import com.sybase.connector.ui.RepConnectorUIPlugin;
import com.sybase.connector.ui.model.ConnectionElement;
import com.sybase.connector.ui.model.ProfileContainer;
import com.sybase.connector.ui.model.ProfileElement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class RCLabelProvider
extends LabelProvider {
    private Map imageCache = new HashMap(11);

    public Image getImage(Object object) {
        ImageDescriptor imageDescriptor = null;
        if (object instanceof ProfileContainer) {
            imageDescriptor = RepConnectorUIPlugin.getImageDescriptor("server_stopped_obj.gif");
        } else if (object instanceof ProfileElement) {
            imageDescriptor = ((ProfileElement)object).getProfileStatus().equals("Connected") ? RepConnectorUIPlugin.getImageDescriptor("connect.gif") : RepConnectorUIPlugin.getImageDescriptor("disconnect.gif");
        } else if (object instanceof ConnectionElement) {
            imageDescriptor = !((ConnectionElement)object).getStatus().equals("RUNNING") ? RepConnectorUIPlugin.getImageDescriptor("stop.gif") : RepConnectorUIPlugin.getImageDescriptor("transports.gif");
        } else {
            throw this.unknownElement(object);
        }
        Image image = (Image)this.imageCache.get(imageDescriptor);
        if (image == null) {
            image = imageDescriptor.createImage();
            this.imageCache.put(imageDescriptor, image);
        }
        return image;
    }

    public String getText(Object object) {
        if (object instanceof ProfileElement) {
            if (((ProfileElement)object).getName() == null) {
                return "Default Profile";
            }
            return ((ProfileElement)object).getName();
        }
        if (object instanceof ConnectionElement) {
            return ((ConnectionElement)object).getTitle();
        }
        throw this.unknownElement(object);
    }

    public void dispose() {
        Iterator iterator = this.imageCache.values().iterator();
        while (iterator.hasNext()) {
            ((Image)iterator.next()).dispose();
        }
        this.imageCache.clear();
    }

    protected RuntimeException unknownElement(Object object) {
        return new RuntimeException("Unknown type of element in tree of type " + object.getClass().getName());
    }
}

