/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.view;

import com.sybase.connector.repra.util.RaClientUtil;
import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.ui.RepConnectorUIPlugin;
import com.sybase.connector.ui.model.ConnectionElement;
import com.sybase.connector.ui.model.ProfileContainer;
import com.sybase.connector.ui.model.ProfileElement;
import com.sybase.connector.ui.view.ConnectionView;
import java.net.ConnectException;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;

public class RCSelectionChangedListener
implements ISelectionChangedListener {
    protected ConnectionView mainView;

    public RCSelectionChangedListener(ConnectionView connectionView) {
        this.mainView = connectionView;
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (selectionChangedEvent.getSelection().isEmpty()) {
            this.mainView.setText("");
            return;
        }
        ProfileElement profileElement = null;
        Object object = null;
        try {
            if (selectionChangedEvent.getSelection() instanceof IStructuredSelection) {
                object = ((IStructuredSelection)selectionChangedEvent.getSelection()).getFirstElement();
                if (object instanceof ProfileContainer) {
                    this.mainView.getViewer().getControl().setMenu(this.mainView.getRootMenu());
                    this.mainView.enableRootMenu();
                } else if (object instanceof ProfileElement) {
                    profileElement = (ProfileElement)object;
                    Menu menu = this.mainView.getProfileMenu();
                    this.mainView.getViewer().getControl().setMenu(menu);
                    this.mainView.enableProfileMenu();
                    this.mainView.modifyProfileMenu(((ProfileElement)object).getProfileStatus().equals("Connected"));
                } else if (object instanceof ConnectionElement) {
                    ConnectionElement connectionElement = (ConnectionElement)object;
                    profileElement = connectionElement.getParent();
                    RaClientUtil raClientUtil = new RaClientUtil(profileElement.getProfileHost(), profileElement.getProfilePort(), profileElement.getProfileUser(), profileElement.getProfilePass());
                    RaStatus raStatus = raClientUtil.getConnectionProps(connectionElement.getName());
                    Properties properties = (Properties)raStatus.getReturnObject();
                    connectionElement.setProperties(properties);
                    RaClientUtil raClientUtil2 = new RaClientUtil(profileElement.getProfileHost(), profileElement.getProfilePort(), profileElement.getProfileUser(), profileElement.getProfilePass());
                    RaStatus raStatus2 = raClientUtil2.getConnectionStatus(connectionElement.getName());
                    Properties properties2 = (Properties)raStatus2.getReturnObject();
                    connectionElement.setStatus(properties2.getProperty(connectionElement.getName()));
                    this.mainView.enableConnectionMenu();
                    this.mainView.getViewer().getControl().setMenu(this.mainView.getConnectionMenu());
                    this.mainView.modifyConnectionMenu(!((ConnectionElement)object).getStatus().equals("STOP"));
                }
            }
        }
        catch (Exception exception) {
            if (exception instanceof ConnectException || exception.getMessage().indexOf("java.net.ConnectException") >= 0) {
                profileElement.removeAll();
                this.mainView.modifyProfileMenu(false);
                this.mainView.getViewer().refresh();
                profileElement.setProfileStatus("Not Connected");
                this.mainView.resetSelection(profileElement);
                MessageDialog.openWarning((Shell)this.mainView.getSite().getWorkbenchWindow().getShell(), (String)ConnectionView.getResourceString("RCSelectionChangedListener.disconnect.dialog.title"), (String)ConnectionView.getResourceString("RCSelectionChangedListener.disconnect.dialog.msg"));
                this.mainView.getViewer().refresh();
            }
            MultiStatus multiStatus = RepConnectorUIPlugin.getDefault().getServiceInfo(exception);
            String string = this.getClass().getName();
            multiStatus.add((IStatus)new Status(4, RepConnectorUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, RepConnectorUIPlugin.getResourceString("RCSelectionChangedListener.error.location") + string + ":" + "\n" + exception.getMessage() + "\n" + RepConnectorUIPlugin.getResourceString("RCSelectionChangedListener.error.guide"), (Throwable)exception));
            ErrorDialog.openError((Shell)this.mainView.getSite().getWorkbenchWindow().getShell(), (String)RepConnectorUIPlugin.getResourceString("RCSelectionChangedListener.error.title"), (String)RepConnectorUIPlugin.getResourceString("RCSelectionChangedListener.error.text"), (IStatus)multiStatus);
        }
    }

    private void reloadProfile(ProfileElement profileElement) throws Exception {
        RaClientUtil raClientUtil = new RaClientUtil(profileElement.getProfileHost(), profileElement.getProfilePort(), profileElement.getProfileUser(), profileElement.getProfilePass());
        profileElement.removeAll();
        profileElement.setProfileStatus("Not Connected");
        this.mainView.modifyProfileMenu(false);
        RaStatus raStatus = raClientUtil.getConnectionStatus();
        Properties properties = (Properties)raStatus.getReturnObject();
        Enumeration<?> enumeration = properties.propertyNames();
        String string = "";
        ConnectionElement connectionElement = null;
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            connectionElement = new ConnectionElement(string);
            connectionElement.setStatus(properties.getProperty(string));
            profileElement.add(connectionElement);
        }
        profileElement.setProfileStatus("Connected");
        this.mainView.modifyProfileMenu(true);
    }

    private boolean checkServer(String string, String string2) throws Exception {
        Socket socket = new Socket(string, Integer.parseInt(string2));
        socket.close();
        return true;
    }
}

