/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.wizards;

import com.sybase.connector.ui.layouts.GeneralInfoPane;
import com.sybase.connector.ui.wizards.BaseWizardPage;
import com.sybase.connector.ui.wizards.ConnectionPropertyObject;
import com.sybase.connector.ui.wizards.NewConnectionWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ConnectionGeneralWizardPage
extends BaseWizardPage
implements SelectionListener {
    private Wizard _currentWizard;
    private IStructuredSelection _selection;
    private GeneralInfoPane _infoPane;
    private ConnectionPropertyObject _connPropObj;
    private String _inbound = null;
    private String _outbound = null;
    private String _pageName = null;

    public ConnectionGeneralWizardPage(String string, IStructuredSelection iStructuredSelection, Wizard wizard) {
        super(string);
        this._selection = iStructuredSelection;
        this._pageName = string;
        this._currentWizard = wizard;
        this.setDescription(this.getResourceString("wizard.general.description"));
        this.setTitle(this.getResourceString("wizard.general.title"));
    }

    public ConnectionGeneralWizardPage(String string, String string2, String string3, IStructuredSelection iStructuredSelection, Wizard wizard) {
        super(string);
        this._selection = iStructuredSelection;
        this._pageName = string;
        this._currentWizard = wizard;
        this._inbound = string2;
        this._outbound = string3;
        this.setTitle(this.getResourceString("wizard.general.title"));
        this.setDescription(this.getResourceString("wizard.general.description"));
    }

    public boolean performFinish() {
        return false;
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        composite2.setLayout((Layout)gridLayout);
        this._connPropObj = ((NewConnectionWizard)this._currentWizard)._connPropObj;
        this._infoPane = new GeneralInfoPane(composite2);
        this._infoPane.createLayout(0);
        this._infoPane.setConnectionPropertyObject(this._connPropObj);
        if (this._connPropObj.getOutboundType().equals("DATABASE")) {
            this._infoPane._cust.setEnabled(false);
        } else {
            this._infoPane._enc.setEnabled(false);
        }
        this.setControl((Control)composite2);
    }

    public void dispose() {
        super.dispose();
    }

    public boolean canFlipToNextPage() {
        if (this._connPropObj.getOutboundType().equals("DATABASE")) {
            this._infoPane._cust.setEnabled(false);
        } else {
            this._infoPane._cust.setEnabled(true);
        }
        return true;
    }

    public IWizardPage getNextPage() {
        if (this.validatePage()) {
            this.saveDataToModel();
            String string = ((NewConnectionWizard)this._currentWizard)._pageSeq.getNextPageName(this._pageName);
            return this._currentWizard.getPage(string);
        }
        return this;
    }

    private void saveDataToModel() {
        NewConnectionWizard newConnectionWizard = (NewConnectionWizard)this._currentWizard;
        ConnectionPropertyObject connectionPropertyObject = newConnectionWizard._connPropObj;
        connectionPropertyObject.setDTDURL(this._infoPane._dtdUrl.getText());
        connectionPropertyObject.setAutoStart(String.valueOf(this._infoPane._autoStart.getSelection()));
        connectionPropertyObject.setLogLevel(this._infoPane._logLevel.getText());
        connectionPropertyObject.setFormatterFlag(this._infoPane._cust.getSelection());
        connectionPropertyObject.setEncryptionFlag(this._infoPane._enc.getSelection());
    }

    private boolean validatePage() {
        boolean bl = false;
        boolean bl2 = true;
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isTextNonEmpty(this._infoPane._dtdUrl)) {
            stringBuffer.append(this.getResourceString("wizard.general.e4") + "\n");
            bl2 = false;
        }
        if (!bl2) {
            String[] stringArray = new String[]{"OK"};
            MessageDialog messageDialog = new MessageDialog(this._currentWizard.getShell(), this.getResourceString("wizard.newconnection.title"), MessageDialog.getDefaultImage(), stringBuffer.toString(), 1, stringArray, 1);
            messageDialog.setBlockOnOpen(true);
            messageDialog.open();
        }
        return bl2;
    }
}

