/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.wizards;

import com.sybase.connector.ui.RepConnectorUIPlugin;
import com.sybase.connector.ui.layouts.InitInfoPane;
import com.sybase.connector.ui.model.IElement;
import com.sybase.connector.ui.wizards.BaseWizardPage;
import com.sybase.connector.ui.wizards.ConnectionPropertyObject;
import com.sybase.connector.ui.wizards.NewConnectionWizard;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConnectionInitPage
extends BaseWizardPage
implements SelectionListener {
    private boolean traceEnabled = false;
    private Wizard _currentWizard;
    private IStructuredSelection _selection;
    private InitInfoPane _infoPane;
    private String _pageName;
    private String _ibTypeName;
    private String _obTypeName;
    private boolean _testing = false;
    private boolean _testingFailure = false;

    public ConnectionInitPage(String string) {
        super(string);
        this._pageName = string;
    }

    public ConnectionInitPage(String string, IStructuredSelection iStructuredSelection, Wizard wizard) {
        super(string);
        this._selection = iStructuredSelection;
        this._currentWizard = wizard;
        this._pageName = string;
        this.setTitle(this.getResourceString("wizard.connectioninit.title"));
        this.setDescription(this.getResourceString("wizard.connectioninit.description"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        composite2.setLayout((Layout)gridLayout);
        this._infoPane = new InitInfoPane(composite2);
        this._infoPane.createLayout();
        this.setControl((Control)composite2);
    }

    public IWizardPage getNextPage() {
        if (this.validatePage()) {
            this.saveDataToModel();
            ((NewConnectionWizard)this._currentWizard)._pageSeq.setPageSequence(this._ibTypeName, this._obTypeName);
            String string = ((NewConnectionWizard)this._currentWizard)._pageSeq.getNextPageName(this._pageName);
            return this._currentWizard.getPage(string);
        }
        return null;
    }

    public boolean canFlipToNextPage() {
        return true;
    }

    private void traceMsg(String string) {
        if (true | this.traceEnabled) {
            System.out.println(string);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void dispose() {
        super.dispose();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    private boolean validatePage() {
        String[] stringArray = new String[]{"OK"};
        MessageDialog messageDialog = null;
        boolean bl = true;
        String string = this._infoPane._connName.getText();
        if (!this.validChar(string)) {
            messageDialog = new MessageDialog(this._currentWizard.getShell(), this.getResourceString("wizard.newconnection.title"), MessageDialog.getDefaultImage(), this.getResourceString("wizard.connectioninit.e4"), 1, stringArray, 1);
            messageDialog.setBlockOnOpen(true);
            messageDialog.open();
            return false;
        }
        this._element = (IElement)this._selection.getFirstElement();
        try {
            if (this._testing) {
                if (this._testingFailure) {
                    messageDialog = new MessageDialog(this._currentWizard.getShell(), this.getResourceString("wizard.newconnection.title"), MessageDialog.getDefaultImage(), this.getResourceString("wizard.connectioninit.e1"), 1, stringArray, 1);
                    messageDialog.setBlockOnOpen(true);
                    messageDialog.open();
                    bl = false;
                } else {
                    bl = true;
                }
            } else if (this._element.isConnectionExist(string)) {
                messageDialog = new MessageDialog(this._currentWizard.getShell(), this.getResourceString("wizard.newconnection.title"), MessageDialog.getDefaultImage(), this.getResourceString("wizard.connectioninit.e1"), 1, stringArray, 1);
                messageDialog.setBlockOnOpen(true);
                messageDialog.open();
                bl = false;
            }
            return bl;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            try {
                MultiStatus multiStatus = RepConnectorUIPlugin.getDefault().getServiceInfo(throwable);
                String string2 = this.getClass().getName();
                multiStatus.add((IStatus)new Status(4, RepConnectorUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, this.getResourceString("wizard.connectioninit.e3") + string2, throwable));
                ErrorDialog.openError((Shell)this._currentWizard.getShell(), (String)this.getResourceString("wizard.connectioninit.e2"), (String)(this.getResourceString("wizard.connectioninit.e2") + "\n" + throwable.getMessage()), (IStatus)multiStatus);
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
            bl = false;
            return bl;
        }
    }

    private void saveDataToModel() {
        try {
            ((NewConnectionWizard)this._currentWizard)._connPropObj.refreshConnection();
            ConnectionPropertyObject connectionPropertyObject = ((NewConnectionWizard)this._currentWizard)._connPropObj;
            connectionPropertyObject.setConnectionName(this._infoPane._connName.getText());
            this._ibTypeName = this._infoPane._ibType.getText();
            String string = this._infoPane._obType.getText();
            this._obTypeName = string.equals("TIBCO RV, RVCM, AE") ? "TIBCO" : string;
            connectionPropertyObject.setInboundType(this._ibTypeName);
            connectionPropertyObject.setOutboundType(this._obTypeName);
            if (this._obTypeName.equals("CUSTOM")) {
                connectionPropertyObject.setSenderFlag(true);
            } else {
                connectionPropertyObject.setSenderFlag(false);
            }
        }
        catch (Throwable throwable) {
            RepConnectorUIPlugin.log(throwable);
        }
    }

    private boolean validChar(String string) {
        if (string == null || string.trim().equals("")) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (Character.isJavaIdentifierPart(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public IWizardPage getPreviousPage() {
        return null;
    }
}

