/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.wizards;

import com.sybase.connector.ui.layouts.JdbcInfoPane;
import com.sybase.connector.ui.model.IElement;
import com.sybase.connector.ui.wizards.BaseWizardPage;
import com.sybase.connector.ui.wizards.ConnectionPropertyObject;
import com.sybase.connector.ui.wizards.NewConnectionWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class JdbcWizardPage
extends BaseWizardPage
implements SelectionListener {
    Wizard currentWizard;
    private IStructuredSelection selection;
    private ConnectionPropertyObject _connPropObj;
    private JdbcInfoPane _infoPane;
    private boolean nextPageExists = true;
    private String _pageName;
    private Listener _listener = new Listener(){

        public void handleEvent(Event event) {
        }
    };

    public JdbcWizardPage(String string, IStructuredSelection iStructuredSelection, Wizard wizard) {
        super(wizard, string);
        this._pageName = string;
        this.selection = iStructuredSelection;
        this.currentWizard = wizard;
        this.setTitle(this.getResourceString("wizard.jdbc.title"));
        this.setDescription(this.getResourceString("wizard.jdbc.description"));
    }

    public JdbcWizardPage(String string, String string2, String string3, IStructuredSelection iStructuredSelection, Wizard wizard) {
        super(wizard, string);
        this._pageName = string;
        this.selection = iStructuredSelection;
        this.currentWizard = wizard;
        this.setTitle(this.getResourceString("wizard.jdbc.title"));
        this.setDescription(this.getResourceString("wizard.jdbc.description"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        composite2.setLayout((Layout)gridLayout);
        this._infoPane = new JdbcInfoPane(composite2);
        this._infoPane.createLayout();
        this._infoPane.setConnElement((IElement)this.selection.getFirstElement());
        this.setControl((Control)composite2);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    public boolean canFlipToNextPage() {
        return this.nextPageExists;
    }

    private void traceMsg(String string) {
        boolean bl = false;
        if (true | bl) {
            System.out.println(string);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void dispose() {
        super.dispose();
    }

    public IWizardPage getNextPage() {
        if (this.validatePage()) {
            this.saveDataToModel();
            String string = ((NewConnectionWizard)this.currentWizard)._pageSeq.getNextPageName(this._pageName);
            return this.currentWizard.getPage(string);
        }
        return this;
    }

    private void saveDataToModel() {
        NewConnectionWizard newConnectionWizard = (NewConnectionWizard)this.currentWizard;
        ConnectionPropertyObject connectionPropertyObject = newConnectionWizard._connPropObj;
        connectionPropertyObject.setJDBCUrl(this._infoPane._connUrl.getText());
        connectionPropertyObject.setJDBCDriver(this._infoPane._driver.getText());
        connectionPropertyObject.setJDBCUser(this._infoPane._userName.getText());
        connectionPropertyObject.setJDBCPassword(this._infoPane._password.getText());
    }

    private boolean validatePage() {
        if (this.isTextNonEmpty(this._infoPane._connUrl) && this.isStringNonEmpty(this._infoPane._driver.getText()) && this.isTextNonEmpty(this._infoPane._userName)) {
            return true;
        }
        String[] stringArray = new String[]{"OK"};
        MessageDialog messageDialog = new MessageDialog(this.currentWizard.getShell(), this.getResourceString("wizard.newconnection.title"), MessageDialog.getDefaultImage(), this.getResourceString("wizard.jdbc.e1"), 1, stringArray, 1);
        messageDialog.setBlockOnOpen(true);
        messageDialog.open();
        return false;
    }
}

