/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.wizards;

import com.sybase.connector.ui.layouts.JmsInfoPane;
import com.sybase.connector.ui.model.IElement;
import com.sybase.connector.ui.wizards.BaseWizardPage;
import com.sybase.connector.ui.wizards.NewConnectionWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class JmsWizardPage
extends BaseWizardPage
implements SelectionListener {
    Wizard currentWizard;
    private String _pageName;
    private IStructuredSelection selection;
    private boolean nextPageExists = true;
    private JmsInfoPane _infoPane;

    public JmsWizardPage(String string, IStructuredSelection iStructuredSelection, Wizard wizard) {
        super(wizard, string);
        this.selection = iStructuredSelection;
        this._pageName = string;
        this.currentWizard = wizard;
        this.setTitle(this.getResourceString("wizard.jms.info.title"));
        this.setDescription(this.getResourceString("wizard.jms.info.description"));
    }

    public JmsWizardPage(String string, String string2, String string3, IStructuredSelection iStructuredSelection, Wizard wizard) {
        super(wizard, string);
        this._pageName = string;
        this.selection = iStructuredSelection;
        this.currentWizard = wizard;
        this.setTitle(this.getResourceString("wizard.jms.info.title"));
        this.setDescription(this.getResourceString("wizard.jms.info.description"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        composite2.setLayout((Layout)gridLayout);
        this._infoPane = new JmsInfoPane(composite2);
        this._infoPane.createLayout();
        this._infoPane.setConnElement((IElement)this.selection.getFirstElement());
        if (!this._connPropObj.getInboundType().equals("REPLICATION")) {
            this._infoPane._statusDestLabel.setEnabled(true);
            this._infoPane._statusDest.setEnabled(true);
            this._infoPane._statusDest.setEditable(true);
        }
        this.setControl((Control)composite2);
        this.createStatusField(this._infoPane);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    public boolean canFlipToNextPage() {
        if (!this._connPropObj.getInboundType().equals("REPLICATION")) {
            this._infoPane._statusDestLabel.setEnabled(true);
            this._infoPane._statusDest.setEnabled(true);
            this._infoPane._statusDest.setEditable(true);
        } else {
            this._infoPane._statusDestLabel.setEnabled(false);
            this._infoPane._statusDest.setEnabled(false);
            this._infoPane._statusDest.setEditable(false);
        }
        return this.nextPageExists;
    }

    private void traceMsg(String string) {
        boolean bl = false;
        if (true | bl) {
            System.out.println(string);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public IWizardPage getNextPage() {
        if (this.validatePage()) {
            this.saveDataToModel();
            String string = ((NewConnectionWizard)this.currentWizard)._pageSeq.getNextPageName(this._pageName);
            return this.currentWizard.getPage(string);
        }
        return this;
    }

    private void saveDataToModel() {
        if (this._infoPane._queue.getSelection()) {
            this._connPropObj.setJMSType("queue");
        } else {
            this._connPropObj.setJMSType("topic");
            this._connPropObj.setJMSTopicSubscribers(this._infoPane._topicSubs.getText());
        }
        this._connPropObj.setJMSProviderUrl(this._infoPane._pUrl.getText());
        this._connPropObj.setJMSInitialContext(this._infoPane._initContext.getText());
        this._connPropObj.setJMSConnectionFactory(this._infoPane._factory.getText());
        this._connPropObj.setJMSName(this._infoPane._dest.getText());
        this._connPropObj.setJMSUser(this._infoPane._userName.getText());
        this._connPropObj.setJMSPassword(this._infoPane._password.getText());
        if (this._infoPane._statusDest.getText() != null && !this._infoPane._statusDest.getText().equals("")) {
            this._connPropObj.setStatusDestination(this._infoPane._statusDest.getText());
        }
    }

    private boolean validatePage() {
        boolean bl = false;
        if (this.isTextNonEmpty(this._infoPane._pUrl) && this.isTextNonEmpty(this._infoPane._dest)) {
            bl = true;
        }
        if (bl && this._connPropObj.getInboundType().equals("JMS")) {
            bl = this.isTextNonEmpty(this._infoPane._statusDest);
        }
        if (!bl) {
            String[] stringArray = new String[]{"OK"};
            MessageDialog messageDialog = new MessageDialog(this.currentWizard.getShell(), this.getResourceString("wizard.newconnection.title"), MessageDialog.getDefaultImage(), this.getResourceString("wizard.jms.e1"), 1, stringArray, 1);
            messageDialog.setBlockOnOpen(true);
            messageDialog.open();
        }
        return bl;
    }
}

