/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.wizards;

import com.sybase.connector.ui.layouts.MqInfoPane;
import com.sybase.connector.ui.model.IElement;
import com.sybase.connector.ui.wizards.BaseWizardPage;
import com.sybase.connector.ui.wizards.ConnectionPropertyObject;
import com.sybase.connector.ui.wizards.NewConnectionWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class MqWizardPage
extends BaseWizardPage
implements SelectionListener {
    private Wizard currentWizard;
    private IStructuredSelection selection;
    private boolean nextPageExists = true;
    private MqInfoPane _infoPane;
    private String _pageName;
    private Listener _listener = new Listener(){

        public void handleEvent(Event event) {
        }
    };

    public MqWizardPage(String string, IStructuredSelection iStructuredSelection, Wizard wizard) {
        super(wizard, string);
        this._pageName = string;
        this.selection = iStructuredSelection;
        this.currentWizard = wizard;
        this.setTitle(this.getResourceString("wizard.mq.info.title"));
        this.setDescription(this.getResourceString("wizard.mq.info.description"));
    }

    public MqWizardPage(String string, String string2, String string3, IStructuredSelection iStructuredSelection, Wizard wizard) {
        super(wizard, string);
        this._pageName = string;
        this.selection = iStructuredSelection;
        this.currentWizard = wizard;
        this.setTitle(this.getResourceString("wizard.mq.info.title"));
        this.setDescription(this.getResourceString("wizard.mq.info.description"));
        this._connPropObj = ((NewConnectionWizard)wizard)._connPropObj;
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        composite2.setLayout((Layout)gridLayout);
        this._infoPane = new MqInfoPane(composite2);
        this._infoPane.createLayout();
        this._infoPane.setConnElement((IElement)this.selection.getFirstElement());
        this.setControl((Control)composite2);
        this.createStatusField(this._infoPane);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        this.getWizard().getContainer().updateButtons();
    }

    public boolean canFlipToNextPage() {
        if (!this._connPropObj.getInboundType().equals("REPLICATION")) {
            this._infoPane._statusDestLabel.setEnabled(true);
            this._infoPane._statusDest.setEnabled(true);
            this._infoPane._statusDest.setEditable(true);
        } else {
            this._infoPane._statusDestLabel.setEnabled(false);
            this._infoPane._statusDest.setEnabled(false);
            this._infoPane._statusDest.setEditable(false);
        }
        return this.nextPageExists;
    }

    private void traceMsg(String string) {
        boolean bl = false;
        if (true | bl) {
            System.out.println(string);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void dispose() {
        super.dispose();
    }

    public IWizardPage getNextPage() {
        if (this.validatePage()) {
            this.saveDataToModel();
            String string = ((NewConnectionWizard)this.currentWizard)._pageSeq.getNextPageName(this._pageName);
            return this.currentWizard.getPage(string);
        }
        return this;
    }

    private void saveDataToModel() {
        ConnectionPropertyObject connectionPropertyObject = ((NewConnectionWizard)this.currentWizard)._connPropObj;
        if (this._infoPane._mqButton.getSelection()) {
            connectionPropertyObject.setMQType("MQ");
        } else {
            connectionPropertyObject.setMQType("MQJMS");
        }
        connectionPropertyObject.setMQLocalClient(String.valueOf(this._infoPane._clientButton.getSelection()));
        if (this._infoPane._utfButton.getSelection()) {
            connectionPropertyObject.setMQEncoding("utf");
        } else {
            connectionPropertyObject.setMQEncoding("Default");
        }
        connectionPropertyObject.setMQHost(this._infoPane._hostName.getText());
        connectionPropertyObject.setMQPortNumber(this._infoPane._portnumber.getText());
        connectionPropertyObject.setMQChannel(this._infoPane._channel.getText());
        connectionPropertyObject.setMQQueueManager(this._infoPane._factory.getText());
        connectionPropertyObject.setMQName(this._infoPane._queueName.getText());
        connectionPropertyObject.setMQUser(this._infoPane._userName.getText());
        connectionPropertyObject.setMQPassword(this._infoPane._password.getText());
        connectionPropertyObject.setStatusDestination(this._infoPane._statusDest.getText());
    }

    private boolean validatePage() {
        boolean bl = false;
        if (this.isTextNonEmpty(this._infoPane._hostName) && this.isTextNonEmpty(this._infoPane._factory) && this.isTextNonEmpty(this._infoPane._queueName)) {
            bl = true;
        }
        if (bl && this._connPropObj.getInboundType().equals("IBMMQ")) {
            bl = this.isTextNonEmpty(this._infoPane._statusDest);
        }
        if (!bl) {
            String[] stringArray = new String[]{"OK"};
            MessageDialog messageDialog = new MessageDialog(this.currentWizard.getShell(), this.getResourceString("wizard.newconnection.title"), MessageDialog.getDefaultImage(), this.getResourceString("wizard.mq.e1"), 1, stringArray, 1);
            messageDialog.setBlockOnOpen(true);
            messageDialog.open();
        }
        return bl;
    }
}

