/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.wizards;

import com.sybase.connector.ui.layouts.RssdInfoPane;
import com.sybase.connector.ui.model.IElement;
import com.sybase.connector.ui.wizards.BaseWizardPage;
import com.sybase.connector.ui.wizards.ConnectionPropertyObject;
import com.sybase.connector.ui.wizards.NewConnectionWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class RssdWizardPage
extends BaseWizardPage
implements SelectionListener {
    private Wizard currentWizard;
    private Wizard parent;
    private boolean nextPageExists = true;
    private boolean traceEnabled = false;
    private IStructuredSelection selection;
    private RssdInfoPane _infoPane;
    private String _pageName;

    public RssdWizardPage(String string, IStructuredSelection iStructuredSelection, Wizard wizard) {
        super(wizard, string);
        this._pageName = string;
        this.selection = iStructuredSelection;
        this.currentWizard = wizard;
        this.parent = wizard;
        this.setTitle(this.getResourceString("wizard.rssd.title"));
        this.setDescription(this.getResourceString("wizard.rssd.description"));
    }

    public RssdWizardPage(String string, String string2, String string3, IStructuredSelection iStructuredSelection, Wizard wizard) {
        super(wizard, string);
        this._pageName = string;
        this.selection = iStructuredSelection;
        this.currentWizard = wizard;
        this.parent = wizard;
        this.setTitle(this.getResourceString("wizard.rssd.title"));
        this.setDescription(this.getResourceString("wizard.rssd.description"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        composite2.setLayout((Layout)gridLayout);
        this._infoPane = new RssdInfoPane(composite2);
        this._infoPane.createLayout();
        this._infoPane.setConnElement((IElement)this.selection.getFirstElement());
        this.setControl((Control)composite2);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void dispose() {
        super.dispose();
    }

    public boolean canFlipToNextPage() {
        return this.nextPageExists;
    }

    public IWizardPage getNextPage() {
        if (this.validatePage()) {
            this.saveDataToModel();
            String string = ((NewConnectionWizard)this.currentWizard)._pageSeq.getNextPageName(this._pageName);
            return this.currentWizard.getPage(string);
        }
        return this;
    }

    private void saveDataToModel() {
        ConnectionPropertyObject connectionPropertyObject = ((NewConnectionWizard)this.currentWizard)._connPropObj;
        connectionPropertyObject.setRSSDUrl(this._infoPane._rssdUrl.getText());
        connectionPropertyObject.setRSSDUser(this._infoPane._userName.getText());
        connectionPropertyObject.setRSSDPassword(this._infoPane._password.getText());
        connectionPropertyObject.setRequiredGroup(this._infoPane._requireGp.getSelection());
        connectionPropertyObject.setSqlInitString("set quoted_identifier off");
    }

    private boolean validatePage() {
        if (this.isTextNonEmpty(this._infoPane._rssdUrl) && this.isTextNonEmpty(this._infoPane._userName)) {
            return true;
        }
        String[] stringArray = new String[]{"OK"};
        MessageDialog messageDialog = new MessageDialog(this.currentWizard.getShell(), this.getResourceString("wizard.newconnection.title"), MessageDialog.getDefaultImage(), this.getResourceString("wizard.rssd.e1"), 1, stringArray, 1);
        messageDialog.setBlockOnOpen(true);
        messageDialog.open();
        return false;
    }
}

