/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.wizards;

import com.sybase.connector.repra.util.RaStatus;
import com.sybase.connector.ui.RepConnectorUIPlugin;
import com.sybase.connector.ui.model.IElement;
import com.sybase.connector.ui.wizards.BaseWizardPage;
import com.sybase.connector.ui.wizards.ConnectionPropertyObject;
import com.sybase.connector.ui.wizards.NewConnectionWizard;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SummaryWizardPage
extends BaseWizardPage
implements IWizardPage {
    Table _table;
    Wizard currentWizard;
    IStructuredSelection selection;
    private boolean _testing = false;
    private boolean _testSuccess = true;
    private boolean _testWarning = false;
    private boolean _testFailure = false;
    private boolean _testException = false;
    private ConnectionPropertyObject _connPropObj;

    public SummaryWizardPage(String string, IStructuredSelection iStructuredSelection, Wizard wizard) {
        super(string);
        this.currentWizard = wizard;
        this.selection = iStructuredSelection;
        this.setTitle(this.getResourceString("wizard.summary.title"));
        this.setDescription(this.getResourceString("wizard.summary.description"));
    }

    public SummaryWizardPage(String string, String string2, String string3, IStructuredSelection iStructuredSelection, Wizard wizard) {
        super(string);
        this.currentWizard = wizard;
        this.selection = iStructuredSelection;
        this.setTitle(this.getResourceString("wizard.summary.title"));
        this.setDescription(this.getResourceString("wizard.summary.description"));
    }

    protected SummaryWizardPage(String string) {
        super(string);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        composite2.setLayout((Layout)gridLayout);
        this._table = new Table(composite2, 2048);
        this._table.setLayoutData((Object)new GridData(1808));
        this._table.setHeaderVisible(true);
        this._table.setLinesVisible(true);
        TableLayout tableLayout = new TableLayout();
        this._table.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(100));
        tableLayout.addColumnData((ColumnLayoutData)new ColumnPixelData(200));
        TableColumn tableColumn = new TableColumn(this._table, 0);
        tableColumn.setText(this.getResourceString("wizard.summary.property"));
        TableColumn tableColumn2 = new TableColumn(this._table, 0);
        tableColumn2.setText(this.getResourceString("wizard.summary.value"));
        this.setControl((Control)composite2);
        this._connPropObj = ((NewConnectionWizard)this.currentWizard)._connPropObj;
        this._element = (IElement)this.selection.getFirstElement();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            this.loadSummaryData();
        }
    }

    private void loadSummaryData() {
        this._table.removeAll();
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        Properties properties = this._connPropObj.getAllProperties();
        if (properties != null && !properties.isEmpty()) {
            String string;
            Object[] objectArray = properties.keys();
            while (objectArray.hasMoreElements()) {
                String string2 = (String)objectArray.nextElement();
                string = properties.getProperty(string2);
                arrayList.add(new String[]{string2, string});
            }
            objectArray = arrayList.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                string = new TableItem(this._table, 0);
                string.setText((String[])objectArray[i]);
            }
        }
    }

    public boolean isPageComplete() {
        return true;
    }

    public void dispose() {
        super.dispose();
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public boolean canFlipToNextPage() {
        return false;
    }

    public void finish() {
        try {
            RaStatus raStatus;
            String[] stringArray = new String[]{"OK"};
            if (this._testing) {
                raStatus = new RaStatus(7, "testing");
                if (this._testSuccess) {
                    raStatus.setCode(0);
                    raStatus.setMessage("This is success message.");
                } else if (this._testWarning) {
                    raStatus.setCode(2);
                    raStatus.setMessage("This is warning message.");
                } else if (this._testFailure) {
                    raStatus.setCode(4);
                    raStatus.setMessage("This is failure message.");
                } else if (this._testException) {
                    throw new Exception("This is an exception message.");
                }
            } else {
                raStatus = this._element.createConnection(this._connPropObj.getConnectionName(), this._connPropObj.getAllProperties());
            }
            MessageDialog messageDialog = raStatus.getCode() == 0 ? new MessageDialog(this.currentWizard.getShell(), this.getResourceString("wizard.summary.title"), MessageDialog.getDefaultImage(), this.getResourceString("wizard.summary.i1"), 2, stringArray, 1) : (raStatus.getCode() == 2 ? new MessageDialog(this.currentWizard.getShell(), this.getResourceString("wizard.summary.message.title"), MessageDialog.getDefaultImage(), this.getResourceString("wizard.summary.w1") + raStatus.getMessage(), 4, stringArray, 1) : new MessageDialog(this.currentWizard.getShell(), this.getResourceString("wizard.summary.message.title"), MessageDialog.getDefaultImage(), this.getResourceString("wizard.summary.e2") + raStatus.getMessage(), 1, stringArray, 1));
            messageDialog.setBlockOnOpen(true);
            messageDialog.open();
        }
        catch (Throwable throwable) {
            try {
                MultiStatus multiStatus = RepConnectorUIPlugin.getDefault().getServiceInfo(throwable);
                String string = this.getClass().getName();
                multiStatus.add((IStatus)new Status(4, RepConnectorUIPlugin.getDefault().getDescriptor().getUniqueIdentifier(), 4, this.getResourceString("wizard.summary.e3") + string, throwable));
                ErrorDialog.openError((Shell)this.currentWizard.getShell(), (String)this.getResourceString("wizard.summary.e1"), (String)(this.getResourceString("wizard.summary.e1") + "\n" + throwable.getMessage()), (IStatus)multiStatus);
            }
            catch (Throwable throwable2) {
                throwable2.printStackTrace();
            }
        }
    }
}

