/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.connector.ui.wizards;

import com.sybase.connector.ui.layouts.TibcoInfoPane;
import com.sybase.connector.ui.model.IElement;
import com.sybase.connector.ui.wizards.BaseWizardPage;
import com.sybase.connector.ui.wizards.ConnectionPropertyObject;
import com.sybase.connector.ui.wizards.NewConnectionWizard;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class TibcoWizardPage
extends BaseWizardPage
implements SelectionListener {
    private Wizard currentWizard;
    private IStructuredSelection selection;
    private boolean nextPageExists = true;
    private TibcoInfoPane _infoPane;
    private String _pageName;

    public TibcoWizardPage(String string, IStructuredSelection iStructuredSelection, Wizard wizard) {
        super(wizard, string);
        this._pageName = string;
        this.selection = iStructuredSelection;
        this.currentWizard = wizard;
        this.setTitle(this.getResourceString("wizard.tibco.info.title"));
        this.setDescription(this.getResourceString("wizard.tibco.info.description"));
    }

    public TibcoWizardPage(String string, String string2, String string3, IStructuredSelection iStructuredSelection, Wizard wizard) {
        super(wizard, string);
        this._pageName = string;
        this.selection = iStructuredSelection;
        this.currentWizard = wizard;
        this.setTitle(this.getResourceString("wizard.tibco.info.title"));
        this.setDescription(this.getResourceString("wizard.tibco.info.description"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.horizontalSpacing = 10;
        gridLayout.verticalSpacing = 10;
        gridLayout.marginHeight = 10;
        gridLayout.marginWidth = 10;
        composite2.setLayout((Layout)gridLayout);
        this._infoPane = new TibcoInfoPane(composite2);
        this._infoPane.createLayout();
        this._infoPane.setConnElement((IElement)this.selection.getFirstElement());
        this._infoPane.setShell(this.getShell());
        this.setControl((Control)composite2);
        this.createStatusField(this._infoPane);
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    public boolean canFlipToNextPage() {
        if (!this._connPropObj.getInboundType().equals("REPLICATION")) {
            this._infoPane._statusDestLabel.setEnabled(true);
            this._infoPane._statusDest.setEnabled(true);
            this._infoPane._statusDest.setEditable(true);
        } else {
            this._infoPane._statusDestLabel.setEnabled(false);
            this._infoPane._statusDest.setEnabled(false);
            this._infoPane._statusDest.setEditable(false);
        }
        return this.nextPageExists;
    }

    private void traceMsg(String string) {
        boolean bl = false;
        if (true | bl) {
            System.out.println(string);
        }
    }

    public void widgetDefaultSelected(SelectionEvent selectionEvent) {
    }

    public void dispose() {
        super.dispose();
    }

    public IWizardPage getNextPage() {
        if (this.validatePage()) {
            this.saveDataToModel();
            String string = ((NewConnectionWizard)this.currentWizard)._pageSeq.getNextPageName(this._pageName);
            return this.currentWizard.getPage(string);
        }
        return this;
    }

    private void saveDataToModel() {
        ConnectionPropertyObject connectionPropertyObject = ((NewConnectionWizard)this.currentWizard)._connPropObj;
        if (this._infoPane._aecmButton.getSelection()) {
            connectionPropertyObject.setTibType("AECM");
            connectionPropertyObject.setTibAEAppConfig(this._infoPane._configFile.getText());
            connectionPropertyObject.setTibAEMsgGenerator(this._infoPane._msgGenerator.getText());
        } else {
            connectionPropertyObject.setTibType("RV");
            connectionPropertyObject.setTibNetwork(this._infoPane._network.getText());
            connectionPropertyObject.setTibService(this._infoPane._serviceName.getText());
            connectionPropertyObject.setTibDaemon(this._infoPane._daemon.getText());
            connectionPropertyObject.setTibSubjects(this._infoPane._subject.getText());
            if (this._infoPane._rvcmButton.getSelection()) {
                connectionPropertyObject.setTibType("RVCM");
                connectionPropertyObject.setTibCMDuration(this._infoPane._cmDuration.getText());
                connectionPropertyObject.setTibCMName(this._infoPane._cmName.getText());
            }
        }
        connectionPropertyObject.setStatusDestination(this._infoPane._statusDest.getText());
    }

    private boolean validatePage() {
        boolean bl = false;
        if (this._infoPane._aecmButton.getSelection()) {
            if (this.isTextNonEmpty(this._infoPane._configFile)) {
                bl = true;
            }
        } else if (this.isTextNonEmpty(this._infoPane._network) && this.isTextNonEmpty(this._infoPane._serviceName) && this.isTextNonEmpty(this._infoPane._daemon) && this.isTextNonEmpty(this._infoPane._subject)) {
            if (this._infoPane._rvcmButton.getSelection()) {
                if (this.isTextNonEmpty(this._infoPane._cmDuration) && this.isTextNonEmpty(this._infoPane._cmName)) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        if (bl && this._connPropObj.getInboundType().equals("TIBCO")) {
            bl = this.isTextNonEmpty(this._infoPane._statusDest);
        }
        if (!bl) {
            String[] stringArray = new String[]{"OK"};
            MessageDialog messageDialog = new MessageDialog(this.currentWizard.getShell(), this.getResourceString("wizard.newconnection.title"), MessageDialog.getDefaultImage(), this.getResourceString("wizard.tibco.e1"), 1, stringArray, 1);
            messageDialog.setBlockOnOpen(true);
            messageDialog.open();
        }
        return bl;
    }
}

