/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.texteditor;

import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class MessageRegion {
    private Text messageText;
    private Label messageImageLabel;
    private Composite messageComposite;
    private String lastMessageText = "";
    private int lastMessageType;

    public void createContents(Composite parent) {
        this.messageComposite = new Composite(parent, 0);
        GridLayout messageLayout = new GridLayout();
        messageLayout.numColumns = 2;
        messageLayout.marginWidth = 0;
        messageLayout.marginHeight = 0;
        messageLayout.makeColumnsEqualWidth = false;
        this.messageComposite.setLayout((Layout)messageLayout);
        this.messageImageLabel = new Label(this.messageComposite, 0);
        GridData imageData = new GridData(4);
        Image sizingImage = JFaceResources.getImage((String)"dialog_message_error_image");
        Rectangle imageBounds = sizingImage == null ? new Rectangle(0, 0, 14, 14) : sizingImage.getBounds();
        imageData.heightHint = imageBounds.height + 4;
        imageData.widthHint = imageBounds.width + 4;
        this.messageImageLabel.setLayoutData((Object)imageData);
        this.messageText = new Text(this.messageComposite, 0);
        this.messageText.setEditable(false);
        this.messageText.setBackground(parent.getDisplay().getSystemColor(22));
        GridData textData = new GridData(772);
        this.messageText.setLayoutData((Object)textData);
        this.hideRegion();
    }

    public void setMessageLayoutData(Object layoutData) {
        this.messageComposite.setLayoutData(layoutData);
    }

    public void updateText(String newMessage, int newType) {
        Image newImage = null;
        boolean showingError = false;
        switch (newType) {
            case 0: {
                this.hideRegion();
                return;
            }
            case 1: {
                newImage = JFaceResources.getImage((String)"dialog_messasge_info_image");
                break;
            }
            case 2: {
                newImage = JFaceResources.getImage((String)"dialog_messasge_warning_image");
                break;
            }
            case 3: {
                newImage = JFaceResources.getImage((String)"dialog_message_error_image");
                showingError = true;
            }
        }
        if (newMessage == null) {
            this.hideRegion();
            return;
        }
        this.showRegion();
        if (newMessage.equals(this.messageText.getText()) && newImage == this.messageImageLabel.getImage()) {
            return;
        }
        this.messageImageLabel.setImage(newImage);
        if (newMessage == null) {
            this.messageText.setText("");
        } else {
            this.messageText.setText(newMessage);
        }
        if (showingError) {
            this.setMessageColors(JFaceColors.getErrorBackground((Display)this.messageComposite.getDisplay()));
        } else {
            this.lastMessageText = newMessage;
            this.setMessageColors(JFaceColors.getBannerBackground((Display)this.messageComposite.getDisplay()));
        }
    }

    private void showRegion() {
        this.messageComposite.setVisible(true);
    }

    private void hideRegion() {
        this.messageComposite.setVisible(false);
        this.lastMessageText = null;
        this.lastMessageType = 0;
    }

    private void setMessageColors(Color color) {
        this.messageText.setBackground(color);
        this.messageComposite.setBackground(color);
        this.messageImageLabel.setBackground(color);
    }

    public void clearErrorMessage() {
        this.updateText(this.lastMessageText, this.lastMessageType);
    }
}

