package com.installshield.extras.product;

/**
 * FileSystemManipulationBeanInfo.java
 * 
 * @author JeffDillon
 * @version 2.0
 * 
 * BeanInfo class for FileSystemManipulation
 * 
 */

import java.beans.*;
import com.installshield.beans.editors.*;

public class FileSystemManipulationBeanInfo extends SimpleBeanInfo {

    PropertyDescriptor[] pds = null;
    private static final Class beanClass = FileSystemManipulation.class;

    public PropertyDescriptor[] getPropertyDescriptors() {
        if (pds == null) {
            pds = new PropertyDescriptor[4];

            try {

                pds[0] = new PropertyDescriptor("source", beanClass);
                pds[1] = new PropertyDescriptor("target", beanClass);

                pds[2] = new PropertyDescriptor("action", beanClass);
                pds[2].setPropertyEditorClass(EnumerationPropertyEditor.class);
                pds[2].setValue(
                    "enumerationValues",
                    new Object[] {
                        "Copy",
                        new Integer(FileSystemManipulation.COPY),
                        "",
                        "Move",
                        new Integer(FileSystemManipulation.MOVE),
                        "",
                        "Delete",
                        new Integer(FileSystemManipulation.DELETE),
                        "" });

                pds[3] = new PropertyDescriptor("runtime", beanClass);
                pds[3].setPropertyEditorClass(EnumerationPropertyEditor.class);
                pds[3].setValue(
                    "enumerationValues",
                    new Object[] {
                        "Install",
                        new Integer(FileSystemManipulation.INSTALL),
                        "",
                        "Uninstall",
                        new Integer(FileSystemManipulation.UNINSTALL),
                        "" });

            } catch (IntrospectionException exc) {
                throw new Error();
            }
        }
        return pds;
    }

    private BeanDescriptor bd = null;

    public BeanDescriptor getBeanDescriptor() {
        if (bd == null) {
            bd = super.getBeanDescriptor();

            if (bd == null)
                bd = new BeanDescriptor(beanClass);

            bd.setValue(
                "details",
                "Performs various runtime file system manipulations on files and directories."
                    + "These operations include copy, delete, and move.");
        }
        return bd;
    }
}