/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor;

import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sek.ase.auditor.utils.AseUtils;
import sek.ase.auditor.utils.Configuration;
import sek.ase.auditor.utils.OpenSslAesUtil;
import sek.ase.auditor.utils.StringUtil;

public class AppConfig {
    private static Logger _logger = LogManager.getLogger();
    public static final String PROPKEY_dbms_server = "dbms.server";
    public static final String DEFAULT_dbms_server = null;
    public static final String PROPKEY_dbms_username = "dbms.username";
    public static final String DEFAULT_dbms_username = null;
    public static final String PROPKEY_dbms_password = "dbms.password";
    public static final String DEFAULT_dbms_password = null;
    public String _dbmsUsername;
    public String _dbmsPassword;
    public String _dbmsServer;
    public String _dbmsUrl;
    public String _configFile;
    public String _installAuditDir;
    private static AppConfig _instance;

    public static AppConfig getInstance() {
        if (_instance == null) {
            throw new RuntimeException("AppConfig doesn't have an instance yet, please set with setInstance(instance).");
        }
        return _instance;
    }

    public static void setInstance(AppConfig instance) {
        _instance = instance;
    }

    public static boolean hasInstance() {
        return _instance != null;
    }

    public AppConfig(CommandLine cmd, Configuration config) throws ParseException {
        this.setOptions(cmd, config);
        this.validate();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOptions(CommandLine cmd, Configuration config) throws ParseException {
        this._dbmsServer = config.getProperty(PROPKEY_dbms_server, DEFAULT_dbms_server);
        this._dbmsUsername = config.getProperty(PROPKEY_dbms_username, DEFAULT_dbms_username);
        this._dbmsPassword = config.getProperty(PROPKEY_dbms_password, DEFAULT_dbms_password);
        if (StringUtil.isNullOrBlank(this._dbmsServer) && cmd.hasOption('S')) {
            this._dbmsServer = cmd.getOptionValue('S');
        }
        if (StringUtil.isNullOrBlank(this._dbmsUsername) && cmd.hasOption('U')) {
            this._dbmsUsername = cmd.getOptionValue('U');
        }
        if (StringUtil.isNullOrBlank(this._dbmsPassword) && cmd.hasOption('P')) {
            this._dbmsPassword = cmd.getOptionValue('P');
        }
        if (StringUtil.isNullOrBlank(this._dbmsServer)) {
            throw new ParseException("Missing mandatory parameter '-S' or '--server' or in the config file as 'dbms.server'.");
        }
        if (StringUtil.isNullOrBlank(this._dbmsUsername)) {
            throw new ParseException("Missing mandatory parameter '-U' or '--user' or in the config file as 'dbms.username'.");
        }
        if (this._dbmsServer.contains(":")) {
            if (this._dbmsServer.startsWith("jdbc:sybase:Tds:")) {
                this._dbmsUrl = this._dbmsServer;
                this._dbmsServer = StringUtils.substringBetween((String)this._dbmsUrl, (String)"jdbc:sybase:Tds:", (String)":");
            } else {
                if (StringUtil.count(":", this._dbmsServer) != 1) throw new ParseException("The DBMS URL or ServerName format is not recognized. dbmsServer=|" + this._dbmsServer + "|.");
                String[] sa = this._dbmsServer.split(":");
                this._dbmsUrl = "jdbc:sybase:Tds:" + this._dbmsServer;
                this._dbmsServer = sa[0].trim();
            }
        } else {
            String hostPortStr = AseUtils.getHostPortFromInterfacesFile(this._dbmsServer);
            if (StringUtil.isNullOrBlank(hostPortStr)) {
                this._dbmsUrl = null;
                throw new RuntimeException("Can't find the server name '" + this._dbmsServer + "' in the interfaces file. If you do not have a interfaces file, you can specify the URL as -S HOST:PORT or -S jdbc:sybase:Tds:HOST:PORT or in config file as: " + PROPKEY_dbms_server + " = jdbc:sybase:Tds:HOSTNAME:PORT");
            }
            this._dbmsUrl = "jdbc:sybase:Tds:" + hostPortStr;
        }
        if (StringUtil.isNullOrBlank(this._dbmsPassword)) {
            try {
                _logger.info("Trying to get get password for user '" + this._dbmsUsername + "', srvName='" + this._dbmsServer + "' from file '" + OpenSslAesUtil.getPasswordFilename() + "'.");
                this._dbmsPassword = OpenSslAesUtil.readPasswdFromFile(this._dbmsUsername, this._dbmsServer);
                if (StringUtil.hasValue(this._dbmsPassword)) {
                    _logger.info("Found password for user '" + this._dbmsUsername + "', srvName='" + this._dbmsServer + "' in file '" + OpenSslAesUtil.getPasswordFilename() + "'.");
                } else {
                    _logger.info("No password for user '" + this._dbmsUsername + "', srvName='" + this._dbmsServer + "' was found in file '" + OpenSslAesUtil.getPasswordFilename() + "'.");
                }
            }
            catch (IOException | OpenSslAesUtil.DecryptionException ex) {
                _logger.warn("Problems to get password for user '" + this._dbmsUsername + "', srvName='" + this._dbmsServer + "' from file '" + OpenSslAesUtil.getPasswordFilename() + "'. Caught: " + ex);
            }
        }
        if (StringUtil.isNullOrBlank(this._dbmsPassword)) {
            throw new ParseException("Missing mandatory parameter '-P' or '--passwd' or in the config file as 'dbms.password'.");
        }
        System.out.println("SybCollector.dbms.server = " + this._dbmsUrl);
        System.out.println("SybCollector.dbms.username = " + this._dbmsUsername);
        System.out.println("SybCollector.dbms.password = " + this._dbmsPassword);
        config.setProperty("SybCollector.dbms.server", this._dbmsUrl);
        config.setProperty("SybCollector.dbms.username", this._dbmsUsername);
        config.setProperty("SybCollector.dbms.password", this._dbmsPassword);
    }

    public void validate() throws ParseException {
    }

    public void printConfigToLogFile() {
        _logger.info("Configuration: ");
        _logger.info("    ...");
        _logger.info("    ...");
    }
}

