/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.collectors;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sek.ase.auditor.collectors.SybAbstractCollector;
import sek.ase.auditor.collectors.SybSysProcessesCache;
import sek.ase.auditor.collectors.records.AuditRecordSybMda;
import sek.ase.auditor.utils.AseUtils;
import sek.ase.auditor.utils.Configuration;
import sek.ase.auditor.utils.StringUtil;
import sek.ase.auditor.utils.TimeUtils;
import sek.ase.auditor.wqs.WriterQueueContainer;

public class SybMdaCollector
extends SybAbstractCollector {
    private static Logger _logger = LogManager.getLogger();
    public static final String PROPKEY_skipSqlTextRegex = "SybMdaCollector.skip.sqlText.regex";
    public static final String DEFAULT_skipSqlTextRegex = null;
    public static final String PROPKEY_keepSqlTextRegex = "SybMdaCollector.keep.sqlText.regex";
    public static final String DEFAULT_keepSqlTextRegex = null;
    public static final String PROPKEY_sleepTimeInSeconds = "SybMdaCollector.sleepTime.seconds";
    public static final int DEFAULT_sleepTimeInSeconds = 1;
    public static final String PROPKEY_clearMonTablesOnConnect = "SybMdaCollector.clearMonTablesOnConnect";
    public static final boolean DEFAULT_clearMonTablesOnConnect = false;
    public static final String PROPKEY_printGetData = "SybMdaCollector.print.getData";
    public static final boolean DEFAULT_printGetData = false;
    private boolean _clearMonTablesOnConnect = false;
    private boolean _printGetData = false;
    private String _skipSqlTextRegex = DEFAULT_skipSqlTextRegex;
    private String _keepSqlTextRegex = DEFAULT_keepSqlTextRegex;
    private Pattern _skipSqlTextPattern = this._skipSqlTextRegex == null ? null : Pattern.compile(this._skipSqlTextRegex);
    private Pattern _keepSqlTextPattern = this._keepSqlTextRegex == null ? null : Pattern.compile(this._keepSqlTextRegex);
    private long _sqlTextSkipCount = 0L;
    public static final String CFGNAME_aseConfig_enable_monitoring = "enable monitoring";
    public static final String PROPKEY_aseConfig_enable_monitoring = "SybMdaCollector.ase.config.enable_monitoring";
    public static final int DEFAULT_aseConfig_enable_monitoring = 1;
    public static final String CFGNAME_aseConfig_sql_text_pipe_active = "sql text pipe active";
    public static final String PROPKEY_aseConfig_sql_text_pipe_active = "SybMdaCollector.ase.config.sql_text_pipe_active";
    public static final int DEFAULT_aseConfig_sql_text_pipe_active = 1;
    public static final String CFGNAME_aseConfig_sql_text_pipe_max_messages = "sql text pipe max messages";
    public static final String PROPKEY_aseConfig_sql_text_pipe_max_messages = "SybMdaCollector.ase.config.sql_text_pipe_max_messages";
    public static final int DEFAULT_aseConfig_sql_text_pipe_max_messages = 1000;
    public static final String CFGNAME_aseConfig_statement_pipe_active = "statement pipe active";
    public static final String PROPKEY_aseConfig_statement_pipe_active = "SybMdaCollector.ase.config.statement_pipe_active";
    public static final int DEFAULT_aseConfig_statement_pipe_active = 1;
    public static final String CFGNAME_aseConfig_statement_pipe_max_messages = "statement pipe max messages";
    public static final String PROPKEY_aseConfig_statement_pipe_max_messages = "SybMdaCollector.ase.config.statement_pipe_max_messages";
    public static final int DEFAULT_aseConfig_statement_pipe_max_messages = 10000;
    private MdaCheckMarker _mdaCheckMarker;

    @Override
    public void init(Configuration config) {
        super.init(config);
        this._skipSqlTextRegex = config.getProperty(PROPKEY_skipSqlTextRegex, DEFAULT_skipSqlTextRegex);
        this._keepSqlTextRegex = config.getProperty(PROPKEY_keepSqlTextRegex, DEFAULT_keepSqlTextRegex);
        this._skipSqlTextPattern = this._skipSqlTextRegex == null ? null : Pattern.compile(this._skipSqlTextRegex);
        this._keepSqlTextPattern = this._keepSqlTextRegex == null ? null : Pattern.compile(this._keepSqlTextRegex);
        this._clearMonTablesOnConnect = this.getConfig().getBooleanProperty(PROPKEY_clearMonTablesOnConnect, false);
        this._printGetData = this.getConfig().getBooleanProperty(PROPKEY_printGetData, false);
        this.setSleepTimeSec(this.getConfig().getIntProperty(PROPKEY_sleepTimeInSeconds, 1));
        this.printConfig();
    }

    @Override
    public void printConfig() {
        int len = 40;
        _logger.info("Configuration for '" + this.getName() + "', with full class name '" + this.getClass().getName() + "'.");
        _logger.info("                   " + StringUtil.left(PROPKEY_skipSqlTextRegex, len) + " = " + this._skipSqlTextRegex);
        _logger.info("                   " + StringUtil.left(PROPKEY_keepSqlTextRegex, len) + " = " + this._keepSqlTextRegex);
        _logger.info("                   " + StringUtil.left(PROPKEY_sleepTimeInSeconds, len) + " = " + this.getSleepTimeSec());
        _logger.info("                   " + StringUtil.left(PROPKEY_clearMonTablesOnConnect, len) + " = " + this._clearMonTablesOnConnect);
        _logger.info("                   " + StringUtil.left(PROPKEY_printGetData, len) + " = " + this._printGetData);
        this.printBaseConfig(len);
    }

    @Override
    public void onConnect(Connection conn) throws SQLException {
        this.checkAseMonitoringConfig(conn);
    }

    private void checkAseMonitoringConfig(Connection conn) throws SQLException {
        int cfg_enableMonitoring = this.getConfig().getIntProperty(PROPKEY_aseConfig_enable_monitoring, 1);
        int cfg_sqlTextPipeActive = this.getConfig().getIntProperty(PROPKEY_aseConfig_sql_text_pipe_active, 1);
        int cfg_sqlTextPipeMaxMessages = this.getConfig().getIntProperty(PROPKEY_aseConfig_sql_text_pipe_max_messages, 1000);
        int cfg_statementPipeActive = this.getConfig().getIntProperty(PROPKEY_aseConfig_statement_pipe_active, 1);
        int cfg_statementPipeMaxMessages = this.getConfig().getIntProperty(PROPKEY_aseConfig_statement_pipe_max_messages, 10000);
        int ase_enableMonitoring = AseUtils.getAseConfigRunValue(conn, CFGNAME_aseConfig_enable_monitoring);
        int ase_sqlTextPipeActive = AseUtils.getAseConfigRunValue(conn, CFGNAME_aseConfig_sql_text_pipe_active);
        int ase_sqlTextPipeMaxMessages = AseUtils.getAseConfigRunValue(conn, CFGNAME_aseConfig_sql_text_pipe_max_messages);
        int ase_statementPipeActive = AseUtils.getAseConfigRunValue(conn, CFGNAME_aseConfig_statement_pipe_active);
        int ase_statementPipeMaxMessages = AseUtils.getAseConfigRunValue(conn, CFGNAME_aseConfig_statement_pipe_max_messages);
        ArrayList<String> doReconfigure = new ArrayList<String>();
        if (ase_enableMonitoring < cfg_enableMonitoring) {
            doReconfigure.add(CFGNAME_aseConfig_enable_monitoring);
            _logger.warn("The ASE Configuration 'enable monitoring' is lower (currently=" + ase_enableMonitoring + ") than the suggested value '" + cfg_enableMonitoring + "'. Please Execeute: sp_configure '" + CFGNAME_aseConfig_sql_text_pipe_active + "', " + cfg_enableMonitoring);
        }
        if (ase_sqlTextPipeActive < cfg_sqlTextPipeActive) {
            doReconfigure.add(CFGNAME_aseConfig_sql_text_pipe_active);
            _logger.warn("The ASE Configuration 'sql text pipe active' is lower (currently=" + ase_sqlTextPipeActive + ") than the suggested value '" + cfg_sqlTextPipeActive + "'. Please Execeute: sp_configure '" + CFGNAME_aseConfig_sql_text_pipe_active + "', " + cfg_sqlTextPipeActive);
        }
        if (ase_sqlTextPipeMaxMessages < cfg_sqlTextPipeMaxMessages) {
            doReconfigure.add(CFGNAME_aseConfig_sql_text_pipe_max_messages);
            _logger.warn("The ASE Configuration 'sql text pipe max messages' is lower (currently=" + ase_sqlTextPipeMaxMessages + ") than the suggested value '" + cfg_sqlTextPipeMaxMessages + "'. Please Execeute: sp_configure '" + CFGNAME_aseConfig_sql_text_pipe_max_messages + "', " + cfg_sqlTextPipeMaxMessages);
        }
        if (ase_statementPipeActive < cfg_statementPipeActive) {
            doReconfigure.add(CFGNAME_aseConfig_statement_pipe_active);
            _logger.warn("The ASE Configuration 'statement pipe active' is lower (currently=" + ase_statementPipeActive + ") than the suggested value '" + cfg_statementPipeActive + "'. Please Execeute: sp_configure '" + CFGNAME_aseConfig_statement_pipe_active + "', " + cfg_statementPipeActive);
        }
        if (ase_statementPipeMaxMessages < cfg_statementPipeMaxMessages) {
            doReconfigure.add(CFGNAME_aseConfig_statement_pipe_max_messages);
            _logger.warn("The ASE Configuration 'statement pipe max messages' is lower (currently=" + ase_statementPipeMaxMessages + ") than the suggested value '" + cfg_statementPipeMaxMessages + "'. Please Execeute: sp_configure '" + CFGNAME_aseConfig_statement_pipe_max_messages + "', " + cfg_statementPipeMaxMessages);
        }
        _logger.info("ASE Configuration " + StringUtil.left(CFGNAME_aseConfig_enable_monitoring, 30, "'") + " RunValue is set to: " + ase_enableMonitoring);
        _logger.info("ASE Configuration " + StringUtil.left(CFGNAME_aseConfig_sql_text_pipe_active, 30, "'") + " RunValue is set to: " + ase_sqlTextPipeActive);
        _logger.info("ASE Configuration " + StringUtil.left(CFGNAME_aseConfig_sql_text_pipe_max_messages, 30, "'") + " RunValue is set to: " + ase_sqlTextPipeMaxMessages);
        _logger.info("ASE Configuration " + StringUtil.left(CFGNAME_aseConfig_statement_pipe_active, 30, "'") + " RunValue is set to: " + ase_statementPipeActive);
        _logger.info("ASE Configuration " + StringUtil.left(CFGNAME_aseConfig_statement_pipe_max_messages, 30, "'") + " RunValue is set to: " + ase_statementPipeMaxMessages);
        if (!doReconfigure.isEmpty()) {
            throw new SQLException("ASE Configuration " + StringUtil.toCommaStrQuoted("'", doReconfigure) + " needs to be increased.");
        }
    }

    @Override
    protected WriterQueueContainer getData() throws SQLException, InterruptedException {
        boolean sendMarker;
        Object object;
        if (this._printGetData) {
            _logger.info("------------------------------------ " + this.getName() + "::getData()");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("------------------------------------ " + this.getName() + "::getData()");
        }
        Connection conn = this.getConnection("master");
        WriterQueueContainer.HeaderInfo headerInfo = new WriterQueueContainer.HeaderInfo(new Timestamp(System.currentTimeMillis()), this.getAseServerName(), this.getAseHostName());
        WriterQueueContainer container = new WriterQueueContainer(headerInfo);
        if (this._clearMonTablesOnConnect && this.isNewConnection()) {
            this.clearTable(conn, "monSysSQLText");
        }
        SpidSqlTextManager spidSqlTextManager = new SpidSqlTextManager();
        String sql = "select SPID, KPID, ServerLogin = suser_name(ServerUserID), BatchID, SequenceInBatch, SQLText \nfrom master.dbo.monSysSQLText \n";
        boolean sqlMarkerWasFound = false;
        int rowCount = 0;
        Statement stmnt = conn.createStatement();
        Object object2 = null;
        try {
            stmnt.setQueryTimeout(1);
            ResultSet rs = stmnt.executeQuery(sql);
            object = null;
            try {
                while (rs.next()) {
                    ++rowCount;
                    int SPID = rs.getInt(1);
                    int KPID = rs.getInt(2);
                    String ServerLogin = rs.getString(3);
                    int BatchID = rs.getInt(4);
                    int SequenceInBatch = rs.getInt(5);
                    String SQLText = rs.getString(6);
                    if (this._mdaCheckMarker != null && this._mdaCheckMarker._sqlMarker != null && this._mdaCheckMarker._sqlMarker.equals(SQLText)) {
                        sqlMarkerWasFound = true;
                        this._mdaCheckMarker._spid = SPID;
                        this._mdaCheckMarker._kpid = KPID;
                        this._mdaCheckMarker._batchId = BatchID;
                    }
                    if (!this.includeLoginName(ServerLogin)) continue;
                    spidSqlTextManager.addSqlText(SPID, KPID, BatchID, SequenceInBatch, SQLText, ServerLogin);
                }
            }
            catch (Throwable SPID) {
                object = SPID;
                throw SPID;
            }
            finally {
                if (rs != null) {
                    if (object != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable SPID) {
                            ((Throwable)object).addSuppressed(SPID);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (Throwable rs) {
            object2 = rs;
            throw rs;
        }
        finally {
            if (stmnt != null) {
                if (object2 != null) {
                    try {
                        stmnt.close();
                    }
                    catch (Throwable rs) {
                        ((Throwable)object2).addSuppressed(rs);
                    }
                } else {
                    stmnt.close();
                }
            }
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("SQL Marker Info: sqlMarkerWasFound=" + sqlMarkerWasFound + ", _mdaCheckMarker=" + this._mdaCheckMarker);
        }
        if (this._mdaCheckMarker != null && !sqlMarkerWasFound) {
            _logger.warn("When checking for 'SQL Marker' previously sent... it wasn't font in 'monSysSQLText'. Searched for SQL Marker Text '" + this._mdaCheckMarker._sqlMarker + "'. Consider to increase ASE Configuration '" + CFGNAME_aseConfig_sql_text_pipe_max_messages + "'.");
            this._mdaCheckMarker = null;
        }
        if (sendMarker = true) {
            String sqlMarker = "/*SQL-Marker:monSysSQLText: " + new Timestamp(System.currentTimeMillis()) + "*/";
            try {
                Statement stmnt2 = conn.createStatement();
                object = null;
                try {
                    stmnt2.executeUpdate(sqlMarker);
                    if (this._mdaCheckMarker == null) {
                        this._mdaCheckMarker = new MdaCheckMarker();
                    }
                    this._mdaCheckMarker._sqlMarker = sqlMarker;
                }
                catch (Throwable SPID) {
                    object = SPID;
                    throw SPID;
                }
                finally {
                    if (stmnt2 != null) {
                        if (object != null) {
                            try {
                                stmnt2.close();
                            }
                            catch (Throwable SPID) {
                                ((Throwable)object).addSuppressed(SPID);
                            }
                        } else {
                            stmnt2.close();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                _logger.warn("Problems executing 'MDA Check Marker' using SQL '" + sqlMarker + "'. Caught: " + AseUtils.sqlExceptionOrWarningAllToString(ex));
                this._mdaCheckMarker = null;
            }
        }
        for (SpidEntry spidEntry : spidSqlTextManager._spidMap.values()) {
            for (BatchIdEntry batchEntry : spidEntry._batchIdMap.values()) {
                String sqlText;
                if (!this.includeProgramName(conn, batchEntry._spid, batchEntry._kpid) || !this.includeSqlText(conn, sqlText = batchEntry.getSqlText())) continue;
                AuditRecordSybMda auditRecord = new AuditRecordSybMda();
                auditRecord.setSqlTextEntry(batchEntry._spid, batchEntry._kpid, batchEntry._batchId, batchEntry.getServerLogin(), sqlText);
                auditRecord.setSybSysProcessesEntry(SybSysProcessesCache.getInstance().getRecord(conn, batchEntry._spid, batchEntry._kpid));
                container.add(auditRecord);
            }
        }
        return container;
    }

    private boolean includeSqlText(Connection conn, String sqlText) {
        if (this._skipSqlTextPattern != null && this._skipSqlTextPattern.matcher(sqlText).matches()) {
            ++this._sqlTextSkipCount;
            return false;
        }
        if (this._keepSqlTextPattern != null && !this._keepSqlTextPattern.matcher(sqlText).matches()) {
            ++this._sqlTextSkipCount;
            return false;
        }
        return true;
    }

    private void clearTable(Connection conn, String tabName) {
        String sql = "select count(*) from master.dbo." + tabName;
        _logger.info("BEGIN: Discarding everything in the transient '" + tabName + "' table in the first sample.");
        long startTime = System.currentTimeMillis();
        try (Statement stmnt = conn.createStatement();
             ResultSet rs = stmnt.executeQuery(sql);){
            int discardCount = 0;
            while (rs.next()) {
                discardCount = rs.getInt(1);
            }
            _logger.info("END:   Discarding everything in the transient '" + tabName + "' table in the first sample. discardCount=" + discardCount + ", this took " + TimeUtils.msToTimeStr(System.currentTimeMillis() - startTime) + ".");
        }
        catch (SQLException ex) {
            _logger.error("END:   Discarding everything in the transient '" + tabName + "' table in the first sample FAILED. Caught: Error=" + ex.getErrorCode() + ", Msg='" + ex.getMessage().trim() + "'");
        }
    }

    private static class BatchIdEntry {
        private SpidEntry _parent;
        private int _spid;
        private int _kpid;
        private int _batchId;
        private String _dynamicSqlName;
        private String _dynamicSqlText;
        private boolean _isDynamicSqlPrepare = false;
        private StringBuilder _sqlText = new StringBuilder();
        private String _srvLogin = "";

        public BatchIdEntry(SpidEntry spidEntry, int spid, int kpid, int batchId) {
            this._parent = spidEntry;
            this._spid = spid;
            this._kpid = kpid;
            this._batchId = batchId;
        }

        public boolean isDynamicSql() {
            return this._dynamicSqlName != null;
        }

        public void addSqlText(int sequenceNum, String sqlText, String serverLogin) {
            if (sqlText == null) {
                return;
            }
            if (sqlText.startsWith("DYNAMIC_SQL ")) {
                this._dynamicSqlName = sqlText;
            }
            if (this._dynamicSqlName != null && StringUtils.startsWithIgnoreCase((CharSequence)sqlText, (CharSequence)"create proc ")) {
                this._isDynamicSqlPrepare = true;
                int startPos = StringUtils.indexOfIgnoreCase((CharSequence)sqlText, (CharSequence)" as ");
                if (startPos != -1) {
                    this._dynamicSqlText = sqlText.substring(startPos += " as ".length());
                }
            }
            if (this._isDynamicSqlPrepare && sequenceNum > 1) {
                this._dynamicSqlText = this._dynamicSqlText == null ? sqlText : this._dynamicSqlText + sqlText;
            }
            this._sqlText.append(sqlText);
            this._srvLogin = serverLogin;
        }

        public String getSqlText() {
            if (this._dynamicSqlName != null && !this._isDynamicSqlPrepare) {
                for (BatchIdEntry be : this._parent._batchIdMap.values()) {
                    if (!be._isDynamicSqlPrepare || !this._dynamicSqlName.equals(be._dynamicSqlName)) continue;
                    if (be._dynamicSqlText != null) {
                        return "/* DYNAMIC-SQL: */ " + be._dynamicSqlText;
                    }
                    return "/* DYNAMIC-SQL: */ " + be._sqlText.toString();
                }
            }
            return this._sqlText.toString();
        }

        public String getServerLogin() {
            return this._srvLogin;
        }
    }

    private static class SpidEntry {
        private int _spid;
        private int _kpid;
        private HashMap<Integer, BatchIdEntry> _batchIdMap = new HashMap();

        public SpidEntry(int spid, int kpid) {
            this._spid = spid;
            this._kpid = kpid;
        }

        private BatchIdEntry getBatchIdEntry(int spid, int kpid, int batchId) {
            BatchIdEntry batchIdEntry;
            if (kpid != this._kpid) {
                this._batchIdMap.clear();
                this._kpid = kpid;
            }
            if ((batchIdEntry = this._batchIdMap.get(batchId)) == null) {
                batchIdEntry = new BatchIdEntry(this, spid, kpid, batchId);
                this._batchIdMap.put(batchId, batchIdEntry);
            }
            return batchIdEntry;
        }

        public void addSqlText(int spid, int kpid, int batchId, int sequenceNum, String sqlText, String serverLogin) {
            this.getBatchIdEntry(spid, kpid, batchId).addSqlText(sequenceNum, sqlText, serverLogin);
        }
    }

    private static class SpidSqlTextManager {
        private HashMap<Integer, SpidEntry> _spidMap = new HashMap();

        private SpidSqlTextManager() {
        }

        private SpidEntry getSpidEntry(int spid, int kpid) {
            SpidEntry spidEntry = this._spidMap.get(spid);
            if (spidEntry == null) {
                spidEntry = new SpidEntry(spid, kpid);
                this._spidMap.put(spid, spidEntry);
            }
            return spidEntry;
        }

        public void addSqlText(int spid, int kpid, int batchId, int sequenceNum, String sqlText, String serverLogin) {
            this.getSpidEntry(spid, kpid).addSqlText(spid, kpid, batchId, sequenceNum, sqlText, serverLogin);
        }
    }

    private static class MdaCheckMarker {
        String _sqlMarker;
        int _spid;
        int _kpid;
        int _batchId;

        private MdaCheckMarker() {
        }

        public String toString() {
            return super.toString() + " -- spid=" + this._spid + ", kpid=" + this._kpid + ", batchId=" + this._batchId + ", sqlMarker='" + this._sqlMarker + "'.";
        }
    }
}

