/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.collectors;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sek.ase.auditor.utils.Configuration;
import sek.ase.auditor.utils.StringUtil;
import sek.ase.auditor.utils.TimeUtils;

public class SybSysProcessesCache {
    private static Logger _logger = LogManager.getLogger();
    public static final String PROPKEY_refreshThresholdInMs = "SybSysProcessesCache.refreshThresholdInMs";
    public static final long DEFAULT_refreshThresholdInMss = 500L;
    private static SybSysProcessesCache _instance = null;
    private long _refreshThresholdInMs = Configuration.getCombinedConfiguration().getLongProperty("SybSysProcessesCache.refreshThresholdInMs", 500L);
    private long _lastTotalRefreshTime = -1L;
    private long _lastSingleRefreshTime = -1L;
    private long _totalRefreshCount = 0L;
    private Map<Integer, Map<Integer, SybSysProcessesEntry>> _cache = new ConcurrentHashMap<Integer, Map<Integer, SybSysProcessesEntry>>();

    public static SybSysProcessesCache getInstance() {
        if (_instance == null) {
            _instance = new SybSysProcessesCache();
        }
        return _instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SybSysProcessesEntry getCachedRecord(int spid, int kpid) {
        Map<Integer, SybSysProcessesEntry> kpidEntry = this._cache.get(spid);
        if (kpidEntry == null) return null;
        if (kpid == -1) {
            if (kpidEntry.size() == 1) {
                Iterator<SybSysProcessesEntry> iterator = kpidEntry.values().iterator();
                if (!iterator.hasNext()) return null;
                return iterator.next();
            }
            long loginTs = 0L;
            SybSysProcessesEntry returnEntry = null;
            Iterator<SybSysProcessesEntry> iterator = kpidEntry.values().iterator();
            while (iterator.hasNext()) {
                SybSysProcessesEntry entry = iterator.next();
                if (entry._loggedindatetime.getTime() <= loginTs) continue;
                loginTs = entry._loggedindatetime.getTime();
                returnEntry = entry;
            }
            return returnEntry;
        }
        SybSysProcessesEntry entry = kpidEntry.get(kpid);
        if (entry == null) return null;
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SybSysProcessesEntry getRecord(Connection conn, int spid, int kpid) throws SQLException {
        SybSysProcessesEntry cachedRecord = this.getCachedRecord(spid, kpid);
        if (cachedRecord != null) {
            return cachedRecord;
        }
        long msSinceLastRefresh = TimeUtils.msDiffNow(this._lastTotalRefreshTime);
        if (msSinceLastRefresh < this._refreshThresholdInMs) {
            _logger.info("Skipping refresh of " + this.getClass().getSimpleName() + ", (spid=" + spid + ", kpid=" + kpid + ") due to last refresh was done " + msSinceLastRefresh + " ms ago, and the threshold is " + this._refreshThresholdInMs + ". This to not overload when there are SPID's not logged in. This can be changed with Property: " + PROPKEY_refreshThresholdInMs + " = ###");
            return null;
        }
        SybSysProcessesCache sybSysProcessesCache = this;
        synchronized (sybSysProcessesCache) {
            cachedRecord = this.getCachedRecord(spid, kpid);
            if (cachedRecord != null) {
                return cachedRecord;
            }
            Map<Integer, List<String>> suidToRoleNames = this.getSrvRolesMap(conn);
            String sql = "select \n     spid \n    ,kpid \n    ,suid \n    ,suser_name(suid) \n    ,hostname \n    ,program_name \n    ,hostprocess \n    ,dbid \n    ,db_name(dbid) \n    ,uid \n    ,gid \n    ,fid \n    ,origsuid \n    ,suser_name(origsuid) \n    ,clientname \n    ,clienthostname \n    ,clientapplname \n    ,loggedindatetime \n    ,ipaddr \nfrom master.dbo.sysprocesses \nwhere suid != 0 \n";
            SybSysProcessesEntry returnEntry = null;
            long startTime = System.currentTimeMillis();
            int refreshRecords = 0;
            int beforeRefreshSpidCount = this._cache.size();
            Statement stmnt = conn.createStatement();
            Object object = null;
            try {
                ResultSet resultSet = stmnt.executeQuery(sql);
                Object object2 = null;
                try {
                    while (resultSet.next()) {
                        ++refreshRecords;
                        SybSysProcessesEntry sybSysProcessesEntry = new SybSysProcessesEntry();
                        sybSysProcessesEntry._spid = resultSet.getInt(1);
                        sybSysProcessesEntry._kpid = resultSet.getInt(2);
                        sybSysProcessesEntry._suid = resultSet.getInt(3);
                        sybSysProcessesEntry._login_name = resultSet.getString(4);
                        sybSysProcessesEntry._hostname = resultSet.getString(5);
                        sybSysProcessesEntry._program_name = resultSet.getString(6);
                        sybSysProcessesEntry._hostprocess = resultSet.getString(7);
                        sybSysProcessesEntry._dbid = resultSet.getInt(8);
                        sybSysProcessesEntry._dbname = resultSet.getString(9);
                        sybSysProcessesEntry._uid = resultSet.getInt(10);
                        sybSysProcessesEntry._gid = resultSet.getInt(11);
                        sybSysProcessesEntry._fid = resultSet.getInt(12);
                        sybSysProcessesEntry._origsuid = resultSet.getInt(13);
                        sybSysProcessesEntry._origin_login_name = resultSet.getString(14);
                        sybSysProcessesEntry._clientname = resultSet.getString(15);
                        sybSysProcessesEntry._clienthostname = resultSet.getString(16);
                        sybSysProcessesEntry._clientapplname = resultSet.getString(17);
                        sybSysProcessesEntry._loggedindatetime = resultSet.getTimestamp(18);
                        sybSysProcessesEntry._ipaddr = resultSet.getString(19);
                        sybSysProcessesEntry._roleNames = StringUtil.toCommaStr((Collection)suidToRoleNames.get(sybSysProcessesEntry._suid));
                        if (sybSysProcessesEntry._spid == spid && sybSysProcessesEntry._kpid == kpid) {
                            returnEntry = sybSysProcessesEntry;
                        }
                        HashMap<Integer, SybSysProcessesEntry> newKpidEntry = new HashMap<Integer, SybSysProcessesEntry>();
                        newKpidEntry.put(sybSysProcessesEntry._kpid, sybSysProcessesEntry);
                        this._cache.put(sybSysProcessesEntry._spid, newKpidEntry);
                    }
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    if (resultSet != null) {
                        if (object2 != null) {
                            try {
                                resultSet.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object2).addSuppressed(throwable);
                            }
                        } else {
                            resultSet.close();
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (stmnt != null) {
                    if (object != null) {
                        try {
                            stmnt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        stmnt.close();
                    }
                }
            }
            boolean debugPrint = false;
            if (debugPrint) {
                for (Map.Entry entry : this._cache.entrySet()) {
                    for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                        System.out.println("############# " + this.getClass().getSimpleName() + " ################# SPID=" + entry.getKey() + ", KPID=" + entry2.getKey() + ": " + entry2.getValue());
                    }
                }
            }
            long execTimeMs = TimeUtils.msDiffNow(startTime);
            String msSinceLastRefreshStr = this._lastTotalRefreshTime < 0L ? "-initial-refresh-" : TimeUtils.msToTimeStrShort(TimeUtils.msDiffNow(this._lastTotalRefreshTime));
            int n = this._cache.size();
            int afterRefreshSpidCountDiff = n - beforeRefreshSpidCount;
            _logger.info("Refreshed 'sysprocesses' cache (total refresh) with " + refreshRecords + " entries, which took " + execTimeMs + " ms. The requested spid=" + spid + ", kpid=" + kpid + ". Last refresh was done '" + msSinceLastRefreshStr + "' (MM:SS.ms) ago. spidCountBeforeRefresh=" + beforeRefreshSpidCount + ", spidCountAfterRefresh=" + n + ", diff=" + afterRefreshSpidCountDiff);
            ++this._totalRefreshCount;
            this._lastTotalRefreshTime = System.currentTimeMillis();
            this._lastSingleRefreshTime = System.currentTimeMillis();
            return returnEntry;
        }
    }

    private Map<Integer, List<String>> getSrvRolesMap(Connection conn) {
        String sql = "select suid, role_name(srid) from master.dbo.sysloginroles";
        HashMap<Integer, List<String>> map = new HashMap<Integer, List<String>>();
        try (Statement stmnt = conn.createStatement();
             ResultSet rs = stmnt.executeQuery(sql);){
            while (rs.next()) {
                int suid = rs.getInt(1);
                String roleName = rs.getString(2);
                ArrayList<String> roleNames = (ArrayList<String>)map.get(suid);
                if (roleNames == null) {
                    roleNames = new ArrayList<String>();
                    map.put(suid, roleNames);
                }
                roleNames.add(roleName);
            }
        }
        catch (SQLException ex) {
            _logger.warn("Problems getting ASE Role information using SQL='" + sql + "'. Error=" + ex.getErrorCode() + ", Msg='" + ex.getMessage() + "'.");
        }
        return map;
    }

    public static class SybSysProcessesEntry {
        int _spid;
        int _kpid;
        int _suid;
        String _login_name;
        String _hostname;
        String _program_name;
        String _hostprocess;
        int _dbid;
        String _dbname;
        int _uid;
        int _gid;
        int _fid;
        int _origsuid;
        String _origin_login_name;
        String _clientname;
        String _clienthostname;
        String _clientapplname;
        Timestamp _loggedindatetime;
        String _ipaddr;
        String _roleNames;

        public int getSpid() {
            return this._spid;
        }

        public int getKpid() {
            return this._kpid;
        }

        public int getSuid() {
            return this._suid;
        }

        public String getLoginName() {
            return this._login_name;
        }

        public String getHostName() {
            return this._hostname;
        }

        public String getProgramName() {
            return this._program_name;
        }

        public String getHostProcess() {
            return this._hostprocess;
        }

        public int getDbid() {
            return this._dbid;
        }

        public String getDbname() {
            return this._dbname;
        }

        public int getUid() {
            return this._uid;
        }

        public int getGid() {
            return this._gid;
        }

        public int getFid() {
            return this._fid;
        }

        public int getOrigSuid() {
            return this._origsuid;
        }

        public String getOriginLoginName() {
            return this._origin_login_name;
        }

        public String getClientName() {
            return this._clientname;
        }

        public String getClientHostName() {
            return this._clienthostname;
        }

        public String getClientApplName() {
            return this._clientapplname;
        }

        public Timestamp getLoggedinDatetime() {
            return this._loggedindatetime;
        }

        public String getIpaddr() {
            return this._ipaddr;
        }

        public String getRoleNames() {
            return this._roleNames;
        }

        public void createJsonForRecord(JsonGenerator gen) throws IOException {
            gen.writeFieldName("sysProcessesInfo");
            gen.writeStartObject();
            gen.writeNumberField("spid", this._spid);
            gen.writeNumberField("kpid", this._kpid);
            gen.writeNumberField("suid", this._suid);
            gen.writeStringField("loginName", this._login_name);
            gen.writeStringField("hostName", this._hostname);
            gen.writeStringField("programName", this._program_name);
            gen.writeStringField("hostProcess", this._hostprocess);
            gen.writeNumberField("dbid", this._dbid);
            gen.writeStringField("dbname", this._dbname);
            gen.writeNumberField("uid", this._uid);
            gen.writeNumberField("gid", this._gid);
            gen.writeNumberField("fid", this._fid);
            gen.writeNumberField("origSuid", this._origsuid);
            gen.writeStringField("originLoginName", this._origin_login_name);
            gen.writeStringField("clientName", this._clientname);
            gen.writeStringField("clientHostName", this._clienthostname);
            gen.writeStringField("clientApplName", this._clientapplname);
            gen.writeStringField("loggedinDatetime", TimeUtils.toStringIso8601(this._loggedindatetime));
            gen.writeStringField("ipaddr", this._ipaddr);
            gen.writeStringField("roleNames", this._roleNames);
            gen.writeEndObject();
        }

        public int hashCode() {
            return Objects.hash(this._kpid, this._spid);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SybSysProcessesEntry other = (SybSysProcessesEntry)obj;
            return this._kpid == other._kpid && this._spid == other._spid;
        }

        public String toString() {
            return "SybSysProcessesEntry [spid=" + this._spid + ", kpid=" + this._kpid + ", suid=" + this._suid + ", login_name='" + this._login_name + "', hostname='" + this._hostname + "', program_name='" + this._program_name + "', hostprocess='" + this._hostprocess + "', dbid=" + this._dbid + ", dbname='" + this._dbname + "', uid=" + this._uid + ", gid=" + this._gid + ", fid=" + this._fid + ", origsuid=" + this._origsuid + ", origin_login_name='" + this._origin_login_name + "', clientname='" + this._clientname + "', clienthostname='" + this._clienthostname + "', clientapplname='" + this._clientapplname + "', loggedindatetime='" + this._loggedindatetime + "', ipaddr=" + this._ipaddr + "]";
        }
    }
}

