/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.collectors.records;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sek.ase.auditor.Version;
import sek.ase.auditor.utils.Configuration;
import sek.ase.auditor.utils.StringUtil;
import sek.ase.auditor.utils.TimeUtils;
import sek.ase.auditor.wqs.WriterQueueContainer;

public abstract class AuditRecord {
    private static Logger _logger = LogManager.getLogger();
    protected WriterQueueContainer _container;
    private static final int JSON_MESSAGE_VERSION = 1;

    public void setContainer(WriterQueueContainer container) {
        this._container = container;
    }

    public WriterQueueContainer getContainer() {
        return this._container;
    }

    public boolean isEmpty() {
        return false;
    }

    public abstract void createJsonForRecord(JsonGenerator var1) throws IOException;

    public void createJson(JsonGenerator gen) throws IOException {
        gen.writeStartObject();
        gen.writeFieldName("head");
        gen.writeStartObject();
        gen.writeNumberField("messageVersion", 1);
        gen.writeStringField("appName", Version.getAppName());
        gen.writeStringField("appVersion", Version.getVersionStr());
        gen.writeStringField("appBuildString", Version.getBuildStr());
        WriterQueueContainer cont = this.getContainer();
        gen.writeStringField("sampleTime", TimeUtils.toStringIso8601(cont.getMainSampleTime()));
        gen.writeStringField("serverName", cont.getServerName());
        gen.writeStringField("onHostname", cont.getOnHostname());
        gen.writeStringField("recordType", this.getClass().getSimpleName());
        gen.writeEndObject();
        this.createJsonForRecord(gen);
        gen.writeEndObject();
    }

    public String toJson() throws IOException {
        String debugToFileNameStr;
        StringWriter sw = new StringWriter();
        JsonFactory jfactory = new JsonFactory();
        JsonGenerator gen = jfactory.createGenerator((Writer)sw);
        gen.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        gen.setCodec((ObjectCodec)new ObjectMapper(jfactory));
        this.createJson(gen);
        gen.close();
        String jsonStr = sw.toString();
        if (Configuration.getCombinedConfiguration().hasProperty("AuditRecordSybMda.debug.toJson.writeToFile") && StringUtil.hasValue(debugToFileNameStr = Configuration.getCombinedConfiguration().getProperty("PersistContainer.debug.toJson.writeToFile", ""))) {
            if ("STDOUT".equalsIgnoreCase(debugToFileNameStr)) {
                System.out.println("#### BEGIN JSON #####################################################################");
                System.out.println(jsonStr);
                System.out.println("#### END JSON #######################################################################");
            } else {
                File debugToFileName = new File(debugToFileNameStr);
                try {
                    _logger.info("Writing JSON message to DEBUG file '" + debugToFileName.getAbsolutePath() + "'.");
                    FileUtils.writeStringToFile((File)debugToFileName, (String)jsonStr, (Charset)StandardCharsets.UTF_8);
                }
                catch (Exception ex) {
                    _logger.error("PROBLEMS Writing JSON message to DEBUG file '" + debugToFileName.getAbsolutePath() + "', skipping and continuing.", (Throwable)ex);
                }
            }
        }
        return jsonStr;
    }
}

