/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.utils;

import com.sybase.jdbcx.EedInfo;
import com.sybase.util.ds.interfaces.Service;
import com.sybase.util.ds.interfaces.SyInterfacesDriver;
import com.sybase.util.ds.interfaces.SyInterfacesEntry;
import java.lang.invoke.MethodHandles;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sek.ase.auditor.utils.StringUtil;

public class AseUtils {
    private static Logger _logger = LogManager.getLogger(MethodHandles.lookup().lookupClass());

    public static String sqlExceptionOrWarningAllToString(SQLException sqle) {
        StringBuffer sb = new StringBuffer();
        String prefix = "";
        int cnt = 0;
        while (sqle != null) {
            ++cnt;
            if (sqle instanceof EedInfo) {
                EedInfo sybsqle = (EedInfo)sqle;
                int errorCode = sqle.getErrorCode();
                int severity = sybsqle.getSeverity();
                sb.append(prefix);
                sb.append("(Srv='").append(sybsqle.getServerName()).append("'");
                if (errorCode != 0 && severity != 10) {
                    sb.append(", Error=").append(errorCode);
                    sb.append(", Severity=").append(severity);
                }
                if (StringUtil.hasValue(sybsqle.getProcedureName())) {
                    sb.append(", Proc='").append(sybsqle.getProcedureName()).append("'");
                    sb.append(", Line=").append(sybsqle.getLineNumber());
                }
                sb.append(", Text='").append(sqle.getMessage().trim()).append("'");
                sb.append(")");
            } else {
                sb.append("(Error=").append(sqle.getErrorCode());
                sb.append(", Text='").append(sqle.getMessage()).append("'");
                sb.append(")");
            }
            sqle = sqle.getNextException();
            prefix = ", ";
        }
        if (cnt == 1) {
            sb.delete(0, 1);
            sb.delete(sb.length() - 1, sb.length());
        }
        return sb.toString();
    }

    public static String sqlExceptionOrWarningSingleToString(SQLException sqle) {
        StringBuffer sb = new StringBuffer();
        if (sqle instanceof EedInfo) {
            EedInfo sybsqle = (EedInfo)sqle;
            int errorCode = sqle.getErrorCode();
            int severity = sybsqle.getSeverity();
            sb.append("Srv='").append(sybsqle.getServerName()).append("'");
            if (errorCode != 0 && severity != 10) {
                sb.append(", Error=").append(errorCode);
                sb.append(", Severity=").append(severity);
            }
            if (StringUtil.hasValue(sybsqle.getProcedureName())) {
                sb.append(", Proc='").append(sybsqle.getProcedureName()).append("'");
                sb.append(", Line=").append(sybsqle.getLineNumber());
            }
            sb.append(", Text='").append(sqle.getMessage().trim()).append("'");
        } else {
            sb.append("Error=").append(sqle.getErrorCode());
            sb.append(", Text='").append(sqle.getMessage()).append("'");
        }
        return sb.toString();
    }

    public static String getHostPortFromInterfacesFile(String server) {
        SyInterfacesDriver interfacesDriver = new SyInterfacesDriver();
        try {
            interfacesDriver.open();
        }
        catch (Exception ex) {
            _logger.warn("getHostPortFromInterfacesFile(): Can not Initialize the interfaces driver. Caught: " + ex);
        }
        SyInterfacesEntry ie = interfacesDriver.getEntry(server);
        if (ie == null) {
            _logger.warn("getHostPortFromInterfacesFile(): Can not find an entry for server '" + server + "', from the interfaces driver '" + interfacesDriver.getBundle() + "'. null will be returned.");
            return null;
        }
        String hostPortStr = "";
        List queryRows = ie.getServices();
        for (Service se : queryRows) {
            if (!"query".equalsIgnoreCase(se.getType())) continue;
            String seHost = se.getHost();
            String sePort = se.getPort();
            hostPortStr = hostPortStr + seHost + ":" + sePort;
            return hostPortStr;
        }
        return null;
    }

    public static int getAseConfigRunValue(Connection conn, String config) throws SQLException {
        int val = -1;
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("sp_configure '" + config + "'");
        while (rs.next()) {
            val = rs.getInt(5);
        }
        rs.close();
        stmt.close();
        return val;
    }

    public static String getAseConfigRunValueStr(Connection conn, String config) throws SQLException {
        String val = null;
        Statement stmt = conn.createStatement();
        ResultSet rs = stmt.executeQuery("sp_configure '" + config + "'");
        while (rs.next()) {
            val = rs.getString(5);
        }
        rs.close();
        stmt.close();
        if (val != null) {
            val = val.trim();
        }
        return val;
    }
}

