/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.utils;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sek.ase.auditor.Version;
import sek.ase.auditor.utils.Encrypter;
import sek.ase.auditor.utils.MandatoryPropertyException;
import sek.ase.auditor.utils.NumberUtils;
import sek.ase.auditor.utils.OSCommand;
import sek.ase.auditor.utils.StringUtil;

public class Configuration
extends Properties {
    private static final long serialVersionUID = 5707562050158600080L;
    private static final String ENCRYPTED_PREFIX = "encrypted:";
    public static final Configuration EMPTY_CONFIGURATION = new Configuration();
    public static final String SYSTEM_CONF = "SYSTEM_CONF";
    public static final String USER_CONF = "USER_CONF";
    public static final String USER_TEMP = "USER_TEMP";
    public static final String PCS = "PCS";
    public static final String TAIL_TEMP = "TAIL_TEMP";
    private static Logger _logger = LogManager.getLogger(MethodHandles.lookup().lookupClass());
    private static HashMap<String, Configuration> _instMap = new HashMap();
    private String _propFileName = null;
    private boolean _saveOnExit = false;
    private boolean _saveIsEnabled = true;
    private String _confName = "";
    private int _saveCount = 0;
    private boolean _isDirty = false;
    private boolean _hasActiveSaveThread = false;
    private static Window _guiWindow = null;
    private static String encrypterBaseKey = "qazZSE44wsxXDR555707562050158600080edcCFT66rfvVGY77";
    private String _embeddedMessage = "This file will be overwritten and maintained by " + Version.getAppName();
    public static final String HAS_GUI = "application.gui";
    public static final int COMBINED_CONFIG_KEY_ADDED = 1;
    public static final int COMBINED_CONFIG_KEY_CHANGED = 2;
    public static final int COMBINED_CONFIG_KEY_REMOVED = 3;
    private static ArrayList<PropertyChangeListener> _combinedConfigPropertyChangeListeners = new ArrayList();
    private static FileWatcher _combinedConfigurationFileWatcher;
    private static final String USE_DEFAULT_PREFIX = "USE_DEFAULT:";
    private static final String USE_DEFAULT = "USE_DEFAULT";
    private static HashMap<String, String> _registeredDefault;
    private static final char[] hexDigit;
    private static String[] _searchOrder;
    private static CombinedConfiguration _combinedConfig;

    public static boolean hasGui() {
        return System.getProperty(HAS_GUI, "true").equalsIgnoreCase("true");
    }

    public static void setGui(boolean hasGui) {
        System.setProperty(HAS_GUI, Boolean.toString(hasGui));
    }

    public static void setGuiWindow(Window w) {
        Configuration.setGui(w != null);
        _guiWindow = w;
    }

    public Configuration() {
    }

    public Configuration(String filename) {
        this.load(filename);
    }

    public Configuration(String confName, String filename) {
        this.setConfName(confName);
        this.load(filename);
    }

    public static Configuration getInstance(String confName) {
        Configuration conf = _instMap.get(confName);
        if (conf == null) {
            _logger.warn("Can't find any configuration named '" + confName + "', creating a new one.");
            conf = new Configuration();
            _instMap.put(confName, conf);
        }
        return conf;
    }

    public static boolean hasInstance(String confName) {
        return _instMap.containsKey(confName);
    }

    public static void setInstance(String confName, Configuration configuration) {
        configuration._confName = confName;
        _instMap.put(confName, configuration);
    }

    public static String changeTypeToStr(Object objType) {
        String typeStr = "" + objType;
        return Configuration.changeTypeToStr(StringUtil.parseInt(typeStr, -1));
    }

    public static String changeTypeToStr(int type) {
        if (type == 1) {
            return "ADDED";
        }
        if (type == 2) {
            return "CHANGED";
        }
        if (type == 3) {
            return "REMOVED";
        }
        return "-UNKNOWN[" + type + "]-";
    }

    public static void addCombinedConfigPropertyChangeListener(PropertyChangeListener listener) {
        _combinedConfigPropertyChangeListeners.add(listener);
    }

    public static void removeCombinedConfigPropertyChangeListener(PropertyChangeListener listener) {
        _combinedConfigPropertyChangeListeners.remove(listener);
    }

    private static void fireCombinedConfigPropertyChangeListener(Configuration source, int type, String propertyName, String oldValue, String newValue) {
        if (_combinedConfigPropertyChangeListeners.isEmpty()) {
            return;
        }
        PropertyChangeEvent evt = new PropertyChangeEvent(source, propertyName, oldValue, newValue);
        evt.setPropagationId(type);
        for (PropertyChangeListener l : _combinedConfigPropertyChangeListeners) {
            try {
                l.propertyChange(evt);
            }
            catch (RuntimeException ex) {
                _logger.error("Problems when calling PropertyChangeListener '" + l + "'. Caught: " + ex, (Throwable)ex);
            }
        }
    }

    public static synchronized void startCombinedConfigurationFileWatcher() {
        if (_combinedConfigurationFileWatcher == null) {
            _combinedConfigurationFileWatcher = new FileWatcher();
            _combinedConfigurationFileWatcher.setName("CombinedConfigurationFileWatcher");
            _combinedConfigurationFileWatcher.setDaemon(true);
            _combinedConfigurationFileWatcher.start();
        } else {
            _logger.warn("Combined Config File change listener has already bee started.");
        }
    }

    public static void stopCombinedConfigurationFileWatcher() {
        if (_combinedConfigurationFileWatcher != null) {
            _combinedConfigurationFileWatcher.setRunning(false);
        }
    }

    public static synchronized void setCombinedConfigurationFileWatcher_SkipKeyPrefix(List<String> list) {
        if (_combinedConfigurationFileWatcher != null) {
            _combinedConfigurationFileWatcher.setSkipKeyPrefix(list);
        }
    }

    public static synchronized void addCombinedConfigurationFileWatcher_SkipKeyPrefix(String skipKeyPrefix) {
        if (_combinedConfigurationFileWatcher != null) {
            _combinedConfigurationFileWatcher.addSkipKeyPrefix(skipKeyPrefix);
        }
    }

    public static Configuration emptyConfiguration() {
        return EMPTY_CONFIGURATION;
    }

    public String getConfName() {
        return this._confName;
    }

    public String setConfName(String confName) {
        String oldName = this._confName;
        this._confName = confName;
        return oldName;
    }

    public String getFilename() {
        return this._propFileName;
    }

    public void setFilename(String filename) {
        this._propFileName = filename;
    }

    public boolean hasFileAndExists() {
        String filename = this.getFilename();
        if (StringUtil.hasValue(filename)) {
            File f = new File(filename);
            return f.exists();
        }
        return false;
    }

    public String getEmbeddedMessage() {
        return this._embeddedMessage;
    }

    public void setEmbeddedMessage(String embeddedMessage) {
        this._embeddedMessage = embeddedMessage;
    }

    public void setSaveOnExit(boolean b) {
        this._saveOnExit = b;
    }

    public void append(String str, String responsible) throws IOException {
        if (str == null) {
            return;
        }
        FileOutputStream os = new FileOutputStream(new File(this._propFileName), true);
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)os, "8859_1"));
        if (!str.endsWith("\n")) {
            str = str + "\n";
        }
        bw.write("\n");
        bw.write("\n");
        bw.write("#--------------------------------------------------------------------\n");
        bw.write("# The below entries was Append at: " + new Date().toString() + "\n");
        bw.write("# By: " + responsible + "\n");
        bw.write("#--------------------------------------------------------------------\n");
        bw.write(str);
        bw.write("#--------------------------------------------------------------------\n");
        bw.flush();
        os.close();
    }

    public void setSaveEnable(boolean enable) {
        this._saveIsEnabled = enable;
    }

    public void save() {
        if (!this._isDirty) {
            _logger.debug("Save was called, but the configuration '" + this.getConfName() + "' was not dirty. Skipping this save.");
            return;
        }
        _logger.debug("calling save(false) for the configuration '" + this.getConfName() + "'. _isDirty=" + this._isDirty);
        this.save(false);
    }

    public void save(boolean withOverride) {
        if (!this._saveIsEnabled && !withOverride) {
            _logger.debug("Save is disabled for the configuration '" + this.getConfName() + "', which uses the file '" + this.getFilename() + "'.");
            return;
        }
        if (this._propFileName == null) {
            _logger.debug("No filename has been assigned to this property file, can't save...");
            return;
        }
        ++this._saveCount;
        final int currentSaveCount = this._saveCount;
        Runnable saveJob = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    while (Configuration.this._hasActiveSaveThread) {
                        Thread.sleep(250L);
                    }
                    Configuration.this._hasActiveSaveThread = true;
                    long startTime = System.currentTimeMillis();
                    File f = new File(Configuration.this._propFileName);
                    long needKB = f.length() * 2L / 1024L;
                    long freeKB = f.getUsableSpace() / 1024L;
                    if (needKB > freeKB) {
                        throw new Exception("Before saving the file '" + Configuration.this._propFileName + "' I predicted that I will need/use " + needKB + " KB during the save. But the filesystem only has " + freeKB + " KB available. If I save the file it might be corrupted. So please clear some additional space, then the files will be saved.");
                    }
                    FileOutputStream os = new FileOutputStream(f);
                    Configuration.this.store(os, Configuration.this.getEmbeddedMessage());
                    os.close();
                    Configuration.this._isDirty = false;
                    long saveTime = System.currentTimeMillis() - startTime;
                    if (saveTime > 1000L) {
                        _logger.warn("Configuration.save() took " + saveTime + " ms... Config file name ='" + Configuration.this._propFileName + "'. Do you have a slow IO subsystem?");
                    }
                }
                catch (Exception e) {
                    _logger.error("Problems saving Configuration name='" + Configuration.this._confName + "', file='" + Configuration.this._propFileName + "', currentSaveCount=" + currentSaveCount + ". Caught: " + e, (Throwable)e);
                }
                finally {
                    Configuration.this._hasActiveSaveThread = false;
                }
            }
        };
        Thread saveThread = new Thread(saveJob, "SaveCfgFile-" + currentSaveCount + "-" + this._confName);
        saveThread.start();
    }

    public void reload() {
        super.clear();
        this.load(this._propFileName);
    }

    public void load() {
        this.load(this._propFileName);
    }

    public void load(String filename) {
        this.setFilename(filename);
        if (filename == null) {
            _logger.warn("No config file was passed, filename=null, continuing anyway.");
            return;
        }
        try {
            FileInputStream in = new FileInputStream(filename);
            super.load(in);
            in.close();
            for (String inclKey : this.getKeys("include.")) {
                String inclFileName = this.getProperty(inclKey);
                _logger.info("Configuration '" + this.getConfName() + "'. Reading configuration file '" + inclFileName + "' for the key '" + inclKey + "'.");
                try {
                    FileInputStream includeFis = new FileInputStream(inclFileName);
                    Properties includeProps = new Properties();
                    includeProps.load(includeFis);
                    includeFis.close();
                    for (Map.Entry<Object, Object> entry : includeProps.entrySet()) {
                        String incKey = String.valueOf(entry.getKey());
                        String incVal = String.valueOf(entry.getValue());
                        if (this.containsKey(incKey)) {
                            _logger.warn("Configuration '" + this.getConfName() + "'. include directive issue: property value already exists, skipping this property. Origin Config File '" + filename + "', includeKey='" + inclKey + "', includeFile='" + inclFileName + "', key='" + incKey + "', skippedValue='" + incVal + "', keepingCurrentValue='" + this.getProperty(incKey) + "'.");
                            continue;
                        }
                        this.setProperty(incKey, incVal);
                    }
                }
                catch (FileNotFoundException e) {
                    _logger.error("Configuration '" + this.getConfName() + "'. While reading the configuration file '" + filename + "' found a 'include' key '" + inclKey + "', however this file '" + inclFileName + "' was not possible to read. continuing anyway. Caught: " + e);
                }
                this.remove(inclKey);
            }
        }
        catch (FileNotFoundException e) {
            _logger.warn("Configuration '" + this.getConfName() + "'. The file '" + filename + "' could not be loaded, continuing anyway.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void print(PrintStream ps, String heading) {
        if (ps == null) {
            ps = System.out;
        }
        ps.println("");
        ps.println(heading);
        if (this.getFilename() != null) {
            ps.println("Filename='" + this.getFilename() + "'.");
        }
        ArrayList<String> sorted = new ArrayList<String>(new TreeSet<String>(this.stringPropertyNames()));
        ps.println("    key                                                          value");
        ps.println("    ------------------------------------------------------------ ----------------------------------------------------------------------------------");
        for (String key : sorted) {
            ps.format("    %-60s %s\n", key, this.getPropertyRaw(key));
        }
        ps.println("");
    }

    public void add(Configuration conf) {
        if (conf == null) {
            return;
        }
        this.putAll((Map<?, ?>)conf);
        this._isDirty = true;
    }

    @Override
    public Object remove(Object key) {
        Object obj = super.remove(key);
        if (obj != null) {
            this._isDirty = true;
        }
        return obj;
    }

    public void removeAll(String prefix) {
        Iterator<Object> it = this.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (!key.startsWith(prefix)) continue;
            it.remove();
            this._isDirty = true;
        }
    }

    public List<String> getKeys(String prefix) {
        ArrayList<String> matchingKeys = new ArrayList<String>();
        for (String string : this.keySet()) {
            if (prefix != null && !string.startsWith(prefix)) continue;
            matchingKeys.add(string);
        }
        Collections.sort(matchingKeys);
        return matchingKeys;
    }

    public List<String> getKeys() {
        return this.getKeys(null);
    }

    public List<String> getUniqueSubKeys(String prefix, boolean keepPrefix) {
        ArrayList<String> uniqueNames = new ArrayList<String>();
        for (String key : this.getKeys(prefix)) {
            String name;
            int start = keepPrefix ? 0 : prefix.length();
            int end = key.indexOf(".", prefix.length());
            if (end < 0) {
                end = key.length();
            }
            if (uniqueNames.contains(name = key.substring(start, end))) continue;
            uniqueNames.add(name);
        }
        Collections.sort(uniqueNames);
        return uniqueNames;
    }

    public boolean hasProperty(String propName) {
        return this.getProperty(propName) != null;
    }

    private static String getScreenResulutionAsString() {
        if (GraphicsEnvironment.isHeadless()) {
            return "headless";
        }
        String retStr = "";
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] screens = ge.getScreenDevices();
        int n = screens.length;
        for (int i = 0; i < n; ++i) {
            GraphicsDevice gd = screens[i];
            if (gd == null || gd.getDisplayMode() == null) continue;
            int width = gd.getDisplayMode().getWidth();
            int height = gd.getDisplayMode().getHeight();
            if (i > 0) {
                retStr = retStr + ";";
            }
            retStr = retStr + width + "x" + height;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("getScreenResulutionAsString(): returns |" + retStr + "|.");
        }
        return retStr;
    }

    public int getLayoutProperty(String key, int defaultVal) {
        String monitorProp = Configuration.getScreenResulutionAsString();
        String newKey = key + ".[" + monitorProp + "]";
        return this.getIntProperty(newKey, defaultVal);
    }

    public int setLayoutProperty(String key, int val) {
        String monitorProp = Configuration.getScreenResulutionAsString();
        String newKey = key + ".[" + monitorProp + "]";
        return this.setProperty(newKey, val);
    }

    public int getIntMandatoryProperty(String propName) throws MandatoryPropertyException {
        String val = this.getProperty(propName);
        if (val == null) {
            throw new MandatoryPropertyException("The property '" + propName + "' is mandatory.");
        }
        try {
            return NumberUtils.toNumber(val).intValue();
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("The property '" + propName + "' must be a number. I found value '" + val + "'.");
        }
    }

    public int getIntProperty(String propName) {
        String val = this.getProperty(propName);
        return NumberUtils.toNumber(val).intValue();
    }

    public int getIntProperty(String propName, int defaultValue) {
        return this.getIntProperty(propName, Integer.toString(defaultValue));
    }

    public int getIntProperty(String propName, String defaultValue) {
        String val = this.getProperty(propName, defaultValue);
        if (StringUtil.isNullOrBlank(val)) {
            val = defaultValue;
        }
        return NumberUtils.toNumber(val).intValue();
    }

    public long getLongMandatoryProperty(String propName) throws MandatoryPropertyException {
        String val = this.getProperty(propName);
        if (val == null) {
            throw new MandatoryPropertyException("The property '" + propName + "' is mandatory.");
        }
        return NumberUtils.toNumber(val).longValue();
    }

    public long getLongProperty(String propName) {
        String val = this.getProperty(propName);
        return NumberUtils.toNumber(val).longValue();
    }

    public long getLongProperty(String propName, long defaultValue) {
        return this.getLongProperty(propName, Long.toString(defaultValue));
    }

    public long getLongProperty(String propName, String defaultValue) {
        String val = this.getProperty(propName, defaultValue);
        if (StringUtil.isNullOrBlank(val)) {
            val = defaultValue;
        }
        return NumberUtils.toNumber(val).longValue();
    }

    public double getDoubleMandatoryProperty(String propName) throws MandatoryPropertyException {
        String val = this.getProperty(propName);
        if (val == null) {
            throw new MandatoryPropertyException("The property '" + propName + "' is mandatory.");
        }
        return NumberUtils.toNumber(val).doubleValue();
    }

    public double getDoubleProperty(String propName) {
        String val = this.getProperty(propName);
        return NumberUtils.toNumber(val).doubleValue();
    }

    public double getDoubleProperty(String propName, double defaultValue) {
        return this.getDoubleProperty(propName, Double.toString(defaultValue));
    }

    public double getDoubleProperty(String propName, String defaultValue) {
        String val = this.getProperty(propName, defaultValue);
        if (StringUtil.isNullOrBlank(val)) {
            val = defaultValue;
        }
        return NumberUtils.toNumber(val).doubleValue();
    }

    public boolean getBooleanMandatoryProperty(String propName) throws MandatoryPropertyException {
        String val = this.getProperty(propName);
        if (val == null) {
            throw new MandatoryPropertyException("The property '" + propName + "' is mandatory.");
        }
        return val.equalsIgnoreCase("true");
    }

    public boolean getBooleanProperty(String propName, boolean defaultValue) {
        String val = this.getProperty(propName, Boolean.toString(defaultValue));
        if (val == null) {
            return false;
        }
        return val.equalsIgnoreCase("true");
    }

    public String getMandatoryProperty(String propName) throws MandatoryPropertyException {
        String val = this.getProperty(propName);
        if (val == null) {
            throw new MandatoryPropertyException("The property '" + propName + "' is mandatory.");
        }
        return val;
    }

    @Override
    public String getProperty(String propName) {
        return this.private_getProperty(propName, false, null);
    }

    protected String private_getProperty(String propName, boolean hasPassedDefaultValue, String defaultValue) {
        String val = super.getProperty(propName);
        if (val == null) {
            val = Configuration.getRegisteredDefaultValue(propName);
            if (val == null && hasPassedDefaultValue) {
                val = defaultValue;
            }
        } else {
            val = val.trim();
            val = hasPassedDefaultValue && (val.startsWith(USE_DEFAULT_PREFIX) || val.equals(USE_DEFAULT)) ? defaultValue : Configuration.getUseDefaultValue(propName, val);
        }
        return this.parseProperty(propName, val);
    }

    @Override
    public String getProperty(String propName, String defaultValue) {
        String val = this.private_getProperty(propName, true, defaultValue);
        return val != null ? val : defaultValue;
    }

    public String getMandatoryPropertyRaw(String propName) throws MandatoryPropertyException {
        String val = this.getPropertyRaw(propName);
        if (val == null) {
            throw new MandatoryPropertyException("The property '" + propName + "' is mandatory.");
        }
        return val;
    }

    public String getPropertyRaw(String propName) {
        return this.private_getPropertyRaw(propName, false, null, true);
    }

    protected String private_getPropertyRaw(String propName, boolean hasPassedDefaultValue, String defaultValue, boolean doTrim) {
        String val = super.getProperty(propName);
        if (val == null) {
            val = Configuration.getRegisteredDefaultValue(propName);
            if (val == null && hasPassedDefaultValue) {
                val = defaultValue;
            }
        } else {
            if (doTrim) {
                val = val.trim();
            }
            val = hasPassedDefaultValue && (val.startsWith(USE_DEFAULT_PREFIX) || val.equals(USE_DEFAULT)) ? defaultValue : Configuration.getUseDefaultValue(propName, val);
        }
        return val;
    }

    public String getPropertyRaw(String propName, String defaultValue) {
        String val = this.private_getPropertyRaw(propName, true, defaultValue, true);
        return val != null ? val : defaultValue;
    }

    private String getPropertyRaw_test(String propName) {
        String val = super.getProperty(propName);
        if (val != null) {
            val = val.trim();
        }
        return val;
    }

    public String getMandatoryPropertyRawVal(String propName) throws MandatoryPropertyException {
        String val = this.getPropertyRawVal(propName);
        if (val == null) {
            throw new MandatoryPropertyException("The property '" + propName + "' is mandatory.");
        }
        return val;
    }

    public String getPropertyRawVal(String propName) {
        return this.private_getPropertyRaw(propName, false, null, false);
    }

    public String getPropertyRawVal(String propName, String defaultValue) {
        String val = this.private_getPropertyRaw(propName, true, defaultValue, false);
        return val != null ? val : defaultValue;
    }

    public static String encryptPropertyValue(String propName, String str) {
        if (str == null) {
            return null;
        }
        Encrypter propEncrypter = new Encrypter(encrypterBaseKey + propName);
        String encryptedStr = propEncrypter.encrypt(str);
        return ENCRYPTED_PREFIX + encryptedStr;
    }

    public static String decryptPropertyValue(String propName, String str) {
        if (str == null) {
            return null;
        }
        if (str.startsWith(ENCRYPTED_PREFIX)) {
            str = str.substring(ENCRYPTED_PREFIX.length());
            Encrypter encrypter = new Encrypter(encrypterBaseKey + propName);
            str = encrypter.decrypt(str);
        }
        return str;
    }

    public static boolean isEncryptedValue(String str) {
        if (str == null) {
            return false;
        }
        return str.startsWith(ENCRYPTED_PREFIX);
    }

    @Override
    public Object setProperty(String propName, String str) {
        return this.setProperty(propName, str, false);
    }

    public Object setProperty(String propName, String str, boolean encryptPropertyValue) {
        String regDefVal;
        if (str != null && encryptPropertyValue) {
            str = Configuration.encryptPropertyValue(propName, str);
        }
        if ((regDefVal = Configuration.getRegisteredDefaultValue(propName)) != null && regDefVal.equals(str)) {
            str = USE_DEFAULT_PREFIX + str;
        }
        if (str == null) {
            _logger.warn("Setting a property value to NULL, which is a faulty value. I will change this to '' (an empty string) for the key/property-name '" + propName + "', in config '" + this.getConfName() + "', using file '" + this.getFilename() + "'.");
            str = "";
        }
        Object prev = super.setProperty(propName, str);
        if (str != null && !str.equals(prev) || prev != null && !prev.equals(str)) {
            this._isDirty = true;
            if (_logger.isDebugEnabled()) {
                _logger.debug("Configuration '" + this.getConfName() + "' changed key='" + propName + "', newValue='" + str + "', oldValue='" + prev + "', _isDirty=" + this._isDirty + ".");
            }
        }
        if (prev != null && prev instanceof String) {
            String prevStr = (String)prev;
            if (prevStr.startsWith(USE_DEFAULT_PREFIX)) {
                prev = prevStr.substring(USE_DEFAULT_PREFIX.length()).trim();
            }
            if (prevStr.equals(USE_DEFAULT)) {
                prev = "";
            }
        }
        return prev;
    }

    public int setProperty(String propName, int t) {
        Object prev = this.setProperty(propName, Integer.toString(t));
        return prev == null ? -1 : this.parseInt((String)prev);
    }

    public long setProperty(String propName, long l) {
        Object prev = this.setProperty(propName, Long.toString(l));
        return prev == null ? -1L : this.parseLong((String)prev);
    }

    public double setProperty(String propName, double d) {
        Object prev = this.setProperty(propName, Double.toString(d));
        return prev == null ? -1.0 : this.parseDouble((String)prev);
    }

    public boolean setProperty(String propName, boolean b) {
        Object prev = this.setProperty(propName, Boolean.toString(b));
        return prev == null ? false : this.parseBoolean((String)prev);
    }

    private int parseInt(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (Throwable e) {
            return 0;
        }
    }

    private long parseLong(String str) {
        try {
            return Long.parseLong(str);
        }
        catch (Throwable e) {
            return 0L;
        }
    }

    private double parseDouble(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (Throwable e) {
            return 0.0;
        }
    }

    private boolean parseBoolean(String str) {
        try {
            return Boolean.parseBoolean(str);
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void removeAllRegisterDefaultValues() {
        _registeredDefault = new HashMap();
    }

    public static void registerDefaultValue(String propName, String defaultValue) {
        _registeredDefault.put(propName, defaultValue);
    }

    public static void registerDefaultValue(String propName, int defaultValue) {
        Configuration.registerDefaultValue(propName, Integer.toString(defaultValue));
    }

    public static void registerDefaultValue(String propName, long defaultValue) {
        Configuration.registerDefaultValue(propName, Long.toString(defaultValue));
    }

    public static void registerDefaultValue(String propName, double defaultValue) {
        Configuration.registerDefaultValue(propName, Double.toString(defaultValue));
    }

    public static void registerDefaultValue(String propName, boolean defaultValue) {
        Configuration.registerDefaultValue(propName, Boolean.toString(defaultValue));
    }

    public static boolean hasRegisteredDefaultValue(String propName) {
        return _registeredDefault.containsKey(propName);
    }

    public static String getRegisteredDefaultValue(String propName) {
        return _registeredDefault.get(propName);
    }

    public static String getUseDefaultValue(String propName, String value) {
        String regDefVal = Configuration.getRegisteredDefaultValue(propName);
        if (value != null && value.startsWith(USE_DEFAULT_PREFIX)) {
            if (regDefVal != null) {
                return regDefVal;
            }
            value = value.substring(USE_DEFAULT_PREFIX.length()).trim();
        }
        return value;
    }

    public String parseProperty(String propName, String val) {
        if (val == null) {
            return null;
        }
        Pattern compiledRegex = Pattern.compile("\\$\\{.*\\}");
        if (compiledRegex.matcher(val).find()) {
            val = StringUtil.envVariableSubstitution(val);
        }
        if (val.startsWith("prop:")) {
            val = this.getProperty(val.substring("prop:".length()));
        }
        if (val.startsWith(ENCRYPTED_PREFIX)) {
            String decryptedStr;
            val = val.substring(ENCRYPTED_PREFIX.length());
            Encrypter propEncrypter = new Encrypter(encrypterBaseKey + propName);
            val = decryptedStr = propEncrypter.decrypt(val);
        }
        if (val != null) {
            if (val.startsWith("oscmd:")) {
                val = this.osCmd(val.substring("oscmd:".length()), false);
            } else if (val.startsWith("oscmd-n:")) {
                val = this.osCmd(val.substring("oscmd-n:".length()), true);
            }
        }
        return val;
    }

    private String osCmd(String osCmdStr, boolean discardNewlines) {
        try {
            OSCommand osCmd = OSCommand.execute(osCmdStr);
            String retVal = osCmd.getOutput();
            if (discardNewlines) {
                retVal = retVal.replaceAll("\r", "");
                retVal = retVal.replaceAll("\n", "");
            }
            return retVal;
        }
        catch (IOException e) {
            _logger.error("Problems when executing the OS Command '" + osCmdStr + "'. Caught: " + e);
            return e.toString();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this._saveOnExit) {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void store(OutputStream outputstream, String s) throws IOException {
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(outputstream, "8859_1"));
        Configuration.writeln(bw, "#=======================================================");
        if (s != null) {
            Configuration.writeln(bw, "# " + s);
        }
        Configuration.writeln(bw, "# Last save time: " + new Date().toString());
        Configuration.writeln(bw, "#-------------------------------------------------------");
        Configuration.writeln(bw, "");
        String sectionStr = "";
        String sectionStrSave = "";
        bw.flush();
        boolean escUnicode = true;
        Configuration configuration = this;
        synchronized (configuration) {
            TreeMap<Object, Object> aSortedOne = new TreeMap<Object, Object>(this);
            for (String key : aSortedOne.keySet()) {
                String val = (String)this.get(key);
                int end = (key = Configuration.saveConvert(key, true, escUnicode)).indexOf(".");
                if (end < 0) {
                    end = key.length();
                }
                if (!(sectionStr = key.substring(0, end)).equals(sectionStrSave)) {
                    Configuration.writeln(bw, "");
                    sectionStrSave = sectionStr;
                }
                val = Configuration.saveConvert(val, false, escUnicode);
                bw.write(key + "=" + val);
                bw.newLine();
            }
        }
        bw.flush();
    }

    private static void writeln(BufferedWriter bufferedwriter, String s) throws IOException {
        bufferedwriter.write(s);
        bufferedwriter.newLine();
    }

    private static char toHex(int i) {
        return hexDigit[i & 0xF];
    }

    public static String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(Configuration.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(Configuration.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(Configuration.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(Configuration.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    public static void setSearchOrder(String ... searchOrder) {
        _searchOrder = searchOrder;
    }

    public static String[] getSearchOrder() {
        return Configuration.getSearchOrder(false);
    }

    public static String[] getSearchOrder(boolean showFilenames) {
        if (!showFilenames) {
            return _searchOrder;
        }
        String[] sa = new String[_searchOrder.length];
        for (int i = 0; i < _searchOrder.length; ++i) {
            String searchOrder = _searchOrder[i];
            Configuration conf = Configuration.getInstance(searchOrder);
            String filename = conf == null ? "--instance-not-found--" : conf.getFilename();
            sa[i] = searchOrder + "='" + filename + "'";
        }
        return sa;
    }

    public static Configuration getCombinedConfiguration() {
        return _combinedConfig;
    }

    public static Configuration parse(String parseStr) throws ParseException {
        return Configuration.parse(parseStr, ",");
    }

    public static Configuration parse(String parseStr, String delimiter) throws ParseException {
        Configuration conf = new Configuration();
        String[] strArr = parseStr.split(delimiter);
        for (int i = 0; i < strArr.length; ++i) {
            strArr[i] = strArr[i].trim();
            _logger.trace("parse() strArr[" + i + "]='" + strArr[i] + "'.");
            String[] strKeyVal = strArr[i].split("=");
            if (strKeyVal.length < 2) {
                throw new ParseException("Faulty key=value representation '" + strArr[i] + "' at position '" + i + "' in the string '" + strArr[i] + "'.", i);
            }
            String key = strKeyVal[0].trim();
            String val = strKeyVal[1].trim();
            conf.setProperty(key, val);
        }
        return conf;
    }

    public static void main(String[] args) {
        Configuration tConf = new Configuration();
        Configuration uConf = new Configuration();
        Configuration sConf = new Configuration();
        String tempDir = System.getProperty("java.io.tmpdir");
        tConf.setFilename(tempDir + "/test.tmpConfigFile.prop");
        uConf.setFilename(tempDir + "/test.userConfigFile.prop");
        sConf.setFilename(tempDir + "/test.systemConfigFile.prop");
        Configuration.setInstance(USER_TEMP, tConf);
        Configuration.setInstance(USER_CONF, uConf);
        Configuration.setInstance(SYSTEM_CONF, sConf);
        Configuration.setSearchOrder(USER_TEMP, USER_CONF, SYSTEM_CONF);
        tConf.setProperty("tmp1", "-tmp1-");
        uConf.setProperty("user1", "-user1-");
        sConf.setProperty("system1", "-system1-");
        tConf.setProperty("prop1", "-prop1-tmp-");
        uConf.setProperty("prop1", "-prop1-user-");
        sConf.setProperty("prop1", "-prop1-system-");
        tConf.setProperty("prop2.p1", "-tmp-prop2.p1-");
        tConf.setProperty("prop2.p2", "-tmp-prop2.p2-");
        tConf.setProperty("prop2.p3", "-tmp-prop2.p3-");
        uConf.setProperty("prop2.p2", "-user-prop2.p2-");
        uConf.setProperty("prop2.p3", "-user-prop2.p3-");
        uConf.setProperty("prop2.p4", "-user-prop2.p4-");
        sConf.setProperty("prop2.p1", "-system-prop2.p1-");
        sConf.setProperty("prop2.p3", "-system-prop2.p3-");
        sConf.setProperty("prop2.p5", "-system-prop2.p5-");
        tConf.setProperty("udc.prop2.p1", "-tmp-udc.prop2.p1-");
        tConf.setProperty("udc.prop2.p2", "-tmp-udc.prop2.p2-");
        tConf.setProperty("udc.prop2.p3", "-tmp-udc.prop2.p3-");
        uConf.setProperty("udc.prop2.p2", "-user-udc.prop2.p2-");
        uConf.setProperty("udc.prop2.p3", "-user-udc.prop2.p3-");
        uConf.setProperty("udc.prop2.p4", "-user-udc.prop2.p4-");
        sConf.setProperty("udc.prop2.p1", "-system-udc.prop2.p1-");
        sConf.setProperty("udc.prop2.p3", "-system-udc.prop2.p3-");
        sConf.setProperty("udc.prop2.p5", "-system-udc.prop2.p5-");
        Configuration cfg = Configuration.getCombinedConfiguration();
        System.out.println("tmp      FILENAME='" + tConf.getFilename() + "'.");
        System.out.println("user     FILENAME='" + uConf.getFilename() + "'.");
        System.out.println("system   FILENAME='" + sConf.getFilename() + "'.");
        System.out.println("Combined FILENAME='" + cfg.getFilename() + "'.");
        System.out.println();
        System.out.println("TMP:    tmp1    = '" + tConf.getProperty("tmp1") + "'.");
        System.out.println("USER:   user1   = '" + uConf.getProperty("user1") + "'.");
        System.out.println("SYSTEM: system1 = '" + sConf.getProperty("system1") + "'.");
        System.out.println();
        System.out.println("notFound= '" + cfg.getProperty("notFound") + "'.");
        System.out.println("tmp1    = '" + cfg.getProperty("tmp1") + "'.");
        System.out.println("user1   = '" + cfg.getProperty("user1") + "'.");
        System.out.println("system1 = '" + cfg.getProperty("system1") + "'.");
        System.out.println();
        System.out.println("prop1 = '" + cfg.getProperty("prop1") + "'.");
        System.out.println();
        System.out.println("prop2.p1 = '" + cfg.getProperty("prop2.p1") + "'.");
        System.out.println("prop2.p2 = '" + cfg.getProperty("prop2.p2") + "'.");
        System.out.println("prop2.p3 = '" + cfg.getProperty("prop2.p3") + "'.");
        System.out.println("prop2.p4 = '" + cfg.getProperty("prop2.p4") + "'.");
        System.out.println("prop2.p5 = '" + cfg.getProperty("prop2.p5") + "'.");
        System.out.println();
        System.out.println("getKeys('prop2.')     = '" + cfg.getKeys("prop2.") + "'.");
        System.out.println("getKeys('udc.prop2.') = '" + cfg.getKeys("udc.prop2.") + "'.");
        System.out.println();
        System.out.println("getUniqueSubKeys(TMP: 'udc.prop2.',true)  = '" + tConf.getUniqueSubKeys("udc.prop2.", true) + "'.");
        System.out.println("getUniqueSubKeys(TMP: 'udc.prop2.',false) = '" + tConf.getUniqueSubKeys("udc.prop2.", false) + "'.");
        System.out.println();
        System.out.println("getUniqueSubKeys('prop2.',true)  = '" + cfg.getUniqueSubKeys("prop2.", true) + "'.");
        System.out.println("getUniqueSubKeys('prop2.',false) = '" + cfg.getUniqueSubKeys("prop2.", false) + "'.");
        System.out.println();
        System.out.println("--- Registered Application Defaults --------");
        Configuration.registerDefaultValue("xxx.str", "str");
        Configuration.registerDefaultValue("xxx.int", Integer.MAX_VALUE);
        Configuration.registerDefaultValue("xxx.long", Long.MAX_VALUE);
        Configuration.registerDefaultValue("xxx.boolean.1", Boolean.TRUE);
        Configuration.registerDefaultValue("xxx.boolean.2", Boolean.TRUE);
        System.out.println("RegisteredDefaultValue: xxx.str       = '" + Configuration.getRegisteredDefaultValue("xxx.str") + "'.");
        System.out.println("RegisteredDefaultValue: xxx.int       = '" + Configuration.getRegisteredDefaultValue("xxx.int") + "'.");
        System.out.println("RegisteredDefaultValue: xxx.long      = '" + Configuration.getRegisteredDefaultValue("xxx.long") + "'.");
        System.out.println("RegisteredDefaultValue: xxx.boolean.1 = '" + Configuration.getRegisteredDefaultValue("xxx.boolean.1") + "'.");
        System.out.println("RegisteredDefaultValue: xxx.boolean.2 = '" + Configuration.getRegisteredDefaultValue("xxx.boolean.2") + "'.");
        System.out.println("RegisteredDefaultValue: xxx.boolean.3 = '" + Configuration.getRegisteredDefaultValue("xxx.boolean.3") + "'  ------- NOT REGISTERED -------");
        System.out.println("--- SOME DEFAULT VALUES --------");
        tConf.setProperty("xxx.password", "someSecretPassword", true);
        tConf.setProperty("xxx.str", "str");
        tConf.setProperty("xxx.int", Integer.MAX_VALUE);
        tConf.setProperty("xxx.long", Long.MAX_VALUE);
        tConf.setProperty("xxx.boolean.1", Boolean.TRUE);
        System.out.println("xxx.password  = '" + tConf.getProperty("xxx.password") + "'.");
        System.out.println("xxx.str       = '" + tConf.getProperty("xxx.str") + "'.");
        System.out.println("xxx.int       = '" + tConf.getIntProperty("xxx.int") + "'.");
        System.out.println("xxx.long      = '" + tConf.getLongProperty("xxx.long") + "'.");
        System.out.println("xxx.boolean.1 = '" + tConf.getBooleanProperty("xxx.boolean.1", true) + "'.");
        System.out.println("xxx.boolean.2 = '" + tConf.getBooleanProperty("xxx.boolean.2", false) + "'.");
        System.out.println("xxx.boolean.3 = '" + tConf.getBooleanProperty("xxx.boolean.3", false) + "'.");
        System.out.println("RAW: xxx.password  = '" + tConf.getPropertyRaw_test("xxx.password") + "'.");
        System.out.println("RAW: xxx.str       = '" + tConf.getPropertyRaw_test("xxx.str") + "'.");
        System.out.println("RAW: xxx.int       = '" + tConf.getPropertyRaw_test("xxx.int") + "'.");
        System.out.println("RAW: xxx.long      = '" + tConf.getPropertyRaw_test("xxx.long") + "'.");
        System.out.println("RAW: xxx.boolean.1 = '" + tConf.getPropertyRaw_test("xxx.boolean.1") + "'.");
        System.out.println("RAW: xxx.boolean.2 = '" + tConf.getPropertyRaw_test("xxx.boolean.2") + "'.");
        System.out.println("RAW: xxx.boolean.3 = '" + tConf.getPropertyRaw_test("xxx.boolean.3") + "'.");
        Configuration.testShouldHaveValue(tConf.getProperty("xxx.password"));
        Configuration.testShouldHaveValue(tConf.getProperty("xxx.str"));
        Configuration.testShouldHaveValue(tConf.getProperty("xxx.int"));
        Configuration.testShouldHaveValue(tConf.getProperty("xxx.long"));
        Configuration.testShouldHaveValue(tConf.getProperty("xxx.boolean.1"));
        Configuration.testShouldHaveValue(tConf.getProperty("xxx.boolean.2"));
        Configuration.testShouldBeNull(tConf.getProperty("xxx.boolean.3"));
        Configuration.testShouldBeEqual("someSecretPassword", tConf.getProperty("xxx.password"));
        Configuration.testShouldBeEqual("str", tConf.getProperty("xxx.str"));
        Configuration.testShouldBeEqual(Integer.MAX_VALUE, tConf.getIntProperty("xxx.int"));
        Configuration.testShouldBeEqual(Long.MAX_VALUE, tConf.getLongProperty("xxx.long"));
        Configuration.testShouldBeEqual(Boolean.TRUE, tConf.getBooleanProperty("xxx.boolean.1", true));
        Configuration.testShouldBeEqual(Boolean.TRUE, tConf.getBooleanProperty("xxx.boolean.2", false));
        Configuration.testShouldBeEqual(Boolean.FALSE, tConf.getBooleanProperty("xxx.boolean.3", false));
        Configuration.testShouldNotBeEqual("someSecretPassword", tConf.getPropertyRaw_test("xxx.password"));
        Configuration.testShouldBeEqual("USE_DEFAULT:str", tConf.getPropertyRaw_test("xxx.str"));
        Configuration.testShouldBeEqual("USE_DEFAULT:2147483647", tConf.getPropertyRaw_test("xxx.int"));
        Configuration.testShouldBeEqual("USE_DEFAULT:9223372036854775807", tConf.getPropertyRaw_test("xxx.long"));
        Configuration.testShouldBeEqual(USE_DEFAULT_PREFIX + Boolean.TRUE, tConf.getPropertyRaw_test("xxx.boolean.1"));
        Configuration.testShouldBeNull(tConf.getPropertyRaw_test("xxx.boolean.2"));
        Configuration.testShouldBeNull(tConf.getPropertyRaw_test("xxx.boolean.3"));
        System.out.println("--- SOME NON DEFAULT VALUES --------");
        tConf.setProperty("xxx.password", "testPasswd", true);
        tConf.setProperty("xxx.str", "another str");
        tConf.setProperty("xxx.int", 1);
        tConf.setProperty("xxx.long", 1L);
        tConf.setProperty("xxx.boolean.1", Boolean.FALSE);
        System.out.println("xxx.password  = '" + tConf.getProperty("xxx.password") + "'.");
        System.out.println("xxx.str       = '" + tConf.getProperty("xxx.str") + "'.");
        System.out.println("xxx.int       = '" + tConf.getIntProperty("xxx.int") + "'.");
        System.out.println("xxx.long      = '" + tConf.getLongProperty("xxx.long") + "'.");
        System.out.println("xxx.boolean.1 = '" + tConf.getBooleanProperty("xxx.boolean.1", true) + "'.");
        System.out.println("xxx.boolean.2 = '" + tConf.getBooleanProperty("xxx.boolean.2", false) + "'.");
        System.out.println("xxx.boolean.3 = '" + tConf.getBooleanProperty("xxx.boolean.3", false) + "'.");
        System.out.println("RAW: xxx.password  = '" + tConf.getPropertyRaw_test("xxx.password") + "'.");
        System.out.println("RAW: xxx.str       = '" + tConf.getPropertyRaw_test("xxx.str") + "'.");
        System.out.println("RAW: xxx.int       = '" + tConf.getPropertyRaw_test("xxx.int") + "'.");
        System.out.println("RAW: xxx.long      = '" + tConf.getPropertyRaw_test("xxx.long") + "'.");
        System.out.println("RAW: xxx.boolean.1 = '" + tConf.getPropertyRaw_test("xxx.boolean.1") + "'.");
        System.out.println("RAW: xxx.boolean.2 = '" + tConf.getPropertyRaw_test("xxx.boolean.2") + "'.");
        System.out.println("RAW: xxx.boolean.3 = '" + tConf.getPropertyRaw_test("xxx.boolean.3") + "'.");
        Configuration.testShouldHaveValue(tConf.getProperty("xxx.password"));
        Configuration.testShouldHaveValue(tConf.getProperty("xxx.str"));
        Configuration.testShouldHaveValue(tConf.getProperty("xxx.int"));
        Configuration.testShouldHaveValue(tConf.getProperty("xxx.long"));
        Configuration.testShouldHaveValue(tConf.getProperty("xxx.boolean.1"));
        Configuration.testShouldHaveValue(tConf.getProperty("xxx.boolean.2"));
        Configuration.testShouldBeNull(tConf.getProperty("xxx.boolean.3"));
        Configuration.testShouldBeEqual("testPasswd", tConf.getProperty("xxx.password"));
        Configuration.testShouldBeEqual("another str", tConf.getProperty("xxx.str"));
        Configuration.testShouldBeEqual(1, tConf.getIntProperty("xxx.int"));
        Configuration.testShouldBeEqual(1L, tConf.getLongProperty("xxx.long"));
        Configuration.testShouldBeEqual(Boolean.FALSE, tConf.getBooleanProperty("xxx.boolean.1", true));
        Configuration.testShouldBeEqual(Boolean.TRUE, tConf.getBooleanProperty("xxx.boolean.2", false));
        Configuration.testShouldBeEqual(Boolean.FALSE, tConf.getBooleanProperty("xxx.boolean.3", false));
        Configuration.testShouldNotBeEqual("testPasswd", tConf.getPropertyRaw_test("xxx.password"));
        Configuration.testShouldBeEqual("another str", tConf.getPropertyRaw_test("xxx.str"));
        Configuration.testShouldBeEqual(1, Integer.parseInt(tConf.getPropertyRaw_test("xxx.int")));
        Configuration.testShouldBeEqual(1L, Long.parseLong(tConf.getPropertyRaw_test("xxx.long")));
        Configuration.testShouldBeEqual(Boolean.FALSE, Boolean.parseBoolean(tConf.getPropertyRaw_test("xxx.boolean.1")));
        Configuration.testShouldBeNull(tConf.getPropertyRaw_test("xxx.boolean.2"));
        Configuration.testShouldBeNull(tConf.getPropertyRaw_test("xxx.boolean.3"));
    }

    private static void testShouldBeNull(Object v1) {
        if (v1 != null) {
            throw new RuntimeException("testShouldBeNull: Object SHOULD be NULL, it has value='" + v1 + "'.");
        }
    }

    private static void testShouldHaveValue(Object v1) {
        if (v1 == null) {
            throw new RuntimeException("testShouldHaveValue: Object should HAVE value, it's null");
        }
    }

    private static void testShouldBeEqual(Object v1, Object v2) {
        if (v1 == null && v2 == null) {
            return;
        }
        if (v1 == null && v2 != null) {
            throw new RuntimeException("testEqual: Values are NOT equal. v1='" + v1 + "', v2='" + v2 + "'");
        }
        if (v2 == null && v1 != null) {
            throw new RuntimeException("testEqual: Values are NOT equal. v1='" + v1 + "', v2='" + v2 + "'");
        }
        if (!v1.equals(v2)) {
            throw new RuntimeException("testEqual: Values are NOT equal. v1='" + v1 + "', v2='" + v2 + "', v1='" + v1.getClass().getName() + "', v2='" + v2.getClass().getName() + "'.");
        }
    }

    private static void testShouldNotBeEqual(Object v1, Object v2) {
        if (v1 == v2) {
            return;
        }
        if (v1 == null && v2 != null) {
            return;
        }
        if (v2 == null && v1 != null) {
            return;
        }
        if (v1.equals(v2)) {
            throw new RuntimeException("testNotEqual: Values ARE equal. v1='" + v1 + "', v2='" + v2 + "', v1='" + v1.getClass().getName() + "', v2='" + v2.getClass().getName() + "'.");
        }
    }

    static {
        _registeredDefault = new HashMap();
        hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        _searchOrder = new String[]{USER_TEMP, USER_CONF, SYSTEM_CONF};
        _combinedConfig = new CombinedConfiguration();
    }

    private static class CombinedConfiguration
    extends Configuration {
        private static final long serialVersionUID = 1L;
        private boolean _fallbackOnSystemProperties = true;

        private CombinedConfiguration() {
        }

        @Override
        public Enumeration<?> propertyNames() {
            throw new RuntimeException("propertyNames() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public synchronized boolean isEmpty() {
            throw new RuntimeException("isEmpty() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public synchronized Enumeration<Object> keys() {
            throw new RuntimeException("keys() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public synchronized Enumeration<Object> elements() {
            throw new RuntimeException("elements() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public synchronized boolean contains(Object value) {
            throw new RuntimeException("contains() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public boolean containsValue(Object value) {
            throw new RuntimeException("containsValue() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public synchronized boolean containsKey(Object key) {
            throw new RuntimeException("containsKey() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public Set<Object> keySet() {
            throw new RuntimeException("keySet() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            throw new RuntimeException("entrySet() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public Collection<Object> values() {
            throw new RuntimeException("values() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public synchronized int size() {
            throw new RuntimeException("size() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public void save() {
            throw new RuntimeException("save() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public Object setProperty(String propName, String str) {
            throw new RuntimeException("setProperty() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public int setProperty(String propName, int t) {
            throw new RuntimeException("setProperty() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public long setProperty(String propName, long l) {
            throw new RuntimeException("setProperty() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public boolean setProperty(String propName, boolean b) {
            throw new RuntimeException("setProperty() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public void setFilename(String filename) {
            throw new RuntimeException("setFilename() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public String getEmbeddedMessage() {
            throw new RuntimeException("getEmbeddedMessage() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public void setEmbeddedMessage(String embeddedMessage) {
            throw new RuntimeException("setEmbeddedMessage() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public void setSaveOnExit(boolean b) {
            throw new RuntimeException("setSaveOnExit() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public void append(String str, String responsible) throws IOException {
            throw new RuntimeException("append() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        @Override
        public void removeAll(String prefix) {
            throw new RuntimeException("removeAll() operation is not supported on the Combined Configuration, this has to be done on the individual Configurations.");
        }

        public List<String> getFilenames() {
            ArrayList<String> list = new ArrayList<String>();
            for (String instName : _searchOrder) {
                Configuration conf = Configuration.getInstance(instName);
                if (!conf.hasFileAndExists()) continue;
                list.add(conf.getFilename());
            }
            return list;
        }

        public Configuration getInstanceForFilename(String filename) {
            for (String instName : _searchOrder) {
                Configuration conf = Configuration.getInstance(instName);
                if (!filename.equals(conf.getFilename())) continue;
                return conf;
            }
            return null;
        }

        @Override
        public String getFilename() {
            String filenames = "";
            for (String instName : _searchOrder) {
                Configuration conf = Configuration.getInstance(instName);
                if (conf == null) continue;
                filenames = filenames + conf.getFilename() + ", ";
            }
            if (filenames.endsWith(", ")) {
                filenames = filenames.substring(0, filenames.length() - 2);
            }
            return "Combined Configuration of files: " + filenames;
        }

        @Override
        public boolean hasProperty(String propName) {
            for (String instName : _searchOrder) {
                Configuration conf = Configuration.getInstance(instName);
                if (conf == null || !conf.hasProperty(propName)) continue;
                return true;
            }
            return this._fallbackOnSystemProperties && System.getProperty(propName) != null;
        }

        @Override
        public List<String> getKeys(String prefix) {
            ArrayList<String> matchingKeys = new ArrayList<String>();
            for (String instName : _searchOrder) {
                Configuration conf = Configuration.getInstance(instName);
                if (conf == null) continue;
                for (String string : conf.keySet()) {
                    if (prefix != null && !string.startsWith(prefix) || matchingKeys.contains(string)) continue;
                    matchingKeys.add(string);
                }
            }
            if (this._fallbackOnSystemProperties) {
                for (String string : System.getProperties().keySet()) {
                    if (prefix != null && !string.startsWith(prefix) || matchingKeys.contains(string)) continue;
                    matchingKeys.add(string);
                }
            }
            Collections.sort(matchingKeys);
            return matchingKeys;
        }

        @Override
        public List<String> getKeys() {
            return this.getKeys(null);
        }

        @Override
        public List<String> getUniqueSubKeys(String prefix, boolean keepPrefix) {
            ArrayList<String> uniqueNames = new ArrayList<String>();
            for (String instName : _searchOrder) {
                Configuration conf = Configuration.getInstance(instName);
                if (conf == null) continue;
                for (String key : conf.getKeys(prefix)) {
                    String name;
                    int start = keepPrefix ? 0 : prefix.length();
                    int end = key.indexOf(".", prefix.length());
                    if (end < 0) {
                        end = key.length();
                    }
                    if (uniqueNames.contains(name = key.substring(start, end))) continue;
                    uniqueNames.add(name);
                }
            }
            if (this._fallbackOnSystemProperties) {
                // empty if block
            }
            Collections.sort(uniqueNames);
            return uniqueNames;
        }

        @Override
        public String getMandatoryProperty(String propName) throws MandatoryPropertyException {
            String val = this.getProperty(propName);
            if (val == null) {
                throw new MandatoryPropertyException("The property '" + propName + "' is mandatory.");
            }
            return val;
        }

        @Override
        public String getProperty(String propName) {
            return this.private_getProperty(propName, false, null);
        }

        @Override
        protected String private_getProperty(String propName, boolean hasPassedDefaultValue, String defaultValue) {
            String val;
            for (String instName : _searchOrder) {
                String val2;
                Configuration conf = Configuration.getInstance(instName);
                if (conf == null || !conf.containsKey(propName) || (val2 = conf.private_getProperty(propName, hasPassedDefaultValue, defaultValue)) == null) continue;
                return val2;
            }
            if (this._fallbackOnSystemProperties && (val = System.getProperty(propName)) != null) {
                return val;
            }
            return CombinedConfiguration.getRegisteredDefaultValue(propName);
        }

        @Override
        public String getProperty(String propName, String defaultValue) {
            String val = this.private_getProperty(propName, true, defaultValue);
            return val != null ? val : defaultValue;
        }

        @Override
        public String getMandatoryPropertyRaw(String propName) throws MandatoryPropertyException {
            String val = this.getPropertyRaw(propName);
            if (val == null) {
                throw new MandatoryPropertyException("The property '" + propName + "' is mandatory.");
            }
            return val;
        }

        @Override
        public String getPropertyRaw(String propName) {
            return this.private_getPropertyRaw(propName, false, null, true);
        }

        @Override
        protected String private_getPropertyRaw(String propName, boolean hasPassedDefaultValue, String defaultValue, boolean doTrim) {
            String val;
            for (String instName : _searchOrder) {
                String val2;
                Configuration conf = Configuration.getInstance(instName);
                if (conf == null || !conf.containsKey(propName) || (val2 = conf.private_getPropertyRaw(propName, hasPassedDefaultValue, defaultValue, doTrim)) == null) continue;
                return val2;
            }
            if (this._fallbackOnSystemProperties && (val = System.getProperty(propName)) != null) {
                return val;
            }
            return CombinedConfiguration.getRegisteredDefaultValue(propName);
        }

        @Override
        public String getPropertyRaw(String propName, String defaultValue) {
            String val = this.private_getPropertyRaw(propName, true, defaultValue, true);
            return val != null ? val : defaultValue;
        }

        @Override
        public String getMandatoryPropertyRawVal(String propName) throws MandatoryPropertyException {
            String val = this.getPropertyRawVal(propName);
            if (val == null) {
                throw new MandatoryPropertyException("The property '" + propName + "' is mandatory.");
            }
            return val;
        }

        @Override
        public String getPropertyRawVal(String propName) {
            return this.private_getPropertyRaw(propName, false, null, false);
        }

        @Override
        public String getPropertyRawVal(String propName, String defaultValue) {
            String val = this.private_getPropertyRaw(propName, true, defaultValue, false);
            return val != null ? val : defaultValue;
        }
    }

    public static class FileWatcher
    extends Thread {
        private AtomicBoolean _running = new AtomicBoolean(true);
        private static List<String> _onChange_SkipKeyPrefix;

        public void setSkipKeyPrefix(List<String> list) {
            _onChange_SkipKeyPrefix = list;
        }

        public void addSkipKeyPrefix(String skipKeyPrefix) {
            if (_onChange_SkipKeyPrefix == null) {
                _onChange_SkipKeyPrefix = new ArrayList<String>();
            }
            if (!_onChange_SkipKeyPrefix.contains(skipKeyPrefix)) {
                _onChange_SkipKeyPrefix.add(skipKeyPrefix);
            }
        }

        public boolean keepFilter(Configuration conf, int type, String key, String oldVal, String newVal) {
            if (StringUtil.isNullOrBlank(key)) {
                return false;
            }
            if (_onChange_SkipKeyPrefix == null) {
                return true;
            }
            for (String skipKeyPrefix : _onChange_SkipKeyPrefix) {
                if (!key.startsWith(skipKeyPrefix)) continue;
                _logger.info("Skipping changes COMBINED CONFIG[" + conf.getConfName() + "], due to keepFilter='" + skipKeyPrefix + "' for: propName='" + key + "', type=" + Configuration.changeTypeToStr(type) + ", newValue='" + newVal + "', oldValue='" + oldVal + "'.");
                return false;
            }
            return true;
        }

        public boolean isRunning() {
            return this._running.get();
        }

        public void setRunning(boolean to) {
            this._running.set(to);
        }

        @Override
        public void run() {
            List<String> fileNames = _combinedConfig.getFilenames();
            _logger.info("Starting to listen for changes in Combined Config files: " + fileNames);
            try (WatchService watchService = FileSystems.getDefault().newWatchService();){
                HashSet<Path> dirs = new HashSet<Path>();
                for (String name : fileNames) {
                    File f = new File(name);
                    Path path = f.toPath().getParent();
                    dirs.add(path);
                }
                if (dirs.isEmpty()) {
                    _logger.info("No Configuration files to listen for, filenames='" + fileNames + "'.");
                    return;
                }
                for (Path path : dirs) {
                    _logger.info("Starts to listen for Configuration file modifications in directory '" + path + "'. All Filenames: " + fileNames);
                    path.register(watchService, StandardWatchEventKinds.ENTRY_MODIFY);
                }
                block18: while (this.isRunning()) {
                    WatchKey watchKey = null;
                    try {
                        watchKey = watchService.poll(10L, TimeUnit.SECONDS);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (watchKey == null) continue;
                    Thread.sleep(100L);
                    for (WatchEvent<?> event : watchKey.pollEvents()) {
                        boolean valid;
                        String longFilename;
                        WatchEvent.Kind<?> kind = event.kind();
                        WatchEvent<?> ev = event;
                        Path dir = (Path)watchKey.watchable();
                        Path filename = (Path)ev.context();
                        Path fullPath = dir.resolve(filename);
                        if (kind == StandardWatchEventKinds.OVERFLOW) {
                            Thread.yield();
                            continue;
                        }
                        if (kind == StandardWatchEventKinds.ENTRY_MODIFY && fileNames.contains(longFilename = fullPath.toString())) {
                            this.onChange(fullPath);
                        }
                        if (valid = watchKey.reset()) continue;
                        continue block18;
                    }
                }
            }
            catch (Throwable ex) {
                _logger.error("Thread Combined Config files listener has problems. Caught: " + ex, ex);
            }
            _logger.info("Thread Combined Config files listener was stopped.");
        }

        public void onChange(Path filename) {
            Configuration curConfig = _combinedConfig.getInstanceForFilename(filename.toString());
            if (curConfig != null) {
                String curConfInstanceName = curConfig.getConfName();
                if (StringUtil.hasValue(curConfInstanceName) && curConfInstanceName.equals(Configuration.USER_TEMP)) {
                    return;
                }
                if (!filename.toFile().exists()) {
                    _logger.warn("Configuration file '" + filename + "' do not exists... will not continue checking for changes.");
                    return;
                }
                Configuration newConfig = new Configuration(filename.toString());
                if (curConfig.equals(newConfig)) {
                    return;
                }
                _logger.info("Found Configuration changes in file '" + filename + "'.");
                for (Object keyObj : newConfig.keySet()) {
                    String string = keyObj.toString();
                    String newVal = newConfig.getProperty(string);
                    if (curConfig.hasProperty(string)) {
                        String oldVal = curConfig.getProperty(string);
                        if (newVal.equals(oldVal) || !this.keepFilter(curConfig, 2, string, oldVal, newVal)) continue;
                        curConfig.setProperty(string, newVal);
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Combened Config, CHANGED-VALUE. name='" + curConfInstanceName + "', file='" + filename + "', key='" + string + "', oldVal='" + oldVal + "', newVal='" + newVal + "'.");
                        }
                        Configuration.fireCombinedConfigPropertyChangeListener(curConfig, 2, string, oldVal, newVal);
                        continue;
                    }
                    if (!this.keepFilter(curConfig, 1, string, null, newVal)) continue;
                    curConfig.setProperty(string, newVal);
                    if (_logger.isDebugEnabled()) {
                        _logger.debug("Combened Config,     NEW-VALUE. name='" + curConfInstanceName + "', file='" + filename + "', key='" + string + "', newVal='" + newVal + "'.");
                    }
                    Configuration.fireCombinedConfigPropertyChangeListener(curConfig, 1, string, null, newVal);
                }
                HashSet<Object> removedKeySet = new HashSet<Object>(curConfig.keySet());
                removedKeySet.removeAll(newConfig.keySet());
                if (!removedKeySet.isEmpty()) {
                    for (Object e : removedKeySet) {
                        String delVal;
                        String delKey = (String)e;
                        if (!this.keepFilter(curConfig, 3, delKey, delVal = curConfig.getProperty(delKey), null)) continue;
                        curConfig.remove(delKey);
                        if (_logger.isDebugEnabled()) {
                            _logger.debug("Combened Config, REMOVED-VALUE. name='" + curConfInstanceName + "', file='" + filename + "', key='" + delKey + "', oldVal='" + delVal + "'.");
                        }
                        Configuration.fireCombinedConfigPropertyChangeListener(curConfig, 3, delKey, delVal, null);
                    }
                }
            }
        }
    }
}

