/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.utils;

import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MonitorInfo;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import sek.ase.auditor.utils.Memory;

public class JavaUtils {
    public static String getProcessId(String fallback) {
        String jvmName = ManagementFactory.getRuntimeMXBean().getName();
        int index = jvmName.indexOf(64);
        if (index < 1) {
            return fallback;
        }
        try {
            return Long.toString(Long.parseLong(jvmName.substring(0, index)));
        }
        catch (NumberFormatException numberFormatException) {
            return fallback;
        }
    }

    public static String getStackDump(boolean extraFields) {
        ThreadInfo[] infos;
        StringBuilder out = new StringBuilder();
        OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
        ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
        MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
        if (extraFields) {
            out.append("Dump of " + threadBean.getThreadCount() + " threads at " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(System.currentTimeMillis()))).append("\n");
            out.append("thread.findDeadlockedThreads:             " + Arrays.toString(threadBean.findDeadlockedThreads())).append("\n");
            out.append("thread.getThreadCount:                    " + threadBean.getThreadCount()).append("\n");
            out.append("thread.getTotalStartedThreadCount:        " + threadBean.getTotalStartedThreadCount()).append("\n");
            out.append("memory.getObjectPendingFinalizationCount: " + memoryBean.getObjectPendingFinalizationCount()).append("\n");
            out.append("memory.getHeapMemoryUsage:                " + memoryBean.getHeapMemoryUsage()).append("\n");
            out.append("memory.getNonHeapMemoryUsage:             " + memoryBean.getNonHeapMemoryUsage()).append("\n");
            out.append("memory.asetune.util.getMemoryInfoMB:      " + Memory.getMemoryInfoMB()).append("\n");
            out.append("    os.getAvailableProcessors:            " + osBean.getAvailableProcessors()).append("\n");
            out.append("    os.getSystemLoadAverage:              " + osBean.getSystemLoadAverage()).append("\n");
            out.append("\n");
        }
        for (ThreadInfo ti : infos = threadBean.dumpAllThreads(true, true)) {
            if (extraFields) {
                long totalCpuTime = threadBean.getThreadCpuTime(ti.getThreadId()) / 1000000L;
                long userCpuTime = threadBean.getThreadUserTime(ti.getThreadId()) / 1000000L;
                long systemCpuTime = totalCpuTime - userCpuTime;
                BigDecimal userCpuPct = totalCpuTime <= 0L ? new BigDecimal(0) : new BigDecimal(1.0 * (double)userCpuTime / (double)totalCpuTime * 100.0).setScale(1, 6);
                BigDecimal systemCpuPct = totalCpuTime <= 0L ? new BigDecimal(0) : new BigDecimal(1.0 * (double)systemCpuTime / (double)totalCpuTime * 100.0).setScale(1, 6);
                String extraInfo = "\t   + isInNative=" + ti.isInNative() + ", isSuspended=" + ti.isSuspended() + ", blockCnt=" + ti.getBlockedCount() + ", waitCnt=" + ti.getWaitedCount() + ", blockTime=" + ti.getBlockedTime() + ", waitTime=" + ti.getWaitedTime() + "\n\t   + lockName='" + ti.getLockName() + "', ownedBy='" + ti.getLockOwnerName() + "', LockOwnerId=" + ti.getLockOwnerId() + "\n\t   + thread Cpu Time Ms: Total=" + totalCpuTime + ", User=" + userCpuTime + " (" + userCpuPct + "%), System=" + systemCpuTime + "(" + systemCpuPct + "%)\n";
                StringBuilder sb = new StringBuilder(JavaUtils.threadInfoToString(ti, -1));
                int firstTab = sb.indexOf("\t");
                if (firstTab != -1) {
                    sb.insert(firstTab, extraInfo);
                }
                out.append(sb.toString());
                continue;
            }
            out.append(JavaUtils.threadInfoToString(ti, -1));
        }
        return out.toString();
    }

    public static String threadInfoToString(ThreadInfo ti, int maxFrames) {
        LockInfo[] locks;
        int i;
        if (maxFrames < 0) {
            maxFrames = 512;
        }
        StringBuilder sb = new StringBuilder("\"" + ti.getThreadName() + "\" Id=" + ti.getThreadId() + " " + (Object)((Object)ti.getThreadState()));
        if (ti.getLockName() != null) {
            sb.append(" on " + ti.getLockName());
        }
        if (ti.getLockOwnerName() != null) {
            sb.append(" owned by \"" + ti.getLockOwnerName() + "\" Id=" + ti.getLockOwnerId());
        }
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append('\n');
        StackTraceElement[] stackTrace = ti.getStackTrace();
        for (i = 0; i < stackTrace.length && i < maxFrames; ++i) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat " + ste.toString());
            sb.append('\n');
            if (i == 0 && ti.getLockInfo() != null) {
                Thread.State ts = ti.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on " + ti.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on " + ti.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on " + ti.getLockInfo());
                        sb.append('\n');
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : ti.getLockedMonitors()) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked " + lockInfo);
                sb.append('\n');
            }
        }
        if (i < stackTrace.length) {
            sb.append("\t...");
            sb.append('\n');
        }
        if ((locks = ti.getLockedSynchronizers()).length > 0) {
            sb.append("\n\tNumber of locked synchronizers = " + locks.length);
            sb.append('\n');
            for (LockInfo lockInfo : locks) {
                sb.append("\t- " + lockInfo);
                sb.append('\n');
            }
        }
        sb.append('\n');
        return sb.toString();
    }
}

