/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.utils;

import com.sun.management.OperatingSystemMXBean;
import java.lang.invoke.MethodHandles;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sek.ase.auditor.utils.TimeUtils;

public class Memory {
    private static Logger _logger = LogManager.getLogger(MethodHandles.lookup().lookupClass());
    private static Thread _checkThread = null;
    private static boolean _running = false;
    private static int _memLimitInMb = 20;
    private static int _sleepTimeInSec = 3;
    private static ArrayList<MemoryListener> _memListeners = new ArrayList();
    private static Object _evaluateAndWaitSemaphore = new Object();
    private static OperatingSystemMXBean _osMbean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();

    public void setMemoryLimit(int memoryLeftInMB) {
        _memLimitInMb = memoryLeftInMB;
    }

    public int getMemoryLimit() {
        return _memLimitInMb;
    }

    public void setSleepTime(int seconds) {
        _sleepTimeInSec = seconds;
    }

    public int getSleepTime() {
        return _sleepTimeInSec;
    }

    public static void addMemoryListener(MemoryListener l) {
        if (!_memListeners.contains(l)) {
            _memListeners.add(l);
        }
    }

    public static void removeMemoryListener(MemoryListener l) {
        _memListeners.remove(l);
    }

    public static List<MemoryListener> getMemoryListener() {
        return _memListeners;
    }

    public static void fireOutOfMemory() {
        for (MemoryListener ml : Memory.getMemoryListener()) {
            _logger.info("Memory.fireOutOfMemory(): calling outOfMemoryHandler() on listener: " + ml);
            ml.outOfMemoryHandler();
        }
    }

    public static void fireMemoryConsumption(int memoryLeftInMB) {
        for (MemoryListener ml : Memory.getMemoryListener()) {
            ml.memoryConsumption(memoryLeftInMB);
        }
    }

    public static void evaluate() {
        if (_checkThread != null) {
            _logger.info("Received 'evaluate' notification from thread '" + Thread.currentThread().getName() + "', the memory monitor thread will 'now' evaluate the memory usage.");
            _checkThread.interrupt();
        } else {
            _logger.warn("Memory monitor thread, has not been started.");
        }
    }

    public static void evaluateAndWait() {
        Memory.evaluateAndWait(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void evaluateAndWait(int maxWaitTime) {
        Object object = _evaluateAndWaitSemaphore;
        synchronized (object) {
            try {
                _logger.info("Waiting for memory evaluater to complete.");
                long startTime = System.currentTimeMillis();
                if (maxWaitTime < 0) {
                    _evaluateAndWaitSemaphore.wait();
                } else {
                    _evaluateAndWaitSemaphore.wait(maxWaitTime);
                }
                _logger.info("AFTER-Waiting for memory evaluater to complete. Wait time was: " + TimeUtils.msDiffNowToTimeStr(startTime));
            }
            catch (InterruptedException ex) {
                _logger.info("Memory.evaluateAndWait(maxWaitTime=" + maxWaitTime + "): was interupted. ex=" + ex);
            }
        }
    }

    public static boolean isRunning() {
        return _checkThread != null && _running;
    }

    public static void stop() {
        _running = false;
        if (_checkThread != null) {
            _checkThread.interrupt();
        }
    }

    public static void start() {
        if (_checkThread != null) {
            _logger.info("There is already a memory check thread running, I will NOT start another one.");
            return;
        }
        _checkThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                _logger.info("Starting memory checker thread.");
                int exceptionCount = 0;
                int exceptionCountExitThreshold = 25;
                long lastExceptionTime = 0L;
                long lastExceptionTimeThreshold = 10000L;
                while (_running) {
                    try {
                        int mbLeftAtStart = Memory.getMemoryLeftInMB();
                        Memory.fireMemoryConsumption(mbLeftAtStart);
                        if (mbLeftAtStart <= _memLimitInMb) {
                            System.gc();
                            int mbLeftAfterGc = Memory.getMemoryLeftInMB();
                            _logger.info("Free memory seems to be less that " + mbLeftAtStart + " MB. After Garbage Collection we got " + mbLeftAfterGc + " MB." + Memory.getMemoryInfoMB());
                            if (mbLeftAfterGc <= _memLimitInMb) {
                                Memory.fireOutOfMemory();
                            }
                        }
                        Object object = _evaluateAndWaitSemaphore;
                        synchronized (object) {
                            _evaluateAndWaitSemaphore.notifyAll();
                        }
                        Thread.sleep(_sleepTimeInSec * 1000);
                    }
                    catch (InterruptedException ignore) {
                        _logger.debug("Received 'interrupted', checking if we should continue to run.");
                    }
                    catch (Throwable t) {
                        if (++exceptionCount > exceptionCountExitThreshold) {
                            _logger.info("Caught '" + t + "', so I will stop the memory checker thread. exceptionCount=" + exceptionCount + ", exceptionCountExitThreshold=" + exceptionCountExitThreshold, t);
                            _running = false;
                        } else {
                            _logger.warn("Memory checker, Caught '" + t + "', skipping this and continuing... exceptionCount=" + exceptionCount + ", exceptionCountExitThreshold=" + exceptionCountExitThreshold, t);
                        }
                        if (System.currentTimeMillis() - lastExceptionTime > lastExceptionTimeThreshold) {
                            exceptionCount = 0;
                        }
                        lastExceptionTime = System.currentTimeMillis();
                    }
                }
                _logger.info("Ending memory checker thread.");
                _checkThread = null;
            }
        };
        _running = true;
        _checkThread.setName("MemoryCheckThread");
        _checkThread.setDaemon(true);
        _checkThread.start();
    }

    public static void shutdown() {
        if (_checkThread == null) {
            _logger.info("The memory check thread isn't running, so no need to shut it down.");
            return;
        }
        _logger.info("Sending an 'interrupt' to the memory check thread.");
        _checkThread.interrupt();
    }

    public static boolean checkMemoryUsage(int thresholdMbLeft) {
        int mbLeftAtStart = Memory.getMemoryLeftInMB();
        _logger.debug(Memory.getMemoryInfoMB());
        if (mbLeftAtStart <= thresholdMbLeft) {
            System.gc();
            int mbLeftAfterGc = Memory.getMemoryLeftInMB();
            _logger.info("Free memory seems to be less that " + mbLeftAtStart + " MB. After Garbage Collection we got " + mbLeftAfterGc + " MB." + Memory.getMemoryInfoMB());
            if (mbLeftAfterGc <= thresholdMbLeft) {
                Memory.fireOutOfMemory();
                return true;
            }
        }
        return false;
    }

    public static long getMemoryLeftInKB() {
        return Memory.getMaxMemoryInKB() - Memory.getAllocatedMemoryInKB() + Memory.getFreeMemoryInKB();
    }

    public static long getUsedMemoryInKB() {
        return (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
    }

    public static long getFreeMemoryInKB() {
        return Runtime.getRuntime().freeMemory() / 1024L;
    }

    public static long getAllocatedMemoryInKB() {
        return Runtime.getRuntime().totalMemory() / 1024L;
    }

    public static long getMaxMemoryInKB() {
        return Runtime.getRuntime().maxMemory() / 1024L;
    }

    public static String getMemoryInfoKB() {
        return "Memory usage: TotalFreeMemory=" + Memory.getMemoryLeftInKB() + " KB, UsedMemory=" + Memory.getUsedMemoryInKB() + " KB, FreeMemory=" + Memory.getFreeMemoryInKB() + " KB, AllocatedMemory=" + Memory.getAllocatedMemoryInKB() + " KB, MaxMemory=" + Memory.getMaxMemoryInKB() + " KB.";
    }

    public static int getMemoryLeftInMB() {
        return Memory.getMaxMemoryInMB() - Memory.getAllocatedMemoryInMB() + Memory.getFreeMemoryInMB();
    }

    public static int getUsedMemoryInMB() {
        return (int)(Memory.getUsedMemoryInKB() / 1024L);
    }

    public static int getFreeMemoryInMB() {
        return (int)(Memory.getFreeMemoryInKB() / 1024L);
    }

    public static int getAllocatedMemoryInMB() {
        return (int)(Memory.getAllocatedMemoryInKB() / 1024L);
    }

    public static int getMaxMemoryInMB() {
        return (int)(Memory.getMaxMemoryInKB() / 1024L);
    }

    public static String getMemoryInfoMB() {
        return "Memory usage: TotalFreeMemory=" + Memory.getMemoryLeftInMB() + " MB, UsedMemory=" + Memory.getUsedMemoryInMB() + " MB, FreeMemory=" + Memory.getFreeMemoryInMB() + " MB, AllocatedMemory=" + Memory.getAllocatedMemoryInMB() + " MB, MaxMemory=" + Memory.getMaxMemoryInMB() + " MB.";
    }

    public static int getTotalPhysicalMemorySizeInMB() {
        long osPhysMemSize = _osMbean.getTotalPhysicalMemorySize();
        return (int)(osPhysMemSize / 1024L / 1024L);
    }

    public static int getFreePhysicalMemorySizeInMB() {
        long osPhysFreeMemSize = _osMbean.getFreePhysicalMemorySize();
        return (int)(osPhysFreeMemSize / 1024L / 1024L);
    }

    public static interface MemoryListener {
        public void outOfMemoryHandler();

        public void memoryConsumption(int var1);
    }
}

