/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.paddings.BlockCipherPadding;
import org.bouncycastle.crypto.paddings.PKCS7Padding;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import sek.ase.auditor.Version;
import sek.ase.auditor.utils.Configuration;

public class OpenSslAesUtil {
    private static final int AES_NIVBITS = 128;
    private final int keyLenBits;

    public OpenSslAesUtil(int nKeyBits) {
        this.keyLenBits = nKeyBits;
    }

    public static String encode(String passwd, String sourceStringToEncode) throws DecryptionException {
        OpenSslAesUtil crypter = new OpenSslAesUtil(128);
        byte[] ba = crypter.encipher(passwd.getBytes(), sourceStringToEncode);
        return Base64.encodeBase64String((byte[])ba);
    }

    private byte[] encipher(byte[] pwd, String sourceString) throws DecryptionException {
        String saltedMagic = "Salted__";
        byte[] salt = new SecureRandom().generateSeed(8);
        byte[] src = sourceString.getBytes();
        try {
            PKCS7Padding padding = new PKCS7Padding();
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()), (BlockCipherPadding)padding);
            CipherParameters params = this.getCipherParameters(pwd, salt);
            cipher.reset();
            cipher.init(true, params);
            int buflen = cipher.getOutputSize(src.length);
            byte[] workingBuffer = new byte[buflen];
            int len = cipher.processBytes(src, 0, src.length, workingBuffer, 0);
            len += cipher.doFinal(workingBuffer, len);
            byte[] bytesEnc = new byte[len];
            System.arraycopy(workingBuffer, 0, bytesEnc, 0, len);
            byte[] openSslOutArr = new byte[len + 16];
            System.arraycopy(saltedMagic.getBytes(), 0, openSslOutArr, 0, 8);
            System.arraycopy(salt, 0, openSslOutArr, 8, 8);
            System.arraycopy(bytesEnc, 0, openSslOutArr, 16, bytesEnc.length);
            return openSslOutArr;
        }
        catch (Exception e) {
            throw new DecryptionException("Decryption failed, Caught: " + e, e);
        }
    }

    public static String decode(String passwd, String base64Str) throws DecryptionException {
        OpenSslAesUtil decrypter = new OpenSslAesUtil(128);
        byte[] ba = decrypter.decipher(passwd.getBytes(), Base64.decodeBase64((String)base64Str));
        return new String(ba).trim();
    }

    public byte[] decipher(byte[] pwd, byte[] src) throws DecryptionException {
        byte[] salt = Arrays.copyOfRange(src, 8, 16);
        try {
            PKCS7Padding padding = new PKCS7Padding();
            PaddedBufferedBlockCipher cipher = new PaddedBufferedBlockCipher((BlockCipher)new CBCBlockCipher((BlockCipher)new AESEngine()), (BlockCipherPadding)padding);
            CipherParameters params = this.getCipherParameters(pwd, salt);
            cipher.reset();
            cipher.init(false, params);
            int buflen = cipher.getOutputSize(src.length - 16);
            byte[] workingBuffer = new byte[buflen];
            int len = cipher.processBytes(src, 16, src.length - 16, workingBuffer, 0);
            len += cipher.doFinal(workingBuffer, len);
            byte[] bytesDec = new byte[len];
            System.arraycopy(workingBuffer, 0, bytesDec, 0, len);
            return bytesDec;
        }
        catch (InvalidCipherTextException e) {
            throw new DecryptionException("Decryption failed, Probably wrong passphrase. Caught: " + (Object)((Object)e), e);
        }
        catch (RuntimeException e) {
            throw new DecryptionException("Decryption failed, Caught: " + e, e);
        }
    }

    private CipherParameters getCipherParameters(byte[] pwd, byte[] salt) {
        OpenSSLPBEParametersGenerator gen = new OpenSSLPBEParametersGenerator();
        gen.init(pwd, salt);
        CipherParameters cp = gen.generateDerivedParameters(this.keyLenBits, 128);
        return cp;
    }

    private static String getDefaultPassPhrase() {
        String passPhrase = Configuration.getCombinedConfiguration().getProperty("OpenSslAesUtil.readPasswdFromFile.encyption.password");
        if (passPhrase == null && "SqlServerTune".equals(Version.getAppName())) {
            passPhrase = "mssql";
        }
        if (passPhrase == null) {
            passPhrase = "sybase";
        }
        return passPhrase;
    }

    public static String readPasswdFromFile(String user) throws IOException, DecryptionException {
        return OpenSslAesUtil.readPasswdFromFile(user, null, null, null);
    }

    public static String readPasswdFromFile(String user, String serverName) throws IOException, DecryptionException {
        return OpenSslAesUtil.readPasswdFromFile(user, serverName, null, null);
    }

    public static String readPasswdFromFile(String user, String serverName, String filename) throws IOException, DecryptionException {
        return OpenSslAesUtil.readPasswdFromFile(user, serverName, filename, null);
    }

    public static String readPasswdFromFile(String user, String serverName, String filename, String encPasswd) throws IOException, DecryptionException {
        File f;
        if (encPasswd == null) {
            encPasswd = OpenSslAesUtil.getDefaultPassPhrase();
        }
        if (filename == null) {
            filename = OpenSslAesUtil.getPasswordFilename();
        }
        if ((f = new File(filename)).exists()) {
            String fallbackEncPasswd = null;
            String srvMatchEncPasswd = null;
            int fallbackEncPasswdAtRow = 0;
            int srvMatchEncPasswdAtRow = 0;
            int rowNumber = 0;
            List<String> lines = Files.readAllLines(Paths.get(filename, new String[0]), Charset.forName("UTF-8"));
            for (String line : lines) {
                ++rowNumber;
                String[] sa = line.split(":");
                if (sa.length < 2) continue;
                boolean srvEntry = false;
                String fUser = null;
                String fServer = null;
                String fEncPasswd = null;
                if (sa.length == 2) {
                    srvEntry = false;
                    fUser = sa[0].trim();
                    fServer = null;
                    fEncPasswd = sa[1].trim();
                } else {
                    srvEntry = true;
                    fUser = sa[0].trim();
                    fServer = sa[1].trim();
                    fEncPasswd = sa[2].trim();
                }
                if (!user.equals(fUser)) continue;
                if (srvEntry) {
                    if (serverName == null || !serverName.equals(fServer)) continue;
                    srvMatchEncPasswd = fEncPasswd;
                    srvMatchEncPasswdAtRow = rowNumber;
                    continue;
                }
                fallbackEncPasswd = fEncPasswd;
                fallbackEncPasswdAtRow = rowNumber;
            }
            String rawEncryptedStr = null;
            int rawEncryptedStrAtRow = 0;
            if (fallbackEncPasswd != null) {
                rawEncryptedStr = fallbackEncPasswd;
                rawEncryptedStrAtRow = fallbackEncPasswdAtRow;
            }
            if (srvMatchEncPasswd != null) {
                rawEncryptedStr = srvMatchEncPasswd;
                rawEncryptedStrAtRow = srvMatchEncPasswdAtRow;
            }
            if (rawEncryptedStr != null) {
                try {
                    return OpenSslAesUtil.decode(encPasswd, rawEncryptedStr);
                }
                catch (DecryptionException originEx) {
                    try {
                        String userPassphrase = System.getProperty("user.name");
                        return OpenSslAesUtil.decode(userPassphrase, rawEncryptedStr);
                    }
                    catch (DecryptionException ex) {
                        throw new DecryptionException("When reading password file '" + f + "', at row " + rawEncryptedStrAtRow + ", we Caught: " + originEx.getMessage(), originEx);
                    }
                }
            }
            return null;
        }
        throw new FileNotFoundException("The password file '" + f + "' didn't exist.");
    }

    public static void writePasswdToFile(String clearPassword, String user) throws IOException, DecryptionException {
        OpenSslAesUtil.writePasswdToFile(clearPassword, user, null, null, null);
    }

    public static void writePasswdToFile(String clearPassword, String user, String serverName) throws IOException, DecryptionException {
        OpenSslAesUtil.writePasswdToFile(clearPassword, user, serverName, null, null);
    }

    public static void writePasswdToFile(String clearPassword, String user, String serverName, String filename) throws IOException, DecryptionException {
        OpenSslAesUtil.writePasswdToFile(clearPassword, user, serverName, filename, null);
    }

    public static boolean removePasswdFromFile(String user) throws IOException, DecryptionException {
        return OpenSslAesUtil.writePasswdToFile("not-used", user, null, null, null, true);
    }

    public static boolean removePasswdFromFile(String user, String serverName) throws IOException, DecryptionException {
        return OpenSslAesUtil.writePasswdToFile("not-used", user, serverName, null, null, true);
    }

    public static boolean removePasswdFromFile(String user, String serverName, String filename) throws IOException, DecryptionException {
        return OpenSslAesUtil.writePasswdToFile("not-used", user, serverName, filename, null, true);
    }

    public static void writePasswdToFile(String clearPassword, String user, String serverName, String filename, String encPasswd) throws IOException, DecryptionException {
        OpenSslAesUtil.writePasswdToFile(clearPassword, user, serverName, filename, encPasswd, false);
    }

    private static boolean writePasswdToFile(String clearPassword, String user, String serverName, String filename, String encPasswd, boolean remove) throws IOException, DecryptionException {
        if (encPasswd == null) {
            encPasswd = OpenSslAesUtil.getDefaultPassPhrase();
        }
        if (filename == null) {
            filename = OpenSslAesUtil.getPasswordFilename();
        }
        String encrypedPassword = OpenSslAesUtil.encode(encPasswd, clearPassword);
        File f = new File(filename);
        if (f.exists()) {
            String newEntry;
            String sep = ": ";
            String fallbackEncPasswd = null;
            String srvMatchEncPasswd = null;
            int srvEntryFoundAtIndex = -1;
            int fallbackEntryFoundAtIndex = -1;
            List<String> lines = Files.readAllLines(Paths.get(filename, new String[0]), Charset.forName("UTF-8"));
            int lineNum = -1;
            for (String line : lines) {
                ++lineNum;
                String[] sa = line.split(":");
                if (sa.length < 2) continue;
                boolean srvEntry = false;
                String fUser = null;
                String fServer = null;
                String fEncPasswd = null;
                if (sa.length == 2) {
                    srvEntry = false;
                    fUser = sa[0].trim();
                    fServer = null;
                    fEncPasswd = sa[1].trim();
                } else {
                    srvEntry = true;
                    fUser = sa[0].trim();
                    fServer = sa[1].trim();
                    fEncPasswd = sa[2].trim();
                }
                if (!user.equals(fUser)) continue;
                if (srvEntry) {
                    if (serverName == null || !serverName.equals(fServer)) continue;
                    srvMatchEncPasswd = fEncPasswd;
                    srvEntryFoundAtIndex = lineNum;
                    continue;
                }
                fallbackEncPasswd = fEncPasswd;
                fallbackEntryFoundAtIndex = lineNum;
            }
            boolean removedEntry = false;
            int entryFoundAtIndex = -1;
            if (serverName != null) {
                if (srvEntryFoundAtIndex != -1) {
                    entryFoundAtIndex = srvEntryFoundAtIndex;
                }
            } else if (fallbackEntryFoundAtIndex != -1) {
                entryFoundAtIndex = fallbackEntryFoundAtIndex;
            }
            if (entryFoundAtIndex != -1) {
                if (serverName != null) {
                    if (remove) {
                        lines.remove(entryFoundAtIndex);
                        removedEntry = true;
                    } else {
                        newEntry = user + sep + serverName + sep + encrypedPassword;
                        lines.set(entryFoundAtIndex, newEntry);
                    }
                } else if (remove) {
                    lines.remove(entryFoundAtIndex);
                    removedEntry = true;
                } else {
                    newEntry = user + sep + encrypedPassword;
                    lines.set(entryFoundAtIndex, newEntry);
                }
            } else {
                newEntry = user + sep + encrypedPassword;
                if (serverName != null) {
                    newEntry = user + sep + serverName + sep + encrypedPassword;
                }
                lines.add(newEntry);
            }
            Files.write(Paths.get(filename, new String[0]), lines, Charset.forName("UTF-8"), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            return removedEntry;
        }
        throw new FileNotFoundException("The password file '" + f + "' didn't exist.");
    }

    public static boolean createPasswordFilenameIfNotExists(String filename) throws IOException {
        if (filename == null) {
            filename = OpenSslAesUtil.getPasswordFilename();
        }
        File f = new File(filename);
        return f.createNewFile();
    }

    public static String getPasswordFilename() {
        String homeDir = System.getProperty("user.home");
        String defFilename = homeDir + File.separatorChar + ".passwd.enc";
        return Configuration.getCombinedConfiguration().getProperty("OpenSslAesUtil.readPasswdFromFile.filename", defFilename);
    }

    public static class DecryptionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public DecryptionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

