/*
 * Decompiled with CFR 0.152.
 */
package sek.ase.auditor.utils;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.InputSource;

public class StringUtil {
    private static Logger _logger = LogManager.getLogger(MethodHandles.lookup().lookupClass());
    private static final String REGEX_SPLIT_COMMA_RESPECT_QUOTES = ",(?=(?:[^\"]*\"[^\"]*\")*[^\"]*$)";
    private static final Pattern HTML_TAG_PATTERN = Pattern.compile("<[^>]*>");
    private static String REGEXP_NEW_LINE = "\\r?\\n|\\r";

    public static String toCommaStr(boolean[] array) {
        return Arrays.toString(array).replace("[", "").replace("]", "");
    }

    public static String toCommaStr(byte[] array) {
        return Arrays.toString(array).replace("[", "").replace("]", "");
    }

    public static String toCommaStr(char[] array) {
        return Arrays.toString(array).replace("[", "").replace("]", "");
    }

    public static String toCommaStr(double[] array) {
        return Arrays.toString(array).replace("[", "").replace("]", "");
    }

    public static String toCommaStr(float[] array) {
        return Arrays.toString(array).replace("[", "").replace("]", "");
    }

    public static String toCommaStr(int[] array) {
        return Arrays.toString(array).replace("[", "").replace("]", "");
    }

    public static String toCommaStr(long[] array) {
        return Arrays.toString(array).replace("[", "").replace("]", "");
    }

    public static String toCommaStr(short[] array) {
        return Arrays.toString(array).replace("[", "").replace("]", "");
    }

    public static <T> String toCommaStr(Collection<T> list) {
        return StringUtil.toCommaStr(list, ", ");
    }

    public static <T> String toCommaStr(Collection<T> list, String entrySep) {
        if (list == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<T> it = list.iterator();
        while (it.hasNext()) {
            T val = it.next();
            sb.append(val);
            if (!it.hasNext()) continue;
            sb.append(entrySep);
        }
        return sb.toString();
    }

    public static <K, V> String toCommaStr(Map<K, V> map) {
        return StringUtil.toCommaStr(map, "=", ", ");
    }

    public static <K, V> String toCommaStrKey(Map<K, V> map) {
        return StringUtil.toCommaStr(map, "=", ", ", true, false);
    }

    public static <K, V> String toCommaStrKey(Map<K, V> map, String entrySep) {
        return StringUtil.toCommaStr(map, "=", entrySep, true, false);
    }

    public static <K, V> String toCommaStrVal(Map<K, V> map) {
        return StringUtil.toCommaStr(map, "=", ", ", false, true);
    }

    public static <K, V> String toCommaStrVal(Map<K, V> map, String entrySep) {
        return StringUtil.toCommaStr(map, "=", entrySep, false, true);
    }

    public static <K, V> String toCommaStr(Map<K, V> map, String keyValSep, String entrySep) {
        return StringUtil.toCommaStr(map, keyValSep, entrySep, true, true);
    }

    public static <K, V> String toCommaStr(Map<K, V> map, String keyValSep, String entrySep, boolean useKey, boolean useValue) {
        if (map == null) {
            return "";
        }
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<K> it = map.keySet().iterator();
        while (it.hasNext()) {
            K key = it.next();
            V val = map.get(key);
            if (useKey) {
                sb.append(key);
            }
            if (useKey && useValue) {
                sb.append(keyValSep);
            }
            if (useValue) {
                sb.append(val);
            }
            if (!it.hasNext()) continue;
            sb.append(entrySep);
        }
        return sb.toString();
    }

    public static String toCommaStrQuoted(Collection<String> collection) {
        return StringUtil.toCommaStrQuoted('\"', '\"', collection);
    }

    public static String toCommaStrQuoted(char quoteChar, Collection<String> collection) {
        return StringUtil.toCommaStrQuoted(quoteChar, quoteChar, collection);
    }

    public static String toCommaStrQuoted(char startQuoteChar, char endQuoteChar, Collection<String> collection) {
        if (collection == null) {
            return "";
        }
        if (collection.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String name : collection) {
            sb.append(startQuoteChar).append(name).append(endQuoteChar).append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        return sb.toString();
    }

    public static String toCommaStrQuoted(String ... names) {
        return StringUtil.toCommaStrQuoted('\"', '\"', names);
    }

    public static String toCommaStrQuoted(char quoteChar, String ... names) {
        return StringUtil.toCommaStrQuoted(quoteChar, quoteChar, names);
    }

    public static String toCommaStrQuoted(char startQuoteChar, char endQuoteChar, String ... names) {
        if (names == null) {
            return "";
        }
        if (names.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            sb.append(startQuoteChar).append(name).append(endQuoteChar).append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        return sb.toString();
    }

    public static String toCommaStrQuoted(String quoteChar, Collection<String> collection) {
        return StringUtil.toCommaStrQuoted(quoteChar, quoteChar, collection);
    }

    public static String toCommaStrQuoted(String startQuoteChar, String endQuoteChar, Collection<String> collection) {
        if (collection == null) {
            return "";
        }
        if (collection.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String name : collection) {
            sb.append(startQuoteChar).append(name).append(endQuoteChar).append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        return sb.toString();
    }

    public static String toCommaStrQuoted(String quoteChar, String ... names) {
        return StringUtil.toCommaStrQuoted(quoteChar, quoteChar, names);
    }

    public static String toCommaStrQuoted(String startQuoteChar, String endQuoteChar, String ... names) {
        if (names == null) {
            return "";
        }
        if (names.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String name : names) {
            sb.append(startQuoteChar).append(name).append(endQuoteChar).append(", ");
        }
        sb.delete(sb.length() - 2, sb.length());
        return sb.toString();
    }

    public static String toCommaStrMultiMap(Map<String, List<String>> map) {
        return StringUtil.toCommaStrMultiMap(map, "=", ", ");
    }

    public static String toCommaStrMultiMapKey(Map<String, List<String>> map) {
        return StringUtil.toCommaStrMultiMap(map, "=", ", ", true, false);
    }

    public static String toCommaStrMultiMapKey(Map<String, List<String>> map, String entrySep) {
        return StringUtil.toCommaStrMultiMap(map, "=", entrySep, true, false);
    }

    public static String toCommaStrMultiMapVal(Map<String, List<String>> map) {
        return StringUtil.toCommaStrMultiMap(map, "=", ", ", false, true);
    }

    public static String toCommaStrMultiMapVal(Map<String, List<String>> map, String entrySep) {
        return StringUtil.toCommaStrMultiMap(map, "=", entrySep, false, true);
    }

    public static String toCommaStrMultiMap(Map<String, List<String>> map, String keyValSep, String entrySep) {
        return StringUtil.toCommaStrMultiMap(map, keyValSep, entrySep, true, true);
    }

    public static String toCommaStrMultiMap(Map<String, List<String>> map, String keyValSep, String entrySep, boolean useKey, boolean useValue) {
        if (map == null) {
            return "";
        }
        if (map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = it.next();
            List<String> list = map.get(key);
            Iterator<String> listIt = list.iterator();
            while (listIt.hasNext()) {
                String listVal = listIt.next();
                if (useKey) {
                    sb.append(key);
                }
                if (useKey && useValue) {
                    sb.append(keyValSep);
                }
                if (useValue) {
                    sb.append(listVal);
                }
                if (!listIt.hasNext()) continue;
                sb.append(entrySep);
            }
            if (!it.hasNext()) continue;
            sb.append(entrySep);
        }
        return sb.toString();
    }

    public static List<String> getMatchingStrings(List<String> list, String regex) {
        ArrayList<String> matches = new ArrayList<String>();
        Pattern p = Pattern.compile(regex);
        for (String str : list) {
            if (!p.matcher(str).matches()) continue;
            matches.add(str);
        }
        return matches;
    }

    public static List<String> parseCommaStrToList(String str) {
        return StringUtil.parseCommaStrToList(str, false);
    }

    public static List<String> parseCommaStrToList(String str, boolean skipEmtyStrings) {
        return StringUtil.parseCommaStrToList(str, REGEX_SPLIT_COMMA_RESPECT_QUOTES, skipEmtyStrings);
    }

    public static List<String> parseCommaStrToList(String str, String regex, boolean skipEmtyStrings) {
        String[] sa;
        ArrayList<String> list = new ArrayList<String>();
        if (str == null) {
            return list;
        }
        for (String se : sa = str.split(regex)) {
            if (skipEmtyStrings && se.equals("")) continue;
            list.add(se.trim());
        }
        return list;
    }

    public static LinkedHashSet<String> parseCommaStrToSet(String str) {
        return StringUtil.parseCommaStrToSet(str, true);
    }

    public static LinkedHashSet<String> parseCommaStrToSet(String str, boolean skipEmptyFields) {
        String[] sa;
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (str == null) {
            return set;
        }
        for (String se : sa = str.split(REGEX_SPLIT_COMMA_RESPECT_QUOTES)) {
            String trimmed = se.trim();
            if (!StringUtil.hasValue(trimmed)) continue;
            set.add(trimmed);
        }
        return set;
    }

    public static Map<String, String> parseCommaStrToMap(String source) {
        return StringUtil.parseCommaStrToMap(source, "=", ",");
    }

    public static Map<String, String> parseCommaStrToMap(String source, String keyValSep, String entrySep) {
        if (StringUtil.isNullOrBlank(source)) {
            return new LinkedHashMap<String, String>();
        }
        if ((source = source.trim()).startsWith("{") && source.endsWith("}")) {
            source = source.substring(1, source.length() - 1);
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Scanner parser = new Scanner(source);
        parser.useDelimiter(entrySep);
        while (parser.hasNext()) {
            String oldVal;
            String keyVal;
            String key = keyVal = parser.next().trim();
            String val = "";
            int keyValSepPos = keyVal.indexOf(keyValSep);
            if (keyValSepPos >= 0) {
                key = keyVal.substring(0, keyValSepPos);
                val = keyVal.substring(keyValSepPos + 1);
            }
            if ((oldVal = map.put(key, val)) == null) continue;
            _logger.warn("Found an already existing value for the key '" + key + "'. The existing value '" + oldVal + "' is replaced with the new value '" + val + "'.");
        }
        parser.close();
        return map;
    }

    public static Map<String, List<String>> parseCommaStrToMultiMap(String source) {
        return StringUtil.parseCommaStrToMultiMap(source, "=", ",");
    }

    public static Map<String, List<String>> parseCommaStrToMultiMap(String source, String keyValSep, String entrySep) {
        if (source == null) {
            return new LinkedHashMap<String, List<String>>();
        }
        if ((source = source.trim()).startsWith("{") && source.endsWith("}")) {
            source = source.substring(1, source.length() - 1);
        }
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        Scanner parser = new Scanner(source);
        parser.useDelimiter(entrySep);
        while (parser.hasNext()) {
            String keyVal = parser.next().trim();
            String[] sa = StringUtil.split(keyValSep, keyVal);
            if (sa.length != 2) continue;
            String key = sa[0];
            String val = sa[1];
            List<String> list = map.get(key);
            if (list == null) {
                list = new LinkedList<String>();
            }
            list.add(val);
            map.put(key, list);
        }
        parser.close();
        return map;
    }

    public static String toCommaStr(Object[] oa) {
        return StringUtil.toCommaStr(oa, ", ");
    }

    public static String toCommaStr(Object[] oa, String sep) {
        StringBuffer sb = new StringBuffer();
        if (oa == null) {
            return "";
        }
        for (int i = 0; i < oa.length; ++i) {
            sb.append(oa[i]);
            if (i >= oa.length - 1) continue;
            sb.append(sep);
        }
        return sb.toString();
    }

    public static String[] commaStrToArray(String str) {
        if (str == null) {
            return new String[0];
        }
        String[] sa = str.split(REGEX_SPLIT_COMMA_RESPECT_QUOTES);
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = sa[i].trim();
        }
        return sa;
    }

    public static String[] commaStrToArray(String str, boolean skipEmtyStrings) {
        if (str == null) {
            return new String[0];
        }
        int emptyCount = 0;
        String[] sa = str.split(REGEX_SPLIT_COMMA_RESPECT_QUOTES);
        for (int i = 0; i < sa.length; ++i) {
            sa[i] = sa[i].trim();
            if (!sa[i].equals("") || !skipEmtyStrings) continue;
            ++emptyCount;
        }
        if (emptyCount > 0) {
            String[] tmp = new String[sa.length - emptyCount];
            int t = 0;
            for (int i = 0; i < sa.length; ++i) {
                if (sa[i].equals("") && skipEmtyStrings) continue;
                tmp[t++] = sa[i];
            }
            sa = tmp;
        }
        return sa;
    }

    public static Set<String> commaStrToSet(String str) {
        String[] sa = StringUtil.commaStrToArray(str);
        LinkedHashSet<String> retSet = new LinkedHashSet<String>();
        for (String s : sa) {
            retSet.add(s);
        }
        return retSet;
    }

    public static Set<String> commaStrToSet(String str, boolean skipEmtyStrings) {
        String[] sa = StringUtil.commaStrToArray(str);
        LinkedHashSet<String> retSet = new LinkedHashSet<String>();
        for (String s : sa) {
            if (s.equals("") && skipEmtyStrings) continue;
            retSet.add(s);
        }
        return retSet;
    }

    public static List<String> commaStrToList(String str) {
        String[] sa = StringUtil.commaStrToArray(str);
        ArrayList<String> retList = new ArrayList<String>();
        for (String s : sa) {
            retList.add(s);
        }
        return retList;
    }

    public static List<String> commaStrToList(String str, boolean skipEmtyStrings) {
        String[] sa = StringUtil.commaStrToArray(str);
        ArrayList<String> retList = new ArrayList<String>();
        for (String s : sa) {
            if (skipEmtyStrings && s.equals("")) continue;
            retList.add(s);
        }
        return retList;
    }

    public static boolean arrayContains(Object[] oa, Object o) {
        if (oa == null) {
            return false;
        }
        for (int i = 0; i < oa.length; ++i) {
            if (!oa[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    public static int count(String searchFor, String searchInString) {
        int count = 0;
        int current = -1;
        int next = 0;
        next = searchInString.indexOf(searchFor);
        while (next > -1) {
            ++count;
            current = next;
            next = searchInString.indexOf(searchFor, current + 1);
        }
        return count;
    }

    public static boolean equalsAny(String strToCheck, String ... equalsAny) {
        if (strToCheck == null) {
            return false;
        }
        for (String str : equalsAny) {
            if (!strToCheck.equals(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsAny(String strToCheck, String ... containsAny) {
        if (strToCheck == null) {
            return false;
        }
        for (String str : containsAny) {
            if (!strToCheck.contains(str)) continue;
            return true;
        }
        return false;
    }

    public static String[] split(String splitAt, String s) {
        int noOfLines = StringUtil.count(splitAt, s) + 1;
        String[] stringArray = new String[noOfLines];
        String remaining = s;
        int splitLen = splitAt.length();
        for (int i = 0; i < noOfLines - 1; ++i) {
            int pos = remaining.indexOf(splitAt);
            stringArray[i] = remaining.substring(0, pos);
            remaining = remaining.substring(pos + splitLen, remaining.length());
        }
        stringArray[noOfLines - 1] = remaining;
        return stringArray;
    }

    public static String word(String str, int number) {
        String[] stra = str.split("[ \t\n\f\r]+");
        if (stra.length <= number) {
            return null;
        }
        return stra[number];
    }

    public static String wordRespectQuotes(String str, int number) {
        String[] stra = StringUtil.translateCommandline(str, false);
        if (stra.length <= number) {
            return null;
        }
        return stra[number];
    }

    public static String lastWord(String str) {
        String[] stra = str.split("[ \t\n\f\r]+");
        return stra[stra.length - 1];
    }

    public static String left(String str, int expandToSize) {
        return StringUtil.left(str, expandToSize, true);
    }

    public static String left(String str, int expandToSize, boolean allowGrow) {
        return StringUtil.left(str, expandToSize, true, "", "");
    }

    public static String left(String str, int expandToSize, String quoteStr) {
        return StringUtil.left(str, expandToSize, true, quoteStr, quoteStr);
    }

    public static String left(String str, int expandToSize, boolean allowGrow, String quoteStr) {
        return StringUtil.left(str, expandToSize, true, quoteStr, quoteStr);
    }

    public static String left(String str, int expandToSize, boolean allowGrow, String quoteStrLeft, String quoteStrRight) {
        if (str == null) {
            str = "";
        }
        int maxSize = 131072;
        if (!StringUtil.isNullOrBlank(quoteStrLeft)) {
            str = quoteStrLeft + str;
        }
        if (!StringUtil.isNullOrBlank(quoteStrRight)) {
            str = str + quoteStrRight;
        }
        if (allowGrow && str.length() > expandToSize) {
            expandToSize = str.length();
        }
        if (expandToSize > maxSize) {
            _logger.warn("StringUtils.left(): expandToSize can't be above " + maxSize + ", using this value. expandToSize=" + expandToSize + ", inStr.length()=" + str.length());
            expandToSize = maxSize;
        }
        int maxPadSize = expandToSize - str.length();
        String space = "                                                                                                                                                                                                                                                               ";
        while (space.length() < maxPadSize) {
            space = space + "                                                                                                                                                                                                                                                               ";
        }
        return (str + space).substring(0, expandToSize);
    }

    public static String right(String str, int num) {
        int len = num - str.length();
        if (len < 0) {
            len = 0;
        }
        String space = "                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ";
        return (space.substring(0, len) + str).substring(0, num);
    }

    public static String envVariableSubstitution(String str) {
        return StrSubstitutor.replaceSystemProperties((Object)str);
    }

    public static String variableSubstitution(String templateString, Map<String, String> valuesMap) {
        StrSubstitutor sub = new StrSubstitutor(valuesMap);
        return sub.replace(templateString);
    }

    public static String getEnvVariableValue(String envName) {
        return StringUtil.getEnvVariableValue(envName, true);
    }

    public static String getEnvVariableValue(String envName, boolean systemPropOverridesEnvVar) {
        String envVal;
        block6: {
            if (envName == null) {
                return null;
            }
            envVal = null;
            if (systemPropOverridesEnvVar && (envVal = System.getProperty(envName)) != null) {
                return envVal;
            }
            try {
                envVal = System.getenv(envName);
            }
            catch (Throwable t) {
                envVal = System.getProperty(envName);
                if (envVal != null) break block6;
                _logger.warn("System.getenv(): Is not supported on this platform or version of Java. Please pass '-D" + envName + "=value' when starting the JVM.");
                System.out.println("System.getenv(): Is not supported on this platform or version of Java. Please pass '-D" + envName + "=value' when starting the JVM.");
            }
        }
        if (envVal == null) {
            envVal = System.getProperty(envName);
        }
        if (envVal == null) {
            _logger.debug("The Environment variable '" + envName + "' cant be found.");
        }
        return envVal;
    }

    public static void setEnvironmentVariablesToSystemProperties(boolean overwrite, boolean writeInfoOnOverwrittenValues) {
        Map<String, String> envVars = System.getenv();
        for (String key : envVars.keySet()) {
            String oldVal;
            String val = envVars.get(key);
            if (overwrite) {
                oldVal = System.setProperty(key, val);
                if (!writeInfoOnOverwrittenValues || oldVal == null || oldVal.equals(val)) continue;
                _logger.info("Overwriting environment variable '" + key + "'. oldValue='" + oldVal + "', newValue='" + val + "'");
                continue;
            }
            oldVal = System.getProperty(key, null);
            if (oldVal != null) continue;
            System.setProperty(key, val);
        }
    }

    public static int utf8Length(CharSequence str) {
        if (str == null) {
            return 0;
        }
        int count = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch <= '\u007f') {
                ++count;
                continue;
            }
            if (ch <= '\u07ff') {
                count += 2;
                continue;
            }
            if (Character.isHighSurrogate(ch)) {
                count += 4;
                ++i;
                continue;
            }
            count += 3;
        }
        return count;
    }

    public static String utf8Truncate(CharSequence str, int maxBytes) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int count = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch <= '\u007f') {
                ++count;
            } else if (ch <= '\u07ff') {
                count += 2;
            } else if (Character.isHighSurrogate(ch)) {
                count += 4;
                ++i;
            } else {
                count += 3;
            }
            if (count > maxBytes) {
                return sb.toString();
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String replicate(String str, int size) {
        StringBuilder sb = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            sb.append(str);
        }
        return sb.toString();
    }

    public static String fill(String str, int fill) {
        if (str.length() >= fill) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        while (sb.length() < fill) {
            sb.append("                                                           ");
        }
        return sb.substring(0, fill);
    }

    public static String fillSpace(int spaceCnt) {
        StringBuilder sb = new StringBuilder(spaceCnt);
        for (int i = 0; i < spaceCnt; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public static String stripHtmlStartEnd(String str) {
        if (str == null) {
            return null;
        }
        if (str.startsWith("<html>") || str.startsWith("<HTML>")) {
            str = str.substring("<html>".length());
        }
        if (str.endsWith("</html>") || str.endsWith("</HTML>")) {
            str = str.substring(0, str.length() - "</html>".length());
        }
        return str;
    }

    public static String stripHtml(String in) {
        if (in == null) {
            return null;
        }
        return HTML_TAG_PATTERN.matcher(in).replaceAll("");
    }

    public static boolean containsHtml(String in) {
        if (in == null) {
            return false;
        }
        return HTML_TAG_PATTERN.matcher(in).find();
    }

    public static String stripNewLine(String str) {
        if (str == null) {
            return null;
        }
        if (str.indexOf(10) >= 0) {
            str = str.replace("\n", "");
        }
        if (str.indexOf(13) >= 0) {
            str = str.replace("\r", "");
        }
        return str.trim();
    }

    public static String makeApproxLineBreak(String str, int rowLength, int wordCountHysteresis, String lineBreak) {
        if (str.length() <= rowLength) {
            return str;
        }
        StringBuffer sb = new StringBuffer();
        char[] ca = str.toCharArray();
        int c = 0;
        int car = 0;
        while (c < ca.length) {
            sb.append(ca[c]);
            car = ca[c] == '\n' ? 0 : ++car;
            ++c;
            if (car < rowLength) continue;
            int nextSpacePos = str.substring(c).trim().indexOf(32);
            if (nextSpacePos > 0 && nextSpacePos < Math.max(15, rowLength / 4)) {
                while (c < ca.length && ca[c] != ' ') {
                    sb.append(ca[c]);
                    ++c;
                }
                if (str.substring(c).split("\\s", wordCountHysteresis + 1).length <= wordCountHysteresis) {
                    while (c < ca.length) {
                        sb.append(ca[c]);
                        ++c;
                    }
                } else {
                    sb.append(lineBreak);
                }
            } else {
                sb.append(lineBreak);
            }
            car = 0;
        }
        return sb.toString();
    }

    public static String getHostname() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String hostname = addr.getHostName();
            return hostname;
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static String getHostnameWithDomain() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            String hostname = addr.getCanonicalHostName();
            return hostname;
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static String stackTraceToString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static boolean isNullOrBlankForAll(String ... inputs) {
        if (inputs == null) {
            return true;
        }
        for (String str : inputs) {
            if (StringUtil.isNullOrBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNullOrBlank(String str) {
        if (str == null) {
            return true;
        }
        if (str.equals("")) {
            return true;
        }
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasValueForAll(String ... inputs) {
        if (inputs == null) {
            return false;
        }
        for (String str : inputs) {
            if (!StringUtil.isNullOrBlank(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasValue(String str) {
        return !StringUtil.isNullOrBlank(str);
    }

    public static boolean matchesRegexArr(String inStr, String[] regexArr) {
        for (String str : regexArr) {
            if (!inStr.matches(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesRegexSet(String inStr, Set<String> regexSet) {
        for (String str : regexSet) {
            if (!inStr.matches(str)) continue;
            return true;
        }
        return false;
    }

    public static String removeLastStr(String str, String endStr) {
        if (str == null) {
            return null;
        }
        if ((str = StringUtil.rtrim(str)).endsWith(endStr)) {
            str = str.substring(0, str.length() - endStr.length());
        }
        return str;
    }

    public static String removeLastComma(String str) {
        if (str == null) {
            return null;
        }
        if ((str = StringUtil.rtrim(str)).endsWith(",")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String removeLastNewLine(String str) {
        if (str == null) {
            return null;
        }
        if ((str = StringUtil.rtrim2(str)).endsWith("\n")) {
            str = str.substring(0, str.length() - 1);
        }
        if (str.endsWith("\r")) {
            str = str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static boolean hasSemicolonAtEnd(String row) {
        if (StringUtil.isNullOrBlank(row)) {
            return false;
        }
        if (row.endsWith(";")) {
            return true;
        }
        for (int i = row.length() - 1; i >= 0; --i) {
            char ch = row.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            return ch == ';';
        }
        return false;
    }

    public static String removeSemicolonAtEnd(String row) {
        if (StringUtil.hasSemicolonAtEnd(row)) {
            return row.substring(0, row.lastIndexOf(59));
        }
        return row;
    }

    public static int charCount(String str, char ch) {
        int count = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ch) continue;
            ++count;
        }
        return count;
    }

    public static int countLines(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        int lines = 1;
        int len = str.length();
        for (int pos = 0; pos < len; ++pos) {
            char c = str.charAt(pos);
            if (c == '\r') {
                ++lines;
                if (pos + 1 >= len || str.charAt(pos + 1) != '\n') continue;
                ++pos;
                continue;
            }
            if (c != '\n') continue;
            ++lines;
        }
        return lines;
    }

    public static int indexOfEndBrace(String searchStr, int startPos, char endChar) {
        char beginChar = ' ';
        if (endChar == '}') {
            beginChar = '{';
        } else if (endChar == ']') {
            beginChar = '[';
        } else if (endChar == ')') {
            beginChar = '(';
        }
        int matchCount = 1;
        char[] search = searchStr.toCharArray();
        for (int i = startPos; i < search.length; ++i) {
            char c = search[i];
            if (c == beginChar) {
                ++matchCount;
            }
            if (c == endChar) {
                --matchCount;
            }
            if (matchCount != 0) continue;
            return i;
        }
        return -1;
    }

    public static boolean isInteger(String str) {
        if (str == null) {
            return false;
        }
        try {
            Integer.parseInt(str.trim());
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    public static int parseInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str.trim());
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static long parseLong(String str, long defaultValue) {
        try {
            return Long.parseLong(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static double parseDouble(String str, double defaultValue) {
        try {
            return Double.parseDouble(str);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static String sqlSafeAlways(String inStr) {
        return StringUtil.sqlSafe(inStr, "[", "]", null, true);
    }

    public static String sqlSafe(String inStr, String preStr, String postStr, List<String> reservedWords, boolean always) {
        if (StringUtil.isNullOrBlank(inStr)) {
            return inStr;
        }
        boolean doQuote = false;
        if (always) {
            doQuote = true;
        } else if (reservedWords != null && reservedWords.contains(inStr)) {
            doQuote = true;
        }
        if (doQuote) {
            StringBuilder sb = new StringBuilder();
            return sb.append(preStr).append(inStr).append(postStr).toString();
        }
        return inStr;
    }

    public static String xmlSafe(String inStr) {
        if (inStr == null) {
            return null;
        }
        if (inStr.indexOf(38) >= 0 || inStr.indexOf(60) >= 0) {
            return "<![CDATA[" + inStr + "]]>";
        }
        return inStr;
    }

    public static StringBuilder xmlAddAttributes(StringBuilder sb, Map<String, String> attributes) {
        if (attributes == null || attributes != null && attributes.size() == 0) {
            return sb;
        }
        for (String key : attributes.keySet()) {
            String val = attributes.get(key);
            sb.append(" ").append(key).append("=\"").append(val).append("\"");
        }
        return sb;
    }

    private static StringBuilder xmlAddAttributes(StringBuilder sb, String[] attributes) {
        if (attributes == null || attributes != null && attributes.length == 0) {
            return sb;
        }
        if (attributes != null && attributes.length % 2 != 0) {
            throw new IllegalArgumentException("Input parameter attributes must be a multiple of 2: key1, val1, key2, val2");
        }
        for (int i = 0; i < attributes.length; i += 2) {
            String key = attributes[i];
            String val = attributes[i + 1];
            sb.append(" ").append(key).append("=\"").append(val).append("\"");
        }
        return sb;
    }

    public static StringBuilder xmlBeginTag(StringBuilder sb, int preSpaces, String tagName) {
        return StringUtil.xmlBeginTag(sb, preSpaces, tagName, (String[])null);
    }

    public static StringBuilder xmlBeginTag(StringBuilder sb, int preSpaces, String tagName, Map<String, String> attributes) {
        for (int i = 0; i < preSpaces; ++i) {
            sb.append(" ");
        }
        sb.append("<").append(tagName);
        if (attributes != null && attributes.size() > 0) {
            StringUtil.xmlAddAttributes(sb, attributes);
        }
        sb.append(">\n");
        return sb;
    }

    public static StringBuilder xmlBeginTag(StringBuilder sb, int preSpaces, String tagName, String ... attributes) {
        if (attributes != null && attributes.length % 2 != 0) {
            throw new IllegalArgumentException("Input parameter attributes must be a multiple of 2: key1, val1, key2, val2");
        }
        for (int i = 0; i < preSpaces; ++i) {
            sb.append(" ");
        }
        sb.append("<").append(tagName);
        if (attributes != null && attributes.length > 0) {
            StringUtil.xmlAddAttributes(sb, attributes);
        }
        sb.append(">\n");
        return sb;
    }

    public static StringBuilder xmlEndTag(StringBuilder sb, int preSpaces, String tagName) {
        for (int i = 0; i < preSpaces; ++i) {
            sb.append(" ");
        }
        return sb.append("</").append(tagName).append(">\n");
    }

    public static StringBuilder xmlTag(StringBuilder sb, int preSpaces, String tagName, boolean value) {
        return StringUtil.xmlTag(sb, preSpaces, tagName, Boolean.toString(value));
    }

    public static StringBuilder xmlTag(StringBuilder sb, int preSpaces, String tagName, int value) {
        return StringUtil.xmlTag(sb, preSpaces, tagName, Integer.toString(value));
    }

    public static StringBuilder xmlTag(StringBuilder sb, int preSpaces, String tagName, String value) {
        return StringUtil.xmlTag(sb, preSpaces, tagName, value, false);
    }

    public static StringBuilder xmlTag(StringBuilder sb, int preSpaces, String tagName, String value, boolean addNullOrBlankValues) {
        if (StringUtil.isNullOrBlank(value) && !addNullOrBlankValues) {
            return sb;
        }
        for (int i = 0; i < preSpaces; ++i) {
            sb.append(" ");
        }
        if ((value = StringUtil.xmlSafe(value)) == null) {
            value = "";
        }
        return sb.append("<").append(tagName).append(">").append(value).append("</").append(tagName).append(">\n");
    }

    public static boolean isPossibleHtml(String inString) {
        return StringUtil.isPossibleHtml(inString, Integer.MAX_VALUE);
    }

    public static boolean isPossibleHtml(String inString, int checkStartLen) {
        if (StringUtil.isNullOrBlank(inString)) {
            return false;
        }
        if (inString.startsWith("<html")) {
            return true;
        }
        if (inString.startsWith("<HTML")) {
            return true;
        }
        int len = Math.min(checkStartLen, inString.length());
        String inStrShort = inString.substring(0, len);
        return StringUtils.containsIgnoreCase((CharSequence)inStrShort, (CharSequence)"</table>") && StringUtils.containsIgnoreCase((CharSequence)inStrShort, (CharSequence)"</tr>");
    }

    public static boolean isPossibleXml(String xmlInString) {
        if (StringUtil.isNullOrBlank(xmlInString)) {
            return false;
        }
        if (xmlInString.startsWith("<?xml ")) {
            return true;
        }
        if (xmlInString.startsWith("<?XML ")) {
            return true;
        }
        int posLt = -1;
        int posGt = -1;
        int posClose = -1;
        posLt = xmlInString.indexOf(60);
        posGt = xmlInString.indexOf(62);
        posClose = xmlInString.indexOf("</");
        int len = Math.min(255, xmlInString.length());
        for (int i = 0; i < len; ++i) {
            int ch2;
            char ch = xmlInString.charAt(i);
            int n = ch2 = i + 1 < len ? (int)xmlInString.charAt(i + 1) : 32;
            if (posLt < 0 && ch == '<') {
                posLt = i;
            }
            if (posGt < 0 && ch == '>') {
                posGt = i;
            }
            if (posClose < 0 && ch == '<' && ch2 == 47) {
                posClose = i;
            }
            if (posLt < 0 || posGt < 0 || posClose < 0) continue;
            return posLt < posGt && posLt < posClose;
        }
        return false;
    }

    public static String xmlFormat(String xml) {
        if (xml == null) {
            return null;
        }
        int len = Math.min(40, xml.length());
        String firstChars = xml.substring(0, len).toLowerCase();
        int xmlStart = firstChars.indexOf("<?xml");
        if (xmlStart > 0) {
            xml = xml.substring(xmlStart);
        }
        return StringUtil.prettyFormat2(xml);
    }

    private static String prettyFormat1(String inputStr, int indentSize) {
        StreamSource xmlInput = new StreamSource(new StringReader(inputStr));
        StringWriter stringWriter = new StringWriter();
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", String.valueOf(indentSize));
            transformer.transform(xmlInput, new StreamResult(stringWriter));
            String retStr = stringWriter.toString().trim();
            return retStr;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String prettyFormat2(String inputStr) {
        try {
            Boolean keepDeclaration = inputStr.startsWith("<?xml");
            InputSource src = new InputSource(new StringReader(inputStr));
            Element document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(src).getDocumentElement();
            DOMImplementationLS dom = (DOMImplementationLS)((Object)DOMImplementationRegistry.newInstance().getDOMImplementation("LS"));
            LSSerializer serializer = dom.createLSSerializer();
            serializer.setNewLine("\n");
            serializer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
            serializer.getDomConfig().setParameter("xml-declaration", keepDeclaration);
            LSOutput destination = dom.createLSOutput();
            destination.setEncoding(StandardCharsets.UTF_8.name());
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            destination.setByteStream(bos);
            serializer.write(document, destination);
            return bos.toString(StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String escapeControlChars(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace("\t", "\\t");
        str = str.replace("\f", "\\f");
        str = str.replace("\n", "\\n");
        str = str.replace("\r", "\\r");
        return str;
    }

    public static String unEscapeControlChars(String str) {
        if (str == null) {
            return null;
        }
        str = str.replace("\\t", "\t");
        str = str.replace("\\f", "\f");
        str = str.replace("\\n", "\n");
        str = str.replace("\\r", "\r");
        return str;
    }

    public static String markTextAtLine(String text, int line, boolean markUsingHtml) {
        if (text == null || line < 0) {
            return text;
        }
        StringBuilder sb = new StringBuilder();
        Scanner scanner = new Scanner(text);
        int rowNumber = 0;
        while (scanner.hasNextLine()) {
            String lineStr = scanner.nextLine();
            if (line == ++rowNumber) {
                if (markUsingHtml) {
                    sb.append("<b><font color=\"red\">").append(rowNumber).append("> ").append(lineStr).append("</font></b>");
                } else {
                    sb.append("**** ").append(rowNumber).append("> ").append(lineStr);
                }
            } else {
                sb.append(rowNumber).append("> ").append(lineStr);
            }
            sb.append("\n");
        }
        scanner.close();
        return sb.toString();
    }

    public static int indexOf(String str, int fromIndex, char ... charsToLookfor) {
        if (str == null) {
            return -1;
        }
        int len = str.length();
        for (int i = fromIndex; i < len; ++i) {
            char c = str.charAt(i);
            for (int j = 0; j < charsToLookfor.length; ++j) {
                if (c != charsToLookfor[j]) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getFirstInputLine(String str) {
        if (StringUtil.isNullOrBlank(str)) {
            return 0;
        }
        int line = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            if (ch == '\r' || ch == '\n') {
                ++line;
                if (ch != '\r' || i + 1 >= len || str.charAt(i + 1) != '\n') continue;
                ++i;
                continue;
            }
            if (!Character.isWhitespace(ch)) break;
        }
        return line;
    }

    public static String getSelectedItemString(JComboBox combo) {
        if (combo == null) {
            return null;
        }
        Object o = combo.getSelectedItem();
        if (o == null) {
            return "";
        }
        return o.toString();
    }

    public static String bytesToHex(String prefix, byte[] bytes) {
        return StringUtil.bytesToHex(prefix, bytes, false, Integer.MAX_VALUE);
    }

    public static String bytesToHex(String prefix, byte[] bytes, boolean toUpper) {
        return StringUtil.bytesToHex(prefix, bytes, toUpper, Integer.MAX_VALUE);
    }

    public static String bytesToHex(String prefix, byte[] bytes, boolean toUpper, int max) {
        if (bytes == null) {
            return null;
        }
        if (max < 0) {
            max = Integer.MAX_VALUE;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < bytes.length && i < max; ++i) {
            if (toUpper) {
                sb.append(String.format("%02X", bytes[i]));
                continue;
            }
            sb.append(String.format("%02x", bytes[i]));
        }
        if (prefix != null) {
            sb.insert(0, prefix);
        }
        return sb.toString();
    }

    public static byte[] hexToBytes(String hexStr) {
        if (hexStr.startsWith("0x")) {
            hexStr = hexStr.substring(2);
        }
        int len = hexStr.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexStr.charAt(i), 16) << 4) + Character.digit(hexStr.charAt(i + 1), 16));
        }
        return data;
    }

    public static List<String> splitOnWhitespaceRespectQuotes(String str) {
        return StringUtil.splitOnCharAllowQuotes(str, ' ', true, false, false);
    }

    public static List<String> splitOnCommasAllowQuotes(String input, boolean trim) {
        return StringUtil.splitOnCharAllowQuotes(input, ',', trim, false, false);
    }

    public static List<String> splitOnCommasAllowQuotes(String input, boolean trim, boolean unquote) {
        return StringUtil.splitOnCharAllowQuotes(input, ',', trim, unquote, false);
    }

    public static List<String> splitOnCharAllowQuotes(String input, char splitChar, boolean trim) {
        return StringUtil.splitOnCharAllowQuotes(input, splitChar, trim, false, false);
    }

    public static List<String> splitOnCharAllowQuotes(String input, char splitChar, boolean trim, boolean unquote, boolean removeEmty) {
        ArrayList<String> tokensList = new ArrayList<String>();
        if (input == null) {
            return tokensList;
        }
        char startQuoteChar = '\u0000';
        boolean inQuotes = false;
        StringBuilder b = new StringBuilder();
        char[] ca = input.toCharArray();
        for (int i = 0; i < ca.length; ++i) {
            char nc;
            char c = ca[i];
            char pc = i == 0 ? (char)'\u0000' : ca[i - 1];
            char c2 = nc = i + 1 < ca.length ? ca[i + 1] : (char)'\u0000';
            if (c == '\"' || c == '\'') {
                if (!inQuotes) {
                    inQuotes = true;
                    startQuoteChar = c;
                } else {
                    if (pc == startQuoteChar) {
                        inQuotes = false;
                    }
                    if (c == startQuoteChar && nc != startQuoteChar && pc != startQuoteChar) {
                        inQuotes = false;
                    }
                }
                b.append(c);
                continue;
            }
            if (c == splitChar) {
                if (inQuotes) {
                    b.append(c);
                    continue;
                }
                String str = b.toString();
                if (trim) {
                    str = str.trim();
                }
                if (unquote) {
                    str = StringUtil.unquote(str);
                }
                boolean addVal = true;
                if (removeEmty && StringUtil.isNullOrBlank(str)) {
                    addVal = false;
                }
                if (addVal) {
                    tokensList.add(str);
                }
                b = new StringBuilder();
                continue;
            }
            b.append(c);
        }
        String str = b.toString();
        if (trim) {
            str = str.trim();
        }
        if (unquote) {
            str = StringUtil.unquote(str);
        }
        boolean addVal = true;
        if (removeEmty && StringUtil.isNullOrBlank(str)) {
            addVal = false;
        }
        if (addVal) {
            tokensList.add(str);
        }
        return tokensList;
    }

    public static String unquote(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        if ((str = str.trim()).charAt(0) != '\'' && str.charAt(0) != '\"') {
            return str;
        }
        StringBuilder b = new StringBuilder();
        char[] ca = str.toCharArray();
        char startQuoteChar = ca[0];
        boolean justSkippedDoubleQuote = false;
        for (int i = 1; i < ca.length - 1; ++i) {
            char pc;
            char c = ca[i];
            char c2 = pc = i <= 1 ? (char)'\u0000' : ca[i - 1];
            if (c == startQuoteChar && pc == startQuoteChar && !justSkippedDoubleQuote) {
                justSkippedDoubleQuote = true;
                continue;
            }
            justSkippedDoubleQuote = false;
            b.append(c);
        }
        return b.toString();
    }

    public static String[] translateCommandline(String toProcess, boolean removeFirst) {
        if (toProcess == null || toProcess.length() == 0) {
            return new String[0];
        }
        boolean normal = false;
        boolean inQuote = true;
        int inDoubleQuote = 2;
        int state = 0;
        StringTokenizer tok = new StringTokenizer(toProcess, "\"' ", true);
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder current = new StringBuilder();
        boolean lastTokenHasBeenQuoted = false;
        block4: while (tok.hasMoreTokens()) {
            String nextTok = tok.nextToken();
            switch (state) {
                case 1: {
                    if ("'".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
                case 2: {
                    if ("\"".equals(nextTok)) {
                        lastTokenHasBeenQuoted = true;
                        state = 0;
                        continue block4;
                    }
                    current.append(nextTok);
                    continue block4;
                }
            }
            if ("'".equals(nextTok)) {
                state = 1;
            } else if ("\"".equals(nextTok)) {
                state = 2;
            } else if (" ".equals(nextTok)) {
                if (lastTokenHasBeenQuoted || current.length() != 0) {
                    list.add(current.toString());
                    current = new StringBuilder();
                }
            } else {
                current.append(nextTok);
            }
            lastTokenHasBeenQuoted = false;
        }
        if (lastTokenHasBeenQuoted || current.length() != 0) {
            list.add(current.toString());
        }
        if (state == 1 || state == 2) {
            throw new IllegalArgumentException("Unbalanced quotes in " + toProcess);
        }
        if (removeFirst && !list.isEmpty()) {
            list.remove(0);
        }
        String[] args = new String[list.size()];
        return list.toArray(args);
    }

    public static String bytesToHuman(long size) {
        return StringUtil.bytesToHuman(size, null);
    }

    public static String bytesToHuman(long size, String fmt) {
        if (fmt == null) {
            fmt = "#.##";
        }
        long Kb = 1024L;
        long Mb = Kb * 1024L;
        long Gb = Mb * 1024L;
        long Tb = Gb * 1024L;
        long Pb = Tb * 1024L;
        long Eb = Pb * 1024L;
        if (size < Kb) {
            return new DecimalFormat(fmt).format(size) + " byte";
        }
        if (size >= Kb && size < Mb) {
            return new DecimalFormat(fmt).format((double)size / (double)Kb) + " KB";
        }
        if (size >= Mb && size < Gb) {
            return new DecimalFormat(fmt).format((double)size / (double)Mb) + " MB";
        }
        if (size >= Gb && size < Tb) {
            return new DecimalFormat(fmt).format((double)size / (double)Gb) + " GB";
        }
        if (size >= Tb && size < Pb) {
            return new DecimalFormat(fmt).format((double)size / (double)Tb) + " TB";
        }
        if (size >= Pb && size < Eb) {
            return new DecimalFormat(fmt).format((double)size / (double)Pb) + " PB";
        }
        if (size >= Eb) {
            return new DecimalFormat(fmt).format((double)size / (double)Eb) + " EB";
        }
        return "???";
    }

    public static String trim(String s) {
        if (s == null) {
            return s;
        }
        return s.trim();
    }

    public static String ltrim(String s) {
        int i;
        if (s == null) {
            return s;
        }
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        return s.substring(i);
    }

    public static String rtrim(String s) {
        int i;
        if (s == null) {
            return s;
        }
        for (i = s.length() - 1; i >= 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        return s.substring(0, i + 1);
    }

    public static String rtrim2(String s) {
        int i;
        if (s == null) {
            return s;
        }
        for (i = s.length() - 1; i >= 0 && (s.charAt(i) == ' ' || s.charAt(i) == '\t' || s.charAt(i) == '\f'); --i) {
        }
        return s.substring(0, i + 1);
    }

    public static int indexOfIgnoreCase(String haystack, String needle) {
        if (needle.isEmpty() || haystack.isEmpty()) {
            return haystack.indexOf(needle);
        }
        for (int i = 0; i < haystack.length(); ++i) {
            char c2;
            char c;
            if (i + needle.length() > haystack.length()) {
                return -1;
            }
            int j = 0;
            for (int ii = i; ii < haystack.length() && j < needle.length() && (c = Character.toLowerCase(haystack.charAt(ii))) == (c2 = Character.toLowerCase(needle.charAt(j))); ++j, ++ii) {
            }
            if (j != needle.length()) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsIgnoreCase(List<String> list, String find) {
        for (String str : list) {
            if (!str.equalsIgnoreCase(find)) continue;
            return true;
        }
        return false;
    }

    public static int indexOfIgnoreCase(List<String> list, String find) {
        int index = 0;
        for (String str : list) {
            if (str.equalsIgnoreCase(find)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static String toRfc4180String(String str) {
        boolean hasComma;
        if (str == null) {
            return null;
        }
        boolean hasNewline = str.indexOf(10) >= 0 || str.indexOf(13) >= 0;
        boolean hasQuote = str.indexOf(34) >= 0;
        boolean bl = hasComma = str.indexOf(44) >= 0;
        if (hasNewline || hasQuote || hasComma) {
            if (hasQuote) {
                str = str.replace("\"", "\"\"");
            }
            str = "\"" + str + "\"";
        }
        return str;
    }

    public static String toHtmlString(Object o) {
        if (o == null) {
            return null;
        }
        String str = o.toString();
        str = str.replace("&", "&amp;");
        str = str.replace("<", "&lt;");
        str = str.replace(">", "&gt;");
        str = str.replace("\n", "<br>");
        return str;
    }

    public static String toHtmlStringExceptNl(Object o) {
        if (o == null) {
            return null;
        }
        String str = o.toString();
        str = str.replace("&", "&amp;");
        str = str.replace("<", "&lt;");
        str = str.replace(">", "&gt;");
        return str;
    }

    public static String toHtmlTable(Map<String, Object> map) {
        return StringUtil.toHtmlTable(map, null);
    }

    public static String toHtmlTable(Map<String, Object> map, String ... colNames) {
        if (map == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<table> \n");
        if (colNames != null && colNames.length > 0) {
            sb.append("<thead> \n");
            sb.append("  <tr> \n");
            for (String colName : colNames) {
                sb.append("    <th nowrap>").append(colName).append("</th> \n");
            }
            sb.append("  </tr> \n");
            sb.append("</thead> \n");
        }
        sb.append("<tbody> \n");
        for (Map.Entry entry : map.entrySet()) {
            sb.append("  <tr> \n");
            sb.append("    <td nowrap><b>").append((String)entry.getKey()).append("</b></td> \n");
            sb.append("    <td nowrap>").append(entry.getValue()).append("</td> \n");
            sb.append("  </tr> \n");
        }
        sb.append("</tbody> \n");
        sb.append("</table> \n");
        return sb.toString();
    }

    public static String toTableString(List<String> tHead, List<List<Object>> tData) {
        return StringUtil.toTableString(tHead, tData, "<SQL-NULL>", false, null, null, -1, -1, null);
    }

    public static String toTableString(List<String> tHead, List<List<Object>> tData, String nullValue) {
        return StringUtil.toTableString(tHead, tData, nullValue, false, null, null, -1, -1, null);
    }

    public static String toTableString(List<String> tHead, List<List<Object>> tData, String nullValue, int[] justRowNumbers) {
        int firstRow = justRowNumbers[0];
        int lastRow = justRowNumbers[justRowNumbers.length - 1] + 1;
        return StringUtil.toTableString(tHead, tData, nullValue, false, null, null, firstRow, lastRow, justRowNumbers);
    }

    public static String toTableString(List<String> tHead, List<List<Object>> tData, String nullValue, int justRowNumber) {
        return StringUtil.toTableString(tHead, tData, nullValue, false, null, null, justRowNumber, justRowNumber + 1, null);
    }

    public static String toTableString(List<String> tHead, List<List<Object>> tData, String nullValue, boolean stripHtml, String[] prefixColName, Object[] prefixColData) {
        return StringUtil.toTableString(tHead, tData, nullValue, stripHtml, prefixColName, prefixColData, -1, -1, null);
    }

    public static String toTableString(List<String> tHead, List<List<Object>> tData, String nullValue, boolean stripHtml, String[] prefixColName, Object[] prefixColData, int firstRow, int lastRow, int[] justRowNumbers) {
        String[] sa;
        String cellStr;
        Object cellObj;
        int c;
        int c2;
        int cols;
        String colSepOther = "+";
        String colSepData = "|";
        String lineSpace = "-";
        String newLine = "\n";
        ArrayList<String> tableHead = new ArrayList<String>();
        ArrayList tableData = new ArrayList();
        StringBuilder sb = new StringBuilder();
        boolean doPrefix = false;
        if (prefixColName != null && prefixColData != null) {
            if (prefixColName.length != prefixColData.length) {
                throw new IllegalArgumentException("tableToString(): prefixColName.length=" + prefixColName.length + " is NOT equal prefixColData.length=" + prefixColData.length);
            }
            doPrefix = true;
        }
        if (tHead == null) {
            cols = tData.get(0).size();
            tHead = new ArrayList<String>();
            for (int c3 = 0; c3 < cols; ++c3) {
                tableHead.add("dummy-" + (c3 + 1));
            }
        }
        cols = tHead.size();
        if (firstRow < 0) {
            firstRow = 0;
        }
        if (lastRow < 0) {
            lastRow = tData.size();
        }
        int copiedRows = 0;
        if (doPrefix) {
            for (c2 = 0; c2 < prefixColName.length; ++c2) {
                tableHead.add(prefixColName[c2]);
            }
        }
        for (c2 = 0; c2 < cols; ++c2) {
            tableHead.add(tHead.get(c2));
        }
        for (int r = firstRow; r < lastRow; ++r) {
            if (justRowNumbers != null) {
                boolean addThisRow = false;
                for (int a = 0; a < justRowNumbers.length; ++a) {
                    if (r != justRowNumbers[a]) continue;
                    addThisRow = true;
                    break;
                }
                if (!addThisRow) continue;
            }
            ArrayList<Object> row = new ArrayList<Object>();
            if (doPrefix) {
                for (int c4 = 0; c4 < prefixColData.length; ++c4) {
                    row.add(prefixColData[c4]);
                }
            }
            List<Object> dataRow = tData.get(r);
            for (c = 0; c < cols; ++c) {
                Object obj = dataRow.get(c);
                if (obj != null && obj instanceof String) {
                    String str = (String)obj;
                    if (stripHtml) {
                        str = StringUtil.stripHtml(str);
                    }
                    while (str.endsWith("\r") || str.endsWith("\n")) {
                        str = str.substring(0, str.length() - 1);
                    }
                    if (str.indexOf(9) >= 0) {
                        str = str.replace("\t", "        ");
                    }
                    obj = str.indexOf(13) >= 0 || str.indexOf(10) >= 0 ? str.split(REGEXP_NEW_LINE) : str;
                }
                if (obj == null) {
                    obj = nullValue;
                }
                row.add(obj);
            }
            tableData.add(row);
            ++copiedRows;
        }
        if (doPrefix) {
            cols += prefixColName.length;
        }
        boolean tableHasMultiLineCells = false;
        int[] colLength = new int[cols];
        int[][] rowColCellLineCount = new int[copiedRows][cols];
        for (c = 0; c < cols; ++c) {
            int maxLen = 0;
            String cellName = (String)tableHead.get(c);
            maxLen = Math.max(maxLen, cellName.length());
            for (int r = 0; r < copiedRows; ++r) {
                cellObj = ((List)tableData.get(r)).get(c);
                cellStr = cellObj == null ? "" : cellObj.toString();
                rowColCellLineCount[r][c] = 0;
                if (cellObj instanceof String[]) {
                    sa = (String[])cellObj;
                    tableHasMultiLineCells = true;
                    rowColCellLineCount[r][c] = sa.length;
                    for (int l = 0; l < sa.length; ++l) {
                        maxLen = Math.max(maxLen, sa[l].length());
                    }
                    continue;
                }
                maxLen = Math.max(maxLen, cellStr.length());
            }
            colLength[c] = maxLen;
        }
        for (c = 0; c < cols; ++c) {
            String line = StringUtil.replicate(lineSpace, colLength[c]);
            sb.append(colSepOther).append(line);
        }
        sb.append(colSepOther).append(newLine);
        for (c = 0; c < cols; ++c) {
            String cellName = (String)tableHead.get(c);
            String data = StringUtil.fill(cellName, colLength[c]);
            sb.append(colSepData).append(data);
        }
        sb.append(colSepData).append(newLine);
        for (c = 0; c < cols; ++c) {
            String line = StringUtil.replicate(lineSpace, colLength[c]);
            sb.append(colSepOther).append(line);
        }
        sb.append(colSepOther).append(newLine);
        for (int r = 0; r < copiedRows; ++r) {
            int c5;
            int maxCellLineCountOnThisRow = 0;
            for (c5 = 0; c5 < cols; ++c5) {
                maxCellLineCountOnThisRow = Math.max(maxCellLineCountOnThisRow, rowColCellLineCount[r][c5]);
            }
            if (tableHasMultiLineCells && r > 0) {
                for (c5 = 0; c5 < cols; ++c5) {
                    String line = StringUtil.replicate(lineSpace, colLength[c5]);
                    sb.append(colSepOther).append(line);
                }
                sb.append(colSepOther).append(newLine);
            }
            if (maxCellLineCountOnThisRow == 0) {
                for (c5 = 0; c5 < cols; ++c5) {
                    Object cellObj2 = ((List)tableData.get(r)).get(c5);
                    String cellStr2 = cellObj2 == null ? "" : cellObj2.toString();
                    String data = StringUtil.fill(cellStr2, colLength[c5]);
                    sb.append(colSepData).append(data);
                }
                sb.append(colSepData).append(newLine);
                continue;
            }
            for (int l = 0; l < maxCellLineCountOnThisRow; ++l) {
                for (int c6 = 0; c6 < cols; ++c6) {
                    String data;
                    cellObj = ((List)tableData.get(r)).get(c6);
                    String string = cellStr = cellObj == null ? "" : cellObj.toString();
                    if (l == 0) {
                        if (cellObj instanceof String[]) {
                            sa = (String[])cellObj;
                            cellStr = sa[0];
                        }
                        data = StringUtil.fill(cellStr, colLength[c6]);
                        sb.append(colSepData).append(data);
                        continue;
                    }
                    if (cellObj instanceof String[]) {
                        sa = (String[])cellObj;
                        cellStr = "";
                        if (l < sa.length) {
                            cellStr = sa[l];
                        }
                    } else {
                        cellStr = "";
                    }
                    data = StringUtil.fill(cellStr, colLength[c6]);
                    sb.append(colSepData).append(data);
                }
                sb.append(colSepData).append(newLine);
            }
        }
        for (c = 0; c < cols; ++c) {
            String line = StringUtil.replicate(lineSpace, colLength[c]);
            sb.append(colSepOther).append(line);
        }
        sb.append(colSepOther).append(newLine);
        sb.append("Rows ").append(copiedRows).append(newLine);
        return sb.toString();
    }

    public static String exceptionToString(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public static String stackTraceToString(StackTraceElement[] stea) {
        StringBuilder sb = new StringBuilder();
        String PREFIX = "\tat ";
        String NEW_LINE = System.getProperty("line.separator");
        sb.append(NEW_LINE);
        for (StackTraceElement ste : stea) {
            sb.append(PREFIX);
            sb.append(ste);
            sb.append(NEW_LINE);
        }
        return sb.toString();
    }

    public static String toStr(Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.toString();
    }

    public static String toStr(Object obj, Map<String, String> trMap) {
        String str = StringUtil.toStr(obj);
        if (str.equals("")) {
            return str;
        }
        if (trMap != null) {
            for (Map.Entry<String, String> entry : trMap.entrySet()) {
                str = str.replace(entry.getKey(), entry.getValue());
            }
        }
        return str;
    }

    public static String format(String format, Object ... args) {
        return String.format(format, args);
    }

    public static String quotify(Object obj, String leftQuote, String rightQuote) {
        if (obj == null) {
            return null;
        }
        boolean addQuotes = false;
        if (obj instanceof String) {
            addQuotes = true;
        } else if (obj instanceof Date) {
            addQuotes = true;
        }
        if (!addQuotes) {
            return obj.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(leftQuote).append(obj).append(rightQuote);
        return sb.toString();
    }

    public static String quotify(Object obj) {
        return StringUtil.quotify(obj, "'", "'");
    }

    public static String quotify(Object obj, String quoteStr) {
        return StringUtil.quotify(obj, quoteStr, quoteStr);
    }

    public static String stripAllNonAlphaNum(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("[^a-zA-Z0-9]", "");
    }

    public static String fixNull(String input, String replacement) {
        if (input == null) {
            return replacement;
        }
        return input;
    }

    public static boolean startsWithIgnoreBlankIgnoreCase(String str, String prefix) {
        int startPos;
        if (str == null || prefix == null) {
            return str == null && prefix == null;
        }
        if (prefix.length() > str.length()) {
            return false;
        }
        for (startPos = 0; startPos < str.length() && Character.isWhitespace(str.charAt(startPos)); ++startPos) {
        }
        return str.regionMatches(true, startPos, prefix, 0, prefix.length());
    }

    public static String substringBeforeIgnoreCase(String str, String separator) {
        if (StringUtils.isEmpty((CharSequence)str) || separator == null) {
            return str;
        }
        if (separator.isEmpty()) {
            return "";
        }
        int pos = StringUtils.indexOfIgnoreCase((CharSequence)str, (CharSequence)separator);
        if (pos == -1) {
            return str;
        }
        return str.substring(0, pos);
    }

    public static String substringBetweenTwoChars(String input, String startChar, String endChar) {
        if (StringUtil.isNullOrBlank(input)) {
            return null;
        }
        if (startChar == null || endChar == null) {
            return null;
        }
        int start = input.indexOf(startChar);
        if (start != -1) {
            int end = input.indexOf(endChar, start + startChar.length());
            if (end != -1) {
                return input.substring(start + startChar.length(), end);
            }
            if (" ".equals(endChar)) {
                return input.substring(start + startChar.length());
            }
        }
        return null;
    }

    public static String truncate(String str, int maxLen, boolean ellipseAtEnd, String logMessage) {
        if (str == null) {
            return null;
        }
        if (maxLen > 0 && str.length() > maxLen) {
            if (StringUtil.hasValue(logMessage)) {
                logMessage = logMessage.replace("${maxlen}", "" + maxLen);
                RuntimeException rte = new RuntimeException(logMessage);
                _logger.warn("Truncated a to long string. MaxLenth=" + maxLen + ", PassedStrLength=" + str.length() + ". User message=|" + logMessage + "|. PassedStr=|" + str + "|", (Throwable)rte);
            }
            if (ellipseAtEnd) {
                return str.substring(0, maxLen - 3) + "...";
            }
            return str.substring(0, maxLen);
        }
        return str;
    }

    public static List<String> readLines(String inStr) {
        return StringUtil.readLines(inStr, true, true);
    }

    public static List<String> readLines(String inStr, boolean doTrim, boolean skipEmpty) {
        ArrayList<String> list = new ArrayList<String>();
        try (Scanner scanner = new Scanner(inStr);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (doTrim) {
                    line = line.trim();
                }
                if (skipEmpty && line.isEmpty()) continue;
                list.add(line);
            }
        }
        return list;
    }

    public static boolean matchesAny(String input, Collection<String> regExList) {
        if (input == null) {
            return false;
        }
        if (regExList == null) {
            return false;
        }
        if (regExList.isEmpty()) {
            return false;
        }
        for (String regex : regExList) {
            if (!input.matches(regex)) continue;
            return true;
        }
        return false;
    }

    public static String parseMailFromAddress_getEmailAddress(String input) {
        return StringUtil.parseMailFromAddress(input, 1);
    }

    public static String parseMailFromAddress_getDisplayName(String input) {
        return StringUtil.parseMailFromAddress(input, 2);
    }

    public static String parseMailFromAddress(String input, int type) {
        if (StringUtil.isNullOrBlank(input)) {
            return input;
        }
        if (type < 1 && type > 2) {
            throw new RuntimeException("Known output types is 1 or 2, you specified: " + type);
        }
        String emailAddress = null;
        String displayName = null;
        int firstPos = input.indexOf(60);
        int lastPos = input.lastIndexOf(62);
        if (firstPos > 0 && lastPos > 0) {
            emailAddress = input.substring(0, firstPos).trim();
            displayName = input.substring(firstPos + 1, lastPos).trim();
        } else {
            emailAddress = input;
            displayName = null;
        }
        if (type == 1) {
            return emailAddress;
        }
        if (type == 2) {
            return displayName;
        }
        throw new RuntimeException("Known output types is 1 or 2, you specified: " + type);
    }

    public static String addPrefix(String prefix, String inputStr, boolean always) {
        if (prefix == null || inputStr == null) {
            return null;
        }
        if (!always && !inputStr.contains("\n")) {
            return inputStr;
        }
        boolean endsWithNewLine = inputStr.endsWith("\n") || inputStr.endsWith("\r\n");
        StringBuilder sb = new StringBuilder();
        try (BufferedReader bufReader = new BufferedReader(new StringReader(inputStr));){
            String line = null;
            while ((line = bufReader.readLine()) != null) {
                sb.append(prefix).append(line).append("\n");
            }
            if (!endsWithNewLine && sb.length() > 1) {
                sb.deleteCharAt(sb.length() - 1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        String[] str;
        String[] htmlStrArr;
        System.out.println(StringUtil.addPrefix("xxx: ", null, false));
        System.out.println(StringUtil.addPrefix("xxx: ", "", false));
        System.out.println(StringUtil.addPrefix("xx1xx: ", "t1: test-no-newline", false));
        System.out.println(StringUtil.addPrefix("xx2xx: ", "t2: (with-NL-at-end) test-row-1\n", false));
        System.out.println(StringUtil.addPrefix("xx3xx: ", "t3: (no-NL-at-end) test-row-1\ntest-row-2\ntest-row-3", false));
        System.out.println(StringUtil.addPrefix("xx4xx: ", "t4: (with-NL-at-end) test-row-1\ntest-row-2\ntest-row-3\n", false));
        System.out.println("----end-test---");
        System.exit(0);
        System.out.println(StringUtil.substringBetweenTwoChars("Metadata: PartitionId = 0           Metadata: IndexId = 0               Metadata: ObjectId = 99", "Metadata: ObjectId = ", " "));
        System.out.println(StringUtil.substringBetweenTwoChars("Metadata: PartitionId = 0           Metadata: IndexId = 0               Metadata: ObjectId = 99", "Metadata: IndexId = ", " "));
        System.exit(0);
        System.out.println(StringUtil.parseMailFromAddress(null, 1) == null ? "OK-1" : "FAIL-1 - |" + StringUtil.parseMailFromAddress(null, 1) + "|");
        System.out.println(StringUtil.parseMailFromAddress("", 1).equals("") ? "OK-2" : "FAIL-2 - |" + StringUtil.parseMailFromAddress("", 1) + "|");
        System.out.println(StringUtil.parseMailFromAddress("a@x.com", 1).equals("a@x.com") ? "OK-3" : "FAIL-3 - |" + StringUtil.parseMailFromAddress("a@x.com", 1) + "|");
        System.out.println(StringUtil.parseMailFromAddress("a@x.com", 2) == null ? "OK-4" : "FAIL-4 - |" + StringUtil.parseMailFromAddress("a@x.com", 2) + "|");
        System.out.println(StringUtil.parseMailFromAddress("a@x.com <Xxx Yyy>", 1).equals("a@x.com") ? "OK-5" : "FAIL-5 - |" + StringUtil.parseMailFromAddress("a@x.com <Xxx Yyy>", 1) + "|");
        System.out.println(StringUtil.parseMailFromAddress("a@x.com <Xxx Yyy>", 2).equals("Xxx Yyy") ? "OK-6" : "FAIL-6 - |" + StringUtil.parseMailFromAddress("a@x.com <Xxx Yyy>", 2) + "|");
        System.exit(0);
        System.out.println(StringUtil.truncate(null, 10, true, null) == null ? "OK" : "FAIL - " + StringUtil.truncate(null, 10, true, null));
        System.out.println(StringUtil.truncate("123", 10, true, null).equals("123") ? "OK" : "FAIL - " + StringUtil.truncate("123", 10, true, null));
        System.out.println(StringUtil.truncate("123456789-", 10, true, null).equals("123456789-") ? "OK" : "FAIL - " + StringUtil.truncate("123456789-", 10, true, null));
        System.out.println(StringUtil.truncate("123456789-12345", 10, true, null).equals("1234567...") ? "OK" : "FAIL - " + StringUtil.truncate("123456789-12345", 10, true, null));
        System.out.println(StringUtil.truncate("123456789-12345", 10, false, null).equals("123456789-") ? "OK" : "FAIL - " + StringUtil.truncate("123456789-12345", 10, false, null));
        System.exit(0);
        System.out.println(StringUtil.startsWithIgnoreBlankIgnoreCase(null, null) ? "OK" : "FAIL");
        System.out.println(!StringUtil.startsWithIgnoreBlankIgnoreCase(null, "abc") ? "OK" : "FAIL");
        System.out.println(!StringUtil.startsWithIgnoreBlankIgnoreCase("abcdef", null) ? "OK" : "FAIL");
        System.out.println(StringUtil.startsWithIgnoreBlankIgnoreCase("abcdef", "abc") ? "OK" : "FAIL");
        System.out.println(StringUtil.startsWithIgnoreBlankIgnoreCase("ABCDEF", "abc") ? "OK" : "FAIL");
        System.out.println(StringUtil.startsWithIgnoreBlankIgnoreCase("  abcdef", "abc") ? "OK" : "FAIL");
        System.out.println(StringUtil.startsWithIgnoreBlankIgnoreCase("  ABCDEF", "abc") ? "OK" : "FAIL");
        System.exit(0);
        System.setProperty("DBXTUNE_ALARM_SOURCE_DIR", "-dbxtune-alarm-source-dir-");
        System.setProperty("DBXTUNE_HOME", "-dbxtune-home-");
        System.out.println("envVariableSubstitution: ${DBXTUNE_ALARM_SOURCE_DIR:-${DBXTUNE_HOME}}/resources/alarm-handler-src = |" + StringUtil.envVariableSubstitution("${DBXTUNE_ALARM_SOURCE_DIR:-${DBXTUNE_HOME}}/resources/alarm-handler-src") + "|");
        System.setProperty("XXX", "-xxx-");
        System.setProperty("YYY", "-yyy-");
        System.out.println("envVariableSubstitution: ${XXX} = |" + StringUtil.envVariableSubstitution("${XXX}") + "|");
        System.out.println("envVariableSubstitution: ${YYY} = |" + StringUtil.envVariableSubstitution("${YYY}") + "|");
        System.out.println("envVariableSubstitution: ${ZZZ} = |" + StringUtil.envVariableSubstitution("${ZZZ}") + "|");
        System.out.println("envVariableSubstitution: ${ZZZ:-} = |" + StringUtil.envVariableSubstitution("${ZZZ:-}") + "|");
        System.out.println("envVariableSubstitution: ${XXX:-${YYY}} = |" + StringUtil.envVariableSubstitution("${XXX:-${YYY}}") + "|");
        System.out.println("envVariableSubstitution: ${AAA:-${BBB}} = |" + StringUtil.envVariableSubstitution("${AAA:-${BBB}}") + "|");
        System.exit(0);
        System.out.println("stripHtmlStartEnd(): |" + StringUtil.stripHtmlStartEnd("<html>12345</html>") + "|");
        System.out.println("stripHtmlStartEnd(): |" + StringUtil.stripHtmlStartEnd("<html> 1 2 3 4 5 </html>") + "|");
        System.exit(0);
        System.out.println("ltrim(): |" + StringUtil.ltrim(" 1 2 3 4 5 ") + "|");
        System.out.println("rtrim(): |" + StringUtil.rtrim(" 1 2 3 4 5 ") + "|");
        System.exit(0);
        System.out.println("splitOnCommasAllowQuotes(): " + StringUtil.toCommaStr(StringUtil.splitOnCommasAllowQuotes("string='',str='x,y',str3='''', int=99,int=null", true, false), "|"));
        System.out.println("splitOnCommasAllowQuotes(): " + StringUtil.toCommaStr(StringUtil.splitOnCommasAllowQuotes("1,2,'a,b,c', 'it''s true 2sq'''''", true, false), "|"));
        System.out.println("unquote(): " + StringUtil.unquote("'it''s 2 single-quotes'''''"));
        System.exit(0);
        System.out.println("countLines():" + StringUtil.countLines("one"));
        System.out.println("countLines():" + StringUtil.countLines("1 \n 2 \r\n 3 \r 4 \n 5"));
        System.exit(0);
        System.out.println("TEST 1-1: " + (StringUtil.indexOfEndBrace("abc ( 123 4 5 6 7 ) xxx", 0, ')') == -1 ? "OK" : "FAIL"));
        System.out.println("TEST 1-2: " + (StringUtil.indexOfEndBrace("abc ( 123 4 5 6 7 ) xxx", 5, ')') != -1 ? "OK" : "FAIL"));
        System.out.println("TEST 1-3: " + (StringUtil.indexOfEndBrace("abc ( 123 4 5 6 7 ] xxx", 5, ')') == -1 ? "OK" : "FAIL"));
        System.out.println("TEST 1-4: " + (StringUtil.indexOfEndBrace("abc ( 123 4 5 ( 6 7 ) xxx", 5, ')') == -1 ? "OK" : "FAIL"));
        System.out.println("TEST 1-5: " + (StringUtil.indexOfEndBrace("abc 123 4 5 6 7 ) xxx", 0, ')') != -1 ? "OK" : "FAIL"));
        System.out.println("TEST 1-6: " + (StringUtil.indexOfEndBrace("abc)", 0, ')') == 3 ? "OK" : "FAIL"));
        System.exit(0);
        for (String s : htmlStrArr = new String[]{"a<>bc", "<html>a<b>b</b>c</html>", "abc,"}) {
            System.out.println("str1='" + StringUtil.stripHtml(s) + "'.");
        }
        System.exit(0);
        for (String s : str = new String[]{"abc", "abc ", "abc,", "abc, ", "abc,\t", "abc,\n", "abc,\t\t", "abc,\n\n", "abc,\t\n"}) {
            System.out.println("str1='" + StringUtil.removeLastComma(s) + "'.");
        }
        System.exit(0);
        String[] strArr = StringUtil.commaStrToArray("");
        System.out.println("length=" + strArr.length);
        for (int i = 0; i < strArr.length; ++i) {
            System.out.println("arr[" + i + "]='" + strArr[i] + "'.");
        }
        System.exit(0);
        System.out.println("MAP=|" + StringUtil.parseCommaStrToMap("aaa=11\\,11,bbbbb=2222, cccc=3333") + "|.");
        System.out.println("MAP=|" + StringUtil.parseCommaStrToMap("{aaa=1111,bbbbb=2222, cccc=3333}") + "|.");
        System.out.println("MAP=|" + StringUtil.parseCommaStrToMap("{aaa=1111, bbbbb=2222, cccc=3333,}") + "|.");
        String t1Str = "{aaa=1111, bbb=2222, bbb=3333,}";
        Map<String, List<String>> t1Map = StringUtil.parseCommaStrToMultiMap(t1Str);
        System.out.println("MMAP=|" + t1Map + "|.");
        System.out.println("MMAP.toCommaStrMultiMap=|" + StringUtil.toCommaStrMultiMap(t1Map) + "|.");
        System.out.println("MMAP.toCommaStrMultiMap(useKey)=|" + StringUtil.toCommaStrMultiMap(t1Map, "=", ",", true, false) + "|.");
        System.out.println("MMAP.toCommaStrMultiMap(useVal)=|" + StringUtil.toCommaStrMultiMap(t1Map, "=", ",", false, true) + "|.");
        System.out.println("MMAP.toCommaStrMultiMapKey=|" + StringUtil.toCommaStrMultiMapKey(t1Map) + "|.");
        System.out.println("MMAP.toCommaStrMultiMapVal=|" + StringUtil.toCommaStrMultiMapVal(t1Map) + "|.");
        System.out.println("TEST: StringUtil BEGIN.");
        if (!StringUtil.lastWord(" 1 2 3 ").equals("3")) {
            System.out.println("FAILED:  test-1: StringUtil.lastWord()");
        }
        if (!StringUtil.lastWord("").equals("")) {
            System.out.println("FAILED:  test-2: StringUtil.lastWord()");
        }
        if (!StringUtil.lastWord(" 1 2\t 3 ").equals("3")) {
            System.out.println("FAILED:  test-3: StringUtil.lastWord()");
        }
        if (!StringUtil.lastWord(" 1 2 \n3").equals("3")) {
            System.out.println("FAILED:  test-4: StringUtil.lastWord()");
        }
        if (!StringUtil.left("123", 5).equals("123  ")) {
            System.out.println("FAILED:  test-1: StringUtil.left()");
        }
        if (!StringUtil.right("  123", 5).equals("  123")) {
            System.out.println("FAILED:  test-1: StringUtil.right()");
        }
        if (StringUtil.fill("123", 1).length() != 3) {
            System.out.println("FAILED:  test-1: StringUtil.fill()");
        }
        if (StringUtil.fill("123", 50).length() != 50) {
            System.out.println("FAILED:  test-2: StringUtil.fill(\"123\", 50)");
        }
        if (StringUtil.fill("123", 5000).length() != 5000) {
            System.out.println("FAILED:  test-3: StringUtil.fill(\"123\", 5000)");
        }
        if (StringUtil.stripHtml("123<html>-<b>B</b>.<xml xx=xxx, z=z>").indexOf("<") != -1) {
            System.out.println("FAILED:  test-1: StringUtil.stripHtml()");
        }
        System.out.println("TEST: StringUtil END.");
    }
}

