/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc4.tds;

import com.sybase.jdbc4.tds.TdsInputStream;
import com.sybase.jdbc4.tds.Token;
import java.io.IOException;

public class Slurp
extends Token {
    public Slurp(TdsInputStream tdsInputStream, int n) throws IOException {
        try {
            int n2 = this.getLength(tdsInputStream, n);
            tdsInputStream.skipBytes(n2);
        }
        catch (IOException iOException) {
            Slurp.readSQE(iOException);
        }
    }

    public Slurp() {
    }

    public int getLength(TdsInputStream tdsInputStream, int n) throws IOException {
        int n2 = 0;
        try {
            if ((n & 0xE0) == 192) {
                n2 = 0;
            } else if ((n & 0x30) == 48) {
                switch (n & 0xC) {
                    case 0: {
                        n2 = 1;
                        break;
                    }
                    case 4: {
                        n2 = 2;
                        break;
                    }
                    case 8: {
                        n2 = 4;
                        break;
                    }
                    case 12: {
                        n2 = 8;
                    }
                }
            } else {
                switch (n & 0xFC) {
                    case 36: 
                    case 40: 
                    case 100: 
                    case 104: {
                        n2 = tdsInputStream.readUnsignedByte();
                        break;
                    }
                    case 32: 
                    case 96: {
                        n2 = tdsInputStream.readInt();
                        break;
                    }
                    default: {
                        n2 = tdsInputStream.readUnsignedShort();
                    }
                }
            }
        }
        catch (IOException iOException) {
            Slurp.readSQE(iOException);
        }
        return n2;
    }
}

