/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.jdbc.ParamManager;
import com.sybase.jdbc42.jdbc.SybProperty;
import com.sybase.jdbc42.tds.MsgToken;
import com.sybase.jdbc42.tds.Tds;
import com.sybase.jdbc42.tds.TdsDataOutputStream;
import com.sybase.jdbc42.tds.TdsJdbcInputStream;
import com.sybase.jdbc42.tds.TdsProtocolContext;
import java.io.IOException;
import java.sql.SQLException;

public class HASessionContext {
    private byte[] _haSessionID = new byte[6];
    private int _haLogin = 0;
    private boolean _haRequested = false;
    private boolean _supportsRedirect = false;
    private boolean _failover = false;
    private Tds _protocol = null;

    protected HASessionContext(SybProperty sybProperty, Tds tds) throws SQLException {
        this._haRequested = sybProperty.getBoolean(34) || sybProperty.getBoolean(72);
        this._supportsRedirect = sybProperty.getBoolean(71);
        this._protocol = tds;
        this._failover = false;
        if (this._haRequested) {
            this._haLogin |= 1;
        }
        if (this._supportsRedirect) {
            this._haLogin |= 8;
        }
    }

    public boolean wasHARequested() {
        return this._haRequested;
    }

    public boolean isInFailoverMode() {
        return this._failover;
    }

    public byte[] getSessionID() {
        return this._haSessionID;
    }

    public int getLogin() {
        return this._haLogin;
    }

    protected boolean isMigrating() {
        return (this._haLogin & 0x10) != 0;
    }

    protected void setFailoverMode(boolean bl) {
        this._failover = bl;
    }

    protected void setHALogin(int n) {
        this._haLogin = n;
    }

    protected void readSessionID(TdsProtocolContext tdsProtocolContext, MsgToken msgToken) throws IOException, SQLException {
        this._protocol.nextResult(tdsProtocolContext);
        int n = tdsProtocolContext._in.readUnsignedByte();
        TdsJdbcInputStream tdsJdbcInputStream = new TdsJdbcInputStream(null, tdsProtocolContext, this._protocol);
        tdsJdbcInputStream._dataFmt = tdsProtocolContext._paramFmts.getDataFormat(0);
        byte[] byArray = tdsJdbcInputStream.getBytes();
        if (this.getLogin() != 7 || this.getLogin() == 1 && !this.isInFailoverMode()) {
            System.arraycopy(byArray, 0, this._haSessionID, 0, 6);
        }
        tdsProtocolContext._lastResult = -1;
        this._protocol.nextResult(tdsProtocolContext);
    }

    protected void acknowledgeSessionID(TdsDataOutputStream tdsDataOutputStream, TdsProtocolContext tdsProtocolContext) throws SQLException, IOException {
        MsgToken msgToken = new MsgToken(1, 12);
        ParamManager paramManager = new ParamManager(1, tdsProtocolContext);
        paramManager.setParam(1, -3, (Object)new byte[0], 0);
        msgToken.send(tdsDataOutputStream);
        this._protocol.sendParamStream(paramManager, tdsDataOutputStream);
        tdsDataOutputStream.flush();
    }
}

