/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.jdbc.ErrorMessage;
import com.sybase.jdbc42.utils.Debug;
import java.io.CharConversionException;
import java.io.DataOutput;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;

public abstract class TdsOutputStream
extends FilterOutputStream
implements DataOutput {
    protected byte[] _numbuf = new byte[]{0, 0, 0, 0, 0, 0, 0, 0};
    protected static final int LOW_BYTE = 255;
    protected static final long D_LOW_BYTE = 255L;
    private boolean _byteswap = false;

    public TdsOutputStream(OutputStream outputStream) throws IOException {
        super(outputStream);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    @Override
    public void write(int n) throws IOException {
        this.out.write(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.out.write(byArray, 0, byArray.length);
    }

    @Override
    public final void writeBoolean(boolean bl) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    @Override
    public final void writeUTF(String string) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    @Override
    public final void writeChar(int n) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    @Override
    public final void writeBytes(String string) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    @Override
    public final void writeChars(String string) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    @Override
    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    public void setBigEndian(boolean bl) {
        this._byteswap = !bl;
    }

    public boolean getBigEndian() {
        return !this._byteswap;
    }

    @Override
    public final void writeShort(int n) throws IOException {
        if (this._byteswap) {
            this._numbuf[1] = (byte)(n >>> 8 & 0xFF);
            this._numbuf[0] = (byte)(n >>> 0 & 0xFF);
        } else {
            this._numbuf[0] = (byte)(n >>> 8 & 0xFF);
            this._numbuf[1] = (byte)(n >>> 0 & 0xFF);
        }
        this.write(this._numbuf, 0, 2);
    }

    @Override
    public final void writeInt(int n) throws IOException {
        if (this._byteswap) {
            this._numbuf[3] = (byte)(n >>> 24 & 0xFF);
            this._numbuf[2] = (byte)(n >>> 16 & 0xFF);
            this._numbuf[1] = (byte)(n >>> 8 & 0xFF);
            this._numbuf[0] = (byte)(n >>> 0 & 0xFF);
        } else {
            this._numbuf[0] = (byte)(n >>> 24 & 0xFF);
            this._numbuf[1] = (byte)(n >>> 16 & 0xFF);
            this._numbuf[2] = (byte)(n >>> 8 & 0xFF);
            this._numbuf[3] = (byte)(n >>> 0 & 0xFF);
        }
        this.write(this._numbuf, 0, 4);
    }

    public final void writeLongAsUnsignedInt(long l) throws IOException {
        if (this._byteswap) {
            this._numbuf[3] = (byte)(l >>> 24 & 0xFFL);
            this._numbuf[2] = (byte)(l >>> 16 & 0xFFL);
            this._numbuf[1] = (byte)(l >>> 8 & 0xFFL);
            this._numbuf[0] = (byte)(l >>> 0 & 0xFFL);
        } else {
            this._numbuf[0] = (byte)(l >>> 24 & 0xFFL);
            this._numbuf[1] = (byte)(l >>> 16 & 0xFFL);
            this._numbuf[2] = (byte)(l >>> 8 & 0xFFL);
            this._numbuf[3] = (byte)(l >>> 0 & 0xFFL);
        }
        this.write(this._numbuf, 0, 4);
    }

    @Override
    public final void writeLong(long l) throws IOException {
        if (this._byteswap) {
            this._numbuf[7] = (byte)((int)(l >>> 56) & 0xFF);
            this._numbuf[6] = (byte)((int)(l >>> 48) & 0xFF);
            this._numbuf[5] = (byte)((int)(l >>> 40) & 0xFF);
            this._numbuf[4] = (byte)((int)(l >>> 32) & 0xFF);
            this._numbuf[3] = (byte)((int)(l >>> 24) & 0xFF);
            this._numbuf[2] = (byte)((int)(l >>> 16) & 0xFF);
            this._numbuf[1] = (byte)((int)(l >>> 8) & 0xFF);
            this._numbuf[0] = (byte)((int)(l >>> 0) & 0xFF);
        } else {
            this._numbuf[0] = (byte)((int)(l >>> 56) & 0xFF);
            this._numbuf[1] = (byte)((int)(l >>> 48) & 0xFF);
            this._numbuf[2] = (byte)((int)(l >>> 40) & 0xFF);
            this._numbuf[3] = (byte)((int)(l >>> 32) & 0xFF);
            this._numbuf[4] = (byte)((int)(l >>> 24) & 0xFF);
            this._numbuf[5] = (byte)((int)(l >>> 16) & 0xFF);
            this._numbuf[6] = (byte)((int)(l >>> 8) & 0xFF);
            this._numbuf[7] = (byte)((int)(l >>> 0) & 0xFF);
        }
        this.write(this._numbuf, 0, 8);
    }

    @Override
    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    @Override
    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final int size() {
        return -1;
    }

    public void writeString(String string) throws IOException {
        throw new IOException("Not a supported TDS type");
    }

    public void writeStringLen(String string, int n) throws IOException {
        int n2 = 0;
        if (string != null) {
            byte[] byArray = this.toBytes(string);
            n2 = byArray.length;
            if (n2 > n) {
                ErrorMessage.raiseIOException("JZ0TS", string);
            }
            this.write(byArray);
        }
        for (int i = n2; i < n; ++i) {
            this.write(0);
        }
        this.write(n2);
    }

    public byte[] stringToByte(String string) throws IOException {
        try {
            return this.toBytes(string);
        }
        catch (CharConversionException charConversionException) {
            ErrorMessage.raiseIOException("JZ0I6", charConversionException.toString(), charConversionException);
            Debug.asrt(null, false);
            return null;
        }
    }

    public final byte[] intToBytes(int n) {
        if (this._byteswap) {
            this._numbuf[3] = (byte)(n >>> 24 & 0xFF);
            this._numbuf[2] = (byte)(n >>> 16 & 0xFF);
            this._numbuf[1] = (byte)(n >>> 8 & 0xFF);
            this._numbuf[0] = (byte)(n >>> 0 & 0xFF);
        } else {
            this._numbuf[0] = (byte)(n >>> 24 & 0xFF);
            this._numbuf[1] = (byte)(n >>> 16 & 0xFF);
            this._numbuf[2] = (byte)(n >>> 8 & 0xFF);
            this._numbuf[3] = (byte)(n >>> 0 & 0xFF);
        }
        return this._numbuf;
    }

    protected abstract byte[] toBytes(String var1) throws CharConversionException;

    protected int getStringByteLen(String string) throws IOException {
        return string == null ? 0 : this.toBytes(string).length;
    }

    public abstract String getCharset();

    public final void writeBigDecimalAsUnsignedBigInt(BigDecimal bigDecimal) throws IOException {
        BigDecimal bigDecimal2 = bigDecimal;
        BigDecimal bigDecimal3 = new BigDecimal("256");
        if (this._byteswap) {
            for (int i = 0; i < 8; ++i) {
                BigDecimal[] bigDecimalArray = bigDecimal2.divideAndRemainder(bigDecimal3);
                bigDecimal2 = bigDecimalArray[0];
                this._numbuf[i] = bigDecimalArray[1].toBigInteger().byteValue();
            }
        } else {
            for (int i = 7; i >= 0; --i) {
                BigDecimal[] bigDecimalArray = bigDecimal2.divideAndRemainder(bigDecimal3);
                bigDecimal2 = bigDecimalArray[0];
                this._numbuf[i] = bigDecimalArray[1].toBigInteger().byteValue();
            }
        }
        this.write(this._numbuf, 0, 8);
    }
}

