/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.tds;

import com.sybase.jdbc42.jdbc.ErrorMessage;
import com.sybase.jdbc42.jdbc.Protocol;
import com.sybase.jdbc42.jdbc.ProtocolResultSet;
import com.sybase.jdbc42.jdbc.SybResultSet;
import com.sybase.jdbc42.tds.AltFormatToken;
import com.sybase.jdbc42.tds.AltRowToken;
import com.sybase.jdbc42.tds.DoneToken;
import com.sybase.jdbc42.tds.PduInputFormatter;
import com.sybase.jdbc42.tds.RowFormat2Token;
import com.sybase.jdbc42.tds.RowFormatToken;
import com.sybase.jdbc42.tds.Tds;
import com.sybase.jdbc42.tds.TdsCursor;
import com.sybase.jdbc42.tds.TdsDataInputStream;
import com.sybase.jdbc42.tds.TdsEventContext;
import com.sybase.jdbc42.tds.TdsInputStream;
import com.sybase.jdbc42.tds.TdsMigrateContext;
import com.sybase.jdbc42.tds.TdsParamSet;
import com.sybase.jdbc42.tds.TdsResultSet;
import com.sybase.jdbc42.tds.TdsScrollResultSet;
import com.sybase.jdbc42.tds.Token;
import com.sybase.jdbc42.timedio.InStreamMgr;
import com.sybase.jdbc42.timedio.OutStreamMgr;
import com.sybase.jdbc42.timedio.StreamContext;
import com.sybase.jdbc42.utils.BufferInterval;
import com.sybase.jdbc42.utils.CacheManager;
import com.sybase.jdbc42.utils.SyncObj;
import java.io.IOException;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;

public class TdsProtocolContext
extends StreamContext {
    private static volatile long _logIdCounter = 0L;
    private String _logId = null;
    protected static final int COLUMN_CHUNK_SIZE = 256;
    protected static final int LOW_BYTE = 255;
    protected static final int DONE_PACKET_SIZE = 17;
    protected static final int PDU_TAIL_SIZE = 8;
    protected Token _tdsToken;
    protected boolean _haveDone;
    protected int _lastResult;
    protected int _ungotResult;
    protected int _maxRows;
    protected int _lastTds;
    protected RowFormatToken _paramFmts;
    protected RowFormatToken _paramFmtsForEed;
    protected RowFormatToken _paramFmtsForEvent;
    protected RowFormatToken _dynamicFmts;
    protected boolean _rereadable;
    protected TdsResultSet _trs;
    protected TdsResultSet _trsForEed;
    protected TdsResultSet _trsForEvent;
    protected TdsResultSet _trsForMsg;
    protected CacheManager _cm;
    protected PduInputFormatter _inFormat;
    protected TdsDataInputStream _in;
    public SQLException _chainedSqe;
    protected boolean _eed = false;
    protected boolean _event = false;
    protected boolean _msg = false;
    protected TdsCursor _cursor;
    boolean _bigEndian = true;
    private byte[] _endOfLastPDU = null;
    protected List<RowFormatToken> _listRowFmtTok = new LinkedList<RowFormatToken>();
    protected List<TdsResultSet> _listResultSet = new LinkedList<TdsResultSet>();
    protected int _rowFmtIndex = 0;
    protected int _previousCount = 0;
    protected int _crcCount = 0;
    protected List<AltFormatToken> _altFormatTokens;
    protected AltRowToken _currentAltRow;
    private boolean _isSelectSql = false;

    public TdsProtocolContext(String string, Protocol protocol, InStreamMgr inStreamMgr, OutStreamMgr outStreamMgr) {
        super(string, protocol, inStreamMgr, outStreamMgr);
        this._logId = "Pc" + _logIdCounter++;
        this._inFormat = new PduInputFormatter(this);
        Tds tds = (Tds)protocol;
        try {
            this._in = new TdsDataInputStream(tds, this._inFormat);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._bigEndian = tds._bigEndian;
        this._in.setBigEndian(this._bigEndian);
        this._is = this._in;
        this.clear(true);
        this._pduState = 0;
    }

    @Override
    public void drop() {
        this.close(true);
        ((Tds)this._protocol).removeProtocolContext(this);
    }

    protected synchronized boolean isCancelNeeded() {
        if (this._state == 2) {
            return true;
        }
        this.cancelled();
        return false;
    }

    @Override
    protected synchronized void cancelled() {
        switch (this._state) {
            case 1: 
            case 4: {
                break;
            }
            case 2: 
            case 3: {
                this.setState(5);
            }
            case 5: 
            case 6: {
                this._responseQue.release();
            }
        }
    }

    @Override
    protected void beginRequest() {
        this.close(true);
        this._pduState = 5;
        if (this._state != 4) {
            this.setState(2);
        }
        if (this._timeout > 0) {
            this._requestStartTime = System.currentTimeMillis();
        }
        this._rowFmtIndex = 0;
        this._paramFmts = this._dynamicFmts;
    }

    @Override
    protected void close(boolean bl) {
        SQLException sQLException = this._chainedSqe;
        this._inFormat.close();
        this.clear(bl);
        this._chainedSqe = sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected BufferInterval queueData(BufferInterval bufferInterval) {
        this._pduState = 1;
        int n = bufferInterval._offset;
        int n2 = bufferInterval._length;
        byte[] byArray = bufferInterval._buf;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n2 > 0) {
            int n6 = n;
            if (this._state == 5) {
                this._pduState = 0;
                this._responseQue.release();
                break;
            }
            if (n2 < 8) {
                this._pduState = 2;
                break;
            }
            n6 = n;
            n3 = byArray[n6++] & 0xFF;
            n4 = byArray[n6++] & 0xFF;
            if (n2 >= (n5 = ((byArray[n6++] & 0xFF) << 8) + (0xFF & byArray[n6++]))) {
                n2 -= n5;
                n += n5;
            } else {
                this._pduState = 2;
                break;
            }
            if (this.checkBufType(n3) || this.checkBufStat(n4)) break;
            boolean bl = (n4 & 1) != 0;
            boolean bl2 = false;
            boolean bl3 = false;
            TdsProtocolContext tdsProtocolContext = this;
            synchronized (tdsProtocolContext) {
                if ((n4 & 2) != 0) {
                    bl = true;
                    bl3 = true;
                    if (this._state != 5 && this._state != 4) {
                        this.cancelled();
                    }
                }
                boolean bl4 = bl3;
                if (bl) {
                    int n7 = DoneToken.getStatusOffset(this._bigEndian);
                    if (n5 >= 9 - n7 && !bl4) {
                        bl4 = (byArray[n - 9 + n7] & 0x20) != 0;
                    }
                    Tds tds = (Tds)this._protocol;
                    if (this._state == 4) {
                        if (n5 < 17 && !bl3) {
                            if (this._endOfLastPDU == null) {
                                bl2 = true;
                            } else {
                                int n8 = 8 - (9 - (n5 - 8));
                                if (n8 + n7 < 8 && !bl3) {
                                    boolean bl5 = bl4 = (this._endOfLastPDU[n8 + n7] & 0x20) != 0;
                                }
                                if (bl4) {
                                    BufferInterval bufferInterval2 = this._inMgr.getBI();
                                    n6 = bufferInterval2._offset;
                                    bufferInterval2._buf[n6++] = (byte)(n3 & 0xFF);
                                    bufferInterval2._buf[n6++] = (byte)(n4 & 0xFF);
                                    bufferInterval2._buf[n6++] = 0;
                                    bufferInterval2._buf[n6++] = 17;
                                    bufferInterval2._buf[n6++] = 0;
                                    bufferInterval2._buf[n6++] = 0;
                                    bufferInterval2._buf[n6++] = 0;
                                    bufferInterval2._buf[n6++] = 0;
                                    int n9 = 8 - n8;
                                    System.arraycopy(this._endOfLastPDU, n8, bufferInterval2._buf, n6, n9);
                                    System.arraycopy(bufferInterval._buf, n - (9 - n9), bufferInterval2._buf, n6 += n9, 9 - n9);
                                    bufferInterval2._length = 17;
                                    if (bufferInterval.free()) {
                                        bufferInterval._buf = null;
                                    }
                                    bufferInterval = bufferInterval2;
                                    n5 = 17;
                                    this._endOfLastPDU = null;
                                }
                            }
                        } else if (n5 > 17 && bl4) {
                            n6 = n - 17;
                            byArray[n6++] = (byte)(n3 & 0xFF);
                            byArray[n6++] = (byte)(n4 & 0xFF);
                            byArray[n6++] = 0;
                            byArray[n6++] = 17;
                            BufferInterval bufferInterval3 = bufferInterval.divide(n5 - 17);
                            if (bufferInterval3.free()) {
                                bufferInterval3 = null;
                            }
                            n5 = 17;
                        }
                        if (!bl4) {
                            bl2 = true;
                        }
                    } else if (this._state == 6) {
                        this.setState(5);
                        bl2 = true;
                    } else {
                        if (bl4 && tds._gotCancelAck) {
                            BufferInterval bufferInterval4 = null;
                            if (n5 < bufferInterval._length) {
                                bufferInterval4 = bufferInterval.divide(n5);
                            } else {
                                bufferInterval4 = bufferInterval;
                                bufferInterval = null;
                            }
                            if (bufferInterval4.free()) {
                                bufferInterval4 = null;
                            }
                            break;
                        }
                        this.setState(3);
                    }
                    if (!(this instanceof TdsEventContext)) {
                        tds._gotCancelAck = bl4;
                    }
                } else {
                    if (this._state == 4) {
                        if (this._endOfLastPDU == null) {
                            this._endOfLastPDU = new byte[8];
                        }
                        System.arraycopy(bufferInterval._buf, bufferInterval._offset + n5 - 8, this._endOfLastPDU, 0, 8);
                    }
                    boolean bl6 = bl2 = this._state == 6 || this._state == 4;
                }
                if (bl && (this._state != 4 || bl4)) {
                    this._pduState = 0;
                    if (!(this instanceof TdsEventContext) && !(this instanceof TdsMigrateContext)) {
                        this._inMgr.setCurrentContextNull();
                    }
                }
                bufferInterval = this.makeChunk(bufferInterval, n5, bl2);
                if (bl) {
                    if (this._state == 4 && bl4) {
                        this._responseQue.release();
                    } else if (bl4) {
                        this._pduState = 0;
                        this._responseQue.release();
                    }
                    break;
                }
            }
        }
        return bufferInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferInterval getChunk() throws IOException {
        switch (this._state) {
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                while (true) {
                    BufferInterval bufferInterval = null;
                    TdsProtocolContext tdsProtocolContext = this;
                    synchronized (tdsProtocolContext) {
                        bufferInterval = this._responseQue.pop();
                        if (bufferInterval == null) {
                            if (this._state == 5 || this._state == 6) {
                                ErrorMessage.raiseIOException("JZ0PA");
                            }
                            if (this._state == 3) {
                                ErrorMessage.raiseIOException("JZ0EM");
                            }
                        } else if (this._state != 5 && this._state != 6) {
                            return bufferInterval;
                        }
                    }
                    if (bufferInterval == null) {
                        this._inMgr.doRead(this);
                        continue;
                    }
                    if (bufferInterval.free()) {
                        bufferInterval = null;
                    }
                    ErrorMessage.raiseIOException("JZ0PA");
                }
            }
        }
        return null;
    }

    public boolean isProcDone() {
        return (((DoneToken)this._tdsToken)._status & 8) == 8;
    }

    protected boolean checkBufStat(int n) {
        if ((n & 8) != 0) {
            this._pduState = 3;
            return true;
        }
        return false;
    }

    protected boolean checkBufType(int n) {
        if (n == 17) {
            this._pduState = 7;
            return true;
        }
        return false;
    }

    protected int available() {
        return this._responseQue.available(8);
    }

    @Override
    protected void chainException(SQLException sQLException) {
        if (this._chainedSqe == null) {
            this._chainedSqe = sQLException;
        } else if ("JZ0F2".equals(sQLException.getSQLState())) {
            sQLException.setNextException(this._chainedSqe);
            this._chainedSqe = sQLException;
        } else {
            this._chainedSqe.setNextException(sQLException);
        }
    }

    private void clear(boolean bl) {
        this._chainedSqe = null;
        this._lastResult = -1;
        this._ungotResult = -1;
        this._tdsToken = null;
        this._haveDone = false;
        this._eed = false;
        this._paramFmts = null;
        this._paramFmtsForEed = null;
        this._paramFmtsForEvent = null;
        this._trs = null;
        this._trsForEed = null;
        this._trsForEvent = null;
        this._trsForMsg = null;
        if (this._state != 4) {
            if (bl) {
                BufferInterval bufferInterval;
                while ((bufferInterval = this._responseQue.pop()) != null) {
                    if (!bufferInterval.free()) continue;
                    bufferInterval = null;
                }
            }
            this.setState(1);
        }
        if (this._cm != null) {
            this._cm.allDead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected SybResultSet getParams() {
        SybResultSet sybResultSet = null;
        int n = 0;
        SQLException sQLException = this._chainedSqe;
        this._chainedSqe = null;
        try {
            block16: while (true) {
                n = this._protocol.nextResult(this);
                switch (n) {
                    case 3: {
                        switch (this._lastTds) {
                            case 32: 
                            case 236: {
                                if (this._eed) {
                                    this._trsForEed = new TdsParamSet(this, false, 2);
                                    sybResultSet = new SybResultSet(this._logId, this._trsForEed, this);
                                } else if (this._event) {
                                    this._trsForEvent = new TdsParamSet(this, false, 3);
                                    sybResultSet = new SybResultSet(this._logId, this._trsForEvent, this);
                                } else if (this._msg) {
                                    this._trsForMsg = new TdsParamSet(this, false, 4);
                                    sybResultSet = new SybResultSet(this._logId, this._trsForMsg, this);
                                }
                                if (sybResultSet != null) {
                                    sybResultSet.setHoldsParams(true);
                                }
                                this._lastResult = -1;
                                continue block16;
                            }
                            case 215: {
                                this._lastResult = -1;
                                return sybResultSet;
                            }
                        }
                        this._protocol.ungetResult(this, this._lastTds);
                        return sybResultSet;
                    }
                    case 0: {
                        this._protocol.ungetResult(this, n);
                        return sybResultSet;
                    }
                }
                this._protocol.ungetResult(this, n);
                continue;
                break;
            }
        }
        catch (SQLException sQLException2) {
            this.chainException(sQLException2);
            return sybResultSet;
        }
        finally {
            if (this._chainedSqe != null) {
                if (sQLException != null) {
                    sQLException.setNextException(this._chainedSqe);
                } else {
                    sQLException = this._chainedSqe;
                }
            }
            this._chainedSqe = sQLException;
        }
    }

    protected SybResultSet makeEmptyParams() {
        SybResultSet sybResultSet = null;
        try {
            if (this._eed) {
                this._paramFmtsForEed = new RowFormatToken();
                this._trsForEed = new TdsParamSet(this, true, 2);
                sybResultSet = new SybResultSet(this._logId, this._trsForEed, this);
            } else if (this._event) {
                this._paramFmtsForEvent = new RowFormatToken();
                this._trsForEvent = new TdsParamSet(this, true, 3);
                sybResultSet = new SybResultSet(this._logId, this._trsForEvent, this);
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return sybResultSet;
    }

    protected void setRereadable() {
        this._cm = new CacheManager(this._in);
        this._cm.setReReadable(true);
        this._cm.setCacheSize(-1);
        this._cm.setChunkSize(256);
        this._cm.setAbortOnCacheOverflow(true);
    }

    @Override
    protected void setState(int n) {
        super.setState(n);
    }

    @Override
    protected void refreshYourself(Protocol protocol, InStreamMgr inStreamMgr, OutStreamMgr outStreamMgr) {
        super.refreshYourself(protocol, inStreamMgr, outStreamMgr);
        this._inFormat = new PduInputFormatter(this);
        Tds tds = (Tds)protocol;
        try {
            this._in = new TdsDataInputStream(tds, this._inFormat);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this._bigEndian = tds._bigEndian;
        this._in.setBigEndian(this._bigEndian);
        this.clear(true);
        this._pduState = 0;
    }

    protected RowFormatToken getFormat() {
        if (this._eed) {
            return this._paramFmtsForEed;
        }
        if (this._event) {
            return this._paramFmtsForEvent;
        }
        return this._paramFmts;
    }

    @Override
    public int getTimeUntilTimeout() throws IOException {
        if (this._timeout == 0) {
            return this._timeout;
        }
        int n = this.getTimeLeft();
        if (n <= 0) {
            ErrorMessage.raiseIOException("JZ0T3");
        }
        return n;
    }

    @Override
    public int getTimeLeft() {
        long l = (long)this._timeout - (System.currentTimeMillis() - this._requestStartTime);
        if (l == 0L) {
            l = -1L;
        }
        return (int)l;
    }

    protected void dump(SyncObj syncObj, SyncObj syncObj2) {
    }

    public int getPreviousCount() {
        return this._previousCount;
    }

    public void resetRowFmt() {
        this._listRowFmtTok.clear();
        this._listResultSet.clear();
    }

    void newRowFmt(TdsInputStream tdsInputStream, int n) throws IOException {
        long l = 0L;
        switch (n) {
            case 238: {
                l = tdsInputStream.readShort();
                RowFormatToken rowFormatToken = null;
                if (this._listRowFmtTok.size() > this._rowFmtIndex) {
                    rowFormatToken = this._listRowFmtTok.get(this._rowFmtIndex);
                }
                if (rowFormatToken == null || l != rowFormatToken.getRowFmtLength()) {
                    this._paramFmts = new RowFormatToken(tdsInputStream, l);
                    this._listRowFmtTok.add(this._rowFmtIndex, this._paramFmts);
                    break;
                }
                this._paramFmts = rowFormatToken;
                tdsInputStream.skip(l);
                break;
            }
            case 97: {
                l = tdsInputStream.readUnsignedIntAsLong();
                RowFormatToken rowFormatToken = null;
                if (this._listRowFmtTok.size() > this._rowFmtIndex) {
                    rowFormatToken = (RowFormat2Token)this._listRowFmtTok.get(this._rowFmtIndex);
                }
                if (rowFormatToken == null || l != rowFormatToken.getRowFmtLength()) {
                    this._paramFmts = new RowFormat2Token(tdsInputStream, l);
                    this._listRowFmtTok.add(this._rowFmtIndex, this._paramFmts);
                    break;
                }
                this._paramFmts = rowFormatToken;
                tdsInputStream.skip(l);
            }
        }
        ++this._rowFmtIndex;
    }

    protected ProtocolResultSet newResultSet() throws SQLException {
        int n = 0;
        if (this._rowFmtIndex > 0) {
            n = this._rowFmtIndex - 1;
        }
        if (this._listResultSet.size() > n) {
            this._trs = this._listResultSet.get(n);
            if (this._trs != null) {
                this._trs.reset();
                this._lastResult = -1;
                return this._trs;
            }
        }
        this._trs = this._cursor != null ? ((this._cursor._type & 0x120) != 0 ? new TdsScrollResultSet(this) : new TdsResultSet(this)) : new TdsResultSet(this);
        this._lastResult = -1;
        this._listResultSet.add(n, this._trs);
        return this._trs;
    }

    public void copyColumnCache(TdsProtocolContext tdsProtocolContext) {
        this._listRowFmtTok = tdsProtocolContext._listRowFmtTok;
        this._listResultSet.clear();
    }

    public void addAltFmtToken(TdsDataInputStream tdsDataInputStream) throws IOException, SQLException {
        AltFormatToken altFormatToken = new AltFormatToken(tdsDataInputStream);
        if (this._altFormatTokens == null) {
            this._altFormatTokens = new LinkedList<AltFormatToken>();
        }
        this._altFormatTokens.add(altFormatToken.getId() - 1, altFormatToken);
    }

    public AltFormatToken getAltFmt(int n) {
        return this._altFormatTokens.get(n - 1);
    }

    public void setCurrentAltRow(TdsDataInputStream tdsDataInputStream) throws IOException {
        this._currentAltRow = new AltRowToken(tdsDataInputStream);
    }

    public AltRowToken getCurrentAltRow() {
        return this._currentAltRow;
    }

    public boolean isSelectSql() {
        return this._isSelectSql;
    }

    public void setIsSelectSql(boolean bl) {
        this._isSelectSql = bl;
    }
}

