/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.jdbc42.timedio;

import com.sybase.jdbc42.jdbc.ErrorMessage;
import com.sybase.jdbc42.jdbc.SybProperty;
import com.sybase.jdbc42.timedio.Dbio;
import com.sybase.jdbc42.timedio.InStreamMgr;
import com.sybase.jdbc42.utils.AsciiInput;
import com.sybase.jdbc42.utils.BufferPool;
import com.sybase.jdbc42.utils.SybVersion;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.sql.SQLException;

public class RawDbio
extends Dbio
implements Runnable {
    private Thread _runner = null;
    protected long _currentTimeout = 0L;
    private volatile boolean _runAsync = false;
    static final boolean READAHEAD = true;
    private static final String CONNECT = "CONNECT";
    private static final String TERMINATOR = "\r\n";
    private static final String HTTP_VERSION = "HTTP/1.0";
    private static final String USER_AGENT = "User-agent:";
    private static final String JDBC_VERSION = SybVersion.PRODUCT_NAME + " " + SybVersion.MAJOR_VERSION + "." + SybVersion.MINOR_VERSION;
    private static final String SUCCESS_CONNECT = "200";

    public RawDbio(String string, int n, InStreamMgr inStreamMgr, SybProperty sybProperty) throws SQLException {
        super(string, n, inStreamMgr, sybProperty);
    }

    @Override
    protected void close() {
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this._socket = null;
        }
    }

    @Override
    protected void doConnect(int n) throws IOException {
        int n2 = 0;
        int n3 = 0;
        int n4 = 1000;
        try {
            n3 = this._info.getInteger(94);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        String string = this._host;
        int n5 = this._port;
        while (n2 < n3 || n2 < n4) {
            try {
                this._socket = new Socket();
                if (this._proxyHost != null) {
                    string = this._proxyHost;
                    n5 = this._proxyPort;
                }
                this._socket.connect(new InetSocketAddress(string, n5), n);
            }
            catch (SocketException socketException) {
                if (socketException.getMessage().startsWith("Connection refused")) {
                    if (++n2 >= n3) {
                        throw socketException;
                    }
                    if (!this._info.isPropertySetToNonDefault(95)) continue;
                    try {
                        Thread.sleep(this._info.getInteger(95) * 1000);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (SQLException sQLException) {}
                    continue;
                }
                if (socketException.getMessage().startsWith("Address already in use")) {
                    if (++n2 < n4) continue;
                    throw socketException;
                }
                if (!this.retryOtherNetworkInterfaces(string, n5, n)) continue;
            }
            break;
        }
        this.setUpSocket(n);
    }

    private boolean retryOtherNetworkInterfaces(String string, int n, int n2) throws IOException {
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        IOException iOException = null;
        for (int i = inetAddressArray.length - 1; i >= 0; --i) {
            try {
                if (!this._socket.isClosed()) {
                    this._socket.close();
                }
                this._socket = new Socket();
                this._socket.connect(new InetSocketAddress(inetAddressArray[i], n), n2);
                return true;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                continue;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        return true;
    }

    protected void setUpSocket(int n) throws IOException {
        this._socket.setKeepAlive(true);
        this._socket.setTcpNoDelay(true);
        if ((long)n != this._currentTimeout) {
            this._currentTimeout = n;
            this._socket.setSoTimeout(n);
        }
        this._out = this._socket.getOutputStream();
        this._in = this._socket.getInputStream();
        if (this._proxyHost != null) {
            this.sendHTTPConnect(this._in, this._out, this._host + ":" + this._port);
        }
    }

    @Override
    public boolean startAsync() {
        if (this._runner == null) {
            this._runAsync = true;
            this._runner = new Thread(this);
            this._runner.setDaemon(true);
            this._runner.start();
        }
        return true;
    }

    @Override
    public void stopAsync() {
        if (this._runner != null) {
            try {
                this._runAsync = false;
                this._runner.join(1L);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                this._runner = null;
            }
        }
    }

    @Override
    public void run() {
        int n = 1;
        int n2 = 0;
        if (this._info.isPropertySetToNonDefault(93)) {
            BufferPool bufferPool = this._ioMgr.getBufferPool();
            while (this._runAsync) {
                try {
                    if (this._info.getMaxBICount() > bufferPool.getInMemoryBICount()) {
                        this.doRead(0L);
                        n = 1;
                        continue;
                    }
                    if (this._ioMgr.isRequestQueueEmpty()) {
                        if (++n2 > 10 && n < 50) {
                            n += 2;
                            n2 = 0;
                        }
                        Thread.sleep(n);
                        continue;
                    }
                    bufferPool.resetInMemoryBICount();
                    this.doRead(0L);
                    n = 1;
                }
                catch (SQLException sQLException) {
                }
                catch (IOException iOException) {
                    this._lastEx = iOException;
                    this._ioMgr.reportError("JZ0T2");
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            while (this._runAsync) {
                try {
                    this.doRead(0L);
                }
                catch (IOException iOException) {
                    this._lastEx = iOException;
                    this._ioMgr.reportError("JZ0T2");
                }
            }
        }
    }

    @Override
    protected int reallyRead(long l) throws IOException {
        if (l != this._currentTimeout) {
            this._currentTimeout = l;
            l = this._currentTimeout == 0L ? (this._networkTimeout != 0L ? (long)((int)this._networkTimeout) : 0L) : (this._networkTimeout != 0L && this._currentTimeout >= this._networkTimeout ? (long)((int)this._networkTimeout) : (long)((int)this._currentTimeout));
            this._socket.setSoTimeout((int)l);
        }
        return this._in.read(this._bufIntv._buf, this._bufIntv._offset + this._bRead, this._bufIntv._length - this._bRead);
    }

    private void sendHTTPConnect(InputStream inputStream, OutputStream outputStream, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(CONNECT);
        stringBuffer.append(" ");
        stringBuffer.append(string);
        stringBuffer.append(" ");
        stringBuffer.append(HTTP_VERSION);
        stringBuffer.append(TERMINATOR);
        stringBuffer.append(USER_AGENT);
        stringBuffer.append(" ");
        stringBuffer.append(JDBC_VERSION);
        stringBuffer.append(TERMINATOR);
        stringBuffer.append(TERMINATOR);
        int n = stringBuffer.length();
        byte[] byArray = stringBuffer.toString().getBytes();
        outputStream.write(byArray, 0, n);
        outputStream.flush();
        String string2 = AsciiInput.readLine(inputStream);
        if (string2 == null) {
            ErrorMessage.raiseIOException("JZ0I7");
        }
        if (string2.indexOf(SUCCESS_CONNECT) == -1) {
            ErrorMessage.raiseIOException("JZ0I8", string2);
        }
        while (string2 != null) {
            string2 = AsciiInput.readLine(inputStream);
        }
    }
}

