/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds;

import com.sybase.util.ds.Settings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SealedObject;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class Utils {
    private static final String STR_WINDOWS = "Windows";
    public static final String OS_NAME = System.getProperty("os.name");
    public static final boolean OS_WINDOWS = OS_NAME != null && OS_NAME.indexOf("Windows") != -1;
    private static Hashtable<String, String> _hostIPs = new Hashtable();
    private static SecureRandom _secureRandom;
    private static String _kph;
    private static Key _aesKey;
    private static Cipher _cipher;

    public static File getSybaseDir() {
        File file;
        File file2 = null;
        String string = "SYBASE";
        String string2 = System.getProperty("sybase.home");
        if (string2 == null && (string2 = Utils.getEnVariable(string)) == null) {
            return file2;
        }
        if (Utils.isNormalPath(string2) && (file = new File(Utils.removeControlCharacter(string2))).isDirectory()) {
            file2 = file;
        }
        return file2;
    }

    public static String getSybasePath() {
        String string = null;
        File file = Utils.getSybaseDir();
        if (file != null) {
            string = Utils.getCanonicalPath(file);
        }
        return string;
    }

    public static String getJREPath() {
        String string = Utils.getEnVariable("SYBASE_JRE7");
        if (string == null) {
            string = Utils.getEnVariable("SYBASE_JRE6");
        }
        return string;
    }

    public static String getCanonicalPath(File file) {
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public static String getOCSPath() {
        String string = "SYBASE_OCS";
        String string2 = System.getProperty("ocs.home");
        if (string2 == null) {
            string2 = Utils.getEnVariable(string);
        }
        return string2;
    }

    public static String getEnVariable(String string) {
        String string2 = null;
        if (OS_WINDOWS) {
            try {
                Process process = null;
                process = OS_NAME.indexOf("9") != -1 ? Runtime.getRuntime().exec("command /c echo %" + string + "%") : Runtime.getRuntime().exec("cmd /c echo %" + string + "%");
                InputStream inputStream = process.getInputStream();
                byte[] byArray = new byte[10240];
                int n = inputStream.read(byArray);
                while (n != -1) {
                    string2 = new String(byArray, 0, n);
                    n = inputStream.read(byArray);
                }
                process.destroy();
            }
            catch (IOException iOException) {
                string2 = null;
            }
            if (string2 != null && string2.indexOf("%") != -1) {
                string2 = null;
            }
        } else {
            String[] stringArray = new String[]{"env"};
            Runtime runtime = Runtime.getRuntime();
            try {
                String string3;
                Process process = runtime.exec(stringArray);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((string3 = Utils.readLimitedLine(bufferedReader)) != null) {
                    if (string3.indexOf(string + "=") != 0) continue;
                    string2 = string3.substring(string.length() + 1);
                }
                bufferedReader.close();
            }
            catch (IOException iOException) {
                string2 = null;
            }
        }
        return string2 != null ? string2.trim() : string2;
    }

    public static String getHostAndPort(String string, String string2) {
        int n;
        try {
            n = Integer.valueOf(string2);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        return Utils.getHostAndPort(string, n);
    }

    public static String getHostAndPort(String string, int n) {
        String string2 = "";
        if (string != null && string.length() > 0) {
            string2 = string2 + string;
            if (n >= 0) {
                string2 = string2 + ":" + n;
            }
        }
        return string2;
    }

    public static String getIP(String string) {
        if (string == null) {
            return null;
        }
        String string2 = _hostIPs.get(string);
        if (string2 != null) {
            return string2.toString();
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            String string3 = inetAddress.getHostAddress();
            _hostIPs.put(string, string3);
            return string3;
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    public static String getIPAndPort(String string, String string2) {
        return Utils.getHostAndPort(Utils.getIP(string), string2);
    }

    public static boolean sameHost(String string, String string2) {
        return Utils.getIP(string).equals(Utils.getIP(string2));
    }

    public static String[] getChildrenNames(Preferences preferences) {
        try {
            return preferences.childrenNames();
        }
        catch (BackingStoreException backingStoreException) {
            return new String[0];
        }
    }

    public static void removeNode(Preferences preferences) {
        try {
            preferences.removeNode();
        }
        catch (BackingStoreException backingStoreException) {
            return;
        }
    }

    public static void setInitialColumnWidths(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        int n = jTable.getModel().getColumnCount();
        int n2 = jTable.getPreferredScrollableViewportSize().height;
        int n3 = n2 / jTable.getRowHeight();
        int n4 = jTable.getRowCount();
        int n5 = Math.min(n4, n3);
        if (n5 < 20 && n4 >= 20) {
            n5 = 20;
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            TableCellRenderer tableCellRenderer;
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n6 = 0;
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (jTableHeader != null) {
                tableCellRenderer = jTableHeader.getDefaultRenderer();
                object = tableColumn.getHeaderValue();
                if (object != null) {
                    try {
                        n6 = tableCellRenderer.getTableCellRendererComponent((JTable)jTable, (Object)object, (boolean)false, (boolean)false, (int)-1, (int)0).getPreferredSize().width;
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            }
            for (int j = 0; j < n5; ++j) {
                tableCellRenderer = jTable.getCellRenderer(j, i);
                object = jTable.getModel().getValueAt(j, i);
                if (object == null && j >= (n5 = Math.min(jTable.getRowCount(), 10))) break;
                int n7 = tableCellRenderer.getTableCellRendererComponent((JTable)jTable, (Object)object, (boolean)false, (boolean)false, (int)j, (int)i).getPreferredSize().width;
                n6 = Math.max(n6, n7);
            }
            tableColumn.setPreferredWidth(n6 + jTable.getIntercellSpacing().width);
        }
        jTable.sizeColumnsToFit(-1);
    }

    public static boolean getEnableServerDiscovery() {
        return Settings.getEnableServerDiscovery();
    }

    public static int getServerDiscoveryTimeout() {
        return Settings.getServerDiscoveryTimeout();
    }

    public static boolean isNormalPath(String string) {
        return string != null && string.length() > 0 && string.indexOf("..") < 0;
    }

    public static final String removeControlCharacter(String string) {
        if (string == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.codePointCount(0, string.length()); ++i) {
            int n = string.codePointAt(i);
            if (Character.isISOControl(n)) continue;
            stringBuilder.appendCodePoint(n);
        }
        return stringBuilder.toString();
    }

    public static boolean isExistingFile(String string) {
        if (!Utils.isNormalPath(string)) {
            return false;
        }
        File file = new File(Utils.removeControlCharacter(string));
        return file.isFile();
    }

    public static boolean isExistingDirectory(String string) {
        if (!Utils.isNormalPath(string)) {
            return false;
        }
        File file = new File(Utils.removeControlCharacter(string));
        return file.isDirectory();
    }

    public static File getExistingFile(String string) throws FileNotFoundException {
        if (!Utils.isExistingFile(string)) {
            throw new FileNotFoundException();
        }
        return new File(string);
    }

    public static FileInputStream getFileInputStream(String string) throws FileNotFoundException {
        if (!Utils.isExistingFile(string) || !Utils.isNormalPath(string)) {
            throw new FileNotFoundException();
        }
        return new FileInputStream(Utils.removeControlCharacter(string));
    }

    public static FileOutputStream getFileOutputStream(String string) throws FileNotFoundException {
        if (!Utils.isExistingFile(string)) {
            throw new FileNotFoundException();
        }
        return new FileOutputStream(string);
    }

    public static String encryptPassword(String string) {
        if (string == null) {
            return null;
        }
        if (string.length() == 0) {
            return "";
        }
        return Utils.encryptPassword(string.toCharArray());
    }

    public static String encryptPassword(char[] cArray) {
        String string = "";
        for (int i = 0; i < cArray.length; ++i) {
            string = string + (char)(cArray[i] + i);
        }
        return string;
    }

    public static String decryptPassword(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        for (int i = 0; i < string.length(); ++i) {
            string2 = string2 + (char)(string.charAt(i) - i);
        }
        return string2;
    }

    private static boolean initCipher() {
        if (_cipher == null) {
            try {
                _cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                _secureRandom = new SecureRandom();
                _kph = Utils.getRandomKeyPhrase();
                _aesKey = Utils.getAESKey();
                return true;
            }
            catch (SecurityException | NoSuchAlgorithmException | NoSuchPaddingException exception) {
                return false;
            }
        }
        return _cipher != null && _aesKey != null;
    }

    public static SealedObject sealCharPwd(char[] cArray) {
        try {
            if (Utils.initCipher()) {
                _cipher.init(1, _aesKey, _secureRandom);
                return new SealedObject((Serializable)cArray, _cipher);
            }
            return null;
        }
        catch (IOException | InvalidKeyException | IllegalBlockSizeException exception) {
            return null;
        }
    }

    public static char[] unsealCharPwd(SealedObject sealedObject) {
        try {
            if (sealedObject == null || _cipher == null || _aesKey == null) {
                return null;
            }
            return (char[])sealedObject.getObject(_aesKey);
        }
        catch (IOException | ClassNotFoundException | InvalidKeyException | NoSuchAlgorithmException exception) {
            return null;
        }
    }

    public static SealedObject sealPassword(String string) {
        try {
            if (Utils.initCipher()) {
                _cipher.init(1, _aesKey, _secureRandom);
                return new SealedObject((Serializable)((Object)string), _cipher);
            }
            return null;
        }
        catch (IOException | InvalidKeyException | IllegalBlockSizeException exception) {
            return null;
        }
    }

    public static String unsealPassword(SealedObject sealedObject) {
        try {
            if (sealedObject == null || _cipher == null || _aesKey == null) {
                return null;
            }
            return (String)sealedObject.getObject(_aesKey);
        }
        catch (IOException | ClassNotFoundException | InvalidKeyException | NoSuchAlgorithmException exception) {
            return null;
        }
    }

    private static String getRandomKeyPhrase() {
        return Utils.getRandomKeyPhrase(128);
    }

    private static String getRandomKeyPhrase(int n) {
        char[] cArray = new char[n];
        for (int i = 0; i < n; ++i) {
            cArray[i] = (char)(_secureRandom.nextInt(95) + 32);
        }
        String string = String.valueOf(cArray);
        Arrays.fill(cArray, '\u0000');
        return string;
    }

    private static Key getAESKey() throws SecurityException {
        byte[] byArray = new byte[]{12, 36, 88};
        try {
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            SecretKey secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(_kph.toCharArray(), byArray, 16384, 128));
            return new SecretKeySpec(secretKey.getEncoded(), "AES");
        }
        catch (Throwable throwable) {
            throw new SecurityException("Error generating key", throwable);
        }
    }

    public static String readLimitedLine(BufferedReader bufferedReader) throws IOException {
        return bufferedReader.readLine();
    }
}

