/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ui;

import com.sybase.util.ds.Utils;
import com.sybase.util.ds.ui.BaseDialog;
import com.sybase.util.ds.ui.NewPasswordPage;
import java.util.Arrays;
import javax.crypto.SealedObject;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NewPasswordDialog
extends BaseDialog
implements DocumentListener {
    private NewPasswordPage _page;
    private SealedObject _oldEncryptedPassword;
    private SealedObject _newEncryptedPassword;

    public NewPasswordDialog(JDialog jDialog, String string) {
        super(jDialog);
        this._oldEncryptedPassword = Utils.sealPassword(string);
    }

    public NewPasswordDialog(JFrame jFrame, String string) {
        super(jFrame);
        this._oldEncryptedPassword = Utils.sealPassword(string);
    }

    public String create() {
        this.setVisible(this.createUI());
        this.destroyUI();
        return this._newEncryptedPassword == null ? null : Utils.unsealPassword(this._newEncryptedPassword);
    }

    private boolean createUI() {
        this._page = new NewPasswordPage();
        this._page.newPasswordField.getDocument().addDocumentListener(this);
        this._page.confirmPasswordField.getDocument().addDocumentListener(this);
        String string = _res.get("CHANGE_PW");
        super.createUI((JPanel)((Object)this._page), string);
        this._okButton.setEnabled(false);
        return true;
    }

    @Override
    void destroyUI() {
        super.destroyUI();
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.textValueChanged();
    }

    void textValueChanged() {
        char[] cArray = this.getNewPassword();
        char[] cArray2 = this.getConfirmPassword();
        this._okButton.setEnabled(cArray.length > 0 && Arrays.equals(cArray, cArray2) && this._oldEncryptedPassword != null && Utils.unsealPassword(this._oldEncryptedPassword) != null && !Arrays.equals(cArray, Utils.unsealPassword(this._oldEncryptedPassword).toCharArray()));
        Arrays.fill(cArray, '\u0000');
        Arrays.fill(cArray2, '\u0000');
    }

    private final char[] getNewPassword() {
        return this._page.newPasswordField.getPassword();
    }

    public void setNewPassword(String string) {
        this._newEncryptedPassword = Utils.sealPassword(string);
    }

    private final char[] getConfirmPassword() {
        return this._page.confirmPasswordField.getPassword();
    }

    @Override
    void handleOK() {
        this.setVisible(false);
        this._newEncryptedPassword = Utils.sealPassword(this._page.newPasswordField.getPasswordString());
    }

    @Override
    void handleCancel() {
        this.setVisible(false);
        this._newEncryptedPassword = null;
    }
}

