/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.ui;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumericsOnlyDocument
extends PlainDocument {
    private boolean _integerOnly;
    private boolean _negative;
    private float _min;
    private float _max;
    private boolean _documentChanged;

    public NumericsOnlyDocument() {
        this._integerOnly = true;
        this._negative = false;
        this._min = 0.0f;
        this._max = 65535.0f;
        this._documentChanged = false;
    }

    public NumericsOnlyDocument(boolean bl) {
        this._integerOnly = bl;
        this._negative = false;
        this._min = 0.0f;
        this._max = 9.223372E18f;
        this._documentChanged = false;
    }

    public NumericsOnlyDocument(boolean bl, float f, float f2) {
        this._integerOnly = bl;
        this._negative = false;
        this._min = f;
        this._max = f2;
        this._documentChanged = false;
    }

    public NumericsOnlyDocument(boolean bl, boolean bl2, float f, float f2) {
        this._integerOnly = bl;
        this._negative = bl2;
        this._min = f;
        this._max = f2;
        this._documentChanged = false;
    }

    public boolean isInteger() {
        return this._integerOnly;
    }

    public boolean isNegative() {
        return this._negative;
    }

    @Override
    public void remove(int n, int n2) throws BadLocationException {
        String string = this.getText(0, n) + this.getText(n + n2, this.getLength() - n2 - n);
        float f = 0.0f;
        boolean bl = false;
        try {
            if (this.isNegative() && string.startsWith("-")) {
                bl = true;
                string = string.substring(1);
            }
            if (this.isInteger()) {
                Long.parseLong(string + "0");
                f = string.equals("") ? 0.0f : (float)Long.parseLong(string);
            } else {
                Float.valueOf(string + "0").floatValue();
                float f2 = f = string.equals("") ? 0.0f : Float.valueOf(string).floatValue();
            }
            if (bl) {
                f *= -1.0f;
            }
            if (f >= this._min && f <= this._max) {
                super.remove(n, n2);
                this._documentChanged = true;
            }
        }
        catch (NumberFormatException | BadLocationException exception) {
            return;
        }
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null || string.equalsIgnoreCase("e") || string.equals("f") || string.equals("d") || this._min > 0.0f && string.equals("-")) {
            return;
        }
        String string2 = this.getText(0, this.getLength());
        String string3 = string2.substring(0, n) + string + string2.substring(n);
        float f = 0.0f;
        boolean bl = false;
        try {
            if (this.isNegative() && string3.startsWith("-")) {
                bl = true;
                if ((string3 = string3.substring(1)).length() == 0) {
                    super.insertString(n, string, attributeSet);
                    this._documentChanged = true;
                } else if (string3.indexOf("-") != -1) {
                    return;
                }
            }
            if (this.isInteger()) {
                Long.parseLong(string3 + "0");
                f = Long.parseLong(string3);
            } else {
                Float.valueOf(string3 + "0").floatValue();
                f = Float.valueOf(string3).floatValue();
            }
            if (bl) {
                f *= -1.0f;
            }
            if (f >= this._min && f <= this._max) {
                super.insertString(n, string, attributeSet);
                this._documentChanged = true;
            }
        }
        catch (NumberFormatException | BadLocationException exception) {
            return;
        }
    }

    public boolean isDocumentChanged() {
        return this._documentChanged;
    }
}

