/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.interfaces;

import com.sybase.util.ds.Utils;
import com.sybase.util.ds.interfaces.IniFileParser;
import com.sybase.util.ds.interfaces.InterfacesBaseParser;
import com.sybase.util.ds.interfaces.InterfacesException;
import com.sybase.util.ds.interfaces.InterfacesFileParser;
import com.sybase.util.ds.interfaces.InterfacesLocator;
import com.sybase.util.ds.interfaces.Service;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Vector;

public class SyInterfacesDriverBase {
    public static final int FORMAT_HOST = 0;
    public static final int FORMAT_WINDOWS = 1;
    public static final int FORMAT_UNIX = 2;
    protected Vector<String> _lines;
    protected Vector<String> _subjects;
    protected Vector<Vector<Service>> _services;
    protected String _fileName;
    protected boolean _saveOnChange = false;
    protected InterfacesBaseParser _interfacesParser;
    protected int _format;
    protected long _nextLine = 0L;
    protected InterfacesLocator _interfacesLocator;

    public SyInterfacesDriverBase() {
    }

    public SyInterfacesDriverBase(String string) throws IOException, InterfacesException {
        this(string, false, 0);
    }

    public SyInterfacesDriverBase(String string, boolean bl) throws IOException, InterfacesException {
        this(string, bl, 0);
    }

    public SyInterfacesDriverBase(String string, boolean bl, int n) throws IOException, InterfacesException {
        this.load(string, bl, n);
    }

    private InterfacesBaseParser getParser() {
        if (this._format == 0) {
            if (Utils.OS_WINDOWS) {
                return new IniFileParser();
            }
            return new InterfacesFileParser();
        }
        if (this._format == 1) {
            return new IniFileParser();
        }
        if (this._format == 2) {
            return new InterfacesFileParser();
        }
        throw new IllegalArgumentException();
    }

    public int getFormat() {
        return this._format;
    }

    protected void load(String string, boolean bl, int n) throws IOException, InterfacesException {
        this._saveOnChange = bl;
        this._fileName = string;
        this._format = n;
        URL uRL = null;
        try {
            uRL = new URL(string);
            this.loadParser(null, uRL);
            this.loadFile(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            int n2 = 1;
            while (!Utils.isExistingFile(string)) {
                if (n2 >= 5) {
                    this._fileName = null;
                    InterfacesException interfacesException = new InterfacesException("ERR_FILE_NOT_FOUND", "MSG_INTERFACES", string);
                    throw interfacesException;
                }
                ++n2;
            }
            this.loadParser(string, null);
            this.loadFile();
        }
        this.parseLines();
    }

    private void loadParser(String string, URL uRL) throws IOException, InterfacesException {
        boolean bl;
        IniFileParser iniFileParser = new IniFileParser();
        boolean bl2 = string == null ? iniFileParser.probe(uRL) : iniFileParser.probe(string);
        InterfacesFileParser interfacesFileParser = new InterfacesFileParser();
        boolean bl3 = bl = string == null ? interfacesFileParser.probe(uRL) : interfacesFileParser.probe(string);
        if (!bl2 && !bl) {
            this._fileName = null;
            InterfacesException interfacesException = new InterfacesException("ERR_FORMAT_ERROR", "MSG_INTERFACES", string == null ? uRL.getFile() : string);
            throw interfacesException;
        }
        if (bl2 && bl) {
            this._interfacesParser = this._format == 0 ? (Utils.OS_WINDOWS ? iniFileParser : interfacesFileParser) : (this._format == 2 ? interfacesFileParser : iniFileParser);
        } else if (bl2) {
            this._interfacesParser = iniFileParser;
            this._format = 1;
        } else {
            this._interfacesParser = interfacesFileParser;
            this._format = 2;
        }
    }

    public void loadFile(URL uRL) throws IOException {
        InputStream inputStream = uRL.openStream();
        this.loadFile(inputStream);
    }

    public void loadFile() throws IOException {
        this.loadFile(Utils.getFileInputStream(this._fileName));
    }

    public void loadFile(InputStream inputStream) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
            this._lines = new Vector();
            this._subjects = new Vector();
            this._services = new Vector();
            String string = "";
            while ((string = Utils.readLimitedLine(bufferedReader)) != null) {
                this._lines.addElement(string);
            }
        }
    }

    protected boolean createFile() {
        return this._interfacesParser.createFile(this._fileName);
    }

    protected void parseLines() {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < this._lines.size(); ++i) {
            Object object;
            string = this._lines.elementAt(i);
            if (this._interfacesParser.isBlankLine(string) || this._interfacesParser.isCommentLine(string)) continue;
            if (this.isSubject(string)) {
                object = this._interfacesParser.getSubject(string);
                string2 = object[0];
                string3 = object[1];
                string4 = object[2];
                continue;
            }
            if (!this.isAssignment(string)) continue;
            object = string.trim();
            this.addAttributes(string2, (String)object);
        }
    }

    protected boolean addAttributes(String string, String string2) {
        Service service = this._interfacesParser.getService(string2);
        if (service != null) {
            return this.addValue(string, service, false);
        }
        return false;
    }

    public boolean setValue(String string, Service service) throws IOException {
        boolean bl = this.addValue(string, service, true);
        if (this._saveOnChange) {
            this.saveFile();
        }
        return bl;
    }

    protected boolean addValue(String string, Service service, boolean bl) {
        if (string == null || string.length() == 0) {
            return false;
        }
        if (!this._subjects.contains(string)) {
            this._subjects.addElement(string);
            this._services.addElement(new Vector());
        }
        int n = this._subjects.indexOf(string);
        Vector<Service> vector = this._services.elementAt(n);
        boolean bl2 = false;
        for (int i = 0; i < vector.size(); ++i) {
            Service service2 = vector.get(i);
            if (!service2.toString().equals(service.toString())) continue;
            bl2 = true;
            break;
        }
        if (!bl2) {
            vector.addElement(service);
        }
        if (bl) {
            this.setLine(string, service);
        }
        return true;
    }

    protected boolean isSubject(String string) {
        return this._interfacesParser.isSubject(string);
    }

    protected void setLine(String string, Service service) {
        int n = this.findSubjectLine(string);
        if (n == -1) {
            String string2 = this.refineSubject(string);
            this.addSubjectLine(string2);
            n = this._lines.size() - 1;
        }
        int n2 = this.endOfSubject(n);
        int n3 = this.findAssignmentBetween(service, n, n2);
        if (this._format == 0) {
            this.setLineElement(Utils.OS_WINDOWS, service, n2, n3);
        } else {
            this.setLineElement(this._format == 1, service, n2, n3);
        }
    }

    private void setLineElement(boolean bl, Service service, int n, int n2) {
        String string;
        service.setFormat(this._format);
        String string2 = string = bl ? service.getType() + "=" + service.getValue() : "\t" + service.getType() + " " + service.getValue();
        if (n2 == -1) {
            this._lines.insertElementAt(string, n);
        } else {
            this._lines.setElementAt(string, n2);
        }
    }

    protected String refineSubject(String string) {
        return this._interfacesParser.refineSubject(string);
    }

    protected int findAssignmentLine(String string, String string2) {
        int n = this.findSubjectLine(string);
        int n2 = this.endOfSubject(n);
        return this.findAssignmentBetween(string2, n, n2);
    }

    protected int findAssignmentBetween(String string, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            if (!this._lines.elementAt(i).trim().startsWith(string)) continue;
            return i;
        }
        return -1;
    }

    private int findAssignmentBetween(Service service, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            String string = this._lines.elementAt(i).trim();
            boolean bl = service.hasPort();
            if ((!string.startsWith(service.getType()) || !bl || string.indexOf(service.getHost()) == -1 || string.indexOf(service.getPort()) == -1) && (bl || string.indexOf(service.getValue()) == -1)) continue;
            return i;
        }
        return -1;
    }

    protected void addSubjectLine(String string) {
        this._lines.addElement(this.refineSubject(string));
    }

    protected int findSubjectLine(String string) {
        for (int i = 0; i < this._lines.size(); ++i) {
            String string2 = this._lines.elementAt(i);
            if (!this._interfacesParser.matchSubject(string2, string)) continue;
            return i;
        }
        return -1;
    }

    protected int endOfSubject(int n) {
        int n2 = n + 1;
        if (n >= this._lines.size()) {
            return this._lines.size();
        }
        for (int i = n + 1; i < this._lines.size(); ++i) {
            if (this.isAssignment(this._lines.elementAt(i))) {
                n2 = i + 1;
            }
            if (!this.isSubject(this._lines.elementAt(i))) continue;
            return n2;
        }
        return n2;
    }

    protected boolean isAssignment(String string) {
        return this._interfacesParser.isAttributes(string);
    }

    public Vector<String> getLines() {
        return (Vector)this._lines.clone();
    }

    public List<Service> getServices(String string) {
        int n = this._subjects.indexOf(string);
        if (n != -1) {
            return this._services.elementAt(n);
        }
        return null;
    }

    public String[] getSubjects() {
        Object[] objectArray = new String[this._subjects.size()];
        this._subjects.copyInto(objectArray);
        return objectArray;
    }

    public void deleteSubject(String string) throws IOException {
        int n = this._subjects.indexOf(string);
        if (n == -1) {
            return;
        }
        this._services.removeElementAt(n);
        this._subjects.removeElementAt(n);
        int n2 = this.findSubjectLine(string);
        int n3 = this.endOfSubject(n2);
        for (int i = n2; i < n3; ++i) {
            this._lines.removeElementAt(n2);
        }
        if (this._saveOnChange) {
            this.saveFile();
        }
    }

    public void deleteService(String string, Service service) throws IOException {
        int n = this._subjects.indexOf(string);
        if (n == -1) {
            return;
        }
        int n2 = this.findSubjectLine(string);
        int n3 = this.endOfSubject(n2);
        int n4 = this.findAssignmentBetween(service, n2, n3);
        this._lines.removeElementAt(n4);
        if (this._saveOnChange) {
            this.saveFile();
        }
    }

    public void saveFile() throws IOException {
        try (DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(Utils.getFileOutputStream(this._fileName)));){
            String string;
            String string2 = string = System.getProperty("line.separator");
            int n = this._lines.size();
            for (int i = 0; i < n; ++i) {
                dataOutputStream.writeBytes(this._lines.elementAt(i) + string2);
            }
        }
    }
}

