/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.uaf;

import com.sybase.ua.AgentConnection;
import com.sybase.ua.AgentDiscovery;
import com.sybase.ua.AgentInfo;
import com.sybase.ua.FastDiscoveryFilter;
import com.sybase.ua.PluginInfo;
import com.sybase.ua.discovery.DiscoveryException;
import com.sybase.util.ds.Debug;
import com.sybase.util.ds.Utils;
import com.sybase.util.ds.uaf.DiscoveryFilter;
import com.sybase.util.ds.uaf.DiscoverySetting;
import com.sybase.util.ds.uaf.SYSAMEntry;
import com.sybase.util.ds.uaf.SyUAFASEEntry;
import com.sybase.util.ds.uaf.SyUAFEntry;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SyUAF {
    public static final String PROP_DISCOVERY_SERVICE = "discovery.service";
    public static final String PROP_DISCOVERY_HOST = "discovery.host";
    public static final String PROP_DISCOVERY_PORT = "discovery.port";
    public static final String PROP_DISCOVERY_TIMEOUT = "discovery.timeout";
    public static final String SERVICE_UDP;
    public static final String DEFAULT_DISCOVERY_SERVICE;
    public static final String DEFAULT_DISCOVERY_HOST = "";
    public static final String DEFAULT_DISCOVERY_PORT = "";
    public static final int DEFAULT_JINI_PORT = 4160;
    public static final int DEFAULT_RMI_PORT;
    public static final int DEFAULT_MIN_PORT = 1025;
    public static final int DEFUALT_MAX_PORT = 65535;
    public static final String PROP_ASE_PLUGIN_ID = "agent.ase.plugin.id";
    public static final String ASE_PLUGIN_ID;
    public static final String PROP_ASE_SYSAM_ID = "agent.sysam.plugin.id";
    public static final String SYSAM_PLUGIN_ID;
    public static final String PROP_SDC_PLUGIN_ID = "agent.sdc.plugin.id";
    public static final String SDC_PLUGIN_ID;
    public static final String[] DISCOVERY_METHODS;
    public static final String AUTHORIZATION_ERROR = "<permission denied>";
    private AgentDiscovery _agentDiscovery;
    private DiscoverySetting _discoverySetting;
    private int _discoveryTimeout = Utils.getServerDiscoveryTimeout();

    public SyUAF() {
        String string;
        String string2;
        String string3;
        this._discoverySetting = new DiscoverySetting();
        String string4 = System.getProperty(PROP_DISCOVERY_SERVICE);
        if (string4 != null) {
            this._discoverySetting.service = string4;
        }
        if ((string3 = System.getProperty(PROP_DISCOVERY_HOST)) != null) {
            this._discoverySetting.host = string3;
        }
        if ((string2 = System.getProperty(PROP_DISCOVERY_PORT)) != null) {
            this._discoverySetting.port = string2;
        }
        if ((string = System.getProperty(PROP_DISCOVERY_TIMEOUT)) != null) {
            try {
                this._discoveryTimeout = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                this._discoveryTimeout = 30;
            }
        }
    }

    public DiscoverySetting getDiscoverySetting() {
        return this._discoverySetting;
    }

    public void init(String string, String string2, String string3) {
        this._discoverySetting.service = string;
        this._discoverySetting.host = string2;
        this._discoverySetting.port = string3;
    }

    public void initAgentDiscovery() throws DiscoveryException {
        this._agentDiscovery = new AgentDiscovery(this._discoverySetting.service.toLowerCase(), this._discoverySetting.host, this._discoverySetting.port);
        if (this._discoveryTimeout > 0) {
            this._agentDiscovery.setTimeOut((long)(this._discoveryTimeout * 1000));
        }
    }

    public List<SyUAFEntry> discover() throws DiscoveryException {
        List<SyUAFEntry> list = this.discover(new String[]{ASE_PLUGIN_ID, SDC_PLUGIN_ID});
        return list;
    }

    public List<SyUAFEntry> discover(Boolean bl) throws DiscoveryException {
        List<SyUAFEntry> list = this.discover(new String[]{ASE_PLUGIN_ID, SDC_PLUGIN_ID}, (boolean)bl);
        return list;
    }

    public List<SyUAFEntry> discover(String string) throws DiscoveryException {
        return this.discover(new String[]{string});
    }

    public List<SyUAFEntry> discover(String[] stringArray) throws DiscoveryException {
        return this.discover(stringArray, true);
    }

    public List<SyUAFEntry> discover(String string, boolean bl) throws DiscoveryException {
        return this.discover(new String[]{string}, bl);
    }

    public List<SyUAFEntry> discover(String[] stringArray, boolean bl) throws DiscoveryException {
        final String[] stringArray2 = stringArray;
        FastDiscoveryFilter fastDiscoveryFilter = new FastDiscoveryFilter(){

            public boolean acceptAgentPlugin(PluginInfo pluginInfo) {
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string = stringArray2[i];
                    if (!pluginInfo.getId().equals(string)) continue;
                    return true;
                }
                return false;
            }
        };
        return this.discover(stringArray, fastDiscoveryFilter, bl);
    }

    public List<SyUAFEntry> discover(String string, FastDiscoveryFilter fastDiscoveryFilter, boolean bl) throws DiscoveryException {
        String[] stringArray = new String[]{string};
        return this.discover(stringArray, fastDiscoveryFilter, bl);
    }

    public List<SyUAFEntry> discover(String[] stringArray, FastDiscoveryFilter fastDiscoveryFilter, boolean bl) throws DiscoveryException {
        String[] stringArray2 = stringArray;
        ArrayList<SyUAFEntry> arrayList = new ArrayList<SyUAFEntry>();
        this._agentDiscovery.discover((com.sybase.ua.DiscoveryFilter)fastDiscoveryFilter);
        List list = this._agentDiscovery.getAgentInfos();
        for (AgentInfo agentInfo : list) {
            try {
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string = stringArray2[i];
                    List list2 = agentInfo.getPluginInfos(string);
                    Iterator iterator = list2.iterator();
                    while (iterator.hasNext()) {
                        PluginInfo pluginInfo = null;
                        Map map = null;
                        try {
                            SyUAFEntry syUAFEntry;
                            pluginInfo = (PluginInfo)iterator.next();
                            String string2 = pluginInfo.getVersion();
                            int n = pluginInfo.getInstanceNumber();
                            map = pluginInfo.getDiscoveryProperties();
                            if (string.equals(ASE_PLUGIN_ID) || string.equals(SDC_PLUGIN_ID)) {
                                syUAFEntry = new SyUAFASEEntry(map, string, string2, n, agentInfo);
                                if (bl && (!bl || !DiscoveryFilter.passFilters("ASE", SyUAFASEEntry.class, syUAFEntry))) continue;
                                arrayList.add(syUAFEntry);
                                continue;
                            }
                            if (!string.equals(SYSAM_PLUGIN_ID)) continue;
                            syUAFEntry = new SYSAMEntry(map, string2, n, agentInfo);
                            if (bl && !DiscoveryFilter.passFilters("SYSAM", SYSAMEntry.class, syUAFEntry)) continue;
                            arrayList.add(syUAFEntry);
                        }
                        catch (Exception exception) {
                            if (!Debug.isOn()) continue;
                            if (pluginInfo != null) {
                                System.out.println("plugin info: " + pluginInfo);
                            }
                            if (map != null) {
                                System.out.println("discovery props: " + map);
                            }
                            System.out.println(exception);
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!Debug.isOn()) continue;
                System.out.println("Discovery error: " + exception);
            }
        }
        return arrayList;
    }

    static {
        DEFAULT_DISCOVERY_SERVICE = SERVICE_UDP = "udp".toUpperCase();
        DEFAULT_RMI_PORT = Integer.valueOf(AgentConnection.DEFAULT_RMI_PORT);
        String string = System.getProperty(PROP_ASE_PLUGIN_ID);
        ASE_PLUGIN_ID = string == null ? "com.sybase.ase" : string;
        string = System.getProperty(PROP_ASE_SYSAM_ID);
        SYSAM_PLUGIN_ID = string == null ? "com.sybase.sysam" : string;
        string = System.getProperty(PROP_SDC_PLUGIN_ID);
        SDC_PLUGIN_ID = string == null ? "com.sybase.ase.cluster" : string;
        DISCOVERY_METHODS = new String[]{SERVICE_UDP};
    }
}

