/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.util.ds.uaf;

import com.sybase.ua.AgentConnection;
import com.sybase.ua.AgentConnectionFactory;
import com.sybase.ua.AgentInfo;
import com.sybase.ua.util.MessageListener;
import com.sybase.util.ds.ASEVersionHelper;
import com.sybase.util.ds.Utils;
import com.sybase.util.ds.uaf.SyUAF;
import com.sybase.util.ds.uaf.SyUAFEntry;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;

public class SyUAFASEEntry
extends SyUAFEntry {
    private String _serverName = "";
    private String _host = "";
    private String _port = "";
    private String _versionString = "";
    private String _platform = "";
    private String _os = "";
    private String _osVersion = "";
    private ASEVersionHelper _versionHelper = null;
    private String _status = "";
    private boolean _cluster = false;
    private ArrayList<String[]> _hostPorts = new ArrayList();

    public SyUAFASEEntry(Map<String, Object> map, String string, int n, AgentInfo agentInfo) {
        super(map, string, n, agentInfo);
        this.initSMP();
    }

    public SyUAFASEEntry(Map<String, Object> map, String string, String string2, int n, AgentInfo agentInfo) {
        super(map, string2, n, agentInfo);
        this._host = agentInfo.getHost();
        this._platform = agentInfo.getOSArchitecture();
        this._os = agentInfo.getOSName();
        this._osVersion = agentInfo.getOSVersion();
        if (string.equals(SyUAF.ASE_PLUGIN_ID)) {
            this.initSMP();
        } else if (string.equals(SyUAF.SDC_PLUGIN_ID)) {
            this.initSDC();
        }
    }

    private void initSMP() {
        this._serverName = this.getValue("serverName");
        this._port = this.getValue("port");
        this._status = this.getValue("ASEStatus");
        this._versionString = this.getValue("ASEVersion");
        if (this.hasVersionString()) {
            this._versionHelper = new ASEVersionHelper(this._versionString);
        }
    }

    private void initSDC() {
        this._cluster = true;
        this._serverName = this.getValue("clusterName");
        String string = this.getValue("hostPorts");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf(":");
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            if (this.stripHostDomain(string3).equalsIgnoreCase(this.stripHostDomain(this._host)) && this._port.equals("")) {
                this._port = string4;
            }
            this._hostPorts.add(new String[]{string3, string4});
        }
        this._status = this.getValue("clusterStatus");
        this._versionString = this.getValue("clusterVersion");
        if (this.hasVersionString()) {
            this._versionHelper = new ASEVersionHelper(this._versionString);
        }
    }

    public String stripHostDomain(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        return (String)stringTokenizer.nextElement();
    }

    public String getName() {
        return this._serverName;
    }

    public String getHostName() {
        return this._host;
    }

    public String getPortNumber() {
        return this._port;
    }

    public int getPort() {
        if (this._port != null & this._port.length() > 0) {
            try {
                return Integer.valueOf(this._port);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }

    public ArrayList<String[]> getHostPorts() {
        return this._hostPorts;
    }

    public boolean containsHostPort(String string, String string2) {
        if (this.isCluster()) {
            for (int i = 0; i < this._hostPorts.size(); ++i) {
                String[] stringArray = this._hostPorts.get(i);
                if (!Utils.sameHost(stringArray[0], string) || !stringArray[1].equals(string2)) continue;
                return true;
            }
            return false;
        }
        return Utils.sameHost(this._host, string) && this._port.equals(string2);
    }

    private boolean hasVersionString() {
        return this._versionString != null && this._versionString.length() > 0;
    }

    public String getVersionString() {
        return this._versionString;
    }

    public String getVersionNumber() {
        return this.hasVersionString() ? this._versionHelper.getVersion() : "";
    }

    public String getBuildPlatform() {
        return this.hasVersionString() ? this._versionHelper.getPlatform() : "";
    }

    public String getAgentPlatform() {
        return this.getHostPlatform();
    }

    public String getHostPlatform() {
        return this._platform;
    }

    public String getBuildOperatingSystem() {
        return this.hasVersionString() ? this._versionHelper.getOperatingSystem() : "";
    }

    public String getAgentOperatingSystem() {
        return this.getHostOperatingSystem();
    }

    public String getHostOperatingSystem() {
        return this._os;
    }

    public String getOSVersion() {
        return this._osVersion;
    }

    public String getReleaseType() {
        return this.hasVersionString() ? this._versionHelper.getReleaseType() : "";
    }

    public String getServerType() {
        return this.hasVersionString() ? this._versionHelper.getType() : "";
    }

    public String getBuild1() {
        return this.hasVersionString() ? this._versionHelper.getBuild1() : "";
    }

    public String getBuild2() {
        return this.hasVersionString() ? this._versionHelper.getBuild2() : "";
    }

    public String getBuildDate() {
        return this.hasVersionString() ? this._versionHelper.getBuildDate() : "";
    }

    public String getStatus() {
        if (this._status.equalsIgnoreCase("RUNNING") || this._status.indexOf(" Up ") > 2) {
            return "RUNNING";
        }
        if (this._status.equalsIgnoreCase("STOPPED")) {
            return "STOPPED";
        }
        if (this._status.equalsIgnoreCase("UNKNOWN")) {
            return "UNKNOWN";
        }
        return this._status;
    }

    public boolean isRunning() {
        return this.getStatus().equalsIgnoreCase("RUNNING");
    }

    public void setStatus(String string) {
        this._status = string;
    }

    public String toString() {
        return this._map == null ? "name = " + this.getName() + ", host = " + this.getHostName() + ", port = " + this.getPortNumber() + ", version string = " + this._versionString + ", status = " + this.getStatus() + ", id = " + this.getInstanceNumber() : this._map.toString();
    }

    public boolean hasHostAndPort() {
        boolean bl = this._host != null && this._host.length() > 0;
        boolean bl2 = this.getPort() > 0;
        return bl && bl2;
    }

    public void startCluster(String string, String string2, String string3, char[] cArray, MessageListener messageListener) throws RemoteException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            AgentConnection agentConnection = AgentConnectionFactory.createAgentConnection((String)"rmi", (String)this.getHostName(), (String)this.getRMIPort());
            agentConnection.connect();
            agentConnection.login(string3, cArray);
            if (this._cluster) {
                Object[] objectArray = new Object[]{string, string2, messageListener};
                String[] stringArray = new String[]{String.class.getName(), String.class.getName(), "com.sybase.ua.util.MessageListener"};
                agentConnection.invokeAgentPluginMethod(SyUAF.SDC_PLUGIN_ID, this.getPluginVersion(), this.getInstanceNumber(), "startInstance", objectArray, stringArray);
            } else {
                agentConnection.invokeAgentPluginMethod(SyUAF.ASE_PLUGIN_ID, this.getPluginVersion(), this.getInstanceNumber(), "start", null, null);
            }
        }
        catch (RemoteException remoteException) {
            Thread.currentThread().setContextClassLoader(classLoader);
            throw remoteException;
        }
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    @Deprecated
    public void startCluster(String string, String string2, String string3, String string4, MessageListener messageListener) throws RemoteException {
        this.startCluster(string, string2, string3, string4.toCharArray(), messageListener);
    }

    public boolean isCluster() {
        return this._cluster;
    }

    @Deprecated
    public void start(String string, String string2) throws RemoteException {
        this.start(string, string2.toCharArray());
    }

    public void start(String string, char[] cArray) throws RemoteException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            AgentConnection agentConnection = AgentConnectionFactory.createAgentConnection((String)"rmi", (String)this.getHostName(), (String)this.getRMIPort());
            agentConnection.setSecureConnection(true);
            agentConnection.connect(string, cArray);
            agentConnection.setSecureConnection(false);
            agentConnection.invokeAgentPluginMethod(SyUAF.ASE_PLUGIN_ID, this.getPluginVersion(), this.getInstanceNumber(), "start", null, null);
        }
        catch (RemoteException remoteException) {
            Thread.currentThread().setContextClassLoader(classLoader);
            throw remoteException;
        }
        Thread.currentThread().setContextClassLoader(classLoader);
    }
}

